# $Id: COMPRESS.pm,v 1.4 2003/04/04 16:27:03 bengen Exp $

#
# Module for unpacking compress'd files.
#

package AMAVIS::Extract::COMPRESS;
use strict;
use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;

use vars qw(
	    $cfg_unz_binary
	   );

sub init {
  my $self = shift;
  my $args = shift;
  my $types = shift;
  $cfg_unz_binary=($AMAVIS::cfg->val('external', 'gzip') || '/bin/gzip');
  if (! -x  $cfg_unz_binary) {
    writelog($args,LOG_CRIT, __PACKAGE__.
	     ": uncompress binary ($cfg_unz_binary) not executable");
    return 0;
  }
  $$types{'application/x-compressed'}=$self;
  $$types{'application/x-compress'}=$self;
  writelog($args,LOG_DEBUG, __PACKAGE__." initialized.");
  return 1;
}

sub extract( $ ) {
  my $self = shift;
  my $args = shift;
  my $filename = shift;
  my $securename=get_secure_filename($args);
  my $unpacked_size = 0;

  writelog($args,LOG_DEBUG, "Attempting to unpack $filename as 16-bit compressed(LZW), Huffman, or adaptive Huffman coded file");

  if ($$args{'unpacked_files'}++ > $cfg_maxfiles) {
    writelog($args,LOG_ERR, __PACKAGE__.": Unpacking uses too many files");
    return 0;
  }

  my $in_handle = cmd_pipe($args, $cfg_unz_binary,
			   '-cd',
			   "$$args{'directory'}/parts/$filename");
  unless (defined $in_handle) {
    writelog($args,LOG_ERR, __PACKAGE__.": Error extracting file");
    return 0;
  }
  my $out_handle=IO::File->new(">$$args{'directory'}/parts/"
			       .$securename);
  unless (defined $out_handle) {
    writelog($args,LOG_ERR, __PACKAGE__.": Error extracting file");
    return 0;
  }

  while ((my $len=$in_handle->read(my $buffer, 4096)) > 0) {
    $out_handle->write($buffer, $len);
    $unpacked_size += $len;
    if ($$args{'unpacked_size'} + $unpacked_size > $cfg_maxspace) {
      $in_handle->close();
      $out_handle->close();
      writelog($args,LOG_ERR, __PACKAGE__.": Unpacking takes too much space");
      return 0;
    }
  }
	
  $in_handle->close();
  $out_handle->close();

  $ {$$args{'contents'}}{$securename} = {};
  $ {$ {$$args{'contents'}}{$securename}}{insecure_type}='';
  $$args{'unpacked_size'} += $unpacked_size;
  return 1;
}

1;
