# $Id: Zip.pm,v 1.6 2002/07/12 08:25:06 bengen Exp $

#
# Module for extracting files from ZIP files (PkZIP, InfoZIP, WinZIP,
# whatever)
#

package AMAVIS::Extract::Zip;
use strict;
use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;
use Archive::Zip qw( :ERROR_CODES :CONSTANTS );

sub init {
  my $self = shift;
  my $args = shift;
  my $types = shift;
  $$types{'application/x-zip'}=$self;
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.");
  return 1;
}

sub extract( $ ) {
  my $self = shift;
  my $args = shift;
  my $filename = shift;
  my $unpacked_size = 0;

  writelog($args,LOG_DEBUG, "Attempting to unpack $filename as Zip file");

  my $ziperr;
  my $zip = Archive::Zip->new();
  Archive::Zip::setErrorHandler(\&myziperr);
  $ziperr = $zip->read("$$args{'directory'}/parts/$filename");

  Archive::Zip::setErrorHandler(\&Carp::carp);
  $Carp::CarpLevel++;

  if ($ziperr != AZ_OK) {
    writelog($args,LOG_ERR, __PACKAGE__.": Error reading zip file");
    return 0;
  }

  foreach my $member ($zip->members()) {
    my $membername=$member->fileName();
    # ignore directories
    next if ($member->isDirectory());
    # ignore encrypted files
    next if ($member->isEncrypted());
    if ($$args{'unpacked_files'}++ > $cfg_maxfiles) {
      writelog($args,LOG_ERR, __PACKAGE__.": Unpacking uses too many files");
      return 0;
    }
    # We don't trust any of the filenames in the zip
    # archive and always use our own.
    my $securename=get_secure_filename($args);

    $unpacked_size += $member->uncompressedSize();
    if ($$args{'unpacked_size'} + $unpacked_size >= $cfg_maxspace) {
      writelog($args,LOG_ERR, __PACKAGE__.": Unpacking takes too much space");
      return 0;
    }

    if ($member->extractToFileNamed("$$args{'directory'}/parts/$securename")
	!= AZ_OK) {
      writelog($args,LOG_ERR, "Error writing file");
    }
    else {
      $ {$$args{'contents'}}{$securename} = {'original_filename' => 
					     $membername};
      $ {$ {$$args{'contents'}}{$securename}}{insecure_type}='';
    }
  }
  $$args{'unpacked_size'} += $unpacked_size;
  return 1;
}

# Error handler.
# TODO: Investigate further

sub myziperr {
  # writelog($args,LOG_ERR, __PACKAGE__.': Error while unpacking.');
  return 5
}

1;
