// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#include "bmanalyse.h"

bmAnalyse::bmAnalyse() :
		strPrefix( "bm" ),
		strName( "Biggest Mail" ),
		strVersion( "V0.1" ),
		strAuthor( "Tobias Erbsland <drzoom@profzone.ch>" ),
		strHelp( "Create statistics about the biggest mail." )
{
	addParam( "limit", "Limit Output to n Lines.", "Integer from 1 to x.", G_STRING, "25" );
	addParam( "no-delivery", "Statistic with not delivered mail",
		"If set, not delivered mails are included.", G_FLAG, "0" );
	addParam( "only-no-delivery", "Statistic ONLY with not delivered mail",
		"If set, ONLY not delivered mails are included.", G_FLAG, "0" );
	addParam( "limit-to", "Maximum recipients shown.",
		"Integer from 1 to x.", STRING, "5" );
}

void bmAnalyse::run( std::map< std::string, unity_t > * unity_map )
{
	bmAnalyse::unity_map = unity_map; // Speichern, unsicher...

	std::map< std::string, unity_t >::iterator i;

	bool not_del = false;
	bool del = true;
	int limit = getIntParam( "limit" );

	if ( getFlagParam( "no_delivery" ) ) not_del = true; // Auch falsche;
	if ( getFlagParam( "only_no_delivery" ) )  // Hat auch vorrang.
	{
		not_del = true;
		del = false;
	};

	for ( i = unity_map->begin(); i != unity_map->end(); i++ )
	{
		// Nichtzugestellte oder zugestellte Mails aus statistik entfernen.
		if ( !not_del && ( i->second.to_intern.size() + i->second.to_extern.size() == 0 ) ) continue;
		if ( !del && ( i->second.to_intern.size() + i->second.to_extern.size() != 0 ) ) continue;

		biggest_mail.insert( std::make_pair( i->second.size, i->first ) );
		if ( biggest_mail.size() > static_cast<std::multimap<long, std::string>::size_type>( limit ) )
			biggest_mail.erase( biggest_mail.begin() );
	}
}

void bmAnalyse::print( void )
{
	if ( !report ) return ; // be sure :-)

	int limit_to = getIntParam( "limit_to" );

	std::list< std::string >::iterator k;
	std::multimap< long, std::string >::reverse_iterator j;
	int r;
	bool f;

	report->startNewReport( "Biggest Mail", Report::TABLE );
	report->addCol( 4, Report::COUNTER, Report::RIGHT, "nr", Report::NONE );
	// -1 = soviel platz verwenden, wie noch vorhanden.
	report->addCol( -1, Report::STRING, Report::LEFT, "from", Report::NONE );
	report->addCol( 9, Report::INTEGER, Report::RIGHT, "size", Report::NONE );
	report->addCol( 9, Report::INTEGER, Report::RIGHT, "tsize", Report::NONE );
	report->addCol( -1, Report::STRING, Report::LEFT, "to", Report::NONE );
	report->addCol( 10, Report::DATE, Report::RIGHT, "date", Report::NONE );
	report->printHeader();
	for ( j = biggest_mail.rbegin(); j != biggest_mail.rend(); j++ )
	{
		report->printField( ( *unity_map ) [ j->second ].from );
		report->printField( ( *unity_map ) [ j->second ].size );
		r = ( *unity_map ) [ j->second ].to_intern.size() + ( *unity_map ) [ j->second ].to_extern.size();
		report->printField( static_cast<long>((*unity_map)[j->second].size * r) );
		if ( r > limit_to )
		{
			report->printField( "many recipients." );
			report->printField( static_cast<long>((*unity_map)[j->second ].date) );
		}
		else
		{
			f = false;
			for ( k = ( *unity_map ) [ j->second ].to_intern.begin(); k != ( *unity_map ) [ j->second ].to_intern.end(); k++ )
			{
				if ( f )
				{
					report->skipField( false ); report->skipField( false );
					report->skipField( false ); report->skipField( false );
				}
				report->printField( ( *k ) );
				if ( !f )
				{
					report->printField( static_cast<long>( ( *unity_map ) [ j->second ].date ) );
					f = true;
				}
				else
				{
					report->skipField( false );
				};
			}
			for ( k = ( *unity_map ) [ j->second ].to_extern.begin(); k != ( *unity_map ) [ j->second ].to_extern.end(); k++ )
			{
				if ( f )
				{
					report->skipField( false ); report->skipField( false );
					report->skipField( false ); report->skipField( false );
				}
				report->printField( ( *k ) );
				if ( !f )
				{
					report->printField( static_cast<long>( ( *unity_map ) [ j->second ].date ) );
					f = true;
				}
				else
				{
					report->skipField( false );
				};
			}
		};
	}
	report->printFooter();
}

void bmAnalyse::free( void )
{
	biggest_mail.clear();
}
