// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#ifndef LTDANALYSE_H
#define LTDANALYSE_H
#ifdef _MSC_VER
#include "win32/config_win32.h"
#endif
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "analyse.h"

/** This analysis module create a statistic about the distribution of
  * local generated traffic to local or external recipients.
  *@short Local traffic distribution analysis.
  *@author Tobias Erbsland
  */
class ltdAnalyse : public Analyse
{
private:
	const char * const strPrefix;
	const char * const strName;
	const char * const strVersion;
	const char * const strAuthor;
	const char * const strHelp;

	/** Map for the analysis. */
	std::multimap< long, std::string > from_traffic;
	/** Map for the analysis. */
	std::map< std::string, long > i2e_traffic_c;
	/** Map for the analysis. */
	std::map< std::string, long > mailc_2e_c;
	/** Map for the analysis. */
	std::map< std::string, long > mailc_2i_c;

public:
	ltdAnalyse();

	virtual const char * Prefix( void ) const { return strPrefix; };
	virtual const char * Name( void ) const { return strName; };
	virtual const char * Version( void ) const { return strVersion; };
	virtual const char * Author( void ) const { return strAuthor; };
	virtual const char * Help( void ) const { return strHelp; };

	virtual	void run( std::map< std::string, unity_t > * unity_map );
	virtual void print( void );
	virtual void free( void );

	virtual ~ltdAnalyse() { };
};

#endif
