// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#ifndef REPORTPLUGIN_H
#define REPORTPLUGIN_H
#ifdef _MSC_VER
#include "win32/config_win32.h"
#endif
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "plugin.h"

/** This plugin controls the selection of the report object of all, or some
  * analysis. It also controls the output.
  *@short Report selection control and output plugin.
  *@author Tobias Erbsland
  */
class reportPlugin : public Plugin
{
private:
	const char * const strPrefix;
	const char * const strName;
	const char * const strVersion;
	const char * const strAuthor;
	const char * const strHelp;

	std::map< Report *, int > usedReports;

public:
	reportPlugin();

	virtual const char * Prefix( void ) const { return strPrefix; };
	virtual const char * Name( void ) const { return strName; };
	virtual const char * Version( void ) const { return strVersion; };
	virtual const char * Author( void ) const { return strAuthor; };
	virtual const char * Help( void ) const { return strHelp; };

	virtual int pa( void ) { return PA_BEFORE_PARAM | PA_INIT | PA_FREE; };
	virtual void beforeParam( void );
	virtual ps_e init( void );
	virtual ps_e free( void );

	~reportPlugin();
};

#endif
