/* Copyright (C) 2006 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#include <mysql/mysqld_error.h>
#include "mysqlDatabase.hpp"
#include "mysqlNetwork.hpp"

using namespace std;

MySQLNetwork::MySQLNetwork( const std::string &_userName,
                            const std::string &_passWord,
                            const std::string &_serverName,
                            int _portNumber ) throw (Error):
  MySQLServer( _userName, _passWord ), serverName(_serverName),
  portNumber( _portNumber )
{
  connect( "", &connection );
}


void MySQLNetwork::connect( const std::string &database, MYSQL *m )
  throw (Error)
{
  mysql_init( m );

  const int timeout = 10;// seconds
  mysql_options( m, MYSQL_OPT_CONNECT_TIMEOUT,
                 (const char *)&timeout );

  try {

    // Specifying an alternative port will lead to a crash in the library :-(
    ERRORMACRO( mysql_real_connect( m,
                                    serverName.c_str(), userName.c_str(),
                                    passWord.empty() ? (const char *)NULL :
                                                       passWord.c_str(),
                                    database.empty() ? (const char *)NULL :
                                                       database.c_str(),
                                    portNumber != MYSQL_PORT ? portNumber : 0,
                                    NULL, 0 ),
                Error, , "Error connecting to server '"
                << serverName << "' as user '" << userName << "' "
                << ( passWord.empty() ? "without" : "with" ) << " password: "
                << mysql_error( m ) );

    // Set character-set of connection to UTF-8.
    // If the server is older than MySQL 4.1, the resulting error-message is
    // being ignored.
    mysql_query( m, "SET NAMES utf8;" );

  } catch ( Error &e ) {

    mysql_close( m );
    throw e;

  };
};


MySQLNetwork::~MySQLNetwork(void)
{
  mysql_close( &connection );
}
