<?xml version="1.0" encoding="ISO-8859-1"?> <!-- -*- nxml -*- -->
<!--
 Copyright (C) 2005 Universitat d'Alacant / Universidad de Alicante

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License as
 published by the Free Software Foundation; either version 2 of the
 License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 02111-1307, USA.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="text" encoding="ISO-8859-1"/>

<xsl:template name="replaceString">
  <xsl:param name="haystack"/>
  <xsl:param name="needle"/>
  <xsl:param name="replacement"/>
  <xsl:choose>
    <xsl:when test="contains($haystack, $needle)">
      <xsl:value-of select="substring-before($haystack, $needle)"/>
      <xsl:value-of select="$replacement"/>
      <xsl:call-template name="replaceString">
	<xsl:with-param name="haystack" 
			select="substring-after($haystack, $needle)"/>
	<xsl:with-param name="needle" select="$needle"/>
	<xsl:with-param name="replacement" select="$replacement"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$haystack"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="processTags">
  <xsl:param name="tags"/>
  <xsl:if test="not($tags=string(''))">
    <xsl:choose>
      <xsl:when test="not(contains($tags, string('.')))">
	<xsl:choose>
	  <xsl:when test="$tags=string('*')">
	    <xsl:value-of select="string('&quot;{ETIQUETA}*&quot;')"/>
	  </xsl:when>
	  <xsl:otherwise>
	    <xsl:value-of select="string('&lt;')"/>
	    <xsl:value-of select="$tags"/>
	    <xsl:value-of select="string('&gt;')"/>
	  </xsl:otherwise>
	</xsl:choose>
      </xsl:when>
      <xsl:when test="substring-before($tags, string('.'))=string('*')">
	<xsl:value-of select="string('&quot;{ETIQUETA}*&quot;')"/>
	<xsl:call-template name="processTags">
	  <xsl:with-param name="tags" 
			  select="substring-after($tags, string('.'))"/>
	</xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
	<xsl:value-of select="string('&lt;')"/>
	<xsl:value-of select="substring-before($tags, string('.'))"/>
	<xsl:value-of select="string('&gt;')"/>
	<xsl:call-template name="processTags">
	  <xsl:with-param name="tags" 
			  select="substring-after($tags, string('.'))"/>
	</xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:if>
</xsl:template>

<xsl:template name="macroSignature">
  <xsl:param name="nparams"/>
  <xsl:choose>
    <xsl:when test="$nparams=number(1)">
       <xsl:value-of select="string('int const p0')"/>
    </xsl:when>
    <xsl:when test="$nparams=number(0)"/>
    <xsl:otherwise>
       <xsl:call-template name="macroSignature">
         <xsl:with-param name="nparams" select="number($nparams)-number(1)"/>
       </xsl:call-template>
       <xsl:value-of select="string(', int const p')"/>
       <xsl:value-of select="number($nparams)-number(1)"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="defLabel">
  <xsl:param name="labelname"/>
  <xsl:value-of select="string('(')"/>
  <xsl:for-each select="/tagger/tagset/def-label[./@name=$labelname]/*">
    <xsl:choose>
      <xsl:when test="count(./@lemma)=1">
	<xsl:value-of select="string('&quot;')"/>
	<xsl:value-of select="./@lemma"/>
      </xsl:when>
      <xsl:otherwise>
	<xsl:value-of select="string('{LEMA}')"/>
	<xsl:value-of select="string('&quot;')"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:call-template name="processTags">
      <xsl:with-param name="tags" select="./@tags"/>
    </xsl:call-template>
    <xsl:value-of select="string('&quot;')"/>
    <xsl:if test="not(position()=last())">
      <xsl:value-of select="string('|')"/>
    </xsl:if>
  </xsl:for-each>
  <xsl:value-of select="string('){CUA}?')"/>
</xsl:template>


<xsl:template match="def-label">
  <xsl:value-of select="string('(')"/>
  <xsl:for-each select="./*">
    <xsl:choose>
      <xsl:when test="count(./@lemma)=1">
	<xsl:value-of select="string('&quot;')"/>
	<xsl:value-of select="./@lemma"/>
      </xsl:when>
      <xsl:otherwise>
	<xsl:value-of select="string('{LEMA}')"/>
	<xsl:value-of select="string('&quot;')"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:call-template name="processTags">
      <xsl:with-param name="tags" select="./@tags"/>
    </xsl:call-template>
    <xsl:value-of select="string('&quot;')"/>
    <xsl:if test="not(position()=last())">
      <xsl:value-of select="string('|')"/>
    </xsl:if>
  </xsl:for-each>
  <xsl:value-of select="string('){CUA}?')"/>
</xsl:template>

<xsl:template match="def-mult">
  <xsl:value-of select="string('(')"/>
  <xsl:for-each select="./*">
    <xsl:value-of select="string('(')"/>
    <xsl:apply-templates select="."/>
    <xsl:value-of select="string(')')"/>
    <xsl:if test="not(position()=last())">
      <xsl:value-of select="string('|')"/>
    </xsl:if>
  </xsl:for-each>
  <xsl:value-of select="string('){CUA}?')"/>
</xsl:template>

<xsl:template match="sequence">
  <xsl:for-each select="./*">
    <xsl:choose>
      <xsl:when test="name(.)=string('label-item')">
	<xsl:call-template name="defLabel">
	  <xsl:with-param name="labelname" select="./@label"/>
	</xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
	<xsl:choose>
	  <xsl:when test="count(./@lemma)=1">
	    <xsl:value-of select="string('&quot;')"/>
	    <xsl:value-of select="./@lemma"/>
	  </xsl:when>
	  <xsl:otherwise>
	    <xsl:value-of select="string('{LEMA}')"/>
	    <xsl:value-of select="string('&quot;')"/>
	  </xsl:otherwise>
	</xsl:choose>
	<xsl:call-template name="processTags">
	  <xsl:with-param name="tags" select="./@tags"/>
	</xsl:call-template>
	<xsl:value-of select="string('&quot;')"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="not(position()=last())">
      <xsl:value-of select="string('[\+]')"/>
    </xsl:if>
  </xsl:for-each>
</xsl:template>




<xsl:template match="tagger">
%{
#include &lt;apertium/TTag.H&gt;
#include &lt;apertium/Tagger.H&gt;
#include &lt;apertium/LexWrapper.H&gt;
#include &lt;apertium/TaggerWord.H&gt;
using namespace std;

%}

BLANC	[ \t\n]
LLETRA	[a-zA-Z_Ʒ\.0-9 '\#]
NUM	[0-9]
MOT_ESPECIAL	([?!.,:;()])|("\\[")|("\\]")
MOT	{LLETRA}+([ ]?[-']{LLETRA}*)*
MULTIMOT	{MOT}([ ]+{MOT})+
MOT_NUM	{LEMA_NUMERO}
F_SUPERFICIAL	({MOT}|{MULTIMOT}|{MOT_NUM}|{MOT_ESPECIAL})
LEMA_LLETRA	{LLETRA}+([-_']{LLETRA}+)*
LEMA_NUMERO	{NUM}+([.,]{NUM}+)?%?
LEMA	[*]?({LEMA_LLETRA}|{LEMA_NUMERO})
ETIQUETA	"&lt;"({LLETRA}+|{NUM}+)"&gt;"
CUA	([_ \#]{LLETRA}+)+
DESCONOCIDA	[*]{F_SUPERFICIAL}

%option caseless
%option nounput
%option noyywrap
%option never-interactive
%%

<xsl:for-each select="./tagset/*">
[*|]?<xsl:apply-templates select="."/>&#x9;{return <xsl:value-of select="position()+6"/>;}</xsl:for-each>

."&lt;lpar&gt;"&#x9;{return 0;}
."&lt;rpar&gt;"&#x9;{return 1;}
"\\[&lt;lpar&gt;"&#x9;{return 0;}
"\\]&lt;rpar&gt;"&#x9;{return 1;}
."&lt;lquest&gt;"&#x9;{return 2;}
."&lt;cm&gt;"&#x9;{return 3;}
."&lt;sent&gt;"&#x9;{return 4;}
&lt;&lt;EOF&gt;&gt;&#x9;{return 5;}
[*|]?{LEMA}{ETIQUETA}+{CUA}?&#x9;{return 6;}
{F_SUPERFICIAL}/\/&#x9;{return <xsl:value-of select="count(./tagset/*)"/>+7;}
{DESCONOCIDA}&#x9;{return <xsl:value-of select="count(./tagset/*)"/>+13;}
"^"&#x9;{return <xsl:value-of select="count(./tagset/*)"/>+12;}
"\$"&#x9;{return <xsl:value-of select="count(./tagset/*)"/>+8;}
"\/"&#x9;{return <xsl:value-of select="count(./tagset/*)"/>+9;}
[\+]&#x9;{return <xsl:value-of select="count(./tagset/*)"/>+10;}
"\\\\"&#x9;{return <xsl:value-of select="count(./tagset/*)"/>+11;}
"\\@"&#x9;{return <xsl:value-of select="count(./tagset/*)"/>+11;}
"["(([^]])|("\\]")|("\\["))*"]"&#x9;{return <xsl:value-of select="count(./tagset/*)"/>+11;}
"\n"&#x9;{return <xsl:value-of select="count(./tagset/*)"/>+11;}
"\t"&#x9;{return <xsl:value-of select="count(./tagset/*)"/>+11;}
.&#x9;{return <xsl:value-of select="count(./tagset/*)"/>+11;}
%%

int main(int argc, char *argv[])
{
  map&lt;string, TTag&gt; tag_index;
  vector&lt;string&gt; array_tags;

  tag_index["TAG_LPAR"] = 0;
  array_tags.push_back("TAG_LPAR");
  tag_index["TAG_RPAR"] = 1;
  array_tags.push_back("TAG_RPAR");
  tag_index["TAG_LQUEST"] = 2;
  array_tags.push_back("TAG_LQUEST");
  tag_index["TAG_CM"] = 3;
  array_tags.push_back("TAG_CM");
  tag_index["TAG_SENT"] = 4;
  array_tags.push_back("TAG_SENT");
  tag_index["TAG_kEOF"] = 5;
  array_tags.push_back("TAG_kEOF");
  tag_index["TAG_kUNDEF"] = 6;
  array_tags.push_back("TAG_kUNDEF");
  <xsl:for-each select="./tagset/*">
  tag_index["TAG_<xsl:value-of select="./@name"/>"] = <xsl:value-of select="position()+6"/>;
  array_tags.push_back("<xsl:value-of select="./@name"/>");</xsl:for-each>

  ConstantManager constants;

  constants.setConstant("kMOT", <xsl:value-of select="count(./tagset/*)"/>+7);
  array_tags.push_back("kMOT");
  constants.setConstant("kDOLLAR", <xsl:value-of select="count(./tagset/*)"/>+8);
  array_tags.push_back("kDOLLAR");
  constants.setConstant("kBARRA", <xsl:value-of select="count(./tagset/*)"/>+9);
  array_tags.push_back("kBARRA");
  constants.setConstant("kMAS", <xsl:value-of select="count(./tagset/*)"/>+10);
  array_tags.push_back("kMAS");
  constants.setConstant("kIGNORAR", <xsl:value-of select="count(./tagset/*)"/>+11);
  array_tags.push_back("kIGNORAR");
  constants.setConstant("kBEGIN", <xsl:value-of select="count(./tagset/*)"/>+12);
  array_tags.push_back("kBEGIN");
  constants.setConstant("kUNKNOWN", <xsl:value-of select="count(./tagset/*)"/>+13);
  array_tags.push_back("kUNKNOWN");

  set&lt;TTag&gt; open_class;
  <xsl:for-each select="./tagset/*[not(./@closed=string('true'))]">
  open_class.insert(tag_index["TAG_<xsl:value-of select="./@name"/>"]);</xsl:for-each>

  TForbidRule *auxfr;
  vector&lt;TForbidRule&gt; forbid_rules(<xsl:value-of select="count(./forbid/*)"/>);
  <xsl:for-each select="./forbid/*">
  auxfr = &amp;forbid_rules[<xsl:value-of select="position()-1"/>];
  auxfr->tagi = tag_index["TAG_<xsl:value-of select="./*[position()=1]/@label"/>"];
  auxfr->tagj = tag_index["TAG_<xsl:value-of select="./*[position()=last()]/@label"/>"];
  </xsl:for-each>

  TEnforceAfterRule *auxear;
  vector&lt;TEnforceAfterRule&gt; enforce_rules(<xsl:value-of select="count(./enforce-rules/*)"/>);

  <xsl:for-each select="./enforce-rules/*">
  auxear = &amp;enforce_rules[<xsl:value-of select="position()-1"/>];
  auxear->tagi = tag_index["TAG_<xsl:value-of select="./@label"/>"];
  auxear->tagsj.resize(<xsl:value-of select="count(./label-set/*)"/>);
  <xsl:for-each select="./label-set/*">
  auxear->tagsj[<xsl:value-of select="position()-1"/>] = tag_index["TAG_<xsl:value-of select="./@label"/>"];</xsl:for-each>
  </xsl:for-each>

  vector&lt;string&gt; prefer_rules(<xsl:value-of select="count(./preferences/*)"/>);
  <xsl:for-each select="./preferences/*">
  prefer_rules[<xsl:value-of select="position()-1"/>] = "<xsl:call-template name="processTags">
	<xsl:with-param name="tags" select="./@tags"/>
      </xsl:call-template>";</xsl:for-each>
  

  // static var initialization
  LexWrapper::initClass(&amp;yyin, &amp;yyout, &amp;yylex, &amp;yytext,
                       &amp;yy_flush_buffer, &amp;yy_create_buffer,
                       &amp;yy_switch_to_buffer, &amp;yy_delete_buffer,
                       YY_BUF_SIZE);
  TaggerWord::setArrayTags(array_tags);

  do_main(argc, argv, open_class,tag_index, constants, prefer_rules,
          forbid_rules, enforce_rules);

  return EXIT_SUCCESS;
}

</xsl:template>

</xsl:stylesheet>
