/***************************************************************************
                          Apollonsearchtab.h  -  description
                             -------------------
begin		: Dec 05 2003
copyright       : (C) 2005 by Martin Koebele, (C) 2002 by Bastiaan Naber, (C) 2002 by Robert Wittams
email           : martin@mkoebele.de
description	: 

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef APOLLONSEARCHTAB_H
#define APOLLONSEARCHTAB_H

#include <qpixmap.h>
#include <qpopupmenu.h>
#include <qsplitter.h>
#include <qvaluelist.h>

#include <kdebug.h>

#include "apollontab.h"
#include "apollonqueryview.h"
#include "apollonbrowseview.h"

class giFTConnection;
class KLineEdit;
class KComboBox;
class KTabWidget;
class QPushButton;

class ApollonSearchTab : public ApollonTab
{
  Q_OBJECT
public:
	ApollonSearchTab(QWidget* parent, const char *name, giFTConnection* gcn);
	~ApollonSearchTab();
	void startQuery(const int& index, const QString& text );

	virtual void keyPressEvent ( QKeyEvent * e );
	//virtual void contextMenuEvent ( QContextMenuEvent * );

	
public slots:
	void startSearch();
	void browseUser(QString);
	void sltChangeTab(QWidget*);
	void closealltabs();
	void closeThisTab();
	void closeCurrentTab();
	void tabContextMenu( QWidget *target, const QPoint &pos );
	void slotGetHash(QString hash);
	void slotDeleteHash(QString hash);

signals:
	void giftItemReply(QString);
	void sigSendHash(QString);
	void sigDeleteHash(QString hash); // sends the hash which was removed from the list
		
private:
	KLineEdit* querybox;
	KComboBox* querycombo;
	QPopupMenu* tabmenu;
	ApollonQueryView* kqv;
	ApollonBrowseView* kbv;

	KTabWidget* viewtab;
	QVBox* splitter;
	QWidget* clickedTab;
	QPushButton *closeButton;
	void makePopup();
	QValueList<QString>* m_hashList;  // a pointer to this list exists also in apollonqueryview!!

};

#endif
