/***************************************************************************
                           chatline.h - a chatline
                             -------------------
    begin                : Mon Jan 2 2004
    copyright            : (C) 2004 by Albert Astals Cid
    email                : astals11@terra.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#ifndef CHATLINE_H
#define CHATLINE_H

#include <klineedit.h>

#include <qstringlist.h>

class chatLine : public QLineEdit
{
Q_OBJECT
	public: 
		chatLine(QWidget *parent, const char *name=0);
		void addNick(const QString& name) {p_names.append(name); p_names.sort();}
		void removeNick(const QString& name) {p_names.remove(name); p_names.sort();}
	
	signals:
		void newMessage();
		void appendLine(const QString&);
	
	protected:
		bool event(QEvent *e);
	
	private slots:
		void addMessage();
		
	private:
		QStringList list, p_names, matches;
		int pos, m_matchIndex;
		bool m_textChanged;
		QString lastWord;
};

#endif
