/* apt-spy (c) Steven Holmes, 2003. This software is licensed as detailed in the LICENSE file. */

#ifndef __PARSE_H
#define __PARSE_H

#define BESTNUMBER 5

#define FTP 0
#define HTTP 1

struct stats_struct {
	int protocol;
	double speed;
};

struct server_struct {
	char	hostname[80];
	char	path[2][80];
	char	url[2][80];
	struct	stats_struct stats;
};

typedef struct server_struct server_t;

int build_area_file(FILE *config_p, FILE *infile_p, FILE *mirror_list, char *area);
int build_country_file(FILE *config_p, FILE *infile_p, FILE *mirror_p, char *country_list);
int find_country(FILE *mirror_list, char *country_code);
void tokenise(server_t *current, char *cur_entry);
char *get_mirrors(FILE *mirror_list);
int write_list(FILE *outfile_p, server_t *best, char *dist);
int write_top(FILE *infile_p, FILE *outfile_p, server_t *best);

#endif
