#!/usr/bin/env python
# -*- coding: utf-8 -*-
######################################################
##
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published
#  by the Free Software Foundation; version 2 only.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
##
######################################################
## 
#  Project: AptOnCd
#  File: parsegz.py
#  Author: Laudeci Oliveira <laudeci@gmail.com>
#  Creation: 16/11/2006
#  Changed: 
#  Purpose: Class that will control repositoy downloads
##
######################################################
import gzip
import re
(PACKAGE, VERSION, FILENAME, SIZE, DEBFILENAME,REMOTEFILEPATH,SECTION) = range(7)
class ParseFile:
    def __init__(self,strParse):
        self.ParseString = strParse.split('\n')
        self.Lines = []

    def Parse(self):
        LineNumber = -1
        # this procedure will return a list in the following format
        # [Package, Version, Filename, Size]
        Package  = re.compile(r'(Package:\s)(.*)',re.IGNORECASE| re.MULTILINE| re.DOTALL)
        Version  = re.compile(r'(Version:\s)(.*)',re.IGNORECASE| re.MULTILINE| re.DOTALL)
        Filename = re.compile(r'(Filename:\s)(.*)',re.IGNORECASE| re.MULTILINE| re.DOTALL)
        Section = re.compile(r'(Section::\s)(.*)',re.IGNORECASE| re.MULTILINE| re.DOTALL)
        Size =re.compile(r'(Size:\s)(.*)',re.IGNORECASE| re.MULTILINE| re.DOTALL)
        
        if len(self.ParseString) <=0:
            return []
    
        for line in self.ParseString:
            #get package name
            match = Package.search(line)
            if match:
                #(PACKAGE, VERSION, FILENAME, SIZE, DEBFILENAME,REMOTEFILEPATH,ARCHITECTURE) = range(7)
                self.Lines.append([match.group(2),'','','','','',''])
                LineNumber +=1
    
            #get package version
            matchv = Version.search(line)
            if matchv:
                self.Lines[LineNumber][1] = matchv.group(2)
            
            matcha = Section.search(line)
            if matcha:
                self.Lines[LineNumber][6] = matcha.group(2)
                
            #get package file
            matchn = Filename.search(line)
            if matchn:
                fullFilePath = matchn.group(2)
                filename = fullFilePath.split('/')[-1] #filename without path
                filePath = fullFilePath.replace(filename,'')#PATH without filename
                
                self.Lines[LineNumber][2] = fullFilePath
                self.Lines[LineNumber][4] = filename 
                self.Lines[LineNumber][5] = filePath 
            
            #get package size
            matchs = Size.search(line)
            if matchs:
                self.Lines[LineNumber][3] = matchs.group(2)

        return self.Lines
    
def openGZ(obj):
    inF = gzip.GzipFile(obj, 'rb')
    s=inF.read()
    inF.close()
    return s
