# Arch Perl library, Copyright (C) 2004 Mikhael Goikhman, Gergely Nagy
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.005;
use strict;

package ArchZoom::TemplateEngine::TT;

use base 'ArchZoom::TemplateEngine';

use ArchZoom::Util;
eval "use Template";

sub parse ($$;$) {
	my $self = shift;
	my $file_name = shift || die "No template to parse";
	my $stash = shift || {};
	$stash = { %{$self->{default_stash}}, %$stash };

	my $dir = $self->{set_dir};
	$file_name .= ".html" unless $file_name =~ /\./;
	$file_name = "$dir/$file_name" unless $file_name =~ /\//;

	my $tt = Template->new(
		INCLUDE_PATH => $dir,
		EVAL_PERL => 1,
		ABSOLUTE => 1,
		RELATIVE => 1,
	);

	$stash->{UTIL} = {
		urlize => \&urlize,
		htmlize => \&htmlize,
		break => \&break,
		selfurl => \&main::selfurl,
		selfurl_archive => \&main::selfurl_archive,
		selfurl_abrowse => \&main::selfurl_abrowse,
		selfurl_category => \&main::selfurl_category,
		selfurl_branch => \&main::selfurl_branch,
		selfurl_version => \&main::selfurl_version,
		selfurl_revision => \&main::selfurl_revision,
		selfurl_tree => \&main::selfurl_tree,
		selfurl_log => \&main::selfurl_log,
		selfurl_diff => \&main::selfurl_diff,
	};

	my $output;
	$tt->process($file_name, $stash, \$output) ||
		die $tt->error();
	return $output;
}

1;
