/*
    Copyright (C) 20002 Paul Davis 
    Sounds by Nick Mainsbridge.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: default_click.cc,v 1.3 2005/08/03 21:12:46 pauld Exp $
*/

#include <ardour/ardour.h>
#include <ardour/session.h>

using namespace ARDOUR;

const Sample Session::default_click_emphasis[] = {


    0.011260986, 0.055389404, 0.10488892, 0.14285278, 0.17984009,
      0.20492554, 0.2244873, 0.23187256, 0.23144531, 0.21932983,
      0.19973755, 0.17034912, 0.13473511, 0.09274292, 0.04699707,
      -0.0009765625, -0.048919678, -0.095123291, -0.13772583,
      -0.17495728, -0.20523071, -0.22750854, -0.24038696, -0.24423218,
      -0.23831177, -0.22305298, -0.19918823, -0.16748047, -0.12948608,
      -0.086730957, -0.041015625, 0.0060424805, 0.052276611,
      0.09588623, 0.13513184, 0.16827393, 0.19415283, 0.21182251,
      0.22024536, 0.2194519, 0.20932007, 0.19030762, 0.1633606,
      0.1295166, 0.090118408, 0.046844482, 0.0015563965, -0.0440979,
      -0.088043213, -0.12854004, -0.16415405, -0.19317627,
      -0.21456909, -0.22750854, -0.23141479, -0.22619629, -0.21224976,
      -0.18994141, -0.1602478, -0.12457275, -0.084228516,
      -0.040893555, 0.0035400391, 0.047485352, 0.08895874, 0.12628174,
      0.15808105, 0.1829834, 0.19998169, 0.20849609, 0.2081604,
      0.19891357, 0.18139648, 0.15621948, 0.12438965, 0.087371826,
      0.046569824, 0.0036621094, -0.039489746, -0.081207275,
      -0.11987305, -0.15371704, -0.18154907, -0.20220947, -0.21481323,
      -0.21896362, -0.21453857, -0.20159912, -0.18084717, -0.15319824,
      -0.11959839, -0.081604004, -0.040771484, 0.001373291,
      0.04296875, 0.082275391, 0.11791992, 0.14828491, 0.17214966,
      0.18869019, 0.19711304, 0.19714355, 0.18896484, 0.17272949,
      0.14916992, 0.11941528, 0.084564209, 0.046081543, 0.005645752,
      -0.03527832, -0.074890137, -0.11154175, -0.14389038,
      -0.17053223, -0.19036865, -0.20272827, -0.20709229, -0.20321655,
      -0.19143677, -0.17221069, -0.14624023, -0.11477661,
      -0.079040527, -0.040435791, -0.00064086914, 0.038726807,
      0.076171875, 0.11004639, 0.13900757, 0.16201782, 0.177948,
      0.18634033, 0.18685913, 0.17938232, 0.16436768, 0.14254761,
      0.11459351, 0.081817627, 0.045623779, 0.0073242188,
      -0.031402588, -0.068939209, -0.10388184, -0.13473511,
      -0.16018677, -0.17938232, -0.19143677, -0.19589233, -0.19271851,
      -0.1819458, -0.16400146, -0.13980103, -0.11026001, -0.076507568,
      -0.040130615, -0.0024414062, 0.034973145, 0.070465088,
      0.10275269, 0.13052368, 0.15255737, 0.1680603, 0.17642212,
      0.17718506, 0.17056274, 0.15673828, 0.13626099, 0.1100769,
      0.079284668, 0.045013428, 0.0088195801, -0.027862549,
      -0.06362915, -0.096862793, -0.12631226, -0.15081787,
      -0.16931152, -0.18109131, -0.18579102, -0.18310547, -0.17321777,
      -0.15661621, -0.13391113, -0.10604858, -0.074310303,
      -0.039794922, -0.0040588379, 0.031433105, 0.065338135,
      0.096191406, 0.1227417, 0.14398193, 0.15905762, 0.16726685,
      0.16845703, 0.16247559, 0.14962769, 0.1305542, 0.10595703,
      0.076812744, 0.044494629, 0.010162354, -0.024719238,
      -0.058685303, -0.090423584, -0.11865234, -0.14208984,
      -0.15994263, -0.17150879, -0.1762085, -0.17401123, -0.16500854,
      -0.1494751, -0.12820435, -0.10205078, -0.071990967,
      -0.039398193, -0.0055847168, 0.028198242, 0.060424805,
      0.089782715, 0.11523438, 0.13565063, 0.15014648, 0.1583252,
      0.159729, 0.15438843, 0.14260864, 0.12475586, 0.10162354,
      0.074310303, 0.043762207, 0.011291504, -0.02166748,
      -0.053924561, -0.084136963, -0.1109314, -0.13342285,
      -0.15060425, -0.16177368, -0.16659546, -0.16485596, -0.15655518,
      -0.14221191, -0.12234497, -0.097747803, -0.069519043,
      -0.038818359, -0.0067749023, 0.025115967, 0.055633545,
      0.083618164, 0.1078186, 0.12731934, 0.14138794, 0.14935303,
      0.15097046, 0.14630127, 0.13537598, 0.11877441, 0.097259521,
      0.071563721, 0.04284668, 0.012329102, -0.018859863,
      -0.049346924, -0.077880859, -0.10342407, -0.12484741,
      -0.14126587, -0.15213013, -0.1569519, -0.1555481, -0.14807129,
      -0.13479614, -0.11624146, -0.093322754, -0.066864014,
      -0.03793335, -0.0078735352, 0.022247314, 0.051116943,
      0.077575684, 0.10055542, 0.11920166, 0.13265991, 0.14047241,
      0.14233398, 0.13812256, 0.12814331, 0.11282349, 0.092681885,
      0.068695068, 0.0418396, 0.013122559, -0.016174316, -0.044891357,
      -0.071929932, -0.096038818, -0.11636353, -0.1321106,
      -0.14254761, -0.14733887, -0.14633179, -0.13955688, -0.12728882,
      -0.11016846, -0.088745117, -0.063995361, -0.036987305,
      -0.0087280273, 0.019592285, 0.04675293, 0.071746826,
      0.093536377, 0.11120605, 0.12411499, 0.13171387, 0.13366699,
      0.1300354, 0.12094116, 0.10671997, 0.088104248, 0.065765381,
      0.040588379, 0.013763428, -0.013702393, -0.040740967,
      -0.066101074, -0.088897705, -0.10818481, -0.12310791,
      -0.13314819, -0.13793945, -0.13720703, -0.13113403, -0.11993408,
      -0.10400391, -0.084136963, -0.061126709, -0.035858154,
      -0.0094299316, 0.017059326, 0.042633057, 0.066131592,
      0.086669922, 0.10345459, 0.11572266, 0.12304688, 0.12521362,
      0.12203979, 0.11373901, 0.10070801, 0.083435059, 0.062652588,
      0.039276123, 0.014221191, -0.011505127, -0.036773682,
      -0.060638428, -0.082092285, -0.10025024, -0.11444092,
      -0.12408447, -0.12875366, -0.12835693, -0.1229248, -0.11260986,
      -0.097991943, -0.079620361, -0.058166504, -0.034698486,
      -0.010040283, 0.014770508, 0.038665771, 0.06072998, 0.080108643,
      0.095916748, 0.10760498, 0.11471558, 0.11691284, 0.11419678,
      0.10671997, 0.094726562, 0.078765869, 0.059570312, 0.037811279,
      0.014465332, -0.0094604492, -0.03314209, -0.055480957,
      -0.075592041, -0.09274292, -0.10617065, -0.11532593, -0.1199646,
      -0.11981201, -0.11489868, -0.1055603, -0.092102051,
      -0.075073242, -0.055267334, -0.033447266, -0.010467529,
      0.012634277, 0.035003662, 0.05569458, 0.073822021, 0.088745117,
      0.099853516, 0.10665894, 0.10894775, 0.10665894, 0.099853516,
      0.088897705, 0.07421875, 0.056427002, 0.0362854, 0.01461792,
      -0.0077209473, -0.029754639, -0.050628662, -0.069519043,
      -0.085571289, -0.098236084, -0.10702515, -0.11151123,
      -0.11157227, -0.1072998, -0.098754883, -0.086364746,
      -0.070739746, -0.052368164, -0.032104492, -0.01083374,
      0.01071167, 0.031585693, 0.050872803, 0.067932129, 0.081970215,
      0.092437744, 0.098999023, 0.10134888, 0.099395752, 0.093292236,
      0.083282471, 0.069763184, 0.053375244, 0.034729004, 0.01461792,
      -0.0061035156, -0.026641846, -0.046142578, -0.063751221,
      -0.078857422, -0.090820312, -0.099121094, -0.10351562,
      -0.1038208, -0.099975586, -0.092254639, -0.080932617,
      -0.066497803, -0.049560547, -0.030822754, -0.011016846,
      0.0090026855, 0.028411865, 0.046478271, 0.062408447,
      0.075592041, 0.085571289, 0.091827393, 0.094177246, 0.092590332,
      0.087097168, 0.077941895, 0.065582275, 0.050445557, 0.033203125,
      0.014587402, -0.0046691895, -0.023803711, -0.04196167,
      -0.05847168, -0.072662354, -0.083892822, -0.091827393,
      -0.096099854, -0.0965271, -0.093170166, -0.086181641,
      -0.075775146, -0.062530518, -0.046875, -0.029510498,
      -0.011169434, 0.0074462891, 0.02557373, 0.042419434,
      0.057342529, 0.069793701, 0.079162598, 0.085174561, 0.087585449,
      0.086273193, 0.081329346, 0.073028564, 0.061645508, 0.047668457,
      0.031768799, 0.014465332, -0.0034484863, -0.021209717,
      -0.038208008, -0.053649902, -0.066925049, -0.077575684,
      -0.085113525, -0.089233398, -0.08984375, -0.086914062,
      -0.080535889, -0.071075439, -0.058837891, -0.044342041,
      -0.028289795, -0.011230469, 0.0061340332, 0.023010254,
      0.038787842, 0.05279541, 0.064483643, 0.073394775, 0.079162598,
      0.081542969, 0.080535889, 0.07611084, 0.068481445, 0.058044434,
      0.045166016, 0.03036499, 0.014343262, -0.0023193359,
      -0.018951416, -0.034820557, -0.049285889, -0.061828613,
      -0.071868896, -0.079040527, -0.083099365, -0.083831787,
      -0.081237793, -0.075500488, -0.066772461, -0.055480957,
      -0.042114258, -0.027130127, -0.011230469, 0.0049133301,
      0.020751953, 0.035552979, 0.048706055, 0.059783936, 0.068237305,
      0.073760986, 0.076202393, 0.075408936, 0.07144165, 0.064483643,
      0.054840088, 0.042877197, 0.029174805, 0.014190674,
      -0.0014038086, -0.016937256, -0.031829834, -0.045501709,
      -0.057312012, -0.066864014, -0.073760986, -0.077667236,
      -0.078552246, -0.076293945, -0.071044922, -0.063018799,
      -0.052581787, -0.040100098, -0.026153564, -0.011291504,
      0.00390625, 0.018768311, 0.032714844, 0.045196533, 0.05569458,
      0.063751221, 0.069152832, 0.071563721, 0.070983887, 0.067443848,
      0.061035156, 0.052093506, 0.040985107, 0.028137207, 0.014099121,
      -0.00051879883, -0.015197754, -0.029296875, -0.042205811,
      -0.053466797, -0.062591553, -0.069213867, -0.073120117,
      -0.07409668, -0.072113037, -0.067321777, -0.059906006,
      -0.050140381, -0.038482666, -0.025360107, -0.011322021,
      0.0029907227, 0.017089844, 0.03036499, 0.042236328, 0.052276611,
      0.060089111, 0.0652771, 0.067749023, 0.067382812, 0.064117432,
      0.058227539, 0.04989624, 0.039428711, 0.02734375, 0.014099121,
      0.00021362305, -0.013702393, -0.027099609, -0.039459229,
      -0.050231934, -0.058990479, -0.065429688, -0.069244385,
      -0.0703125, -0.068634033, -0.064208984, -0.057250977,
      -0.048126221, -0.037109375, -0.024688721, -0.011413574,
      0.0021972656, 0.015625, 0.028259277, 0.039642334, 0.049285889,
      0.056793213, 0.061889648, 0.064361572, 0.064117432, 0.061187744,
      0.05569458, 0.047851562, 0.03805542, 0.026611328, 0.014038086,
      0.00088500977, -0.012329102, -0.025146484, -0.03692627,
      -0.047241211, -0.055725098, -0.061920166, -0.065673828,
      -0.066864014, -0.065338135, -0.061279297, -0.05480957,
      -0.046203613, -0.035797119, -0.024078369, -0.011474609,
      0.0014648438, 0.014251709, 0.02633667, 0.037200928, 0.046447754,
      0.053741455, 0.05871582, 0.061157227, 0.061096191, 0.058441162,
      0.053314209, 0.04598999, 0.036712646, 0.025909424, 0.014007568,
      0.0014953613, -0.011138916, -0.02331543, -0.034576416,
      -0.044494629, -0.052612305, -0.058654785, -0.06237793,
      -0.063598633, -0.062316895, -0.058563232, -0.052490234,
      -0.044403076, -0.034606934, -0.023468018, -0.011505127,
      0.00079345703, 0.013000488, 0.024505615, 0.034942627,
      0.04385376, 0.050872803, 0.05569458, 0.058197021, 0.058227539,
      0.055786133, 0.051055908, 0.044158936, 0.035430908, 0.02520752,
      0.013916016, 0.0020141602, -0.009979248, -0.021636963,
      -0.032440186, -0.041931152, -0.04977417, -0.055664062,
      -0.059265137, -0.060577393, -0.05947876, -0.055999756,
      -0.050354004, -0.042724609, -0.033447266, -0.022918701,
      -0.011566162, 0.00018310547, 0.011810303, 0.022827148,
      0.032836914, 0.041381836, 0.048187256, 0.05291748, 0.055389404,
      0.055541992, 0.053344727, 0.048919678, 0.042449951, 0.034210205,
      0.024536133, 0.013793945, 0.0025024414, -0.008972168,
      -0.020080566, -0.030426025, -0.039581299, -0.047149658,
      -0.05279541, -0.056396484, -0.057739258, -0.056793213,
      -0.053619385, -0.048309326, -0.041137695, -0.03237915,
      -0.022369385, -0.011566162, -0.00039672852, 0.01071167,
      0.02130127, 0.030883789, 0.039123535, 0.045684814, 0.050292969,
      0.052764893, 0.053039551, 0.051055908, 0.046936035, 0.040863037,
      0.033081055, 0.023895264, 0.01373291, 0.0029296875,
      -0.0079956055, -0.01864624, -0.028564453, -0.037353516,
      -0.044647217, -0.050170898, -0.05368042, -0.055084229,
      -0.054290771, -0.051361084, -0.046386719, -0.039642334,
      -0.031311035, -0.021820068, -0.011566162, -0.00088500977,
      0.0097351074, 0.019836426, 0.029083252, 0.037017822,
      0.043365479, 0.04788208, 0.050323486, 0.050689697, 0.048919678,
      0.045074463, 0.039367676, 0.032012939, 0.02331543, 0.01361084,
      0.0033569336, -0.0071105957, -0.017303467, -0.026794434,
      -0.035247803, -0.042327881, -0.047668457, -0.051147461,
      -0.052581787, -0.0519104, -0.049224854, -0.044586182,
      -0.03817749, -0.030334473, -0.021331787, -0.011505127,
      -0.0013427734, 0.0088195801, 0.01852417, 0.027374268,
      0.03503418, 0.04119873, 0.045593262, 0.048034668, 0.048492432,
      0.046905518, 0.043334961, 0.037963867, 0.031005859, 0.022735596,
      0.013519287, 0.003692627, -0.0062866211, -0.016021729,
      -0.025177002, -0.033325195, -0.040130615, -0.045349121,
      -0.04876709, -0.050231934, -0.049713135, -0.047210693,
      -0.04284668, -0.036834717, -0.029388428, -0.020812988,
      -0.011474609, -0.001739502, 0.0079650879, 0.017272949,
      0.025787354, 0.033203125, 0.039154053, 0.043457031, 0.045898438,
      0.046417236, 0.04498291, 0.041687012, 0.036621094, 0.030029297,
      0.022186279, 0.013397217, 0.0040588379, -0.0054931641,
      -0.014862061, -0.023651123, -0.031494141, -0.038085938,
      -0.043151855, -0.046508789, -0.048034668, -0.047607422,
      -0.045318604, -0.041259766, -0.035552979, -0.0284729,
      -0.020324707, -0.011413574, -0.0021057129, 0.0071716309,
      0.016113281, 0.02432251, 0.031463623, 0.037231445, 0.041442871,
      0.043884277, 0.044464111, 0.043212891, 0.040100098, 0.035339355,
      0.02911377, 0.021636963, 0.013275146, 0.0043640137,
      -0.0048217773, -0.013763428, -0.022216797, -0.029785156,
      -0.03616333, -0.041107178, -0.044403076, -0.045928955,
      -0.045623779, -0.043548584, -0.039703369, -0.034332275,
      -0.027648926, -0.019866943, -0.011352539, -0.0024719238,
      0.0064697266, 0.015045166, 0.022918701, 0.029815674,
      0.035430908, 0.039520264, 0.04196167, 0.042602539, 0.041473389,
      0.038604736, 0.034118652, 0.02822876, 0.021148682, 0.013153076,
      0.0046081543, -0.0041503906, -0.012756348, -0.020874023,
      -0.028167725, -0.034332275, -0.039154053, -0.042388916,
      -0.043945312, -0.043762207, -0.041809082, -0.038238525,
      -0.033172607, -0.026794434, -0.01940918, -0.011291504,
      -0.0027770996, 0.0057678223, 0.014007568, 0.021636963,
      0.028259277, 0.033691406, 0.037719727, 0.040100098, 0.04083252,
      0.039825439, 0.03717041, 0.032958984, 0.027374268, 0.020599365,
      0.013000488, 0.0048522949, -0.0035400391, -0.011810303,
      -0.019592285, -0.026641846, -0.032623291, -0.03729248,
      -0.040466309, -0.042053223, -0.041931152, -0.04019165,
      -0.036834717, -0.032012939, -0.026000977, -0.018951416,
      -0.011199951, -0.0030517578, 0.0051269531, 0.013061523,
      0.020385742, 0.026794434, 0.032073975, 0.035980225, 0.038360596,
      0.039123535, 0.038238525, 0.035766602, 0.031799316, 0.026489258,
      0.020080566, 0.0128479, 0.0050354004, -0.0029907227,
      -0.010894775, -0.018432617, -0.02520752, -0.030975342,
      -0.035522461, -0.038635254, -0.040222168, -0.04019165,
      -0.038574219, -0.035430908, -0.030914307, -0.025177002,
      -0.018493652, -0.011108398, -0.0032958984, 0.0045471191,
      0.012145996, 0.019195557, 0.025390625, 0.030487061, 0.034301758,
      0.036651611, 0.037475586, 0.036712646, 0.034423828, 0.030670166,
      0.025665283, 0.019592285, 0.012664795, 0.0052185059,
      -0.0024719238, -0.010070801, -0.017272949, -0.023803711,
      -0.029388428, -0.033813477, -0.036865234, -0.038452148,
      -0.038513184, -0.03704834, -0.034118652, -0.029815674,
      -0.024383545, -0.018035889, -0.010955811, -0.0035400391,
      0.0039978027, 0.011291504, 0.018066406, 0.024047852,
      0.028991699, 0.032684326, 0.035003662, 0.035858154, 0.035217285,
      0.033081055, 0.029571533, 0.024810791, 0.019042969, 0.012481689,
      0.0053405762, -0.0020141602, -0.0092773438, -0.016204834,
      -0.022491455, -0.027862549, -0.032165527, -0.03515625,
      -0.036743164, -0.036865234, -0.035552979, -0.032775879,
      -0.028778076, -0.023620605, -0.017547607, -0.01083374,
      -0.0037231445, 0.0034790039, 0.010467529, 0.016967773,
      0.022735596, 0.027526855, 0.03112793, 0.033416748, 0.034301758,
      0.033752441, 0.031768799, 0.0284729, 0.023986816, 0.01852417,
      0.012237549, 0.0054626465, -0.0015563965, -0.0085449219,
      -0.015167236, -0.021209717, -0.026428223, -0.030578613,
      -0.033508301, -0.035095215, -0.03527832, -0.034057617,
      -0.031524658, -0.027709961, -0.022827148, -0.017089844,
      -0.010681152, -0.00390625, 0.0029907227, 0.0096740723,
      0.015960693, 0.021484375, 0.026123047, 0.029632568, 0.031890869,
      0.032806396, 0.032348633, 0.030517578, 0.027435303, 0.023193359,
      0.017974854, 0.012023926, 0.0055847168, -0.001159668,
      -0.0078125, -0.014190674, -0.020019531, -0.025024414,
      -0.029052734, -0.031921387, -0.033477783, -0.033752441,
      -0.032653809, -0.030273438, -0.026702881, -0.022094727,
      -0.016601562, -0.010498047, -0.0040588379, 0.002532959,
      0.008972168, 0.014953613, 0.020324707, 0.024780273, 0.028198242,
      0.030426025, 0.031341553, 0.030975342, 0.029296875, 0.026397705,
      0.022399902, 0.017486572, 0.011810303, 0.005645752,
      -0.00076293945, -0.0071411133, -0.013275146, -0.018859863,
      -0.023681641, -0.027587891, -0.03036499, -0.031951904,
      -0.03225708, -0.03125, -0.029052734, -0.025695801, -0.02130127,
      -0.016113281, -0.010345459, -0.0041503906, 0.0021362305,
      0.0082702637, 0.014068604, 0.019195557, 0.023498535,
      0.026824951, 0.028991699, 0.029937744, 0.029663086, 0.028106689,
      0.025390625, 0.021636963, 0.016967773, 0.011566162,
      0.0057067871, -0.00039672852, -0.0065307617, -0.012359619,
      -0.01776123, -0.022399902, -0.026184082, -0.028900146,
      -0.030456543, -0.030792236, -0.029937744, -0.027862549,
      -0.024688721, -0.020568848, -0.015655518, -0.010131836,
      -0.0042419434, 0.001739502, 0.0076599121, 0.013183594,
      0.018127441, 0.022277832, 0.025512695, 0.027618408, 0.028625488,
      0.028381348, 0.026977539, 0.02444458, 0.020874023, 0.016448975,
      0.011352539, 0.0057373047, -9.1552734e-05, -0.0059204102,
      -0.011535645, -0.016693115, -0.021179199, -0.024841309,
      -0.02746582, -0.029022217, -0.029418945, -0.028625488,
      -0.026702881, -0.023742676, -0.019866943, -0.015197754,
      -0.0099487305, -0.0043334961, 0.0014038086, 0.007019043,
      0.012329102, 0.017089844, 0.021087646, 0.024230957, 0.026306152,
      0.027282715, 0.027130127, 0.025848389, 0.023468018, 0.020111084,
      0.015930176, 0.011077881, 0.0057678223, 0.00021362305,
      -0.0053710938, -0.010742188, -0.015686035, -0.020019531,
      -0.023529053, -0.026123047, -0.027648926, -0.028076172,
      -0.027374268, -0.025604248, -0.022827148, -0.019134521,
      -0.01473999, -0.0097351074, -0.0043945312, 0.0010681152,
      0.0064697266, 0.011535645, 0.016113281, 0.019989014,
      0.023010254, 0.025024414, 0.026031494, 0.025939941, 0.024749756,
      0.02255249, 0.019378662, 0.015411377, 0.01083374, 0.0057678223,
      0.00045776367, -0.0048522949, -0.010009766, -0.01473999,
      -0.018890381, -0.02230835, -0.024810791, -0.02633667,
      -0.026794434, -0.026184082, -0.024536133, -0.021911621,
      -0.018463135, -0.014251709, -0.009552002, -0.0044555664,
      0.00076293945, 0.0059204102, 0.010772705, 0.015167236,
      0.018890381, 0.021820068, 0.023803711, 0.024810791, 0.024749756,
      0.023681641, 0.021606445, 0.01864624, 0.014923096, 0.010559082,
      0.0057373047, 0.0007019043, -0.0043945312, -0.0093078613,
      -0.01385498, -0.017852783, -0.021118164, -0.02355957,
      -0.025054932, -0.025543213, -0.024993896, -0.023498535,
      -0.021057129, -0.01776123, -0.013824463, -0.0093383789,
      -0.004486084, 0.00048828125, 0.0054016113, 0.010040283,
      0.014251709, 0.017852783, 0.020690918, 0.022613525, 0.023620605,
      0.023620605, 0.022644043, 0.020721436, 0.017944336, 0.014404297,
      0.010284424, 0.0057373047, 0.00091552734, -0.0039367676,
      -0.0086364746, -0.013000488, -0.016815186, -0.019989014,
      -0.022338867, -0.023803711, -0.02432251, -0.023864746,
      -0.022460938, -0.020172119, -0.017089844, -0.013366699,
      -0.0090942383, -0.0045166016, 0.00021362305, 0.0049133301,
      0.0093688965, 0.013397217, 0.016845703, 0.019592285,
      0.021484375, 0.022491455, 0.022521973, 0.021636963, 0.019866943,
      0.017242432, 0.013916016, 0.010009766, 0.0056762695,
      0.0010986328, -0.0035095215, -0.0079956055, -0.012176514,
      -0.015838623, -0.018890381, -0.021179199, -0.022613525,
      -0.023162842, -0.022766113, -0.021484375, -0.019348145,
      -0.016418457, -0.012908936, -0.0088806152, -0.0045166016, 0,
      0.0044555664, 0.0087280273, 0.012573242, 0.015899658,
      0.01852417, 0.020385742, 0.021362305, 0.021484375, 0.0206604,
      0.019012451, 0.016571045, 0.013427734, 0.0097045898,
      0.0056152344, 0.0012817383, -0.003112793, -0.0073852539,
      -0.011383057, -0.014923096, -0.017822266, -0.020050049,
      -0.021453857, -0.022003174, -0.021697998, -0.020507812,
      -0.018493652, -0.015777588, -0.012451172, -0.0086364746,
      -0.004486084, -0.00021362305, 0.0040588379, 0.0080871582,
      0.011779785, 0.014984131, 0.01751709, 0.019317627, 0.020294189,
      0.020446777, 0.019714355, 0.018188477, 0.015869141, 0.012908936,
      0.0094299316, 0.0055541992, 0.0014343262, -0.002746582,
      -0.0068359375, -0.010620117, -0.014007568, -0.016815186,
      -0.018981934, -0.020355225, -0.020904541, -0.020629883,
      -0.019561768, -0.017700195, -0.015136719, -0.011993408,
      -0.008392334, -0.0044555664, -0.00039672852, 0.0036621094,
      0.0075073242, 0.011047363, 0.014099121, 0.016540527,
      0.018280029, 0.019256592, 0.01940918, 0.018768311, 0.017364502,
      0.015197754, 0.012420654, 0.0091247559, 0.0054626465,
      0.0015563965, -0.0024108887, -0.0062866211, -0.0099182129,
      -0.013153076, -0.015838623, -0.017913818, -0.019256592,
      -0.019836426, -0.019622803, -0.018615723, -0.016876221,
      -0.01449585, -0.011535645, -0.0081176758, -0.0044250488,
      -0.00057983398, 0.0032958984, 0.0069580078, 0.010314941,
      0.013244629, 0.015594482, 0.017272949, 0.018249512, 0.018432617,
      0.017852783, 0.016540527, 0.014556885, 0.011932373,
      0.0088195801, 0.0053710938, 0.0016784668, -0.0021057129,
      -0.0057678223, -0.0092468262, -0.012329102, -0.014892578,
      -0.016906738, -0.018188477, -0.018768311, -0.018615723,
      -0.017700195, -0.016082764, -0.01385498, -0.011047363,
      -0.0078430176, -0.0043640137, -0.0007019043, 0.0029296875,
      0.006439209, 0.0096435547, 0.012451172, 0.014678955,
      0.016326904, 0.017272949, 0.017486572, 0.016967773, 0.01574707,
      0.013885498, 0.011444092, 0.0085144043, 0.0052490234,
      0.0017700195, -0.0018005371, -0.0053100586, -0.0085754395,
      -0.011535645, -0.014007568, -0.015899658, -0.017181396,
      -0.01776123, -0.01763916, -0.016815186, -0.015319824,
      -0.013214111, -0.0105896, -0.007598877, -0.0042724609,
      -0.00082397461, 0.0026245117, 0.0059509277, 0.0090026855,
      0.011657715, 0.013824463, 0.015380859, 0.016296387, 0.016540527,
      0.016082764, 0.014984131, 0.013244629, 0.010955811,
      0.0082092285, 0.0051269531, 0.0018310547, -0.0015258789,
      -0.0048522949, -0.0079650879, -0.010772705, -0.013122559,
      -0.014953613, -0.016204834, -0.01675415, -0.016693115,
      -0.015930176, -0.014556885, -0.01260376, -0.010131836,
      -0.0072937012, -0.0042114258, -0.00094604492, 0.0023193359,
      0.0054626465, 0.0083618164, 0.010894775, 0.012939453,
      0.014465332, 0.015380859, 0.015625, 0.015228271, 0.014221191,
      0.012573242, 0.010467529, 0.0078735352, 0.0049743652,
      0.0018920898, -0.0012817383, -0.0044250488, -0.0073852539,
      -0.010040283, -0.012298584, -0.014038086, -0.015228271,
      -0.015808105, -0.01574707, -0.015075684, -0.013793945,
      -0.011962891, -0.0096740723, -0.007019043, -0.004119873,
      -0.0010375977, 0.0020446777, 0.0050048828, 0.0077514648,
      0.010162354, 0.012115479, 0.013580322, 0.014465332, 0.01473999,
      0.014373779, 0.013458252, 0.011962891, 0.0099487305,
      0.0075378418, 0.0048522949, 0.0019226074, -0.0010681152,
      -0.0040283203, -0.0068054199, -0.0093383789, -0.011474609,
      -0.013153076, -0.014312744, -0.014862061, -0.014862061,
      -0.014251709, -0.013061523, -0.011352539, -0.0092468262,
      -0.0067443848, -0.0039978027, -0.0011291504, 0.0017700195,
      0.0045776367, 0.0071716309, 0.0094604492, 0.011322021,
      0.012695312, 0.013580322, 0.01385498, 0.013549805, 0.012695312,
      0.011322021, 0.0094604492, 0.007232666, 0.0046691895,
      0.001953125, -0.00085449219, -0.0036621094, -0.0062866211,
      -0.0086669922, -0.010681152, -0.012298584, -0.013397217,
      -0.013946533, -0.013946533, -0.013397217, -0.012329102,
      -0.010772705, -0.0087585449, -0.006439209, -0.00390625,
      -0.0011901855, 0.0015258789, 0.0041809082, 0.0066223145,
      0.0087585449, 0.010559082, 0.011871338, 0.012695312,
      0.013000488, 0.012756348, 0.011962891, 0.010681152, 0.008972168,
      0.0068664551, 0.0045166016, 0.001953125, -0.00067138672,
      -0.0032958984, -0.0057678223, -0.0079956055, -0.0099182129,
      -0.011444092, -0.012512207, -0.013061523, -0.013092041,
      -0.01260376, -0.01159668, -0.010162354, -0.0083007812,
      -0.0061645508, -0.0037536621, -0.0012512207, 0.0013122559,
      0.0037841797, 0.0061035156, 0.0081176758, 0.0097961426,
      0.011077881, 0.011871338, 0.012145996, 0.011932373, 0.011230469,
      0.010070801, 0.0084838867, 0.0065307617, 0.0043334961,
      0.001953125, -0.00051879883, -0.0029602051, -0.005279541,
      -0.0073852539, -0.009185791, -0.010620117, -0.011627197,
      -0.012176514, -0.012237549, -0.011779785, -0.010894775,
      -0.009552002, -0.0078430176, -0.0058288574, -0.0036315918,
      -0.0012817383, 0.0011291504, 0.0034179688, 0.0055847168,
      0.0075073242, 0.0090637207, 0.010284424, 0.011047363,
      0.011322021, 0.011169434, 0.010528564, 0.0094604492,
      0.0079956055, 0.0061950684, 0.0041503906, 0.0019226074,
      -0.00036621094, -0.0026550293, -0.0048217773, -0.0067749023,
      -0.0084838867, -0.0098266602, -0.010803223, -0.011322021,
      -0.011383057, -0.010986328, -0.010192871, -0.0089416504,
      -0.0073852539, -0.0055236816, -0.0034790039, -0.0012817383,
      0.00094604492, 0.0030822754, 0.0050964355, 0.0068969727,
      0.008392334, 0.0095214844, 0.010223389, 0.010528564,
      0.010406494, 0.0098266602, 0.0088500977, 0.0075073242,
      0.0058288574, 0.0039672852, 0.0018920898, -0.00021362305,
      -0.0023498535, -0.0043640137, -0.0061950684, -0.0077819824,
      -0.0090637207, -0.009979248, -0.010467529, -0.010559082,
      -0.010223389, -0.0094909668, -0.0083618164, -0.0069274902,
      -0.0052185059, -0.0032958984, -0.0012817383, 0.00076293945,
      0.0027770996, 0.0046386719, 0.0063171387, 0.0076904297,
      0.0087585449, 0.0094604492, 0.0097351074, 0.0096435547,
      0.0091247559, 0.0082397461, 0.0069885254, 0.0054931641,
      0.0037536621, 0.0018615723, -0.00012207031, -0.0020751953,
      -0.0039367676, -0.005645752, -0.0071411133, -0.0083312988,
      -0.009185791, -0.0096740723, -0.009765625, -0.0094604492,
      -0.0087890625, -0.0077819824, -0.006439209, -0.0048828125,
      -0.0031433105, -0.0012817383, 0.00061035156, 0.0024719238,
      0.0042114258, 0.0057373047, 0.0070495605, 0.008026123,
      0.0086975098, 0.008972168, 0.0088806152, 0.0084228516,
      0.0076293945, 0.0065002441, 0.0051269531, 0.0035400391,
      0.0018005371, 0, -0.0018005371, -0.0035400391, -0.0051269531,
      -0.0065002441, -0.007598877, -0.008392334, -0.0088500977,
      -0.008972168, -0.0086975098, -0.0081176758, -0.0071716309,
      -0.0059814453, -0.0045471191, -0.0029602051, -0.0012512207,
      0.00048828125, 0.0021972656, 0.0037841797, 0.0052185059,
      0.0064086914, 0.0073242188, 0.0079345703, 0.0082092285,
      0.0081481934, 0.0077514648, 0.007019043, 0.0060119629,
      0.0047607422, 0.0032958984, 0.0017089844, 6.1035156e-05,
      -0.0015869141, -0.0031738281, -0.0046081543, -0.0058898926,
      -0.0068969727, -0.0076293945, -0.0080566406, -0.0081787109,
      -0.0079650879, -0.0074157715, -0.0065917969, -0.0055236816,
      -0.0042114258, -0.0027770996, -0.0012207031, 0.00036621094,
      0.0019226074, 0.0033874512, 0.0046691895, 0.0057678223,
      0.0066223145, 0.0072021484, 0.0074768066, 0.0074157715,
      0.0070800781, 0.0064086914, 0.0055236816, 0.0043945312,
      0.0030822754, 0.0016479492, 0.00015258789, -0.001373291,
      -0.0028076172, -0.004119873, -0.005279541, -0.0062255859,
      -0.0068969727, -0.0072937012, -0.0074157715, -0.007232666,
      -0.0067443848, -0.0060119629, -0.0050354004, -0.0038757324,
      -0.0025634766, -0.001159668, 0.0002746582, 0.0016784668,
      0.0029907227, 0.0041809082, 0.0051879883, 0.0059509277,
      0.0064697266, 0.0067443848, 0.0067138672, 0.0064086914,
      0.0058288574, 0.0050048828, 0.0039978027, 0.0028381348,
      0.0015258789, 0.00018310547, -0.001159668, -0.0024719238,
      -0.0036621094, -0.004699707, -0.0055541992, -0.0061645508,
      -0.0065307617, -0.006652832, -0.0065002441, -0.006072998,
      -0.0054321289, -0.0045776367, -0.0035400391, -0.0023498535,
      -0.0010986328, 0.00018310547, 0.0014343262, 0.0026245117,
      0.003692627, 0.0046081543, 0.0053100586, 0.0057678223,
      0.0060119629, 0.0060119629, 0.0057373047, 0.0052185059,
      0.0045166016, 0.0036315918, 0.0025634766, 0.0014343262,
      0.00024414062, -0.0009765625, -0.0021362305, -0.0032043457,
      -0.0041503906, -0.0049133301, -0.0054626465, -0.0057983398,
      -0.0059204102, -0.0057678223, -0.0054321289, -0.0048522949,
      -0.0040893555, -0.0031738281, -0.0021362305, -0.0010375977,
      9.1552734e-05, 0.0012207031, 0.0022583008, 0.0032348633,
      0.0040283203, 0.0046691895, 0.0050964355, 0.0053100586,
      0.0053100586, 0.005065918, 0.0046386719, 0.0039978027,
      0.0032348633, 0.0023193359, 0.0013122559, 0.00024414062,
      -0.00079345703, -0.0018310547, -0.0027770996, -0.0036010742,
      -0.0042724609, -0.0047607422, -0.005065918, -0.0051879883,
      -0.005065918, -0.0047607422, -0.0042724609, -0.0036010742,
      -0.0028076172, -0.0019226074, -0.00094604492, 3.0517578e-05,
      0.0010070801, 0.0019226074, 0.0027770996, 0.0034790039,
      0.0040283203, 0.0043945312, 0.0046081543, 0.0046081543,
      0.0044250488, 0.0040283203, 0.0035095215, 0.0028381348,
      0.0020446777, 0.001159668, 0.0002746582, -0.00064086914,
      -0.0015258789, -0.0023498535, -0.0030517578, -0.0036621094,
      -0.0040893555, -0.0043640137, -0.0044555664, -0.0043640137,
      -0.0040893555, -0.003692627, -0.003112793, -0.0024414062,
      -0.0016784668, -0.00085449219, 0, 0.00082397461, 0.0016174316,
      0.0023193359, 0.0029296875, 0.0034179688, 0.0037536621,
      0.00390625, 0.00390625, 0.0037536621, 0.0034484863,
      0.0029907227, 0.0024414062, 0.0017700195, 0.0010375977,
      0.0002746582, -0.00051879883, -0.0012512207, -0.001953125,
      -0.0025634766, -0.0030517578, -0.0034179688, -0.0036621094,
      -0.0037231445, -0.0036621094, -0.0034484863, -0.003112793,
      -0.0026245117, -0.0020751953, -0.0014343262, -0.00073242188,
      -3.0517578e-05, 0.00067138672, 0.0013122559, 0.0019226074,
      0.0024108887, 0.0028076172, 0.0030822754, 0.0032348633,
      0.0032348633, 0.003112793, 0.0028686523, 0.0025024414,
      0.0020141602, 0.0014648438, 0.00088500977, 0.00024414062,
      -0.00039672852, -0.0010070801, -0.0015563965, -0.0020446777,
      -0.0024719238, -0.0027770996, -0.0029602051, -0.0030212402,
      -0.0029602051, -0.0028076172, -0.0025024414, -0.0021362305,
      -0.0016784668, -0.001159668, -0.00061035156, -6.1035156e-05,
      0.00048828125, 0.0010375977, 0.0014953613, 0.0018920898,
      0.0022277832, 0.0024414062, 0.0025634766, 0.0025634766,
      0.0024719238, 0.0022583008, 0.0019836426, 0.0016174316,
      0.0011901855, 0.0007019043, 0.00021362305, -0.0002746582,
      -0.00076293945, -0.0011901855, -0.0015563965, -0.0018920898,
      -0.0021057129, -0.0022583008, -0.0023193359, -0.0022583008,
      -0.0021362305, -0.0019226074, -0.0016479492, -0.0012817383,
      -0.00091552734, -0.00048828125, -6.1035156e-05, 0.00036621094,
      0.00076293945, 0.0010986328, 0.0014038086, 0.0016479492,
      0.0018005371, 0.0018920898, 0.0018920898, 0.0018005371,
      0.0016479492, 0.0014343262, 0.0011901855, 0.00085449219,
      0.00051879883, 0.00018310547, -0.00018310547, -0.00051879883,
      -0.00082397461, -0.0010986328, -0.0013122559, -0.0014953613,
      -0.0015869141, -0.0016174316, -0.0015869141, -0.0014953613,
      -0.0013427734, -0.0011291504, -0.00088500977, -0.00064086914,
      -0.00033569336, -6.1035156e-05, 0.00021362305, 0.00048828125,
      0.00073242188, 0.00091552734, 0.0010681152, 0.001159668,
      0.0012207031, 0.0012207031, 0.001159668, 0.0010681152,
      0.00091552734, 0.00073242188, 0.00054931641, 0.00033569336,
      0.00012207031, -9.1552734e-05, -0.00030517578, -0.00048828125,
      -0.00064086914, -0.00076293945, -0.00085449219, -0.00091552734,
      -0.00091552734, -0.00088500977, -0.00082397461, -0.00073242188,
      -0.00061035156, -0.00048828125, -0.00033569336, -0.00018310547,
      -3.0517578e-05, 0.00012207031, 0.00024414062, 0.00033569336,
      0.00042724609, 0.00048828125, 0.00054931641, 0.00054931641,
      0.00054931641, 0.00051879883, 0.00045776367, 0.00039672852,
      0.00030517578, 0.00021362305, 0.00012207031, 6.1035156e-05,
      -3.0517578e-05, -9.1552734e-05, -0.00015258789, -0.00018310547,
      -0.00021362305, -0.00024414062, -0.00024414062, -0.00021362305,
      -0.00021362305, -0.00018310547, -0.00012207031, -9.1552734e-05,
      -6.1035156e-05, -3.0517578e-05, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0,
};

const jack_nframes_t Session::default_click_emphasis_length = sizeof (default_click_emphasis) / sizeof (default_click_emphasis[0]);

const Sample Session::default_click[] = {
              0, -0.014312744, -0.03338623, 0.019165039, 0.042541504,
              0.08984375, 0.082611084, 0.13909912, 0.17236328,
              0.19238281, 0.21087646, 0.22238159, 0.23114014,
              0.23321533, 0.23080444, 0.222229, 0.20944214,
              0.19146729, 0.16964722, 0.14352417, 0.11450195,
              0.082489014, 0.049316406, 0.014068604, -0.020507812,
              -0.055969238, -0.089233398, -0.1211853, -0.15036011,
              -0.1763916, -0.19882202, -0.2170105, -0.23062134,
              -0.23916626, -0.24279785, -0.24142456, -0.23483276,
              -0.22357178, -0.2074585, -0.18701172, -0.16308594,
              -0.1355896, -0.10562134, -0.073547363, -0.040100098,
              -0.0061645508, 0.027618408, 0.060394287, 0.091796875,
              0.12072754, 0.14685059, 0.16949463, 0.18804932,
              0.20245361, 0.21212769, 0.21694946, 0.21691895,
              0.21191406, 0.20214844, 0.18786621, 0.16943359,
              0.14706421, 0.12145996, 0.093139648, 0.06262207,
              0.030822754, -0.0018310547, -0.034545898, -0.066467285,
              -0.097076416, -0.12564087, -0.15155029, -0.17422485,
              -0.19326782, -0.20812988, -0.21862793, -0.22457886,
              -0.22567749, -0.22210693, -0.21392822, -0.20120239,
              -0.18438721, -0.16381836, -0.13986206, -0.11315918,
              -0.084289551, -0.053771973, -0.02243042, 0.0090942383,
              0.040252686, 0.07019043, 0.098297119, 0.12408447,
              0.14685059, 0.16616821, 0.18170166, 0.19302368,
              0.19985962, 0.20230103, 0.20007324, 0.19329834,
              0.18231201, 0.16711426, 0.14819336, 0.1260376,
              0.10095215, 0.073608398, 0.044647217, 0.01461792,
              -0.015808105, -0.04586792, -0.075073242, -0.10272217,
              -0.12811279, -0.15084839, -0.17041016, -0.1862793,
              -0.19827271, -0.20602417, -0.20941162, -0.20846558,
              -0.203125, -0.19348145, -0.17990112, -0.16259766,
              -0.14190674, -0.11846924, -0.092651367, -0.065002441,
              -0.0362854, -0.0069885254, 0.022247314, 0.05065918,
              0.077758789, 0.10296631, 0.12561035, 0.14532471,
              0.16171265, 0.17428589, 0.18289185, 0.18737793,
              0.18756104, 0.18353271, 0.17541504, 0.16329956,
              0.14755249, 0.12854004, 0.10656738, 0.082244873,
              0.056091309, 0.028594971, 0.00045776367, -0.027709961,
              -0.055419922, -0.08190918, -0.10665894, -0.12924194,
              -0.14901733, -0.1656189, -0.17877197, -0.18811035,
              -0.19342041, -0.19473267, -0.19189453, -0.18505859,
              -0.17440796, -0.16009521, -0.14245605, -0.12203979,
              -0.099121094, -0.07421875, -0.048034668, -0.020935059,
              0.0063781738, 0.033233643, 0.059234619, 0.083709717,
              0.1060791, 0.12600708, 0.14294434, 0.15655518,
              0.16662598, 0.17288208, 0.1751709, 0.17355347,
              0.16802979, 0.15866089, 0.14581299, 0.12966919,
              0.1105957, 0.089080811, 0.065551758, 0.040466309,
              0.014556885, -0.011779785, -0.037963867, -0.063293457,
              -0.087341309, -0.10958862, -0.12942505, -0.14654541,
              -0.16061401, -0.1711731, -0.17816162, -0.18145752,
              -0.18081665, -0.17642212, -0.16836548, -0.15673828,
              -0.14193726, -0.12426758, -0.10400391, -0.081695557,
              -0.057891846, -0.032928467, -0.0075073242, 0.017791748,
              0.042602539, 0.066192627, 0.088134766, 0.10803223,
              0.12530518, 0.13967896, 0.15087891, 0.15859985,
              0.16265869, 0.16311646, 0.15982056, 0.1529541,
              0.14273071, 0.12921143, 0.11282349, 0.093963623,
              0.072967529, 0.050323486, 0.026580811, 0.002166748,
              -0.022369385, -0.046356201, -0.069458008, -0.091094971,
              -0.11071777, -0.12808228, -0.1427002, -0.15420532,
              -0.16253662, -0.16741943, -0.16867065, -0.16647339,
              -0.1607666, -0.15164185, -0.13946533, -0.12438965,
              -0.10675049, -0.087036133, -0.065582275, -0.042877197,
              -0.019500732, 0.004119873, 0.027496338, 0.049957275,
              0.071228027, 0.090759277, 0.10803223, 0.12283325,
              0.13482666, 0.14364624, 0.14923096, 0.15145874,
              0.150177, 0.14556885, 0.13772583, 0.1267395, 0.11294556,
              0.096679688, 0.078155518, 0.057952881, 0.036499023,
              0.014099121, -0.0085449219, -0.031066895, -0.052978516,
              -0.073730469, -0.092895508, -0.11013794, -0.125,
              -0.13717651, -0.14648438, -0.15264893, -0.15557861,
              -0.15527344, -0.15164185, -0.14486694, -0.13510132,
              -0.12252808, -0.10742188, -0.090240479, -0.07119751,
              -0.05078125, -0.029510498, -0.0077514648, 0.014007568,
              0.035186768, 0.055480957, 0.074401855, 0.091430664,
              0.10638428, 0.11880493, 0.128479, 0.13525391,
              0.13891602, 0.1394043, 0.1368103, 0.13113403,
              0.12246704, 0.11114502, 0.097320557, 0.081268311,
              0.06350708, 0.044281006, 0.024017334, 0.0032958984,
              -0.017578125, -0.038116455, -0.057769775, -0.07623291,
              -0.093109131, -0.10791016, -0.12045288, -0.13046265,
              -0.13763428, -0.14190674, -0.14321899, -0.14141846,
              -0.13674927, -0.12921143, -0.11895752, -0.10629272,
              -0.091491699, -0.074798584, -0.05670166, -0.037536621,
              -0.017700195, 0.0022888184, 0.022033691, 0.04119873,
              0.059234619, 0.075805664, 0.090606689, 0.10324097,
              0.11346436, 0.12112427, 0.12594604, 0.12796021,
              0.12710571, 0.12335205, 0.11682129, 0.10772705,
              0.096191406, 0.082519531, 0.067077637, 0.050079346,
              0.031982422, 0.013244629, -0.0058898926, -0.024902344,
              -0.043334961, -0.060882568, -0.077148438, -0.091674805,
              -0.10430908, -0.11471558, -0.12261963, -0.12799072,
              -0.13061523, -0.13043213, -0.12759399, -0.12203979,
              -0.11392212, -0.10351562, -0.0909729, -0.076568604,
              -0.060699463, -0.043640137, -0.025787354, -0.0075683594,
              0.010650635, 0.028503418, 0.045532227, 0.061431885,
              0.075836182, 0.088409424, 0.098968506, 0.10720825,
              0.11297607, 0.11621094, 0.11682129, 0.11471558,
              0.11010742, 0.10305786, 0.093658447, 0.082214355,
              0.068969727, 0.054138184, 0.038146973, 0.021331787,
              0.0039978027, -0.013397217, -0.030517578, -0.047027588,
              -0.062469482, -0.076568604, -0.089080811, -0.099609375,
              -0.10803223, -0.11419678, -0.1178894, -0.11907959,
              -0.11779785, -0.11398315, -0.1078186, -0.099456787,
              -0.089019775, -0.076751709, -0.063018799, -0.047973633,
              -0.032073975, -0.015655518, 0.0010070801, 0.017456055,
              0.033355713, 0.048431396, 0.062286377, 0.074615479,
              0.085235596, 0.09387207, 0.10031128, 0.10449219,
              0.10629272, 0.10565186, 0.10272217, 0.097442627,
              0.089996338, 0.080566406, 0.069366455, 0.05657959,
              0.042633057, 0.027679443, 0.012115479, -0.003692627,
              -0.01940918, -0.034759521, -0.049316406, -0.062835693,
              -0.075012207, -0.085510254, -0.094238281, -0.10095215,
              -0.10543823, -0.10775757, -0.10778809, -0.10552979,
              -0.10107422, -0.094512939, -0.085968018, -0.075714111,
              -0.063934326, -0.050842285, -0.036834717, -0.022125244,
              -0.0070800781, 0.0079650879, 0.022705078, 0.036865234,
              0.050018311, 0.061981201, 0.072479248, 0.081268311,
              0.088165283, 0.093109131, 0.095855713, 0.096466064,
              0.094940186, 0.091247559, 0.085510254, 0.077911377,
              0.06854248, 0.057678223, 0.045593262, 0.032440186,
              0.018585205, 0.0043640137, -0.010009766, -0.024169922,
              -0.037750244, -0.050567627, -0.062286377, -0.072631836,
              -0.081451416, -0.088500977, -0.093658447, -0.096862793,
              -0.097961426, -0.097015381, -0.094024658, -0.089080811,
              -0.082275391, -0.073791504, -0.063812256, -0.052520752,
              -0.040252686, -0.027191162, -0.013641357, 0,
              0.013580322, 0.026733398, 0.039154053, 0.050628662,
              0.060913086, 0.069702148, 0.076934814, 0.082366943,
              0.085906982, 0.087524414, 0.087158203, 0.08480835,
              0.080627441, 0.074615479, 0.066925049, 0.057800293,
              0.047393799, 0.035888672, 0.023651123, 0.010894775,
              -0.0021362305, -0.015106201, -0.027740479, -0.039825439,
              -0.050994873, -0.061096191, -0.069885254, -0.077148438,
              -0.082763672, -0.086669922, -0.088684082, -0.088806152,
              -0.087097168, -0.083526611, -0.07824707, -0.071350098,
              -0.062957764, -0.053314209, -0.042633057, -0.031066895,
              -0.018981934, -0.0065917969, 0.0058288574, 0.018035889,
              0.029693604, 0.040649414, 0.050628662, 0.059356689,
              0.066741943, 0.072570801, 0.076721191, 0.079162598,
              0.079772949, 0.078613281, 0.075714111, 0.071105957,
              0.064880371, 0.057281494, 0.048400879, 0.038421631,
              0.027618408, 0.016204834, 0.0043945312, -0.0074768066,
              -0.019195557, -0.030548096, -0.041168213, -0.050964355,
              -0.059661865, -0.067047119, -0.072998047, -0.077453613,
              -0.080169678, -0.081237793, -0.080596924, -0.078216553,
              -0.074249268, -0.068725586, -0.061767578, -0.05355835,
              -0.044281006, -0.034088135, -0.023284912, -0.012084961,
              -0.00067138672, 0.010650635, 0.021606445, 0.032043457,
              0.041687012, 0.050292969, 0.057769775, 0.063903809,
              0.06854248, 0.071655273, 0.073120117, 0.072937012,
              0.071166992, 0.067749023, 0.062835693, 0.056549072,
              0.048980713, 0.040313721, 0.030792236, 0.020568848,
              0.0098571777, -0.0010375977, -0.011932373, -0.022613525,
              -0.032745361, -0.042236328, -0.050811768, -0.058288574,
              -0.064544678, -0.069396973, -0.072784424, -0.074645996,
              -0.074890137, -0.073547363, -0.070709229, -0.066375732,
              -0.060638428, -0.05368042, -0.045593262, -0.036590576,
              -0.026916504, -0.016693115, -0.0061950684, 0.0043334961,
              0.014709473, 0.024688721, 0.0340271, 0.042572021,
              0.050109863, 0.05645752, 0.061553955, 0.065246582,
              0.06741333, 0.068115234, 0.067260742, 0.064880371,
              0.061065674, 0.055908203, 0.049468994, 0.04196167,
              0.033508301, 0.024291992, 0.014556885, 0.004486084,
              -0.0057067871, -0.015777588, -0.025512695, -0.034759521,
              -0.043212891, -0.050750732, -0.057250977, -0.062469482,
              -0.066375732, -0.068908691, -0.069915771, -0.069488525,
              -0.067596436, -0.064239502, -0.05960083, -0.053710938,
              -0.046691895, -0.038726807, -0.029998779, -0.020690918,
              -0.011016846, -0.001159668, 0.0086364746, 0.018188477,
              0.027252197, 0.035675049, 0.043243408, 0.04977417,
              0.055175781, 0.059326172, 0.062103271, 0.063537598,
              0.063476562, 0.062011719, 0.059173584, 0.054992676,
              0.049591064, 0.043121338, 0.035675049, 0.027404785,
              0.018554688, 0.0092468262, -0.00024414062,
              -0.0097351074, -0.019042969, -0.027954102, -0.036254883,
              -0.043792725, -0.050415039, -0.055938721, -0.060272217,
              -0.063323975, -0.065032959, -0.065368652, -0.064300537,
              -0.061889648, -0.058197021, -0.053283691, -0.047241211,
              -0.040283203, -0.032470703, -0.024017334, -0.015136719,
              -0.0059814453, 0.0032653809, 0.012329102, 0.021087646,
              0.029327393, 0.036834717, 0.043487549, 0.049133301,
              0.053649902, 0.056945801, 0.058959961, 0.059631348,
              0.058990479, 0.057006836, 0.053741455, 0.049316406,
              0.043762207, 0.037231445, 0.029876709, 0.021881104,
              0.013366699, 0.0045471191, -0.0043640137, -0.013214111,
              -0.021759033, -0.029876709, -0.037353516, -0.044006348,
              -0.049743652, -0.054412842, -0.057922363, -0.060180664,
              -0.061187744, -0.060913086, -0.059295654, -0.056488037,
              -0.052459717, -0.047363281, -0.041290283, -0.034362793,
              -0.026733398, -0.018615723, -0.010131836, -0.0014953613,
              0.0070800781, 0.01550293, 0.023498535, 0.030883789,
              0.037597656, 0.043426514, 0.048217773, 0.051940918,
              0.054473877, 0.055786133, 0.055847168, 0.054656982,
              0.052215576, 0.04864502, 0.04397583, 0.038330078,
              0.031829834, 0.024627686, 0.016845703, 0.0087280273,
              0.00039672852, -0.0079650879, -0.016143799,
              -0.024017334, -0.03137207, -0.038024902, -0.043914795,
              -0.048828125, -0.052703857, -0.055480957, -0.057067871,
              -0.057434082, -0.05657959, -0.05456543, -0.051361084,
              -0.047119141, -0.041900635, -0.035797119, -0.028961182,
              -0.021575928, -0.013763428, -0.0057067871, 0.0023803711,
              0.010406494, 0.018127441, 0.025390625, 0.032073975,
              0.037994385, 0.043029785, 0.047088623, 0.050048828,
              0.0519104, 0.052581787, 0.052093506, 0.050415039,
              0.047637939, 0.043792725, 0.03894043, 0.03326416,
              0.026824951, 0.019775391, 0.012329102, 0.0045776367,
              -0.0032958984, -0.011108398, -0.018676758, -0.025878906,
              -0.032501221, -0.038421631, -0.043548584, -0.047729492,
              -0.05090332, -0.053009033, -0.053955078, -0.053771973,
              -0.052459717, -0.050018311, -0.046539307, -0.042114258,
              -0.036773682, -0.030731201, -0.024047852, -0.016876221,
              -0.0094299316, -0.0018005371, 0.0058288574, 0.013244629,
              0.020324707, 0.026916504, 0.032867432, 0.03805542,
              0.042388916, 0.04574585, 0.048034668, 0.049285889,
              0.049407959, 0.048400879, 0.046356201, 0.043243408,
              0.03918457, 0.034240723, 0.028533936, 0.022216797,
              0.015380859, 0.0082092285, 0.00082397461, -0.0065612793,
              -0.013824463, -0.020812988, -0.02734375, -0.033294678,
              -0.038543701, -0.042938232, -0.046478271, -0.048980713,
              -0.050445557, -0.050842285, -0.050170898, -0.048431396,
              -0.045684814, -0.041992188, -0.037384033, -0.032073975,
              -0.026062012, -0.01953125, -0.012634277, -0.0055236816,
              0.0016784668, 0.0087890625, 0.015655518, 0.022125244,
              0.028076172, 0.033355713, 0.037902832, 0.041534424,
              0.044250488, 0.045959473, 0.046630859, 0.046264648,
              0.04486084, 0.042419434, 0.039093018, 0.034851074,
              0.029846191, 0.024200439, 0.018005371, 0.011383057,
              0.0045166016, -0.0024719238, -0.0093994141,
              -0.016143799, -0.022521973, -0.0284729, -0.033752441,
              -0.038360596, -0.042144775, -0.045013428, -0.046936035,
              -0.047851562, -0.04776001, -0.046630859, -0.044555664,
              -0.041534424, -0.037628174, -0.032989502, -0.027618408,
              -0.021728516, -0.015411377, -0.0087585449,
              -0.0020141602, 0.0047607422, 0.011383057, 0.017700195,
              0.023590088, 0.028930664, 0.033569336, 0.037475586,
              0.040527344, 0.042633057, 0.043792725, 0.04397583,
              0.043151855, 0.041381836, 0.038696289, 0.035125732,
              0.030792236, 0.025756836, 0.020172119, 0.014099121,
              0.0077514648, 0.0011901855, -0.0053710938, -0.01184082,
              -0.018066406, -0.023925781, -0.02923584, -0.033966064,
              -0.037963867, -0.041107178, -0.043426514, -0.044799805,
              -0.045196533, -0.044677734, -0.043182373, -0.040802002,
              -0.037567139, -0.033538818, -0.028808594, -0.023498535,
              -0.017730713, -0.01159668, -0.005279541, 0.0011291504,
              0.0074768066, 0.013580322, 0.019378662, 0.024719238,
              0.02947998, 0.033538818, 0.036865234, 0.039306641,
              0.040893555, 0.041564941, 0.041290283, 0.040100098,
              0.038024902, 0.035064697, 0.031341553, 0.026947021,
              0.021942139, 0.016418457, 0.0105896, 0.0044555664,
              -0.001739502, -0.0079345703, -0.013946533, -0.019683838,
              -0.024963379, -0.029754639, -0.033905029, -0.03729248,
              -0.039916992, -0.041687012, -0.042572021, -0.042541504,
              -0.041625977, -0.039794922, -0.03717041, -0.033752441,
              -0.029632568, -0.024902344, -0.019683838, -0.014038086,
              -0.0081787109, -0.0021362305, 0.00390625, 0.0097961426,
              0.015472412, 0.020751953, 0.025512695, 0.029724121,
              0.033233643, 0.036010742, 0.037963867, 0.039031982,
              0.039245605, 0.038574219, 0.03704834, 0.034698486,
              0.031585693, 0.027740479, 0.02331543, 0.018341064,
              0.012969971, 0.0073242188, 0.0014953613, -0.0043640137,
              -0.010162354, -0.015716553, -0.020965576, -0.025756836,
              -0.029968262, -0.033569336, -0.036468506, -0.038543701,
              -0.039825439, -0.040283203, -0.039825439, -0.038574219,
              -0.036499023, -0.033630371, -0.030090332, -0.025939941,
              -0.021240234, -0.016113281, -0.010681152, -0.0050354004,
              0.00067138672, 0.0063171387, 0.011810303, 0.016998291,
              0.021759033, 0.026031494, 0.029724121, 0.032684326,
              0.034942627, 0.036407471, 0.03704834, 0.036865234,
              0.035858154, 0.0340271, 0.031463623, 0.028198242,
              0.024291992, 0.019866943, 0.014984131, 0.0097961426,
              0.0043640137, -0.0011901855, -0.0066833496,
              -0.012054443, -0.017181396, -0.021942139, -0.0262146,
              -0.029937744, -0.03302002, -0.035400391, -0.037017822,
              -0.037841797, -0.037872314, -0.037109375, -0.035552979,
              -0.033233643, -0.03024292, -0.026611328, -0.02243042,
              -0.017791748, -0.012817383, -0.0075683594,
              -0.0022277832, 0.0031433105, 0.0084228516, 0.013458252,
              0.018188477, 0.022491455, 0.026245117, 0.029418945,
              0.031921387, 0.033691406, 0.034729004, 0.034973145,
              0.034423828, 0.033111572, 0.031066895, 0.028320312,
              0.024932861, 0.021026611, 0.01663208, 0.011871338,
              0.0068664551, 0.0016784668, -0.0035400391,
              -0.0086669922, -0.013641357, -0.018310547, -0.022613525,
              -0.026428223, -0.029632568, -0.032226562, -0.03414917,
              -0.035339355, -0.035766602, -0.035430908, -0.034362793,
              -0.032531738, -0.030059814, -0.026947021, -0.023284912,
              -0.019134521, -0.014587402, -0.009765625, -0.0047912598,
              0.00030517578, 0.0053405762, 0.010192871, 0.014831543,
              0.019104004, 0.022918701, 0.0262146, 0.028930664,
              0.030944824, 0.032318115, 0.032928467, 0.032806396,
              0.031951904, 0.030395508, 0.028137207, 0.025268555,
              0.021850586, 0.017944336, 0.013641357, 0.0090332031,
              0.0042114258, -0.0007019043, -0.0056152344,
              -0.010406494, -0.014953613, -0.019195557, -0.023040771,
              -0.026367188, -0.029144287, -0.031280518, -0.032775879,
              -0.033538818, -0.033630371, -0.032958984, -0.031646729,
              -0.029632568, -0.027008057, -0.023803711, -0.020141602,
              -0.016052246, -0.011627197, -0.007019043, -0.0022583008,
              0.0025024414, 0.0072021484, 0.011688232, 0.015899658,
              0.019744873, 0.023132324, 0.025970459, 0.02822876,
              0.029846191, 0.030792236, 0.031036377, 0.030609131,
              0.02947998, 0.027679443, 0.025299072, 0.022338867,
              0.018890381, 0.015045166, 0.01083374, 0.0063781738,
              0.0018005371, -0.0028381348, -0.0073852539,
              -0.011810303, -0.015991211, -0.019805908, -0.023193359,
              -0.026092529, -0.028442383, -0.030181885, -0.031280518,
              -0.031677246, -0.031433105, -0.030517578, -0.028961182,
              -0.026794434, -0.024078369, -0.020843506, -0.017181396,
              -0.013183594, -0.0089416504, -0.0045166016,
              -3.0517578e-05, 0.0044555664, 0.0087890625, 0.012908936,
              0.016723633, 0.020141602, 0.023071289, 0.025512695,
              0.02734375, 0.028564453, 0.029174805, 0.02911377,
              0.028381348, 0.027038574, 0.025085449, 0.022583008,
              0.019561768, 0.016143799, 0.012329102, 0.0082702637,
              0.0040283203, -0.00033569336, -0.0046691895,
              -0.0089111328, -0.012969971, -0.01675415, -0.020172119,
              -0.023162842, -0.025634766, -0.027557373, -0.028930664,
              -0.029663086, -0.029754639, -0.02923584, -0.028076172,
              -0.02633667, -0.024047852, -0.021240234, -0.018005371,
              -0.014434814, -0.010528564, -0.006439209, -0.0022583008,
              0.0019836426, 0.0061340332, 0.010101318, 0.01385498,
              0.017272949, 0.020294189, 0.022857666, 0.024871826,
              0.02633667, 0.02722168, 0.027496338, 0.027130127,
              0.026184082, 0.024658203, 0.02255249, 0.019989014,
              0.016967773, 0.013549805, 0.0098571777, 0.0059509277,
              0.0018920898, -0.0021972656, -0.0062561035,
              -0.010162354, -0.01385498, -0.017272949, -0.020294189,
              -0.022888184, -0.024993896, -0.026550293, -0.027557373,
              -0.027954102, -0.027770996, -0.027008057, -0.025665283,
              -0.023773193, -0.021392822, -0.018585205, -0.015380859,
              -0.01184082, -0.0080871582, -0.0042114258,
              -0.00021362305, 0.0037231445, 0.0075378418, 0.011199951,
              0.014587402, 0.01763916, 0.020263672, 0.02243042,
              0.024108887, 0.025238037, 0.025756836, 0.025756836,
              0.025146484, 0.023986816, 0.02230835, 0.020141602,
              0.017486572, 0.01449585, 0.011169434, 0.0075683594,
              0.0038146973, 0, -0.0038452148, -0.007598877,
              -0.011169434, -0.014526367, -0.017578125, -0.020233154,
              -0.022460938, -0.024200439, -0.025421143, -0.026123047,
              -0.026245117, -0.025787354, -0.024810791, -0.02331543,
              -0.021331787, -0.018890381, -0.016052246, -0.012908936,
              -0.0094909668, -0.0058898926, -0.0021972656,
              0.0015258789, 0.0051879883, 0.0087280273, 0.012054443,
              0.015075684, 0.01776123, 0.020019531, 0.021850586,
              0.023193359, 0.023986816, 0.024261475, 0.023986816,
              0.023162842, 0.021850586, 0.020050049, 0.017791748,
              0.015136719, 0.012176514, 0.0089111328, 0.0054931641,
              0.0019226074, -0.0016784668, -0.0052490234,
              -0.0087280273, -0.011993408, -0.014984131, -0.017700195,
              -0.019989014, -0.021881104, -0.023284912, -0.024200439,
              -0.024597168, -0.024475098, -0.023834229, -0.022674561,
              -0.021026611, -0.018981934, -0.01651001, -0.013702393,
              -0.010620117, -0.0073242188, -0.00390625,
              -0.00042724609, 0.0030517578, 0.006439209, 0.0096740723,
              0.012664795, 0.015350342, 0.017700195, 0.019622803,
              0.021118164, 0.022125244, 0.022644043, 0.022674561,
              0.022155762, 0.021179199, 0.019714355, 0.017822266,
              0.015563965, 0.012908936, 0.010009766, 0.0068664551,
              0.0036010742, 0.00021362305, -0.0031433105,
              -0.0064697266, -0.0096130371, -0.012573242,
              -0.015258789, -0.01763916, -0.019592285, -0.021148682,
              -0.022277832, -0.022888184, -0.023040771, -0.022674561,
              -0.021850586, -0.020568848, -0.018829346, -0.016723633,
              -0.014251709, -0.011505127, -0.0085144043,
              -0.0053710938, -0.0021362305, 0.001159668, 0.0043640137,
              0.0074768066, 0.010406494, 0.013061523, 0.015441895,
              0.017456055, 0.019073486, 0.020263672, 0.020996094,
              0.021270752, 0.021057129, 0.020385742, 0.019226074,
              0.017669678, 0.01574707, 0.013427734, 0.01083374,
              0.008026123, 0.0050048828, 0.0018920898, -0.0012512207,
              -0.0043945312, -0.0074462891, -0.010314941,
              -0.012969971, -0.015350342, -0.01739502, -0.019073486,
              -0.020324707, -0.021148682, -0.021514893, -0.02142334,
              -0.020874023, -0.019897461, -0.018493652, -0.016723633,
              -0.014587402, -0.012145996, -0.0094604492,
              -0.0065917969, -0.0036010742, -0.00054931641,
              0.0025024414, 0.0054626465, 0.0083007812, 0.010925293,
              0.013305664, 0.015380859, 0.017089844, 0.0184021,
              0.019317627, 0.019805908, 0.019836426, 0.019439697,
              0.018585205, 0.017333984, 0.015716553, 0.01373291,
              0.011444092, 0.0089111328, 0.0061950684, 0.003326416,
              0.00039672852, -0.0025634766, -0.0054321289,
              -0.0082092285, -0.010803223, -0.013183594, -0.015258789,
              -0.016998291, -0.018371582, -0.019378662, -0.019958496,
              -0.020080566, -0.019805908, -0.019104004, -0.018005371,
              -0.01651001, -0.014709473, -0.012573242, -0.010162354,
              -0.007598877, -0.0048522949, -0.0020141602,
              0.00082397461, 0.0036315918, 0.0063476562, 0.0089111328,
              0.011260986, 0.013336182, 0.015106201, 0.016571045,
              0.017608643, 0.018280029, 0.01852417, 0.018371582,
              0.017791748, 0.016845703, 0.01550293, 0.013824463,
              0.01184082, 0.0096130371, 0.0071411133, 0.0045471191,
              0.0018310547, -0.00091552734, -0.0036315918,
              -0.0062866211, -0.0087890625, -0.011108398,
              -0.013214111, -0.015014648, -0.016479492, -0.017578125,
              -0.018341064, -0.018676758, -0.018615723, -0.018188477,
              -0.017333984, -0.016143799, -0.01461792, -0.012786865,
              -0.010681152, -0.0083618164, -0.005859375,
              -0.0032958984, -0.00064086914, 0.0020141602,
              0.0045776367, 0.0070495605, 0.0093383789, 0.011413574,
              0.013214111, 0.01473999, 0.015899658, 0.016723633,
              0.017150879, 0.017211914, 0.016876221, 0.016174316,
              0.015106201, 0.01373291, 0.012023926, 0.010070801,
              0.0078735352, 0.0055236816, 0.0030517578, 0.00051879883,
              -0.0020446777, -0.0045471191, -0.0069580078,
              -0.0092163086, -0.011260986, -0.013061523, -0.014587402,
              -0.015808105, -0.016693115, -0.017211914, -0.017364502,
              -0.017150879, -0.016540527, -0.015625, -0.014343262,
              -0.012786865, -0.010955811, -0.0089111328,
              -0.0066833496, -0.0043334961, -0.0018920898,
              0.00057983398, 0.0029907227, 0.0053405762, 0.0075683594,
              0.0096130371, 0.011413574, 0.012969971, 0.014221191,
              0.015167236, 0.01574707, 0.015991211, 0.015869141,
              0.015411377, 0.014587402, 0.013458252, 0.012023926,
              0.010345459, 0.0084228516, 0.0063171387, 0.0040588379,
              0.001739502, -0.00061035156, -0.0029602051,
              -0.0052490234, -0.0074157715, -0.0094299316,
              -0.011230469, -0.012786865, -0.014068604, -0.015045166,
              -0.015716553, -0.016021729, -0.015991211, -0.015655518,
              -0.014953613, -0.013946533, -0.012634277, -0.011077881,
              -0.0092773438, -0.0072937012, -0.0051574707,
              -0.0029602051, -0.00067138672, 0.0015869141,
              0.0038146973, 0.0059204102, 0.0079040527, 0.0097045898,
              0.011260986, 0.012573242, 0.01361084, 0.014312744,
              0.014709473, 0.014770508, 0.01449585, 0.013916016,
              0.013031006, 0.01184082, 0.010406494, 0.0087585449,
              0.0068969727, 0.0048828125, 0.0027770996, 0.00061035156,
              -0.0015869141, -0.0037231445, -0.0057983398,
              -0.0077514648, -0.0094909668, -0.011077881,
              -0.012390137, -0.013427734, -0.014221191, -0.014678955,
              -0.014801025, -0.014648438, -0.014160156, -0.013366699,
              -0.012329102, -0.010986328, -0.0094604492,
              -0.0077209473, -0.0058288574, -0.0038146973,
              -0.001739502, 0.00036621094, 0.0024414062, 0.0044250488,
              0.0063476562, 0.0080871582, 0.0096435547, 0.010986328,
              0.012054443, 0.0128479, 0.013397217, 0.01361084,
              0.013519287, 0.013153076, 0.012481689, 0.011505127,
              0.010314941, 0.0088806152, 0.0072631836, 0.0054931641,
              0.0036010742, 0.0016174316, -0.00039672852,
              -0.0023803711, -0.0043334961, -0.0061645508,
              -0.0079040527, -0.0094299316, -0.010772705,
              -0.011871338, -0.01272583, -0.013275146, -0.013580322,
              -0.013580322, -0.013275146, -0.012695312, -0.011871338,
              -0.010772705, -0.0094604492, -0.0079650879,
              -0.0062866211, -0.004486084, -0.0026245117,
              -0.0007019043, 0.0012207031, 0.003112793, 0.0049133301,
              0.0065917969, 0.0080871582, 0.0094299316, 0.010559082,
              0.011413574, 0.012054443, 0.012390137, 0.012451172,
              0.012268066, 0.011779785, 0.011047363, 0.010070801,
              0.0088500977, 0.0074768066, 0.0059204102, 0.0042114258,
              0.0024414062, 0.00061035156, -0.0012207031,
              -0.0030212402, -0.0047607422, -0.0064086914,
              -0.0079040527, -0.0092163086, -0.010345459,
              -0.011260986, -0.011901855, -0.012298584, -0.012451172,
              -0.012298584, -0.011901855, -0.011260986, -0.010406494,
              -0.0093078613, -0.008026123, -0.0065612793,
              -0.0049743652, -0.0032958984, -0.0015563965,
              0.00018310547, 0.0019226074, 0.0036010742, 0.0052185059,
              0.0066833496, 0.0079956055, 0.0091247559, 0.010040283,
              0.01071167, 0.011169434, 0.011352539, 0.011322021,
              0.010986328, 0.010437012, 0.0096740723, 0.0086669922,
              0.0075073242, 0.0061645508, 0.0046691895, 0.003112793,
              0.0014648438, -0.00021362305, -0.0018920898,
              -0.0035095215, -0.0050354004, -0.0064697266,
              -0.0077514648, -0.0088806152, -0.0098266602,
              -0.010528564, -0.011016846, -0.011260986, -0.011260986,
              -0.011047363, -0.0105896, -0.0098876953, -0.0090026855,
              -0.0079040527, -0.0066833496, -0.005279541,
              -0.0038146973, -0.0022583008, -0.00067138672,
              0.00091552734, 0.0024719238, 0.0039672852, 0.0053710938,
              0.0066223145, 0.0077514648, 0.0086669922, 0.0093994141,
              0.0099182129, 0.010223389, 0.010314941, 0.010131836,
              0.009765625, 0.0091552734, 0.0083618164, 0.0073852539,
              0.0062255859, 0.0049438477, 0.0035705566, 0.0021057129,
              0.00061035156, -0.00088500977, -0.0023803711,
              -0.0038146973, -0.0051574707, -0.0064086914,
              -0.0075073242, -0.0084228516, -0.009185791,
              -0.0097351074, -0.010070801, -0.010192871, -0.010101318,
              -0.0097961426, -0.0092773438, -0.0085449219,
              -0.0076599121, -0.0066223145, -0.0054321289,
              -0.0041503906, -0.0027770996, -0.001373291,
              6.1035156e-05, 0.0014953613, 0.0028686523, 0.0041809082,
              0.0053710938, 0.006439209, 0.0073852539, 0.0081481934,
              0.0086975098, 0.0090942383, 0.0092468262, 0.0092163086,
              0.008972168, 0.0085449219, 0.0079040527, 0.0071105957,
              0.0061645508, 0.005065918, 0.0038757324, 0.0025939941,
              0.0012817383, -9.1552734e-05, -0.0014343262,
              -0.002746582, -0.0039978027, -0.0051574707,
              -0.0062255859, -0.0071105957, -0.0078735352,
              -0.0084533691, -0.0088806152, -0.0090637207,
              -0.0090942383, -0.0089111328, -0.0085449219,
              -0.0079956055, -0.0072937012, -0.006439209,
              -0.0054321289, -0.0043334961, -0.0031433105,
              -0.0018920898, -0.00061035156, 0.00067138672,
              0.0019226074, 0.003112793, 0.0042419434, 0.0052490234,
              0.0061645508, 0.0069274902, 0.0075073242, 0.0079345703,
              0.0081787109, 0.0082397461, 0.0081176758, 0.0078125,
              0.0073547363, 0.0067138672, 0.0059509277, 0.0050354004,
              0.0040283203, 0.0029296875, 0.0017700195, 0.00057983398,
              -0.00064086914, -0.0018310547, -0.0029602051,
              -0.0040283203, -0.0050354004, -0.0058898926,
              -0.006652832, -0.007232666, -0.0076904297,
              -0.0079650879, -0.0080566406, -0.0079956055,
              -0.0077514648, -0.0073547363, -0.0068054199,
              -0.0061035156, -0.005279541, -0.0043334961,
              -0.003326416, -0.0022583008, -0.0011291504, 0,
              0.0010986328, 0.0021972656, 0.0032348633, 0.0041809082,
              0.0050354004, 0.0057678223, 0.0063476562, 0.0068054199,
              0.0071105957, 0.007232666, 0.007232666, 0.0070495605,
              0.0067138672, 0.0062255859, 0.0056152344, 0.0048522949,
              0.0040283203, 0.0030822754, 0.0021057129, 0.0010681152,
              0, -0.0010375977, -0.0020751953, -0.0030517578,
              -0.0039367676, -0.0047607422, -0.0054626465,
              -0.006072998, -0.0065307617, -0.0068359375,
              -0.007019043, -0.007019043, -0.0068969727,
              -0.0066223145, -0.0061950684, -0.005645752,
              -0.0049743652, -0.0042114258, -0.0033874512,
              -0.0024719238, -0.0014953613, -0.00051879883,
              0.00045776367, 0.0014038086, 0.0023193359, 0.0032043457,
              0.0039672852, 0.0046691895, 0.0052490234, 0.0057067871,
              0.0060424805, 0.0062255859, 0.0062866211, 0.0061950684,
              0.0059814453, 0.0056152344, 0.0051269531, 0.0045471191,
              0.0038757324, 0.003112793, 0.0022888184, 0.0014038086,
              0.00048828125, -0.00042724609, -0.0013122559,
              -0.002166748, -0.0029907227, -0.0037231445,
              -0.0043945312, -0.0049438477, -0.0054016113,
              -0.0057373047, -0.0059509277, -0.0060424805,
              -0.0059814453, -0.0057983398, -0.0054931641,
              -0.0050964355, -0.0045776367, -0.0039672852,
              -0.0032653809, -0.002532959, -0.001739502,
              -0.00088500977, -6.1035156e-05, 0.00076293945,
              0.0015869141, 0.0023498535, 0.0030517578, 0.0036621094,
              0.0042114258, 0.0046386719, 0.0050048828, 0.0052185059,
              0.0053100586, 0.0053100586, 0.0051879883, 0.0049133301,
              0.0045776367, 0.004119873, 0.0036010742, 0.0029602051,
              0.0022888184, 0.0015869141, 0.00082397461,
              6.1035156e-05, -0.0007019043, -0.0014343262,
              -0.002166748, -0.0028076172, -0.0033874512, -0.00390625,
              -0.0043334961, -0.0046691895, -0.0049133301,
              -0.0050354004, -0.0050354004, -0.0049438477,
              -0.0047302246, -0.0044555664, -0.0040588379,
              -0.0035705566, -0.0030517578, -0.0024414062,
              -0.0018005371, -0.0010986328, -0.00042724609,
              0.0002746582, 0.00094604492, 0.0016174316, 0.0022277832,
              0.0027770996, 0.0032653809, 0.0036621094, 0.0039978027,
              0.0042114258, 0.0043334961, 0.0043945312, 0.0043334961,
              0.0041809082, 0.0039367676, 0.0036010742, 0.0031738281,
              0.0027160645, 0.002166748, 0.0016174316, 0.0010070801,
              0.00039672852, -0.00024414062, -0.00085449219,
              -0.0014343262, -0.0020141602, -0.0025024414,
              -0.0029602051, -0.0033569336, -0.0036621094,
              -0.0038757324, -0.0040283203, -0.0040588379,
              -0.0040283203, -0.00390625, -0.0037231445,
              -0.0034484863, -0.0030822754, -0.0026855469,
              -0.0022277832, -0.0017089844, -0.0011901855,
              -0.00064086914, -6.1035156e-05, 0.00048828125,
              0.0010070801, 0.0014953613, 0.0019836426, 0.0023803711,
              0.002746582, 0.0030212402, 0.0032348633, 0.0033874512,
              0.0034484863, 0.0034484863, 0.0033569336, 0.0032043457,
              0.0029602051, 0.0026855469, 0.0023193359, 0.0019226074,
              0.0014953613, 0.0010375977, 0.00054931641,
              6.1035156e-05, -0.00039672852, -0.00088500977,
              -0.0013122559, -0.001739502, -0.0021057129,
              -0.0024108887, -0.0026855469, -0.0028991699,
              -0.0030212402, -0.003112793, -0.003112793,
              -0.0030517578, -0.0029296875, -0.0027160645,
              -0.0025024414, -0.0021972656, -0.0018615723,
              -0.0014953613, -0.0010986328, -0.0007019043,
              -0.0002746582, 0.00015258789, 0.00054931641,
              0.00094604492, 0.0012817383, 0.0016174316, 0.0018920898,
              0.0021362305, 0.0023193359, 0.0024414062, 0.002532959,
              0.002532959, 0.0025024414, 0.0024108887, 0.0022583008,
              0.0020751953, 0.0018310547, 0.0015563965, 0.0012512207,
              0.00091552734, 0.00057983398, 0.00024414062,
              -0.00012207031, -0.00045776367, -0.00076293945,
              -0.0010681152, -0.0013427734, -0.0015869141,
              -0.0018005371, -0.001953125, -0.0020751953,
              -0.0021362305, -0.002166748, -0.0021362305,
              -0.0020751953, -0.001953125, -0.0018005371,
              -0.0016174316, -0.0014038086, -0.001159668,
              -0.00088500977, -0.00061035156, -0.00033569336,
              -6.1035156e-05, 0.00021362305, 0.00048828125,
              0.00073242188, 0.00094604492, 0.001159668, 0.0013122559,
              0.0014648438, 0.0015563965, 0.0016174316, 0.0016479492,
              0.0016174316, 0.0015563965, 0.0014953613, 0.001373291,
              0.0012207031, 0.0010681152, 0.00088500977,
              0.00067138672, 0.00045776367, 0.0002746582,
              6.1035156e-05, -0.00015258789, -0.00036621094,
              -0.00054931641, -0.0007019043, -0.00085449219,
              -0.0009765625, -0.0010986328, -0.001159668,
              -0.0012207031, -0.0012207031, -0.0012207031,
              -0.0011901855, -0.0011291504, -0.0010375977,
              -0.00094604492, -0.00082397461, -0.00067138672,
              -0.00054931641, -0.00039672852, -0.00024414062,
              -9.1552734e-05, 3.0517578e-05, 0.00018310547,
              0.00030517578, 0.00042724609, 0.00051879883,
              0.00057983398, 0.00064086914, 0.0007019043,
              0.00073242188, 0.00073242188, 0.00073242188,
              0.0007019043, 0.00067138672, 0.00061035156,
              0.00054931641, 0.00045776367, 0.00039672852,
              0.00030517578, 0.00021362305, 0.00015258789,
              6.1035156e-05, -3.0517578e-05, -9.1552734e-05,
              -0.00015258789, -0.00021362305, -0.00024414062,
              -0.0002746582, -0.00030517578, -0.00030517578,
              -0.00030517578, -0.00030517578, -0.0002746582,
              -0.0002746582, -0.00024414062, -0.00021362305,
              -0.00018310547, -0.00015258789, -9.1552734e-05,
              -9.1552734e-05, -6.1035156e-05, -3.0517578e-05, 0, 0, 0,
              0, 0, 0, 0, 0, 0, 0, 0,
};

const jack_nframes_t Session::default_click_length = sizeof (default_click) / sizeof (default_click[0]);
