/* $Id: Client.h,v 1.14 2003/03/12 21:50:01 mrq Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2002 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef CLIENT_CLIENT_H
#define CLIENT_CLIENT_H

#include <Ark/ArkConfig.h>
#include <Ark/ArkMath.h>
#include <Ark/ArkWorld.h>
#include <Ark/ArkWorldUpd.h>
#include <Ark/ArkEntity.h>
#include <Ark/ArkRenderer.h>

#include <Client/Widget.h>
#include <stdio.h>

namespace Client
{

   class Client
   {
      protected:
	 Ark::Config *m_Config;
	 Ark::Renderer *m_Renderer;

	 Ark::WorldUpdater *m_Updater;
	 Ark::World *m_World;
	 Ark::Entity *m_Player;
	 scalar m_MaxFPS;

      public:
	 Client (int argc, char **argv);
	 virtual ~Client();

	 virtual void Login (const Ark::String &name,
			     const Ark::String &pass);

	 virtual void HandleMenuString(const Ark::String &str) = 0;

	 /* === Looping stuff === */
	 virtual int Loop () = 0;

	 /* === Wrap === */
	 Ark::World  *GetWorld()     {return m_World;}
	 Ark::Cache  *GetCache()     {return m_World->GetCache();}
	 Ark::Config *GetConfig ()   {return m_Config;}
	 Ark::Entity *GetPlayer ()   {return m_Player;}
   };

  extern Client *g_Client;

}

#endif
