/* $Id: SkyDome.h,v 1.10 2003/03/18 18:23:54 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2003 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef ARK_SKYCAP_H
#define ARK_SKYCAP_H

#include <Ark/ArkMath.h>
#include <Ark/ArkImage.h>
#include <Ark/ArkMaterial.h>

#include <Ark/ArkWorld.h>
#include <Ark/ArkConfig.h>

#include <Modules/HeightField/ArkHeightField.h>

namespace Ark
{

   class ARKHEIGHTFIELD_DLL_API SkyDome
   {
       Cache* m_Cache;
       Config& m_Config;
       ImagePtr m_AmbientImage;
       ImagePtr m_ToneImage;
       MaterialPtr m_ToneMap;
       MaterialPtr m_StarMap;
       PrimitiveBlock m_TriangleIndices;
       VertexBuffer m_Triangles;
       scalar m_Radius;

       void Reset();
       bool LoadImage(const char* name, ImagePtr& texmap);
       bool LoadTexture(const char* name, TexturePtr& texmap);
       void CreateSphere(int iterations);

       void SetPosition(int n, const Vector3& position);
       void ComputeTextureCoord(int n);

     public:
       SkyDome (Cache *cache, Config &cfg);
       ~SkyDome ();
       void Build();

       void Render (Renderer &renderer, const Vector3 &position, scalar timeOfDay);
       Color GetHorizonColor(float timeOfDay) const;
       Color GetAmbientColor(float timeOfDay) const;
   };

/* namespace Ark */
}

#endif
