/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*================================================*/
/*	The burner's option page.
 *
 *	by Tony Sideris	(11:23PM Apr 28, 2002)
 *================================================*/
#include "arson.h"

#include <qpushbutton.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qslider.h>
#include <qcombobox.h>

#include <kfiledialog.h>

#include "burnerpage.h"
#include "konfig.h"

struct size_preset {
	int minutes;
	int MB;

}	g_size_presets[] = {
	{ 21, 185 },
	{ 25, 220 },
	{ 74, 650 },
	{ 80, 700 },
	{ 90, 800 },
	{ 99, 880 },
};

#define SIZE_PRESETS_COUNT	ARRSIZE(g_size_presets)

/*========================================================*/

ArsonBurnerPage::ArsonBurnerPage (ArsonConfig &config, ArsonConfigDlg *pdlg, QWidget *parent)
	: ArsonBurnerPageBase(parent), ArsonConfigPage(config), m_preset(0), m_devs(NULL)
{
	updateDevs(cfg().device(), cfg().devices());
	handleCheckboxes(false);

	//	Nice level slider
	nice_level->setValue(cfg().nice());

	//	Spin boxes
	cdlen_min->setValue(cfg().cdlenMin());
	cdlen_mb->setValue(cfg().cdlenMB());

	for (int index = 0; index < SIZE_PRESETS_COUNT; ++index)
		if (g_size_presets[index].minutes == cfg().cdlenMin() &&
			g_size_presets[index].MB == cfg().cdlenMB())
		{
			m_preset = index;
			break;
		}
	
	QObject::connect(confdev, SIGNAL(clicked()),
		pdlg, SLOT(configure_devices()));
}

ArsonBurnerPage::~ArsonBurnerPage (void)
{
	delete m_devs;
}

/*========================================================*/

void ArsonBurnerPage::handleCheckboxes (bool save)
{
	struct {
		QCheckBox *box;
		uint mask;
	}	checks[] = {
		{ burn_proof, ArsonConfig::flagBurnProof },
		{ force_speed, ArsonConfig::flagForceSpeed },
		{ renice, ArsonConfig::flagRenice },
	};

	for (int index = 0; index < ARRSIZE(checks); ++index)
	{
		if (save)
			cfg().fromBool(checks[index].mask, checks[index].box->isOn());
		else
			checks[index].box->setChecked(cfg().is(checks[index].mask));
	}
}

/*========================================================*/

void ArsonBurnerPage::updateDevs (const char *dev, const ArsonDeviceList &dl)
{
	QCString sel (dev);

	if (writer_device->count() > 0 && !dev && m_devs)
		sel = m_devs->fromList(writer_device);

	delete m_devs;
	m_devs = new ArsonDeviceUiList(dl.uiList());

	m_devs->fillList(writer_device,
		sel.isEmpty() ? NULL : sel.data());
}

void ArsonBurnerPage::on_dev_changed (const ArsonDeviceList &dl)
{
	updateDevs(NULL, dl);
}

/*========================================================*/

void ArsonBurnerPage::size_preset_down (void)
{
	if (--m_preset < 0)
		m_preset = SIZE_PRESETS_COUNT - 1;

	setPresetText();
}

void ArsonBurnerPage::size_preset_up (void)
{
	if (++m_preset >= SIZE_PRESETS_COUNT)
		m_preset = 0;

	setPresetText();
}

void ArsonBurnerPage::setPresetText (void)
{
	const size_preset &pr = g_size_presets[m_preset];

	cdlen_min->setValue(pr.minutes);
	cdlen_mb->setValue(pr.MB);
}

/*========================================================*/

void ArsonBurnerPage::on_accept (void)
{
	cfg().setCdLenMin(cdlen_min->cleanText().toInt());
	cfg().setCdLenMB(cdlen_mb->cleanText().toInt());
	cfg().setNice(nice_level->value());

	cfg().setDevice(m_devs->fromList(writer_device));

	handleCheckboxes(true);
}

/*========================================================*/
