/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*================================================*/
/*	The program page.
 *
 *	by Tony Sideris	(11:27PM Apr 28, 2002)
 *================================================*/
#include "arson.h"

#include <qlabel.h>
#include <qcombobox.h>
#include <qlistbox.h>
#include <qlayout.h>

#include "programpage.h"

/*========================================================*/

ArsonProgramPage::ArsonProgramPage (ArsonConfig &config, ArsonConfigDlg *pd, QWidget *parent)
	: QWidget(parent), ArsonConfigPage(config)
{
	m_pVB = new QVBoxLayout(this, 11, 6);

	for (int index = 0; index < _PROGGRP_MAX; ++index)
	{
		QComboBox *pc = addSelectionRow(
			i18n(ArsonProgramPref::groupName(index)),
			ArsonProgramPref::groupChoices(index),
			config.programPref(index));

		m_cbs[index] = pc;
	}
}

/*========================================================*/

inline const char *nextString (const char *str)
{
	const char *t = str + qstrlen(str) + 1;
	return *t ? t : NULL;
}

QComboBox *ArsonProgramPage::addSelectionRow (const QString &label,
	const char *choices, const char *init)
{
	QHBoxLayout *ph = new QHBoxLayout(this, 0);
	QLabel *pl = new QLabel(label + i18n(": "), this);
	QComboBox *pc = new QComboBox(this);
	int index = 0, sel = -1;

	for (const char *ch = choices; ch; ch = nextString(ch), ++index)
	{
		if (QCString(ch) == init)
			sel = index;

		pc->insertItem(ch);
	}

	pc->setCurrentItem(sel);

	ph->addWidget(pl);
	ph->addWidget(pc);

	m_pVB->addLayout(ph);
	return pc;
}

/*==========================================================*/

void ArsonProgramPage::on_accept (void)
{
	for (int index = 0; index < _PROGGRP_MAX; ++index)
	{
		Trace("setting %d=%s\n", index, m_cbs[index]->currentText().latin1());
		cfg().setProgramPref(index, m_cbs[index]->currentText().latin1());
	}
}

/*========================================================*/
