/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __XMLWRITER_H__
#define __XMLWRITER_H__

#include <qstring.h>
#include <qmap.h>

/*========================================================*/

class ArsonXmlWriter;
class QTextStream;

class ArsonXmlTag
{
	typedef QMap<QString,QString> Attributes;
	
public:
	ArsonXmlTag (ArsonXmlWriter &out, const QString &name);

	void addAttribute (const QString &name, const QString &value);
	void addAttribute (const QString &name, int value);

	virtual void begin (void);
	virtual void end (void);
	virtual void doit (void);

protected:
	void startTag (QTextStream &out, const char *end);

private:
	ArsonXmlWriter &m_out;
	Attributes m_attr;
	QString m_name;
};

/*========================================================*/

class ArsonXmlWriter : public ArsonXmlTag
{
public:
	ArsonXmlWriter (QTextStream &out, const QString &name);

	virtual void begin (void);
	virtual void doit (void);

	QTextStream &writer (bool begin);
	QTextStream &writer (void);

protected:
	QString indentation (int how);
	QTextStream &out (void) { return m_out; }

	enum {
		unindent = -1,
		none = 0,
		indent = 1,
	};
	
private:
	QTextStream &m_out;
	int m_level;
};

/*========================================================*/
#endif	/*	__XMLWRITER_H__	*/
