/* :: ascii-jump project
   :: $Id: xfnc.c,v 1.1.1.1 2003/02/28 10:05:04 loth Exp $
   
   :: copyright (c) 2003 :: grzegorz moskal, g.moskal@opengruop.org
   :: license gnu gpl v 2						*/

#define XFNC_C
#include "xfnc.h"

char *xgetcwd()
{
	char *dir = NULL;
	int size = 100;

	dir = malloc(size);
	
	while (getcwd(dir, size) == NULL && errno == ERANGE)
		dir = xrealloc(dir, size *=2);
	return dir;
}

DIR *xopendir(char *name)
{
	DIR *dir;
	if (name == NULL || (dir = opendir(name)) == NULL) {
		return NULL;
//		perror("opendir() faild ::");
//		fprintf(stderr, "Can`t open dir: %s\n", name);
//		exit(2);
	}
	return dir;
}

void xchdir(char *name)
{
	if (name == NULL || chdir(name) == -1) {
		perror("chdir() failed ::");
		fprintf(stderr, "Can`t change dir: %s\n", name);
		exit(2);
	}
}

void *xmalloc(size_t size)
{
	void *ptr;
	
	if (!size)
		return NULL;

	if ((ptr = calloc(1, size)) == NULL) {
		perror("calloc() failed ::");
		exit(1);
	}
	return ptr;
}

void *xrealloc(void *ptr, size_t size)
{

	if (!size)
		return NULL;
	
	ptr = realloc(ptr, size);
	
	if (ptr == NULL) {
		perror("realloc() failed ::");
		exit(1);
	}
	return ptr;
}

void *xfree(void *ptr)
{
	if (ptr)
		free(ptr);
	return 0;
}

FILE *xfopen(char *name, char *mode)
{
	FILE *fd = fopen(name, mode);
	if (fd == NULL) {
		perror("fopen() failed :: ");
		fprintf(stderr, "Can`t open file: %s\n", name);
		exit(3);
	}
	return fd;
}

int d(int h)
{
	if (h)
		return rand() % h +1;
	return 0;
}

void rand_init()
{
	srand(time(0));
}

char *read_line(FILE *fd)
{
	int length = 1;
	int i = 0;
	char *line = NULL;

	for (;;) {
		if (length-1 == i) {
			length *=3;
			line = xrealloc(line, length*(sizeof(char)));
		}
		
		line[i] = fgetc(fd);

		if (line[i] == EOF) {
			if (i == 0)
				return NULL;
			line[i] = '\0';
			break;

		} else if (line[i] == '\n') {
			if (i == 0)
				return read_line(fd);
			line[i] = '\0';
			break;
		}
		i++;
	}
	
	return line;
}

char *strglue(char *p1, char *space, char *p2)
{
	char *r = malloc(sizeof(char) * 
			(strlen(p1) + strlen(p2) + strlen(space) +1));
	sprintf(r,"%s%s%s", p1, space, p2);
	return r;
}

char *strdglue(char *p1, char *p2)
{
	return strglue(p1, "/", p2);
}

char *strwide(char *s)
{
	char *wt = xmalloc(sizeof(char)*(strlen(s)*2+1));
	char *j = wt;
	while (s && *s) {
		*j++ = *s++;
		*j++ = ' ';
	}
	*j = '\0';
	return wt;
}
