.TH asmounter 0.3 "XX Mar 1999"
.UC

.SH NAME
\fBasmounter\fP \- AfterStep All-Purpose Mounter

.SH SYNOPSIS
.B asmounter
        [-h | -help]
        [-v | -version]
        [-D | -debug]
        [-d \fIdisplay\fP | -display \fIdisplay\fP]
        [-g +XPOS+YPOS | -geometry +XPOS+YPOS]
        [-c | -cycle]
        [-C | -create]
        [-s | -shaped]
        [-w | -withdrawn]

.SH DESCRIPTION
\fBAsmounter\fP monitors different mount points and facilitates the mounting
and unmounting of these mount points.  It is a X11 application that is
designed to work with the AfterStep window manager.  The code is loosely
based on wmmount and asmodem and others.  I primarily wrote this program to
gain a rudimentary understanding of X programming so that I may go on to
write better apps for AfterStep (hopefully).

The left mouse button is used to cycle through the mount points, which are
established in the resource file (either ~/.asmounter or
/usr/lib/asmounter/sys.asmounter).  The right mouse button is used to toggle
the mount point (mount/unmount).  The middle mouse button is used to
execute a command related to the mount points (in future versions this will
be mount point specific).

.SH CONFIGURATION OPTIONS
.IP "-h | -help"
.RS	
Prints a help message
.RE
.IP "-v | -version"
.RS	
Prints the version of the program
.RE
.IP "-s | -shaped"
.RS
Starts \fBasmounter\fP with a shaped window. Useful if you would like to place
\fBasmounter\fP in your Wharf.
.RE
.IP "-w | -withdrawn"
.RS
Starts \fBasmounter\fP as a withdrawn window. Useful if you would like to place
\fBasmounter\fP in the Dock of WindowMaker.
.RE
.IP "-D | -debug"
.RS
Starts \fBasmounter\fP in debug mode. This is useful for if (when?) you find
a bug/error and you want to inform me of it ... simply show me this output
with a description of the problem.
.RE
.IP "-d <name> | -display <name>"
.RS
The name of the display to start the window in.
This works just as does the X Windows display option.
.RE
.IP "-g +XPOS+YPOS | -geometry +XPOS+YPOS"
.RS
This enables the user to specify the position on the screen that \fBasmounter\fP
will appear when started.
.RE
.IP "-C | -create"
.RS
This aids the use in creating a resource file to be used by \fBasmounter\fP.
Use this option if you dislike fiddling with config files.  Note: this
may one day be implemented as a GTK GUI if there's enough interest.
.RE
.IP "-c | -cycle"
.RS
If specified, the mountpoints will be cycled through when \fBasmounter\fP has been
idle for a while.  I can't really justify its usefulness, but, I like it.

.SH EXAMPLES
Here are examples of how to start \fBasmounter\fP from the command line.
  
.nf
asmounter -s &
.fi

.nf
asmounter -display :0.0 &
.fi

.nf
asmounter -c &
.fi

Here is an example of how to start \fBasmounter\fP from within
\fBAfterStep\fP.  It uses the shaped extension.  Place the following line in
your \fI.wharf\fP file in your ~/GNUstep/Library/Afterstep directory.

.nf
*Wharf - - Swallow "asmounter" asmounter -s &
.fi

.SH COPYRIGHT
Copyright (c) 1999 by David Taylor.  No guarantees.  No warrantees.

.SH AUTHORS
Program: David Taylor
.RE
n9506769@scholar.nepean.uws.edu.au

Pixmaps: Chris Lee
.RE
mental0ne@sydcom.net





