#!/bin/bash

function die {
	echo "Error: ${1}"
	exit 1
}

IFS=$'\n'

_ifndef=0
_ifdef=0
_else=0

filelist=`ls -1 *.c *.h`

set -o noglob

for filename in ${filelist};
do
	echo -n "Now working on \"${filename}\"... "

	TEMPFILE=`tempfile` || die "could not create tempfile"
	RESULTFILE=`tempfile` || die "could not create tempfile"
	cat "${filename}" | sed -e "s/^$/===/g" > "${TEMPFILE}"

	for line in `cat "${TEMPFILE}"`;
	do
		echo "${line}" | grep "#ifndef ASTERISK_STABLE" > /dev/null 2>&1
		if [ "$?" == "0" ]; then
			_ifndef=1
			continue
		fi
		echo "${line}" | grep "#ifdef ASTERISK_STABLE" > /dev/null 2>&1
		if [ "$?" == "0" ]; then
			_ifdef=1
			continue
		fi
		
		if [ "${_ifndef}" == "1" ] || [ "${_ifdef}" == "1" ]; then
			echo "${line}" | grep "#else" > /dev/null 2>&1
			if [ "$?" == "0" ]; then
				_else=1
				continue
			fi
			echo "${line}" | grep "#endif" > /dev/null 2>&1
			if [ "$?" == "0" ]; then
				_ifndef=0
				_ifdef=0
				_else=0
				continue
			fi
		fi

		if [ "${line}" == "===" ]; then
			echo >> "${RESULTFILE}"
			continue
		fi
		
#ifndef stuff
		if [ "${_ifndef}" == "1" ]; then
			if [ "$_else" == "1" ]; then
				continue
			fi
			if [ "$_else" == "0" ]; then
				echo "${line}" >> "${RESULTFILE}"	
			fi
			continue
		fi

#ifdef stuff
		if [ "${_ifdef}" == "1" ]; then
			if [ "$_else" == "0" ]; then
				continue
			fi
			if [ "$_else" == "1" ]; then
				echo "${line}" >> "${RESULTFILE}"	
			fi
			continue
		fi

#non target line
		echo "${line}" >> "${RESULTFILE}"	
		
	done
	
	cp ${RESULTFILE} ${filename} || die "copy failed"
	rm ${TEMPFILE} || die "could not rm tempfile"
	rm ${RESULTFILE} || die "could not rm tempfile"

	echo "done"	
done
