#ifndef TE_LIB
#define TE_LIB

#include <mISDNlib.h>
#include <isdn_net.h>
#include <l3dss1.h>
#include <net_l3.h>

#include <pthread.h>



#ifndef mISDNUSER_HEAD_SIZE

#ifdef MISDNUSER_JOLLY
#define mISDNUSER_HEAD_SIZE (sizeof(mISDNuser_head_t))
#else
#define mISDNUSER_HEAD_SIZE (sizeof(mISDN_head_t))
#endif
#endif


/* #include "ies.h" */

#define MAX_BCHANS 30


#ifndef ASTERISK_STABLE
/* #define pthread_create ast_pthread_create */
#endif



#ifdef USE_ZT_EC

#include "ecdis.h"
#include "mec3.h"

struct echo_can_s {
	int echostate;
	int echotimer;
	int echolastupdate;
	echo_can_state_t  *ec;
}; 
#endif



/** For initialization usage **/
/* typedef int ie_nothing_t ;*/
/** end of init usage **/


enum bc_te_state_e {
	STATE_NOTHING=0,
	STATE_NULL,
	STATE_CALL_INIT,
	STATE_CONNECTED,
	STATE_HOLD_ACKNOWLEDGE
};


enum tone_e {
	TONE_NONE=0,
	TONE_DIAL,
	TONE_ALERTING,
	TONE_BUSY,
	TONE_FILE
};

enum misdn_err_e {
	ENOCHAN=1
};



enum mISDN_NUMBER_PLAN {
	NUMPLAN_INTERNATIONAL=0x1,
	NUMPLAN_NATIONAL=0x2,
	NUMPLAN_SUBSCRIBER=0x4,
	NUMPLAN_UNKNOWN=0x0
}; 


enum te_event_response_e {
	RESPONSE_IGNORE_SETUP_WITHOUT_CLOSE,
	RESPONSE_IGNORE_SETUP,
	RESPONSE_ERR,
	RESPONSE_OK
};



enum te_event_e {
	EVENT_NOTHING,
	EVENT_BCHAN_DATA,
	EVENT_CLEANUP,
	EVENT_PROCEEDING,
	EVENT_PROGRESS,
	EVENT_SETUP,
	EVENT_ALERTING,
	EVENT_CONNECT,
	EVENT_SETUP_ACKNOWLEDGE,
	EVENT_CONNECT_ACKNOWLEDGE ,
	EVENT_USER_INFORMATION,
	EVENT_SUSPEND_REJECT,
	EVENT_RESUME_REJECT,
	EVENT_HOLD,
	EVENT_SUSPEND,
	EVENT_RESUME,
	EVENT_HOLD_ACKNOWLEDGE,
	EVENT_SUSPEND_ACKNOWLEDGE,
	EVENT_RESUME_ACKNOWLEDGE,
	EVENT_HOLD_REJECT,
	EVENT_RETRIEVE,
	EVENT_RETRIEVE_ACKNOWLEDGE,
	EVENT_RETRIEVE_REJECT,
	EVENT_DISCONNECT,
	EVENT_RESTART,
	EVENT_RELEASE,
	EVENT_RELEASE_COMPLETE,
	EVENT_FACILITY,
	EVENT_NOTIFY,
	EVENT_STATUS_ENQUIRY,
	EVENT_INFORMATION,
	EVENT_STATUS,
	EVENT_TIMEOUT,
	EVENT_DTMF_TONE,
	EVENT_NEW_L3ID,
	EVENT_UNKNOWN
}; 


enum ie_name_e {
	IE_DUMMY,
	IE_LAST
};

enum { /* bearer capability */
	INFO_CAPABILITY_SPEECH=0,
	INFO_CAPABILITY_AUDIO_3_1K=0x10 ,
	INFO_CAPABILITY_AUDIO_7K=0x11 ,
	INFO_CAPABILITY_VIDEO =0x18,
	INFO_CAPABILITY_DIGITAL_UNRESTRICTED =0x8,
	INFO_CAPABILITY_DIGITAL_RESTRICTED =0x09,
	INFO_CAPABILITY_DIGITAL_UNRESTRICTED_TONES,
};

enum { /*CODECS*/
	INFO_CODEC_ULAW=2,
	INFO_CODEC_ALAW=3
}; 


enum layer_e {
	L3,
	L2,
	L1,
	UNKNOWN
}; 


struct misdn_bchannel {
	/** init stuff **/
	int b_stid;
	/* int b_addr; */
	int layer_id;
  
	/** var stuff**/
	int l3_id;
	int pid;
	int ces;
  
	int channel;
	int in_use;
	int addr;

	unsigned char * bframe;
	int bframe_len;
	int time_usec;
	
	sem_t astsem;
	sem_t misdnsem;
	ibuffer_t *astbuf;
	ibuffer_t *misdnbuf;
  
	/* dtmf digit */
	int dtmf;
	int send_dtmf;

	/* wether we should use jollys dsp or not */
	int nodsp;
	
	/* wether we should use our jitter buf system or not */
	int nojitter;
	
	enum mISDN_NUMBER_PLAN dnumplan;
	enum mISDN_NUMBER_PLAN onumplan;
	
	enum te_event_e evq;
	
	/*** CRYPTING STUFF ***/
  
	int crypt;
	int curprx;
	int curptx; 
	char crypt_key[255];
  
	int crypt_state;
    
	/*char ast_dtmf_buf[255];
	  char misdn_dtmf_buf[255]; */
  
	/*** CRYPTING STUFF END***/
  
	int active;
	int upset;

	enum tone_e tone;
	int tone_cnt;
	int tone_cnt2;
  
	enum bc_te_state_e state;

	int holded;
	int holded_l3id;
  
	int pres;
  
	int digital;
	int digital_trans;
	int capability;
	int law;
	/** V110 Stuff **/
	int rate;
	int mode;

	int user1;
	int urate;
	int async;
	/* V110 */
  
	unsigned char display[84];
	unsigned char msn[32];
	unsigned char oad[32];
	unsigned char dad[32];
	unsigned char orig_dad[32];
	unsigned char keypad[32];
  
	unsigned char info_dad[64];
	unsigned char infos_pending[64];
	unsigned char info_keypad[32];
	unsigned char clisub[24];
	unsigned char cldsub[24];
	unsigned char fac[132];
	unsigned char uu[256];
  
	int cause;
	int out_cause;
  
	/* struct misdn_bchannel hold_bc; */
  
	/** list stuf **/
#ifdef USE_ZT_EC
	/* struct echo_can_s ec; */
	echo_can_state_t* ec;      /**< == NULL: echo cancellation disabled;
				      != NULL: echo cancellation enabled */
	
	echo_can_disable_detector_state_t* ecdis_rd;
	echo_can_disable_detector_state_t* ecdis_wr;
	
	uint16_t echotimer;
	uint16_t echostate;
	uint16_t echolastupdate;

#endif
	int ec_enable;
	int ec_deftaps;
	int ec_whenbridged;
	int ec_training;
	
	int ec_tics;
	int orig;

	int txgain;
	int rxgain;
  
	struct misdn_bchannel *next;
	struct misdn_stack *stack;
};



struct misdn_stack {
	/** is first element because &nst equals &mISDNlist **/
	net_stack_t nst;
	manager_t mgr;
  
	int d_stid;
  
	int b_num;
  
	int b_stids[MAX_BCHANS + 1];
  
	int ptp;
	int lower_id;
	int upper_id;
  
	int l2link;
  
	time_t l2establish;
  
	int l1link;
	int midev;
  
	enum mode_e {NT_MODE, TE_MODE} mode;
	int pri;
  

	int procids[0x100+1];

	msg_queue_t downqueue;
	int busy;
  
	int port;
	struct misdn_bchannel bc_te[MAX_BCHANS + 1];
  
	struct misdn_bchannel* bc_list; 
  
	int channels[MAX_BCHANS + 1];

  
  
	int te_choose_channel;
  

	struct misdn_bchannel *holding; /* Queue which holds holded channels :) */
  
	struct misdn_stack *next;
	struct misdn_lib *mgr_te;
}; 






struct misdn_lib {
	int midev;
	int midev_nt;
  
	enum te_event_response_e
	(*cbEvent)(struct misdn_lib *mgr, enum te_event_e event, struct misdn_bchannel *bc, void *user_data);
  
	pthread_t event_thread;
	pthread_t event_handler_thread;
  
	void *user_data;

	msg_queue_t upqueue;
	msg_queue_t activatequeue; 
  
	sem_t new_msg;
  
	struct misdn_lib *next;
	struct misdn_stack *stack_list;
  
} ;

int init_bc_te(struct misdn_stack * stack,  struct misdn_bchannel *bc_te, int midev, int port, int bidx, char *msn, int firsttime);

struct misdn_stack* stack_te_init(int midev,  int port, int ptp);
void stack_te_destroy(struct misdn_stack* stack);




/***** USER IFACE **********/

int te_lib_init( void ) ; /* returns midev */
void te_lib_destroy(int midev) ;


struct misdn_lib*
misdn_lib_init(char *portlist, void *cbEvent, void *user_data);
int misdn_lib_send_event(struct misdn_lib *mgr, struct misdn_bchannel *bc, enum te_event_e event );
void misdn_lib_destroy(struct misdn_lib * mgr_te);

char *manager_isdn_get_info(enum te_event_e event);

void misdn_lib_transfer(struct misdn_lib *mgr ,struct misdn_bchannel* holded_bc);

struct misdn_bchannel *manager_find_bc_by_pid(struct misdn_lib *mgr, int pid);
struct misdn_bchannel* misdn_lib_get_free_bc(struct misdn_lib *mgr, int port);
struct misdn_bchannel *manager_find_bc_holded(struct misdn_lib *mgr, struct misdn_bchannel* bc);


void manager_bchannel_activate(struct misdn_bchannel *bc);
void manager_bchannel_deactivate(struct misdn_bchannel * bc);
int manager_tx2misdn_frm(struct misdn_bchannel *bc, void *data, int len);
void manager_send_tone ( struct misdn_lib *mgr, struct misdn_bchannel *bc, enum tone_e tone);
unsigned char * manager_flip_buf_bits ( unsigned char * buf , int len);

void manager_ph_control(struct misdn_bchannel *bc, int c1, int c2);
void manager_ph_control_block(struct misdn_bchannel *bc, int c1, void *c2, int c2_len);
void manager_clean_bc(struct misdn_lib *mgr, struct misdn_bchannel *bc );

void manager_bchannel_setup (struct misdn_bchannel *bc);
void manager_bchannel_cleanup (struct misdn_bchannel *bc);

int misdn_lib_port_restart(struct misdn_lib *mgr_te,int port);
int misdn_lib_get_port_info(struct misdn_lib* mgr,  int port);

int misdn_lib_free_bc_avail(struct misdn_lib *mgr_te, int port );
int misdn_lib_port_up(struct misdn_lib *mgr_te, int port);

int misdn_lib_get_port_up (struct misdn_lib *mgr, int port) ;
     
int misdn_lib_maxports_get(void) ;

struct misdn_bchannel * find_new_bc_in_stack(struct misdn_lib * mgr, int port);
void free_bc ( struct misdn_lib *mgr, struct misdn_bchannel *bc);


struct isdn_msg {
	unsigned long misdn_msg;
  
	enum layer_e layer;
	enum te_event_e event;
  
	void (*msg_parser)(struct isdn_msg msgs[], msg_t *msg, struct misdn_bchannel *bc, int nt);
	msg_t *(*msg_builder)(struct isdn_msg msgs[], struct misdn_bchannel *bc, int nt);
	void (*msg_printer)(struct isdn_msg msgs[]);
  
	char *info;
  
} ; 


msg_t *create_l3msg(int prim, int mt, int dinfo , int size, int nt);

int isdn_msg_get_index(struct isdn_msg msgs[], msg_t *frm, int nt);
enum te_event_e isdn_msg_get_event(struct isdn_msg msgs[], msg_t *frm, int nt);
int isdn_msg_parse_event(struct isdn_msg msgs[], msg_t *frm, struct misdn_bchannel *bc, int nt);

char * isdn_get_info(struct isdn_msg msgs[], enum te_event_e event, int nt);

msg_t * isdn_msg_build_event(struct isdn_msg msgs[], struct misdn_bchannel *bc, enum te_event_e event, int nt);

void ec_chunk( struct misdn_bchannel *bc, unsigned char *rxchunk, unsigned char *txchunk, int chunk_size);


void manager_ec_enable(struct misdn_bchannel *bc);
void manager_ec_disable(struct misdn_bchannel *bc);

#ifdef USE_ZT_EC

/*************/
inline void bchdev_echocancel_chunk(struct misdn_bchannel* dev, uint8_t *rxchunk, uint8_t *txchunk, uint16_t size);
int bchdev_echocancel_activate(struct misdn_bchannel* dev);
void bchdev_echocancel_deactivate(struct misdn_bchannel* dev);




#endif


#define PRI_TRANS_CAP_SPEECH                                    0x0
#define PRI_TRANS_CAP_DIGITAL                                   0x08
#define PRI_TRANS_CAP_RESTRICTED_DIGITAL                        0x09
#define PRI_TRANS_CAP_3_1K_AUDIO                                0x10
#define PRI_TRANS_CAP_7K_AUDIO                                  0x11

#endif
