/***** Autogenerated from runtime.in; changes will be overwritten *****/

#line 1 "runtime.in"
/*****
 * runtime.in
 * Tom Prince 2005/4/15
 *
 * Generate the runtime functions used by the vm::stack machine.
 *
 *****/

/* Autogenerated routines are specified like this (separated by a formfeed):
type asyname:cname(cparams)
{
  C code
}

*/

// Use Void f() instead of void f() to force an explicit Stack argument.


#line 55 "runtime.in"
#include <cfloat>
#include <time.h>
#include <sys/times.h>
  
#include "angle.h"
#include "pair.h"
#include "triple.h"
#include "transform.h"
#include "path.h"
#include "pen.h"
#include "guide.h"
#include "picture.h"
#include "drawpath.h"
#include "drawfill.h"
#include "drawclipbegin.h"
#include "drawclipend.h"
#include "drawlabel.h"
#include "drawverbatim.h"
#include "drawgsave.h"
#include "drawgrestore.h"
#include "drawlayer.h"
#include "drawimage.h"
#include "drawgroup.h"
#include "fileio.h"
#include "genv.h"
#include "builtin.h"
#include "texfile.h"
#include "pipestream.h"
#include "parser.h"
#include "stack.h"
#include "util.h"
#include "locate.h"
#include "mathop.h"
#include "callable.h"
#include "stm.h"
#include "lexical.h"
#include "Delaunay.h"
#include "process.h"
  
#ifdef HAVE_LIBFFTW3
#include "fftw++.h"
#endif
  
#if defined(HAVE_LIBREADLINE) && defined(HAVE_LIBCURSES)
#include <readline/readline.h>
#include <readline/history.h>
#endif

using namespace vm;
using namespace camp;
using namespace settings;

namespace settings {
extern pen *initialdefaultpen;
}

namespace run {
using camp::pair;
using mem::string;
using vm::array;
using vm::frame;
using vm::stack;
using camp::transform;
using absyntax::runnable;

typedef double real;

typedef array boolarray;
typedef array intarray;
typedef array intarray2;
typedef array realarray;
typedef array realarray2;
typedef array pairarray;
typedef array triplearray;
typedef array patharray;
typedef array guidearray;
typedef array transformarray;
typedef array penarray;
typedef array penarray2;
typedef array stringarray;
typedef array stringarray2;
  
typedef callable callableBp;
}

using vm::array;
using types::function;
using types::primVoid;
using types::primBoolean;
using types::primInt;
using types::primReal;
using types::primPair;
using types::primTriple;
using types::primPen;
using types::primPath;
using types::primGuide;
using types::primPicture;
using types::primString;
using types::primCode;
using types::primArray;
using types::primFile;
using types::primTransform;
using types::boolArray;
using types::intArray;
using types::intArray2;
using types::realArray;
using types::realArray2;
using types::pairArray;
using types::tripleArray;
using types::pathArray;
using types::guideArray;
using types::transformArray;
using types::penArray;
using types::penArray2;
using types::stringArray;
using types::stringArray2;
using types::formal;

function *voidFunction()
{
  return new function(primVoid());
}

function *breakpointFunction()
{
  return new function(primString(),primString(),primInt(),primInt(),
  primCode());
}

callable *atExitFunction=NULL;
callable *atDrawFunction=NULL;
callable *atBreakpointFunction=NULL;
  
const int camp::ColorComponents[]={0,0,1,3,4,0};

namespace vm {
const char *arraymismatch="operation attempted on arrays of different lengths";
}

namespace run {
  
const char *emptyarray="cannot take min or max of empty array";

static inline int Round(double x) 
{
  return int(x+((x >= 0) ? 0.5 : -0.5));
}

inline int sgn(double x) 
{
  return (x > 0.0 ? 1 : (x < 0.0 ? -1 : 0));
}

void outOfBounds(const char *op, size_t len, int n)
{
  ostringstream buf;
  buf << op << " array of length " << len << " with out-of-bounds index "
      << n;
  error(buf);
}

inline item& arrayRead(array *a, int n)  
{
  size_t len=checkArray(a);
  bool cyclic=a->cyclic();
  if(cyclic && len > 0) n=imod(n,len);
  else if(n < 0 || n >= (int) len) outOfBounds("reading",len,n);
  return (*a)[(unsigned) n];
}

// Helper function to create deep arrays.
static array* deepArray(int depth, int *dims)
{
  assert(depth > 0);
  
  if (depth == 1) {
    return new array(dims[0]);
  } else {
    int length = dims[0];
    depth--; dims++;

    array *a = new array(length);

    for (int index = 0; index < length; index++) {
      (*a)[index] = deepArray(depth, dims);
    }
    return a;
  }
}
  
array *copyArray(array *a)
{
  size_t size=checkArray(a);
  array *c=new array(size);
  for(size_t i=0; i < size; i++) 
    (*c)[i]=(*a)[i];
  return c;
}

double *copyArrayC(array *a)
{
  size_t size=checkArray(a);
  double *c=new double [size];
  for(size_t i=0; i < size; i++) 
    c[i]=read<double>(a,i);
  return c;
}

array *copyArray2(array *a)
{
  size_t size=checkArray(a);
  array *c=new array(size);
  for(size_t i=0; i < size; i++) {
    array *ai=read<array*>(a,i);
    size_t aisize=checkArray(ai);
    array *ci=new array(aisize);
    (*c)[i]=ci;
    for(size_t j=0; j < aisize; j++) 
      (*ci)[j]=(*ai)[j];
  }
  return c;
}

array *copyArray3(array *a)
{
  size_t size=checkArray(a);
  array *c=new array(size);
  for(size_t i=0; i < size; i++) {
    array *ai=read<array*>(a,i);
    size_t aisize=checkArray(ai);
    array *ci=new array(aisize);
    (*c)[i]=ci;
    for(size_t j=0; j < aisize; j++) {
      array *aij=read<array*>(ai,j);
      size_t aijsize=checkArray(aij);
      array *cij=new array(aijsize);
      (*ci)[j]=cij;
      for(size_t k=0; k < aijsize; k++) 
	(*cij)[k]=(*aij)[k];
    }
  }
  return c;
}

double **copyArray2C(array *a, bool square=true)
{
  size_t size=checkArray(a);
  size_t m=((square || size == 0) ? size : read<array*>(a,0)->size());
  double **c=new double* [size];
  for(size_t i=0; i < size; i++) {
    array *ai=read<array*>(a,i);
    size_t aisize=checkArray(ai);
    if(aisize == m) {
      double *ci=c[i]=new double [aisize];
      for(size_t j=0; j < aisize; j++) 
	ci[j]=read<double>(ai,j);
    } else
      error(square ? "matrix must be square" : "matrix must be rectangular");
  }
  return c;
}

static const char *incommensurate="Incommensurate matrices";
static const char *singular="Singular matrix";
static size_t *pivot,*Row,*Col;
static inline void inverseAllocate(size_t n)
{
  pivot=new size_t[n];
  Row=new size_t[n];
  Col=new size_t[n];
}

static inline void inverseDeallocate()
{
  delete[] pivot;
  delete[] Row;
  delete[] Col;
}

static inline void deleteArray(real **a, size_t n)
{
  for(size_t i=0; i < n; i++)
    delete a[i];
  delete a;
}

void writestring(stack *s)
{
  callable *suffix=pop<callable *>(s,NULL);
  string S=pop<string>(s);
  vm::item it=pop(s);
  bool defaultfile=isdefault(it);
  camp::file *f=defaultfile ? &camp::Stdout : vm::get<camp::file*>(it);
  if(!f->isOpen()) return;
  if(S != "") f->write(S);
  if(f->text()) {
    if(suffix) {
      s->push(f);
      suffix->call(s);
    } else if(defaultfile) f->writeline();
  }
}

void checkSquare(array *a) 
{
  size_t n=a->size();
  for(size_t i=0; i < n; i++)
    if(read<array*>(a,i)->size() != n)
      error("matrix a must be square");
}

// Crout's algorithm for computing the LU decomposition of a square matrix.
// cf. routine ludcmp (Press et al.,  Numerical Recipes, 1991).
int LUdecompose(double **a, size_t n, size_t* index, bool warn=true)
{
  double *vv=new double[n];
  int swap=1;
  for(size_t i=0; i < n; ++i) {
    double big=0.0;
    double *ai=a[i];
    for(size_t j=0; j < n; ++j) {
      double temp=fabs(ai[j]);
      if(temp > big) big=temp;
    }
    if(big == 0.0) {
      delete[] vv;
      if(warn) error(singular);
      else return 0;
    }
    vv[i]=1.0/big;
  }
  for(size_t j=0; j < n; ++j) {
    for(size_t i=0; i < j; ++i) {
      double *ai=a[i];
      double sum=ai[j];
      for(size_t k=0; k < i; ++k) {
	sum -= ai[k]*a[k][j];
      }
      ai[j]=sum;
    }
    double big=0.0;
    size_t imax=j;
    for(size_t i=j; i < n; ++i) {
      double *ai=a[i];
      double sum=ai[j];
      for(size_t k=0; k < j; ++k)
	sum -= ai[k]*a[k][j];
      ai[j]=sum;
      double temp=vv[i]*fabs(sum);
      if(temp >= big) {
	big=temp;
	imax=i;
      }
    }
    double *aj=a[j];
    double *aimax=a[imax];
    if(j != imax) {
      for(size_t k=0; k < n; ++k) {
	double temp=aimax[k];
	aimax[k]=aj[k];
	aj[k]=temp;
      }
      swap *= -1;
      vv[imax]=vv[j];
    }
    index[j]=imax;
    if(j != n) {
      double denom=aj[j];
      if(denom == 0.0) {
	delete[] vv;
	if(warn) error(singular);
	else return 0;
      }
      for(size_t i=j+1; i < n; ++i)
	a[i][j] /= denom;
    }
  }
  delete[] vv;
  return swap;
}

void dividebyzero(size_t i)
{
  std::ostringstream buf;
  if(i > 0) buf << "array element " << i << ": ";
  buf << "Divide by zero";
  error(buf);
}
  
void integeroverflow(size_t i)
{
  std::ostringstream buf;
  if(i > 0) buf << "array element " << i << ": ";
  buf << "Integer overflow";
  error(buf);
}
  
#if defined(HAVE_LIBREADLINE) && defined(HAVE_LIBCURSES)
typedef mem::map<CONST string, HISTORY_STATE> historyMap_t;
historyMap_t historyMap;
static HISTORY_STATE history_save;

// Store a deep copy of the current readline history in dest.
void store_history(HISTORY_STATE *dest)
{
  HISTORY_STATE *src=history_get_history_state();
  *dest=*src;
  if(src) {
    for(int i=0; i < src->length; ++i)
      dest->entries[i]=src->entries[i];
    free(src);
  }
}

const char nosave='\n';

string historyfilename(const string &name) 
{
  return historyname+"_"+name;
}
#endif

#if defined(HAVE_LIBREADLINE) && defined(HAVE_LIBCURSES)
int readline_startup_hook()
{
#ifdef __CYGWIN__
  rl_set_key("\\M-[3~",rl_delete,rl_get_keymap());
  rl_set_key("\\M-[2~",rl_overwrite_mode,rl_get_keymap());
#endif    
  return 0;
}

void init_readline(bool tabcompletion=true) 
{
  static bool first=true;
  if(first) {
    first=false;
#ifdef __CYGWIN__
    rl_startup_hook=readline_startup_hook;
#endif    
  }
  rl_bind_key('\t',tabcompletion ? rl_complete : rl_insert);
}
#endif

void clearTeX()
{
  if(TeXinitialized) {
    camp::TeXpipepreamble.clear();
    camp::TeXpreamble.clear();
    camp::tex.pipeclose();
    TeXinitialized=false;
  }
}

void cleanup()
{
  if(initialdefaultpen) defaultpen=*initialdefaultpen;

  atExitFunction=NULL;
  atDrawFunction=NULL;
  atBreakpointFunction=NULL;
  
  clearTeX();

#if defined(HAVE_LIBREADLINE) && defined(HAVE_LIBCURSES)
  store_history(&history_save);
  int nlines=getSetting<int>("historylines");
  for(historyMap_t::iterator h=historyMap.begin(); h != historyMap.end(); 
      ++h) {
    history_set_history_state(&h->second);
    stifle_history(nlines);
    if(h->first[0] != nosave) write_history(historyfilename(h->first).c_str());
  }
  history_set_history_state(&history_save);
#endif
}

void updateFunction(stack *Stack)
{
  if(atExitFunction && !nullfunc::instance()->compare(atExitFunction))
    atExitFunction->call(Stack);
}

void exitFunction(stack *Stack)
{
  updateFunction(Stack);
  cleanup();
}

default_t def;
string emptystring;
transform Identity;
string commentchar="#";

void breakpoint(stack *Stack, runnable *r)
{
  if(atBreakpointFunction &&
     !nullfunc::instance()->compare(atBreakpointFunction)) {
    position curPos=getPos();
    Stack->push<string>(curPos.filename());
    Stack->push<int>((int) curPos.Line());
    Stack->push<int>((int) curPos.Column());
    Stack->push(r ? r : item(def));
    atBreakpointFunction->call(Stack); // returns a string
  } else Stack->push<string>("");
}

}

namespace types {
extern const char *names[];
}

void checkformat(const char *ptr, bool intformat) 
{
  while(*ptr != '\0') {
    if(*ptr != '%') /* While we have regular characters, print them.  */
      ptr++;
    else { /* We've got a format specifier. */
      ptr++;
      
      while(*ptr && strchr ("-+ #0'I", *ptr)) /* Move past flags.  */
	*ptr++;

      if(*ptr == '*')
	ptr++;
      else while(isdigit(*ptr)) /* Handle explicit numeric value.  */
	ptr++;
	  
      if(*ptr == '.') {
	*ptr++; /* Go past the period.  */
	if(*ptr == '*') {
	  ptr++;
	} else
	  while(isdigit(*ptr)) /* Handle explicit numeric value.  */
	    *ptr++;
      }
      while(*ptr && strchr ("hlL", *ptr))
	*ptr++;
	  
      if(*ptr == '%') ++ptr;
      else if(*ptr != '\0') {
	if(intformat) {
	  switch(*ptr) {
	  case 'd':
	  case 'i':
	  case 'o':
	  case 'u':
	  case 'x':
	  case 'X':
	  case 'c':
	    break;
	  default:
	    ostringstream buf;
	    buf << "Invalid format '" << *ptr << "' for type " 
		<< types::names[types::ty_int];
	    error(buf);
	    break;
	  }
	} else {
	  switch(*ptr) {
	  case 'f':
	  case 'F':
	  case 'e':
	  case 'E':
	  case 'g':
	  case 'G':
	    break;
	  default:
	    ostringstream buf;
	    buf << "Invalid format '" << *ptr << "' for type "
		<< types::names[types::ty_real];
	    error(buf);
	    break;
	  }
	}
      }
    } /* End of else statement */
  }
}
  
// Return an angle in the interval [0,360).
inline double principalBranch(double deg)
{
  if(deg < 0) deg += 360; 
  return deg;
}

inline double Min(double a, double b)
{
  return (a < b) ? a : b;
}

inline double Max(double a, double b)
{
  return (a > b) ? a : b;
}

static mem::string *defaulttransparency=new mem::string("Compatible");

static mem::string *defaulttimeformat=new mem::string("%a %b %d %T %Z %Y");
#ifdef HAVE_STRFTIME
static const size_t nTime=256;
static char Time[nTime];
#endif  

void clear(string file, int line, bool warn=false) 
{
  bpinfo bp(file,line);
  for(mem::list<bpinfo>::iterator p=bplist.begin(); p != bplist.end(); ++p) {
    if(*p == bp) {
      cout << "cleared breakpoint at " << file << ": " << line << endl;
      bplist.remove(bp);
      return;
    }
  }
  if(warn)
    cout << "No such breakpoint at "  << file << ": " << line << endl;
}

// Autogenerated routines:



namespace run {

// Initializers
#line 681 "runtime.in"
void intZero(stack *Stack)
{
#line 682 "runtime.in"
  {Stack->push<int>(0); return;}
}

#line 687 "runtime.in"
void realZero(stack *Stack)
{
#line 688 "runtime.in"
  {Stack->push<real>(0.0); return;}
}

#line 692 "runtime.in"
void boolFalse(stack *Stack)
{
#line 693 "runtime.in"
  {Stack->push<bool>(false); return;}
}

#line 697 "runtime.in"
void pushNullArray(stack *Stack)
{
#line 698 "runtime.in"
  {Stack->push<array*>(0); return;}
}

#line 702 "runtime.in"
void pushNullRecord(stack *Stack)
{
#line 703 "runtime.in"
  {Stack->push<frame*>(0); return;}
}

#line 707 "runtime.in"
void pushNullFunction(stack *Stack)
{
#line 708 "runtime.in"
  {Stack->push(nullfunc::instance()); return;}
}


// Default operations

// Put the default value token on the stack (in place of an argument when
// making a function call).
#line 717 "runtime.in"
void pushDefault(stack *Stack)
{
#line 718 "runtime.in"
  {Stack->push(def); return;}
}


// Test if the value on the stack is the default value token.
#line 724 "runtime.in"
void isDefault(stack *Stack)
{
  item i = vm::pop(Stack);
#line 725 "runtime.in"
  {Stack->push<bool>(isdefault(i)); return;}
}


// Logical operations
#line 731 "runtime.in"
// bool !(bool b);
void gen8(stack *Stack)
{
  bool b = vm::pop<bool>(Stack);
#line 732 "runtime.in"
  {Stack->push<bool>(!b); return;}
}

#line 737 "runtime.in"
void boolMemEq(stack *Stack)
{
  frame * b = vm::pop<frame *>(Stack);
  frame * a = vm::pop<frame *>(Stack);
#line 738 "runtime.in"
  {Stack->push<bool>(a == b); return;}
}

#line 742 "runtime.in"
void boolMemNeq(stack *Stack)
{
  frame * b = vm::pop<frame *>(Stack);
  frame * a = vm::pop<frame *>(Stack);
#line 743 "runtime.in"
  {Stack->push<bool>(a != b); return;}
}

#line 747 "runtime.in"
void boolFuncEq(stack *Stack)
{
  callable * b = vm::pop<callable *>(Stack);
  callable * a = vm::pop<callable *>(Stack);
#line 748 "runtime.in"
  {Stack->push<bool>(a->compare(b)); return;}
}

#line 752 "runtime.in"
void boolFuncNeq(stack *Stack)
{
  callable * b = vm::pop<callable *>(Stack);
  callable * a = vm::pop<callable *>(Stack);
#line 753 "runtime.in"
  {Stack->push<bool>(!(a->compare(b))); return;}
}


// Casts
#line 759 "runtime.in"
void pairToGuide(stack *Stack)
{
  pair z = vm::pop<pair>(Stack);
#line 760 "runtime.in"
  {Stack->push<guide*>(new pairguide(z)); return;}
}

#line 765 "runtime.in"
void pathToGuide(stack *Stack)
{
  path p = vm::pop<path>(Stack);
#line 766 "runtime.in"
  {Stack->push<guide*>(new pathguide(p)); return;}
}

#line 770 "runtime.in"
void guideToPath(stack *Stack)
{
  guide * g = vm::pop<guide *>(Stack);
#line 771 "runtime.in"
  {Stack->push<path>(g->solve()); return;}
}


// Picture operations
#line 777 "runtime.in"
void newPicture(stack *Stack)
{
#line 778 "runtime.in"
  {Stack->push<picture*>(new picture()); return;}
}

#line 783 "runtime.in"
// bool empty(picture *f);
void gen17(stack *Stack)
{
  picture * f = vm::pop<picture *>(Stack);
#line 784 "runtime.in"
  {Stack->push<bool>(f->null()); return;}
}

#line 788 "runtime.in"
// pair max(picture *f);
void gen18(stack *Stack)
{
  picture * f = vm::pop<picture *>(Stack);
#line 789 "runtime.in"
  {Stack->push<pair>(f->bounds().Max()); return;}
}

#line 793 "runtime.in"
// pair min(picture *f);
void gen19(stack *Stack)
{
  picture * f = vm::pop<picture *>(Stack);
#line 794 "runtime.in"
  {Stack->push<pair>(f->bounds().Min()); return;}
}

#line 798 "runtime.in"
// void label(picture *f, string *s, string *size, transform t, pair position,	   pair align, pen p);
void gen20(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
  pair align = vm::pop<pair>(Stack);
  pair position = vm::pop<pair>(Stack);
  transform t = vm::pop<transform>(Stack);
  string * size = vm::pop<string *>(Stack);
  string * s = vm::pop<string *>(Stack);
  picture * f = vm::pop<picture *>(Stack);
#line 800 "runtime.in"
  f->append(new drawLabel(*s,*size,t,position,align,p));
}

#line 804 "runtime.in"
// bool labels(picture *f);
void gen21(stack *Stack)
{
  picture * f = vm::pop<picture *>(Stack);
#line 805 "runtime.in"
  {Stack->push<bool>(f->havelabels()); return;}
}

#line 809 "runtime.in"
// void _draw(picture *f, path g, pen p);
void gen22(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
  path g = vm::pop<path>(Stack);
  picture * f = vm::pop<picture *>(Stack);
#line 810 "runtime.in"
  f->append(new drawPath(g,p));
}

#line 814 "runtime.in"
// void fill(picture *f, patharray *g, pen p);
void gen23(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
  patharray * g = vm::pop<patharray *>(Stack);
  picture * f = vm::pop<picture *>(Stack);
#line 815 "runtime.in"
  f->append(new drawFill(copyArray(g),p));
}

#line 819 "runtime.in"
// void latticeshade(picture *f, patharray *g, pen fillrule, penarray2 *p);
void gen24(stack *Stack)
{
  penarray2 * p = vm::pop<penarray2 *>(Stack);
  pen fillrule = vm::pop<pen>(Stack);
  patharray * g = vm::pop<patharray *>(Stack);
  picture * f = vm::pop<picture *>(Stack);
#line 820 "runtime.in"
  f->append(new drawLatticeShade(copyArray(g),fillrule,copyArray(p)));
}

#line 824 "runtime.in"
// void axialshade(picture *f, patharray *g, pen pena, pair a, pen penb, pair b);
void gen25(stack *Stack)
{
  pair b = vm::pop<pair>(Stack);
  pen penb = vm::pop<pen>(Stack);
  pair a = vm::pop<pair>(Stack);
  pen pena = vm::pop<pen>(Stack);
  patharray * g = vm::pop<patharray *>(Stack);
  picture * f = vm::pop<picture *>(Stack);
#line 825 "runtime.in"
  f->append(new drawAxialShade(copyArray(g),pena,a,penb,b));
}

#line 829 "runtime.in"
// void radialshade(picture *f, patharray *g, pen pena, pair a, real ra,		 pen penb, pair b, real rb);
void gen26(stack *Stack)
{
  real rb = vm::pop<real>(Stack);
  pair b = vm::pop<pair>(Stack);
  pen penb = vm::pop<pen>(Stack);
  real ra = vm::pop<real>(Stack);
  pair a = vm::pop<pair>(Stack);
  pen pena = vm::pop<pen>(Stack);
  patharray * g = vm::pop<patharray *>(Stack);
  picture * f = vm::pop<picture *>(Stack);
#line 831 "runtime.in"
  f->append(new drawRadialShade(copyArray(g),pena,a,ra,penb,b,rb));
}

#line 835 "runtime.in"
// void gouraudshade(picture *f, patharray *g, pen fillrule, penarray *p,		  pairarray *z, intarray *edges);
void gen27(stack *Stack)
{
  intarray * edges = vm::pop<intarray *>(Stack);
  pairarray * z = vm::pop<pairarray *>(Stack);
  penarray * p = vm::pop<penarray *>(Stack);
  pen fillrule = vm::pop<pen>(Stack);
  patharray * g = vm::pop<patharray *>(Stack);
  picture * f = vm::pop<picture *>(Stack);
#line 837 "runtime.in"
  checkArrays(p,z);
  checkArrays(z,edges);
  f->append(new drawGouraudShade(copyArray(g),fillrule,copyArray(p),
				 copyArray(z),copyArray(edges)));
}

// Clip a picture to a superpath using the given fill rule.
// Subsequent additions to the picture will not be affected by the clipping.
#line 846 "runtime.in"
// void clip(picture *f, patharray *g, pen p);
void gen28(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
  patharray * g = vm::pop<patharray *>(Stack);
  picture * f = vm::pop<picture *>(Stack);
#line 847 "runtime.in"
  f->enclose(new drawClipBegin(copyArray(g),p),new drawClipEnd());
}

#line 851 "runtime.in"
// void beginclip(picture *f, patharray *g, pen p);
void gen29(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
  patharray * g = vm::pop<patharray *>(Stack);
  picture * f = vm::pop<picture *>(Stack);
#line 852 "runtime.in"
  f->append(new drawClipBegin(copyArray(g),p,false));
}

#line 856 "runtime.in"
// void endclip(picture *f);
void gen30(stack *Stack)
{
  picture * f = vm::pop<picture *>(Stack);
#line 857 "runtime.in"
  f->append(new drawClipEnd(false));
}

#line 861 "runtime.in"
// void gsave(picture *f);
void gen31(stack *Stack)
{
  picture * f = vm::pop<picture *>(Stack);
#line 862 "runtime.in"
  f->append(new drawGsave());
}

#line 866 "runtime.in"
// void grestore(picture *f);
void gen32(stack *Stack)
{
  picture * f = vm::pop<picture *>(Stack);
#line 867 "runtime.in"
  f->append(new drawGrestore());
}

#line 871 "runtime.in"
// void begingroup(picture *f);
void gen33(stack *Stack)
{
  picture * f = vm::pop<picture *>(Stack);
#line 872 "runtime.in"
  f->append(new drawBegin());
}

#line 876 "runtime.in"
// void endgroup(picture *f);
void gen34(stack *Stack)
{
  picture * f = vm::pop<picture *>(Stack);
#line 877 "runtime.in"
  f->append(new drawEnd());
}

#line 881 "runtime.in"
// void add(picture *dest, picture *src);
void gen35(stack *Stack)
{
  picture * src = vm::pop<picture *>(Stack);
  picture * dest = vm::pop<picture *>(Stack);
#line 882 "runtime.in"
  dest->add(*src);
}

#line 886 "runtime.in"
// void prepend(picture *dest, picture *src);
void gen36(stack *Stack)
{
  picture * src = vm::pop<picture *>(Stack);
  picture * dest = vm::pop<picture *>(Stack);
#line 887 "runtime.in"
  dest->prepend(*src);
}

#line 891 "runtime.in"
// void postscript(picture *f, string s);
void gen37(stack *Stack)
{
  string s = vm::pop<string>(Stack);
  picture * f = vm::pop<picture *>(Stack);
#line 892 "runtime.in"
  f->append(new drawVerbatim(PostScript,s));
}

#line 896 "runtime.in"
// void tex(picture *f, string s);
void gen38(stack *Stack)
{
  string s = vm::pop<string>(Stack);
  picture * f = vm::pop<picture *>(Stack);
#line 897 "runtime.in"
  f->append(new drawVerbatim(TeX,s));
}

#line 901 "runtime.in"
// void texpreamble(string s);
void gen39(stack *Stack)
{
  string s = vm::pop<string>(Stack);
#line 902 "runtime.in"
  string t=s+"\n";
  camp::TeXpipepreamble.push_back(t);
  camp::TeXpreamble.push_back(t);
}

#line 908 "runtime.in"
// void texreset();
void gen40(stack *)
{
#line 909 "runtime.in"
  clearTeX();
}

#line 913 "runtime.in"
// void layer(picture *f);
void gen41(stack *Stack)
{
  picture * f = vm::pop<picture *>(Stack);
#line 914 "runtime.in"
  f->append(new drawLayer());
}

#line 918 "runtime.in"
// void _image(picture *f, realarray2 *data, pair initial, pair final,	    penarray *palette=NULL, transform t=Identity);
void gen42(stack *Stack)
{
  transform t = vm::pop<transform>(Stack,Identity);
  penarray * palette = vm::pop<penarray *>(Stack,NULL);
  pair final = vm::pop<pair>(Stack);
  pair initial = vm::pop<pair>(Stack);
  realarray2 * data = vm::pop<realarray2 *>(Stack);
  picture * f = vm::pop<picture *>(Stack);
#line 920 "runtime.in"
  f->append(new drawImage(copyArray2(data),copyArray(palette),
			  t*matrix(initial,final)));
}

#line 925 "runtime.in"
// void _image(picture *f, penarray2 *data, pair initial, pair final,	    transform t=Identity);
void gen43(stack *Stack)
{
  transform t = vm::pop<transform>(Stack,Identity);
  pair final = vm::pop<pair>(Stack);
  pair initial = vm::pop<pair>(Stack);
  penarray2 * data = vm::pop<penarray2 *>(Stack);
  picture * f = vm::pop<picture *>(Stack);
#line 927 "runtime.in"
  f->append(new drawImage(copyArray2(data),NULL,t*matrix(initial,final)));
}

#line 931 "runtime.in"
// string nativeformat();
void gen44(stack *Stack)
{
#line 932 "runtime.in"
  {Stack->push<string>(nativeformat()); return;}
}

#line 936 "runtime.in"
// bool latex();
void gen45(stack *Stack)
{
#line 937 "runtime.in"
  {Stack->push<bool>(latex(texengine())); return;}
}

#line 941 "runtime.in"
// bool pdf();
void gen46(stack *Stack)
{
#line 942 "runtime.in"
  {Stack->push<bool>(pdf(texengine())); return;}
}

#line 946 "runtime.in"
// void shipout(string prefix=emptystring, picture *f, picture *preamble=NULL,	     string format=emptystring, bool wait=false, bool view=true,	     transformarray *GUItransform, boolarray *GUIdelete);
void gen47(stack *Stack)
{
  boolarray * GUIdelete = vm::pop<boolarray *>(Stack);
  transformarray * GUItransform = vm::pop<transformarray *>(Stack);
  bool view = vm::pop<bool>(Stack,true);
  bool wait = vm::pop<bool>(Stack,false);
  string format = vm::pop<string>(Stack,emptystring);
  picture * preamble = vm::pop<picture *>(Stack,NULL);
  picture * f = vm::pop<picture *>(Stack);
  string prefix = vm::pop<string>(Stack,emptystring);
#line 949 "runtime.in"
  if(prefix.empty()) prefix=outname();
  
  size_t size=GUItransform && GUIdelete ?
    checkArrays(GUItransform,GUIdelete) : 0;
 
  if(getSetting<real>("deconstruct") || size) {
    picture *result=new picture;
    unsigned level=0;
    unsigned i=0;
    nodelist::iterator p;
    for(p = f->nodes.begin(); p != f->nodes.end(); ++p) {
      bool Delete;
      transform t;
      if(i < size) {
	t=*(read<transform*>(GUItransform,i));
	Delete=read<bool>(GUIdelete,i);
      } else {
	t=identity();
	Delete=false;
      }
      picture *group=new picture;
// Ignore unclosed begingroups but not spurious endgroups.
      const char *nobegin="endgroup without matching begingroup";
      assert(*p);
      if((*p)->endgroup()) error(nobegin);
      if((*p)->begingroup()) {
	++level;
	while(p != f->nodes.end() && level) {
	  drawElement *e=t.isIdentity() ? *p : (*p)->transformed(t);
	  group->append(e);
	  ++p;
	  if(p == f->nodes.end()) break;
	  assert(*p);
	  if((*p)->begingroup()) ++level;
	  if((*p)->endgroup()) if(level) --level;
	  else error(nobegin);
	}
      }
      if(p == f->nodes.end()) break;
      assert(*p);
      drawElement *e=t.isIdentity() ? *p : (*p)->transformed(t);
      group->append(e);
      if(!group->empty()) {
	if(getSetting<real>("deconstruct")) {
	  ostringstream buf;
	  buf << prefix << "_" << i;
	  group->shipout(preamble,buf.str(),"tgif",false,false,Delete);
	}
	++i;
      }
      if(size && !Delete) result->add(*group);
    }
    if(size) f=result;
  }

  f->shipout(preamble,prefix,format,wait,view);
}


// Pen operations
#line 1010 "runtime.in"
void newPen(stack *Stack)
{
#line 1011 "runtime.in"
  {Stack->push<pen>(pen()); return;}
}

#line 1016 "runtime.in"
// bool ==(pen a, pen b);
void gen49(stack *Stack)
{
  pen b = vm::pop<pen>(Stack);
  pen a = vm::pop<pen>(Stack);
#line 1017 "runtime.in"
  {Stack->push<bool>(a == b); return;}
}

#line 1021 "runtime.in"
// bool !=(pen a, pen b);
void gen50(stack *Stack)
{
  pen b = vm::pop<pen>(Stack);
  pen a = vm::pop<pen>(Stack);
#line 1022 "runtime.in"
  {Stack->push<bool>(a != b); return;}
}

#line 1026 "runtime.in"
// pen +(pen a, pen b);
void gen51(stack *Stack)
{
  pen b = vm::pop<pen>(Stack);
  pen a = vm::pop<pen>(Stack);
#line 1027 "runtime.in"
  {Stack->push<pen>(a+b); return;}
}

#line 1031 "runtime.in"
// pen *(real a, pen b);
void gen52(stack *Stack)
{
  pen b = vm::pop<pen>(Stack);
  real a = vm::pop<real>(Stack);
#line 1032 "runtime.in"
  {Stack->push<pen>(a*b); return;}
}

#line 1036 "runtime.in"
// pen *(pen a, real b);
void gen53(stack *Stack)
{
  real b = vm::pop<real>(Stack);
  pen a = vm::pop<pen>(Stack);
#line 1037 "runtime.in"
  {Stack->push<pen>(b*a); return;}
}

#line 1041 "runtime.in"
// pair max(pen p);
void gen54(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 1042 "runtime.in"
  {Stack->push<pair>(p.bounds().Max()); return;}
}

#line 1046 "runtime.in"
// pair min(pen p);
void gen55(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 1047 "runtime.in"
  {Stack->push<pair>(p.bounds().Min()); return;}
}

// Reset the meaning of pen default attributes.
#line 1052 "runtime.in"
// void resetdefaultpen();
void gen56(stack *)
{
#line 1053 "runtime.in"
  if(initialdefaultpen) defaultpen=*initialdefaultpen;
}

#line 1057 "runtime.in"
// void defaultpen(pen p);
void gen57(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 1058 "runtime.in"
  defaultpen=pen(resolvepen,p);
}

#line 1062 "runtime.in"
// pen defaultpen();
void gen58(stack *Stack)
{
#line 1063 "runtime.in"
  {Stack->push<pen>(defaultpen); return;}
}

#line 1067 "runtime.in"
// pen invisible();
void gen59(stack *Stack)
{
#line 1068 "runtime.in"
  {Stack->push<pen>(pen(invisiblepen)); return;}
}

#line 1072 "runtime.in"
// pen gray(pen p);
void gen60(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 1073 "runtime.in"
  if(p.rgb()) p.rgbtogrey();
  else if (p.cmyk()) p.cmyktogrey();
  {Stack->push<pen>(p); return;}
}

#line 1079 "runtime.in"
// pen rgb(pen p);
void gen61(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 1080 "runtime.in"
  if(p.grayscale()) p.greytorgb();
  else if (p.cmyk()) p.cmyktorgb();
  {Stack->push<pen>(p); return;}
}

#line 1086 "runtime.in"
// pen rgb(real r, real g, real b);
void gen62(stack *Stack)
{
  real b = vm::pop<real>(Stack);
  real g = vm::pop<real>(Stack);
  real r = vm::pop<real>(Stack);
#line 1087 "runtime.in"
  {Stack->push<pen>(pen(r,g,b)); return;}
}

#line 1091 "runtime.in"
// pen cmyk(real c, real m, real y, real k);
void gen63(stack *Stack)
{
  real k = vm::pop<real>(Stack);
  real y = vm::pop<real>(Stack);
  real m = vm::pop<real>(Stack);
  real c = vm::pop<real>(Stack);
#line 1092 "runtime.in"
  {Stack->push<pen>(pen(c,m,y,k)); return;}  
}

#line 1096 "runtime.in"
// pen gray(real gray);
void gen64(stack *Stack)
{
  real gray = vm::pop<real>(Stack);
#line 1097 "runtime.in"
  {Stack->push<pen>(pen(gray)); return;}
}

#line 1101 "runtime.in"
// realarray* colors(pen p);
void gen65(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 1102 "runtime.in"  
  int n=ColorComponents[p.colorspace()];
  array *a=new array(n);
  
  switch(n) {
  case 0:
    break;
  case 1: 
    (*a)[0]=p.gray(); 
    break;
  case 3:
    (*a)[0]=p.red(); 
    (*a)[1]=p.green(); 
    (*a)[2]=p.blue(); 
    break;
  case 4:
    (*a)[0]=p.cyan();
    (*a)[1]=p.magenta(); 
    (*a)[2]=p.yellow(); 
    (*a)[3]=p.black();
    break;
  default:
    break;
  }
  {Stack->push<realarray*>(a); return;}
}

#line 1129 "runtime.in"
// pen pattern(string *s);
void gen66(stack *Stack)
{
  string * s = vm::pop<string *>(Stack);
#line 1130 "runtime.in"
  {Stack->push<pen>(pen(setpattern,*s)); return;}
}

#line 1134 "runtime.in"
// string pattern(pen p);
void gen67(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 1135 "runtime.in"
  {Stack->push<string>(p.fillpattern()); return;}  
}

#line 1139 "runtime.in"
// pen fillrule(int n);
void gen68(stack *Stack)
{
  int n = vm::pop<int>(Stack);
#line 1140 "runtime.in"
  {Stack->push<pen>(pen(n >= 0 && n < nFill ? (FillRule) n : DEFFILL)); return;}
}

#line 1144 "runtime.in"
// int fillrule(pen p);
void gen69(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 1145 "runtime.in"
  {Stack->push<int>(p.Fillrule()); return;}  
}

#line 1149 "runtime.in"
// pen opacity(real opacity=1.0, string *blend=defaulttransparency);
void gen70(stack *Stack)
{
  string * blend = vm::pop<string *>(Stack,defaulttransparency);
  real opacity = vm::pop<real>(Stack,1.0);
#line 1150 "runtime.in"
  for(int i=0; i < nBlendMode; ++i)
   if(*blend == BlendMode[i]) {Stack->push<pen>(pen(Transparency(*blend,opacity))); return;}

  ostringstream buf;
  buf << "Unknown blend mode: " << "'" << *blend << "'";
  error(buf);
}

#line 1159 "runtime.in"
// real opacity(pen p);
void gen71(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 1160 "runtime.in"
  {Stack->push<real>(p.opacity()); return;}
}

#line 1164 "runtime.in"
// string blend(pen p);
void gen72(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 1165 "runtime.in"
  {Stack->push<string>(p.blend()); return;}
}

#line 1169 "runtime.in"
// pen linetype(string *s, real offset=0, bool scale=true, bool adjust=true);
void gen73(stack *Stack)
{
  bool adjust = vm::pop<bool>(Stack,true);
  bool scale = vm::pop<bool>(Stack,true);
  real offset = vm::pop<real>(Stack,0);
  string * s = vm::pop<string *>(Stack);
#line 1170 "runtime.in"
  {Stack->push<pen>(pen(LineType(*s,offset,scale,adjust))); return;} 
}

#line 1174 "runtime.in"
// string linetype(pen p);
void gen74(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 1175 "runtime.in"
  {Stack->push<string>(p.stroke()); return;}  
}

#line 1179 "runtime.in"
// real offset(pen p);
void gen75(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 1180 "runtime.in"
  {Stack->push<real>(p.linetype().offset); return;}
}

#line 1184 "runtime.in"
// bool scale(pen p);
void gen76(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 1185 "runtime.in"
  {Stack->push<bool>(p.linetype().scale); return;}
}

#line 1189 "runtime.in"
// bool adjust(pen p);
void gen77(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 1190 "runtime.in"
  {Stack->push<bool>(p.linetype().adjust); return;}
}

#line 1194 "runtime.in"
// pen linecap(int n);
void gen78(stack *Stack)
{
  int n = vm::pop<int>(Stack);
#line 1195 "runtime.in"
  {Stack->push<pen>(pen(setlinecap,n >= 0 && n < nCap ? n : DEFCAP)); return;}
}

#line 1199 "runtime.in"
// int linecap(pen p);
void gen79(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 1200 "runtime.in"
  {Stack->push<int>(p.cap()); return;}  
}

#line 1204 "runtime.in"
// pen linejoin(int n);
void gen80(stack *Stack)
{
  int n = vm::pop<int>(Stack);
#line 1205 "runtime.in"
  {Stack->push<pen>(pen(setlinejoin,n >= 0 && n < nJoin ? n : DEFJOIN)); return;}
}

#line 1209 "runtime.in"
// int linejoin(pen p);
void gen81(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 1210 "runtime.in"
  {Stack->push<int>(p.join()); return;}  
}

#line 1214 "runtime.in"
// pen linewidth(real x);
void gen82(stack *Stack)
{
  real x = vm::pop<real>(Stack);
#line 1215 "runtime.in"
  {Stack->push<pen>(pen(setlinewidth,x >= 0.0 ? x : DEFWIDTH)); return;}
}

#line 1219 "runtime.in"
// real linewidth(pen p);
void gen83(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 1220 "runtime.in"
  {Stack->push<real>(p.width()); return;}  
}

#line 1224 "runtime.in"
// pen fontcommand(string *s);
void gen84(stack *Stack)
{
  string * s = vm::pop<string *>(Stack);
#line 1225 "runtime.in"
  {Stack->push<pen>(pen(setfont,*s)); return;}
}

#line 1229 "runtime.in"
// string font(pen p);
void gen85(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 1230 "runtime.in"
  {Stack->push<string>(p.Font()); return;}
}

#line 1234 "runtime.in"
// pen fontsize(real size, real lineskip);
void gen86(stack *Stack)
{
  real lineskip = vm::pop<real>(Stack);
  real size = vm::pop<real>(Stack);
#line 1235 "runtime.in"
  {Stack->push<pen>(pen(setfontsize,size > 0.0 ? size : 0.0,
	     lineskip > 0.0 ? lineskip : 0.0)); return;}
}

#line 1240 "runtime.in"
// real fontsize(pen p);
void gen87(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 1241 "runtime.in"
  {Stack->push<real>(p.size()); return;}
}

#line 1245 "runtime.in"
// real lineskip(pen p);
void gen88(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 1246 "runtime.in"
  {Stack->push<real>(p.Lineskip()); return;}  
}

#line 1250 "runtime.in"
// pen overwrite(int n);
void gen89(stack *Stack)
{
  int n = vm::pop<int>(Stack);
#line 1251 "runtime.in"
  {Stack->push<pen>(pen(setoverwrite,n >= 0 && n < nOverwrite ? (overwrite_t) n :
	     DEFWRITE)); return;}
}

#line 1256 "runtime.in"
// int overwrite(pen p);
void gen90(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 1257 "runtime.in"
  {Stack->push<int>(p.Overwrite()); return;}  
}

#line 1261 "runtime.in"
// pen basealign(int n);
void gen91(stack *Stack)
{
  int n = vm::pop<int>(Stack);
#line 1262 "runtime.in"
  {Stack->push<pen>(pen(n >= 0 && n < nBaseLine ? (BaseLine) n : DEFBASE)); return;}
}

#line 1266 "runtime.in"
// int basealign(pen p);
void gen92(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 1267 "runtime.in"
  {Stack->push<int>(p.Baseline()); return;}
}

#line 1271 "runtime.in"
// path nib(pen p);
void gen93(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 1272 "runtime.in"
  static path nullpath;
  path *g=p.Path();
  {Stack->push<path>(g ? *g : nullpath); return;}
}

#line 1278 "runtime.in"
// pen makepen(path p);
void gen94(stack *Stack)
{
  path p = vm::pop<path>(Stack);
#line 1279 "runtime.in"
  {Stack->push<pen>(p.size() == 0 ? pen() : pen(new path(p))); return;}
}

#line 1283 "runtime.in"
// pen colorless(pen p);
void gen95(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
#line 1284 "runtime.in"
  p.colorless();
  {Stack->push<pen>(p); return;}
}

// Interactive mode
#line 1290 "runtime.in"
// bool interactive();
void gen96(stack *Stack)
{
#line 1291 "runtime.in"
  {Stack->push<bool>(interact::interactive); return;}
}

#line 1296 "runtime.in"
// void uptodate(bool b);
void gen97(stack *Stack)
{
  bool b = vm::pop<bool>(Stack);
#line 1297 "runtime.in"
  interact::uptodate=b;
}

#line 1301 "runtime.in"
// bool uptodate();
void gen98(stack *Stack)
{
#line 1302 "runtime.in"
  {Stack->push<bool>(interact::uptodate); return;}
}


// System commands
#line 1308 "runtime.in"
// int system(string *s);
void gen99(stack *Stack)
{
  string * s = vm::pop<string *>(Stack);
#line 1309 "runtime.in"
  if(safe) error("system() call disabled; override with option -unsafe");
  else {Stack->push<int>(System(s->c_str())); return;}
}

#line 1315 "runtime.in"
// void abort(string s=emptystring);
void gen100(stack *Stack)
{
  string s = vm::pop<string>(Stack,emptystring);
#line 1316 "runtime.in"
  if(s == "") throw handled_error();
  error(s.c_str());
}

#line 1321 "runtime.in"
// void assert(bool b, string s=emptystring);
void gen101(stack *Stack)
{
  string s = vm::pop<string>(Stack,emptystring);
  bool b = vm::pop<bool>(Stack);
#line 1322 "runtime.in"
  flush(cout);
  if(!b) {
    ostringstream buf;
    buf << "assert FAILED";
    if(s != "") buf << ": " << s << endl;
    error(buf);
  }
}

#line 1332 "runtime.in"
// void _eval(string *s, bool embedded);
void gen102(stack *Stack)
{
  bool embedded = vm::pop<bool>(Stack);
  string * s = vm::pop<string *>(Stack);
#line 1333 "runtime.in"
  if (embedded) {
    trans::coenv *e=Stack->getEnvironment();
    vm::interactiveStack *is=dynamic_cast<vm::interactiveStack *>(Stack);
    if (e && is) {
      runStringEmbedded(*s, *e, *is);
    } else {
      cerr << "no runtime environment for embedded eval" << endl;
    }
  } else {
    runString(*s);
  }
}

#line 1347 "runtime.in"
// void _eval(runnable *s, bool embedded);
void gen103(stack *Stack)
{
  bool embedded = vm::pop<bool>(Stack);
  runnable * s = vm::pop<runnable *>(Stack);
#line 1348 "runtime.in"
  absyntax::block *ast=new absyntax::block(s->getPos(), false);
  ast->add(s);

  if (embedded) {
    trans::coenv *e=Stack->getEnvironment();
    vm::interactiveStack *is=dynamic_cast<vm::interactiveStack *>(Stack);
    if (e && is) {
      runCodeEmbedded(ast, *e, *is);
    } else {
      cerr << "no runtime environment for embedded eval" << endl;
    }
  } else {
    runCode(ast);
  }
}

#line 1365 "runtime.in"
// string location();
void gen104(stack *Stack)
{
#line 1366 "runtime.in"
  ostringstream buf;
  buf << getPos();
  {Stack->push<string>(buf.str()); return;}
}

#line 1371 "runtime.in"
// void gui(real x=1);
void gen105(stack *Stack)
{
  real x = vm::pop<real>(Stack,1);
#line 1372 "runtime.in" 
  Setting("deconstruct")=(x > 0.0 ? x : 0.0);
}

#line 1376 "runtime.in"
// bool deconstruct();
void gen106(stack *Stack)
{
#line 1377 "runtime.in" 
  {Stack->push<bool>(getSetting<real>("deconstruct")); return;}
}

#line 1381 "runtime.in"
// Void readGUI();
void gen107(stack *Stack)
{
#line 1382 "runtime.in"
  static bool first=true;
  string name=buildname(outname(),"gui");
  std::ifstream exists(name.c_str());
  if(exists) {
    if((getSetting<bool>("clearGUI") && !interact::interactive) ||
       (first && interact::interactive)) unlink(name.c_str());
    else {
      if (!getSetting<bool>("ignoreGUI")) {
	string cmd=string("include \"")+name+string("\";");

        // NOTE: Duplicate code with _eval.
        trans::coenv *e=Stack->getEnvironment();
        vm::interactiveStack *is=dynamic_cast<vm::interactiveStack *>(Stack);
        if (e && is) {
          runStringEmbedded(cmd, *e, *is);
        } else {
          cerr << "no runtime environment for readGUI" << endl;
        }
      }
    }
  }
  first=false;
}

// Wrapper for the stack::load() method.
#line 1408 "runtime.in"
void loadModule(stack *Stack)
{
  string * index = vm::pop<string *>(Stack);
#line 1409 "runtime.in"
  Stack->load(*index);
}

#line 1413 "runtime.in"
// string cd(string *d);
void gen109(stack *Stack)
{
  string * d = vm::pop<string *>(Stack);
#line 1414 "runtime.in"
  int rc=setPath(d->c_str());
  if(rc != 0) {
    ostringstream buf;
    buf << "Cannot change to directory '" << *d << "'";
    error(buf);
  }
  char *p=getPath();
  if(p && interact::interactive) 
    cout << p << endl;
  {Stack->push<string>(p); return;}
}

#line 1427 "runtime.in"
// void list(string *s, bool imports=false);
void gen110(stack *Stack)
{
  bool imports = vm::pop<bool>(Stack,false);
  string * s = vm::pop<string *>(Stack);
#line 1428 "runtime.in"
  if(*s == "-") return;
  trans::genv ge;
  symbol *name=symbol::trans((std::string) *s);
  record *r=ge.getModule(name,*s);
  r->e.list(imports ? 0 : r);
}


// Path operations
#line 1438 "runtime.in"
void nullPath(stack *Stack)
{
#line 1439 "runtime.in"
  static path nullpath;
  {Stack->push<path>(nullpath); return;}
}

#line 1445 "runtime.in"
// pair point(path p, int n);
void gen112(stack *Stack)
{
  int n = vm::pop<int>(Stack);
  path p = vm::pop<path>(Stack);
#line 1446 "runtime.in"
  {Stack->push<pair>(p.point(n)); return;}
}

#line 1450 "runtime.in"
// pair point(path p, real t);
void gen113(stack *Stack)
{
  real t = vm::pop<real>(Stack);
  path p = vm::pop<path>(Stack);
#line 1451 "runtime.in"
  {Stack->push<pair>(p.point(t)); return;}
}

#line 1455 "runtime.in"
// pair precontrol(path p, int n);
void gen114(stack *Stack)
{
  int n = vm::pop<int>(Stack);
  path p = vm::pop<path>(Stack);
#line 1456 "runtime.in"
  {Stack->push<pair>(p.precontrol(n)); return;}
}

#line 1460 "runtime.in"
// pair precontrol(path p, real t);
void gen115(stack *Stack)
{
  real t = vm::pop<real>(Stack);
  path p = vm::pop<path>(Stack);
#line 1461 "runtime.in"
  {Stack->push<pair>(p.precontrol(t)); return;}
}

#line 1465 "runtime.in"
// pair postcontrol(path p, int n);
void gen116(stack *Stack)
{
  int n = vm::pop<int>(Stack);
  path p = vm::pop<path>(Stack);
#line 1466 "runtime.in"
  {Stack->push<pair>(p.postcontrol(n)); return;}
}

#line 1470 "runtime.in"
// pair postcontrol(path p, real t);
void gen117(stack *Stack)
{
  real t = vm::pop<real>(Stack);
  path p = vm::pop<path>(Stack);
#line 1471 "runtime.in"
  {Stack->push<pair>(p.postcontrol(t)); return;}
}

#line 1475 "runtime.in"
// pair dir(path p, int n);
void gen118(stack *Stack)
{
  int n = vm::pop<int>(Stack);
  path p = vm::pop<path>(Stack);
#line 1476 "runtime.in"
  {Stack->push<pair>(unit(p.direction(n))); return;}
}

#line 1480 "runtime.in"
// pair dir(path p, real t);
void gen119(stack *Stack)
{
  real t = vm::pop<real>(Stack);
  path p = vm::pop<path>(Stack);
#line 1481 "runtime.in"
  {Stack->push<pair>(unit(p.direction(t))); return;}
}

#line 1485 "runtime.in"
// path reverse(path p);
void gen120(stack *Stack)
{
  path p = vm::pop<path>(Stack);
#line 1486 "runtime.in"
  {Stack->push<path>(p.reverse()); return;}
}

#line 1490 "runtime.in"
// path subpath(path p, int b, int e);
void gen121(stack *Stack)
{
  int e = vm::pop<int>(Stack);
  int b = vm::pop<int>(Stack);
  path p = vm::pop<path>(Stack);
#line 1491 "runtime.in"
  {Stack->push<path>(p.subpath(b,e)); return;}
}

#line 1495 "runtime.in"
// path subpath(path p, real b, real e);
void gen122(stack *Stack)
{
  real e = vm::pop<real>(Stack);
  real b = vm::pop<real>(Stack);
  path p = vm::pop<path>(Stack);
#line 1496 "runtime.in"
  {Stack->push<path>(p.subpath(b,e)); return;}
}

#line 1500 "runtime.in"
// int length(path p);
void gen123(stack *Stack)
{
  path p = vm::pop<path>(Stack);
#line 1501 "runtime.in"
  {Stack->push<int>(p.length()); return;}
}

#line 1505 "runtime.in"
// bool cyclic(path p);
void gen124(stack *Stack)
{
  path p = vm::pop<path>(Stack);
#line 1506 "runtime.in"
  {Stack->push<bool>(p.cyclic()); return;}
}

#line 1510 "runtime.in"
// bool straight(path p, int i);
void gen125(stack *Stack)
{
  int i = vm::pop<int>(Stack);
  path p = vm::pop<path>(Stack);
#line 1511 "runtime.in"
  {Stack->push<bool>(p.straight(i)); return;}
}

#line 1515 "runtime.in"
// bool piecewisestraight(path p);
void gen126(stack *Stack)
{
  path p = vm::pop<path>(Stack);
#line 1516 "runtime.in"
  int L=p.length();
  for(int i=0; i < L; ++i)
    if(!p.straight(i)) {Stack->push<bool>(false); return;}
  {Stack->push<bool>(true); return;}
}

#line 1523 "runtime.in"
// real arclength(path p);
void gen127(stack *Stack)
{
  path p = vm::pop<path>(Stack);
#line 1524 "runtime.in"
  {Stack->push<real>(p.arclength()); return;}
}

#line 1528 "runtime.in"
// real arctime(path p, real dval);
void gen128(stack *Stack)
{
  real dval = vm::pop<real>(Stack);
  path p = vm::pop<path>(Stack);
#line 1529 "runtime.in"
  {Stack->push<real>(p.arctime(dval)); return;}
}

#line 1533 "runtime.in"
// real dirtime(path p, pair z);
void gen129(stack *Stack)
{
  pair z = vm::pop<pair>(Stack);
  path p = vm::pop<path>(Stack);
#line 1534 "runtime.in"
  {Stack->push<real>(p.directiontime(z)); return;}
}

#line 1538 "runtime.in"
// pair intersect(path x, path y, real fuzz=0);
void gen130(stack *Stack)
{
  real fuzz = vm::pop<real>(Stack,0);
  path y = vm::pop<path>(Stack);
  path x = vm::pop<path>(Stack);
#line 1539 "runtime.in"
  {Stack->push<pair>(intersectiontime(x,y,fuzz)); return;}
}

#line 1543 "runtime.in"
// int size(path p);
void gen131(stack *Stack)
{
  path p = vm::pop<path>(Stack);
#line 1544 "runtime.in"
  {Stack->push<int>(p.size()); return;}
}

#line 1548 "runtime.in"
// path &(path p, path q);
void gen132(stack *Stack)
{
  path q = vm::pop<path>(Stack);
  path p = vm::pop<path>(Stack);
#line 1549 "runtime.in"
  {Stack->push<path>(camp::concat(p,q)); return;}
}

#line 1553 "runtime.in"
// pair min(path p);
void gen133(stack *Stack)
{
  path p = vm::pop<path>(Stack);
#line 1554 "runtime.in"
  {Stack->push<pair>(p.bounds().Min()); return;}
}

#line 1558 "runtime.in"
// pair max(path p);
void gen134(stack *Stack)
{
  path p = vm::pop<path>(Stack);
#line 1559 "runtime.in"
  {Stack->push<pair>(p.bounds().Max()); return;}
}

#line 1563 "runtime.in"
// real relativedistance(real theta, real phi, real t, bool atleast);
void gen135(stack *Stack)
{
  bool atleast = vm::pop<bool>(Stack);
  real t = vm::pop<real>(Stack);
  real phi = vm::pop<real>(Stack);
  real theta = vm::pop<real>(Stack);
#line 1564 "runtime.in"
  {Stack->push<real>(camp::velocity(theta,phi,tension(t,atleast))); return;}
}

#line 1568 "runtime.in"
// bool inside(patharray *g, pair z, pen p);
void gen136(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
  pair z = vm::pop<pair>(Stack);
  patharray * g = vm::pop<patharray *>(Stack);
#line 1569 "runtime.in"
  size_t size=g->size();
  int count=0;
  for(size_t i=0; i < size; i++) 
    count += read<path *>(g,i)->inside(z);
  {Stack->push<bool>(p.inside(count)); return;}
}


// Guide operations
#line 1579 "runtime.in"
void nullGuide(stack *Stack)
{
#line 1580 "runtime.in"
  {Stack->push<guide*>(new pathguide(path())); return;}
}

#line 1585 "runtime.in"
void dotsGuide(stack *Stack)
{
  guidearray * a = vm::pop<guidearray *>(Stack);
#line 1586 "runtime.in"
  guidevector v;
  size_t size=checkArray(a);
  for (size_t i=0; i < size; ++i)
    v.push_back(a->read<guide*>(i));

  {Stack->push<guide*>(new multiguide(v)); return;}
}

#line 1595 "runtime.in"
void dashesGuide(stack *Stack)
{
  guidearray * a = vm::pop<guidearray *>(Stack);
#line 1596 "runtime.in"
  static camp::curlSpec curly;
  static specguide curlout(&curly, camp::OUT);
  static specguide curlin(&curly, camp::IN);

  size_t n=checkArray(a);

  // a--b is equivalent to a{curl 1}..{curl 1}b
  guidevector v;
  if (n > 0)
    v.push_back(a->read<guide*>(0));

  if (n==1) {
    v.push_back(&curlout);
    v.push_back(&curlin);
  }
  else
    for (size_t i=1; i<n; ++i) {
      v.push_back(&curlout);
      v.push_back(&curlin);
      v.push_back(a->read<guide*>(i));
    }

  {Stack->push<guide*>(new multiguide(v)); return;}
}

#line 1622 "runtime.in"
// guide* operator cycle();
void gen140(stack *Stack)
{
#line 1623 "runtime.in"
  {Stack->push<guide*>(new cycletokguide()); return;}
}

#line 1627 "runtime.in"
// guide* operator spec(pair z, int p);
void gen141(stack *Stack)
{
  int p = vm::pop<int>(Stack);
  pair z = vm::pop<pair>(Stack);
#line 1628 "runtime.in"
  camp::side d=(camp::side) p;
  camp::dirSpec *sp=new camp::dirSpec(angle(z));

  {Stack->push<guide*>(new specguide(sp,d)); return;}
}

#line 1635 "runtime.in"
// guide* operator curl(real gamma, int p);
void gen142(stack *Stack)
{
  int p = vm::pop<int>(Stack);
  real gamma = vm::pop<real>(Stack);
#line 1636 "runtime.in"
  camp::side d=(camp::side) p;
  camp::curlSpec *sp=new camp::curlSpec(gamma);

  {Stack->push<guide*>(new specguide(sp,d)); return;}
}

#line 1643 "runtime.in"
// guide* operator tension(real tout, real tin, bool atleast);
void gen143(stack *Stack)
{
  bool atleast = vm::pop<bool>(Stack);
  real tin = vm::pop<real>(Stack);
  real tout = vm::pop<real>(Stack);
#line 1644 "runtime.in"
  {Stack->push<guide*>(new tensionguide(tension(tout,atleast),tension(tin,atleast))); return;}
}

#line 1648 "runtime.in"
// guide* operator controls(pair zout, pair zin);
void gen144(stack *Stack)
{
  pair zin = vm::pop<pair>(Stack);
  pair zout = vm::pop<pair>(Stack);
#line 1649 "runtime.in"
  {Stack->push<guide*>(new controlguide(zout, zin)); return;}
}


// String operations
#line 1655 "runtime.in"
void emptyString(stack *Stack)
{
#line 1656 "runtime.in"
  {Stack->push<string>(emptystring); return;}
}

#line 1661 "runtime.in"
// int length(string *s);
void gen146(stack *Stack)
{
  string * s = vm::pop<string *>(Stack);
#line 1662 "runtime.in"
  {Stack->push<int>((int) s->length()); return;}
}

#line 1666 "runtime.in"
// int find(string *s, string t, int pos=0);
void gen147(stack *Stack)
{
  int pos = vm::pop<int>(Stack,0);
  string t = vm::pop<string>(Stack);
  string * s = vm::pop<string *>(Stack);
#line 1667 "runtime.in"
  {Stack->push<int>((int) s->find(t,pos)); return;}
}

#line 1671 "runtime.in"
// int rfind(string *s, string t, int pos=-1);
void gen148(stack *Stack)
{
  int pos = vm::pop<int>(Stack,-1);
  string t = vm::pop<string>(Stack);
  string * s = vm::pop<string *>(Stack);
#line 1672 "runtime.in"
  {Stack->push<int>((int) s->rfind(t,pos)); return;}
}

#line 1676 "runtime.in"
// string reverse(string s);
void gen149(stack *Stack)
{
  string s = vm::pop<string>(Stack);
#line 1677 "runtime.in"
  reverse(s.begin(),s.end());
  {Stack->push<string>(s); return;}
}

#line 1682 "runtime.in"
// string insert(string s, int pos, string t);
void gen150(stack *Stack)
{
  string t = vm::pop<string>(Stack);
  int pos = vm::pop<int>(Stack);
  string s = vm::pop<string>(Stack);
#line 1683 "runtime.in"
  if ((size_t) pos < s.length())
    {Stack->push<string>(s.insert(pos,t)); return;}
  {Stack->push<string>(s); return;}
}

#line 1689 "runtime.in"
// string substr(string* s, int pos, int n=-1);
void gen151(stack *Stack)
{
  int n = vm::pop<int>(Stack,-1);
  int pos = vm::pop<int>(Stack);
  string* s = vm::pop<string*>(Stack);
#line 1690 "runtime.in"
  if ((size_t) pos < s->length())
    {Stack->push<string>(s->substr(pos,n)); return;}
  {Stack->push<string>(emptystring); return;}
}

#line 1696 "runtime.in"
// string erase(string s, int pos, int n);
void gen152(stack *Stack)
{
  int n = vm::pop<int>(Stack);
  int pos = vm::pop<int>(Stack);
  string s = vm::pop<string>(Stack);
#line 1697 "runtime.in"
  if ((size_t) pos < s.length())
    {Stack->push<string>(s.erase(pos,n)); return;}
  {Stack->push<string>(s); return;} 
}

// returns a string constructed by translating all occurrences of the string
// from in an array of string pairs {from,to} to the string to in string s.
#line 1705 "runtime.in"
// string replace(string *S, stringarray2 *translate);
void gen153(stack *Stack)
{
  stringarray2 * translate = vm::pop<stringarray2 *>(Stack);
  string * S = vm::pop<string *>(Stack);
#line 1706 "runtime.in"
  size_t size=checkArray(translate);
  for(size_t i=0; i < size; i++) {
    array *a=read<array*>(translate,i);
    checkArray(a);
  }
  const char *p=S->c_str();
  ostringstream buf;
  while(*p) {
    for(size_t i=0; i < size;) {
      array *a=read<array*>(translate,i);
      string* from=read<string*>(a,0);
      size_t len=from->length();
      if(strncmp(p,from->c_str(),len) != 0) {i++; continue;}
      buf << read<string>(a,1);
      p += len;
      if(*p == 0) {Stack->push<string>(buf.str()); return;}
      i=0;
    }
    buf << *(p++);
  }
  {Stack->push<string>(buf.str()); return;}
}

#line 1730 "runtime.in"
// string format(string *format, int x);
void gen154(stack *Stack)
{
  int x = vm::pop<int>(Stack);
  string * format = vm::pop<string *>(Stack);
#line 1731 "runtime.in"
  const char *f=format->c_str();
  
  checkformat(f,true);
  
  int size=snprintf(NULL,0,f,x)+1;
  if(size < 1) size=255; // Workaround for non-C99 compliant systems.
  char *buf=new char[size];
  snprintf(buf,size,f,x);
  string s=string(buf);
  delete[] buf;
  {Stack->push<string>(s); return;}
}

#line 1745 "runtime.in"
// string format(string *format, real x);
void gen155(stack *Stack)
{
  real x = vm::pop<real>(Stack);
  string * format = vm::pop<string *>(Stack);
#line 1746 "runtime.in"
  ostringstream out;
  
  checkformat(format->c_str(),false);
  
  const char *phantom="\\phantom{+}";
  const char *p0=format->c_str();
  
  const char *p=p0;
  const char *start=NULL;
  while (*p != 0) {
    if(*p == '%') {
      p++;
      if(*p != '%') {start=p-1; break;}
    }
    out << *(p++);
  }
  
  if(!start) {Stack->push<string>(out.str()); return;}
  
  // Allow at most 1 argument  
  while (*p != 0) {
    if(*p == '*' || *p == '$') {Stack->push<string>(out.str()); return;}
    if(isupper(*p) || islower(*p)) {p++; break;}
    p++;
  }
  
  const char *tail=p;
  string f=format->substr(start-p0,tail-start);
  int size=snprintf(NULL,0,f.c_str(),x)+1;
  if(size < 1) size=255; // Workaround for non-C99 compliant systems.
  char *buf=new char[size];
  snprintf(buf,size,f.c_str(),x);

  bool trailingzero=f.find("#") < string::npos;
  bool plus=f.find("+") < string::npos;
  bool space=f.find(" ") < string::npos;
  
  char *q=buf; // beginning of formatted number

  if(*q == ' ') {
    out << phantom;
    q++;
  }
  
  // Remove any spurious sign
  if(*q == '-' || *q == '+') {
    p=q+1;
    bool zero=true;
    while(*p != 0) {
      if(!isdigit(*p) && *p != '.') break;
      if(isdigit(*p) && *p != '0') {zero=false; break;}
      p++;
    }
    if(zero) {
      q++;
      if(plus || space) out << phantom;
    }
  }
  
  const char *r=p=q;
  bool dp=false;
  while(*r != 0 && (isdigit(*r) || *r == '.' || *r == '+' || *r == '-')) {
    if(*r == '.') dp=true;
    r++;
  }
  if(dp) { // Remove trailing zeros and/or decimal point
    r--;
    unsigned int n=0;
    while(r > q && *r == '0') {r--; n++;}
    if(*r == '.') {r--; n++;}
    while(q <= r) out << *(q++);
    if(!trailingzero) q += n;
  }
  
  bool zero=(r == p && *r == '0') && !trailingzero;
  
  // Translate "E+/E-/e+/e-" exponential notation to TeX
  while(*q != 0) {
    if((*q == 'E' || *q == 'e') && (*(q+1) == '+' || *(q+1) == '-')) {
      if(!zero) out << "\\!\\times\\!10^{";
      bool plus=(*(q+1) == '+');
      q++;
      if(plus) q++;
      if(*q == '-') out << *(q++);
      while(*q == '0' && (zero || isdigit(*(q+1)))) q++;
      while(isdigit(*q)) out << *(q++);
      if(!zero) {
	if(plus) out << phantom;
	out << "}";
      }
      break;
    }
    out << *(q++);
  }
  
  while(*tail != 0) 
    out << *(tail++);
  
  delete[] buf;
  {Stack->push<string>(out.str()); return;}
}

#line 1849 "runtime.in"
// string string(real x, int digits);
void gen156(stack *Stack)
{
  int digits = vm::pop<int>(Stack);
  real x = vm::pop<real>(Stack);
#line 1850 "runtime.in"
  std::ostringstream buf;
  buf.precision(digits);
  buf << x;
  {Stack->push<string>(buf.str()); return;}
}

#line 1857 "runtime.in"
// string time(string *format=defaulttimeformat);
void gen157(stack *Stack)
{
  string * format = vm::pop<string *>(Stack,defaulttimeformat);
#line 1858 "runtime.in"
#ifdef HAVE_STRFTIME
  const time_t bintime=time(NULL);
  if(!strftime(Time,nTime,format->c_str(),localtime(&bintime))) {Stack->push<string>(""); return;}
  {Stack->push<string>(Time); return;}
#else
  {Stack->push<string>(*format); return;}
#endif  
}

#line 1868 "runtime.in"
// string time(int seconds, string *format=defaulttimeformat);
void gen158(stack *Stack)
{
  string * format = vm::pop<string *>(Stack,defaulttimeformat);
  int seconds = vm::pop<int>(Stack);
#line 1869 "runtime.in"
#ifdef HAVE_STRFTIME
  const time_t bintime=seconds;
  if(!strftime(Time,nTime,format->c_str(),localtime(&bintime))) {Stack->push<string>(""); return;}
  {Stack->push<string>(Time); return;}
#else
// Avoid unused variable warning messages
  {Stack->push<string>(seconds ? *format : *format); return;}
#endif
}

#line 1880 "runtime.in"
// int seconds(string t=emptystring, string format=emptystring);
void gen159(stack *Stack)
{
  string format = vm::pop<string>(Stack,emptystring);
  string t = vm::pop<string>(Stack,emptystring);
#line 1881 "runtime.in"
#if defined(HAVE_STRPTIME) && defined(HAVE_STRFTIME)
  const time_t bintime=time(NULL);
  tm tm=*localtime(&bintime);
  if(t != "" && !strptime(t.c_str(),format.c_str(),&tm)) {Stack->push<int>(0); return;}
  if(!strftime(Time,nTime,"%s",&tm)) {Stack->push<int>(0); return;}
  {Stack->push<int>(lexical::cast<int>(Time)); return;}
#else  
  {Stack->push<int>(0); return;}
#endif  
}

#line 1893 "runtime.in"
// realarray* _cputime();
void gen160(stack *Stack)
{
#line 1894 "runtime.in"
  static const real ticktime=1.0/sysconf(_SC_CLK_TCK);
  struct tms buf;

  ::times(&buf);
  array *t=new array(4);
  (*t)[0] = ((real) buf.tms_utime)*ticktime;
  (*t)[1] = ((real) buf.tms_stime)*ticktime;
  (*t)[2] = ((real) buf.tms_cutime)*ticktime;
  (*t)[3] = ((real) buf.tms_cstime)*ticktime;
  {Stack->push<realarray*>(t); return;}
}


// Math
#line 1909 "runtime.in"
// real ^(real x, int y);
void gen161(stack *Stack)
{
  int y = vm::pop<int>(Stack);
  real x = vm::pop<real>(Stack);
#line 1910 "runtime.in"
  {Stack->push<real>(pow(x,y)); return;}
}

#line 1915 "runtime.in"
// int quotient(int x, int y);
void gen162(stack *Stack)
{
  int y = vm::pop<int>(Stack);
  int x = vm::pop<int>(Stack);
#line 1916 "runtime.in" 
  if (y == 0) dividebyzero();
// Implementation-independent definition of integer division: round down
  {Stack->push<int>((x-portableMod(x,y))/y); return;}
}

#line 1922 "runtime.in"
// int abs(int x);
void gen163(stack *Stack)
{
  int x = vm::pop<int>(Stack);
#line 1923 "runtime.in" 
  {Stack->push<int>(abs(x)); return;}
}

#line 1927 "runtime.in"
// int sgn(real x);
void gen164(stack *Stack)
{
  real x = vm::pop<real>(Stack);
#line 1928 "runtime.in" 
  {Stack->push<int>(sgn(x)); return;}
}

#line 1932 "runtime.in"
// int rand();
void gen165(stack *Stack)
{
#line 1933 "runtime.in" 
  {Stack->push<int>(rand()); return;}
}

#line 1937 "runtime.in"
// void srand(int seed);
void gen166(stack *Stack)
{
  int seed = vm::pop<int>(Stack);
#line 1938 "runtime.in" 
  srand(seed);
}

#line 1942 "runtime.in"
// int ceil(real x);
void gen167(stack *Stack)
{
  real x = vm::pop<real>(Stack);
#line 1943 "runtime.in" 
  real y=ceil(x);
  checkint(y,0);
  {Stack->push<int>((int) y); return;}
}

#line 1949 "runtime.in"
// int floor(real x);
void gen168(stack *Stack)
{
  real x = vm::pop<real>(Stack);
#line 1950 "runtime.in" 
  real y=floor(x);
  checkint(y,0);
  {Stack->push<int>((int) y); return;}
}

#line 1956 "runtime.in"
// int round(real x);
void gen169(stack *Stack)
{
  real x = vm::pop<real>(Stack);
#line 1957 "runtime.in" 
  if(fabs(x) >= INT_MAX+0.5) integeroverflow(0);
  {Stack->push<int>(Round(x)); return;}
}

#line 1962 "runtime.in"
// int Ceil(real x);
void gen170(stack *Stack)
{
  real x = vm::pop<real>(Stack);
#line 1963 "runtime.in" 
  {Stack->push<int>(Ceil(x)); return;}
}

#line 1967 "runtime.in"
// int Floor(real x);
void gen171(stack *Stack)
{
  real x = vm::pop<real>(Stack);
#line 1968 "runtime.in" 
  {Stack->push<int>(Floor(x)); return;}
}

#line 1972 "runtime.in"
// int Round(real x);
void gen172(stack *Stack)
{
  real x = vm::pop<real>(Stack);
#line 1973 "runtime.in" 
  {Stack->push<int>(Round(intcap(x))); return;}
}

#line 1977 "runtime.in"
// real fmod(real x, real y);
void gen173(stack *Stack)
{
  real y = vm::pop<real>(Stack);
  real x = vm::pop<real>(Stack);
#line 1978 "runtime.in"
  if (y == 0.0) dividebyzero();
  {Stack->push<real>(fmod(x,y)); return;}
}

#line 1983 "runtime.in"
// real atan2(real y, real x);
void gen174(stack *Stack)
{
  real x = vm::pop<real>(Stack);
  real y = vm::pop<real>(Stack);
#line 1984 "runtime.in" 
  {Stack->push<real>(atan2(y,x)); return;}
}

#line 1988 "runtime.in"
// real hypot(real x, real y);
void gen175(stack *Stack)
{
  real y = vm::pop<real>(Stack);
  real x = vm::pop<real>(Stack);
#line 1989 "runtime.in" 
  {Stack->push<real>(hypot(x,y)); return;}
}

#line 1993 "runtime.in"
// real remainder(real x, real y);
void gen176(stack *Stack)
{
  real y = vm::pop<real>(Stack);
  real x = vm::pop<real>(Stack);
#line 1994 "runtime.in" 
  {Stack->push<real>(remainder(x,y)); return;}
}

#line 1998 "runtime.in"
// real J(int n, real x);
void gen177(stack *Stack)
{
  real x = vm::pop<real>(Stack);
  int n = vm::pop<int>(Stack);
#line 1999 "runtime.in"
  {Stack->push<real>(jn(n,x)); return;}
}

#line 2003 "runtime.in"
// real Y(int n, real x);
void gen178(stack *Stack)
{
  real x = vm::pop<real>(Stack);
  int n = vm::pop<int>(Stack);
#line 2004 "runtime.in"
  {Stack->push<real>(yn(n,x)); return;}
}

#line 2008 "runtime.in"
// real erf(real x);
void gen179(stack *Stack)
{
  real x = vm::pop<real>(Stack);
#line 2009 "runtime.in"
  {Stack->push<real>(erf(x)); return;}
}

#line 2013 "runtime.in"
// real erfc(real x);
void gen180(stack *Stack)
{
  real x = vm::pop<real>(Stack);
#line 2014 "runtime.in"
  {Stack->push<real>(erfc(x)); return;}
}

#line 2018 "runtime.in"
// real gamma(real x);
void gen181(stack *Stack)
{
  real x = vm::pop<real>(Stack);
#line 2019 "runtime.in"
#ifdef HAVE_TGAMMA
  {Stack->push<real>(tgamma(x)); return;}
#else
 real lg = lgamma(x);
 {Stack->push<real>(signgam*exp(lg)); return;}
#endif
}

#line 2028 "runtime.in"
// realarray* quadraticroots(real a, real b, real c);
void gen182(stack *Stack)
{
  real c = vm::pop<real>(Stack);
  real b = vm::pop<real>(Stack);
  real a = vm::pop<real>(Stack);
#line 2029 "runtime.in"
  quadraticroots q(a,b,c);
  array *roots=new array(q.roots);
  if(q.roots >= 1) (*roots)[0]=q.t1;
  if(q.roots == 2) (*roots)[1]=q.t2;
  {Stack->push<realarray*>(roots); return;}
}

#line 2037 "runtime.in"
// realarray* cubicroots(real a, real b, real c, real d);
void gen183(stack *Stack)
{
  real d = vm::pop<real>(Stack);
  real c = vm::pop<real>(Stack);
  real b = vm::pop<real>(Stack);
  real a = vm::pop<real>(Stack);
#line 2038 "runtime.in"
  cubicroots q(a,b,c,d);
  array *roots=new array(q.roots);
  if(q.roots >= 1) (*roots)[0]=q.t1;
  if(q.roots >= 2) (*roots)[1]=q.t2;
  if(q.roots == 3) (*roots)[2]=q.t3;
  {Stack->push<realarray*>(roots); return;}
}

  
// Transforms
#line 2049 "runtime.in"
// bool ==(transform a, transform b);
void gen184(stack *Stack)
{
  transform b = vm::pop<transform>(Stack);
  transform a = vm::pop<transform>(Stack);
#line 2050 "runtime.in"
  {Stack->push<bool>(a == b); return;}
}

#line 2055 "runtime.in"
// bool !=(transform a, transform b);
void gen185(stack *Stack)
{
  transform b = vm::pop<transform>(Stack);
  transform a = vm::pop<transform>(Stack);
#line 2056 "runtime.in"
  {Stack->push<bool>(a != b); return;}
}

#line 2060 "runtime.in"
// transform +(transform a, transform b);
void gen186(stack *Stack)
{
  transform b = vm::pop<transform>(Stack);
  transform a = vm::pop<transform>(Stack);
#line 2061 "runtime.in"
  {Stack->push<transform>(a+b); return;}
}

#line 2065 "runtime.in"
// transform *(transform a, transform b);
void gen187(stack *Stack)
{
  transform b = vm::pop<transform>(Stack);
  transform a = vm::pop<transform>(Stack);
#line 2066 "runtime.in"
  {Stack->push<transform>(a*b); return;}
}

#line 2070 "runtime.in"
// pair *(transform t, pair z);
void gen188(stack *Stack)
{
  pair z = vm::pop<pair>(Stack);
  transform t = vm::pop<transform>(Stack);
#line 2071 "runtime.in"
  {Stack->push<pair>(t*z); return;}
}

#line 2075 "runtime.in"
// path *(transform t, path g);
void gen189(stack *Stack)
{
  path g = vm::pop<path>(Stack);
  transform t = vm::pop<transform>(Stack);
#line 2076 "runtime.in"
  {Stack->push<path>(transformed(t,g)); return;}
}

#line 2080 "runtime.in"
// pen *(transform t, pen p);
void gen190(stack *Stack)
{
  pen p = vm::pop<pen>(Stack);
  transform t = vm::pop<transform>(Stack);
#line 2081 "runtime.in"
  {Stack->push<pen>(transformed(t,p)); return;}
}

#line 2085 "runtime.in"
// picture* *(transform t, picture *f);
void gen191(stack *Stack)
{
  picture * f = vm::pop<picture *>(Stack);
  transform t = vm::pop<transform>(Stack);
#line 2086 "runtime.in"
  {Stack->push<picture*>(transformed(t,f)); return;}
}

#line 2090 "runtime.in"
// transform ^(transform t, int n);
void gen192(stack *Stack)
{
  int n = vm::pop<int>(Stack);
  transform t = vm::pop<transform>(Stack);
#line 2091 "runtime.in"
  transform T;
  if(n < 0) {
    n=-n;
    t=inverse(t);
  }
  for(int i=0; i < n; i++) T=T*t;
  {Stack->push<transform>(T); return;}
}

#line 2101 "runtime.in"
void transformXPart(stack *Stack)
{
  transform t = vm::pop<transform>(Stack);
#line 2102 "runtime.in"
  {Stack->push<real>(t.getx()); return;}
}

#line 2106 "runtime.in"
void transformYPart(stack *Stack)
{
  transform t = vm::pop<transform>(Stack);
#line 2107 "runtime.in"
  {Stack->push<real>(t.gety()); return;}
}

#line 2111 "runtime.in"
void transformXXPart(stack *Stack)
{
  transform t = vm::pop<transform>(Stack);
#line 2112 "runtime.in"
  {Stack->push<real>(t.getxx()); return;}
}

#line 2116 "runtime.in"
void transformXYPart(stack *Stack)
{
  transform t = vm::pop<transform>(Stack);
#line 2117 "runtime.in"
  {Stack->push<real>(t.getxy()); return;}
}

#line 2121 "runtime.in"
void transformYXPart(stack *Stack)
{
  transform t = vm::pop<transform>(Stack);
#line 2122 "runtime.in"
  {Stack->push<real>(t.getyx()); return;}
}

#line 2126 "runtime.in"
void transformYYPart(stack *Stack)
{
  transform t = vm::pop<transform>(Stack);
#line 2127 "runtime.in"
  {Stack->push<real>(t.getyy()); return;}
}

#line 2131 "runtime.in"
void real6ToTransform(stack *Stack)
{
  real yy = vm::pop<real>(Stack);
  real yx = vm::pop<real>(Stack);
  real xy = vm::pop<real>(Stack);
  real xx = vm::pop<real>(Stack);
  real y = vm::pop<real>(Stack);
  real x = vm::pop<real>(Stack);
#line 2133 "runtime.in"
  {Stack->push<transform>(transform(x,y,xx,xy,yx,yy)); return;}
}

#line 2137 "runtime.in"
// transform shift(transform t);
void gen200(stack *Stack)
{
  transform t = vm::pop<transform>(Stack);
#line 2138 "runtime.in"
  {Stack->push<transform>(transform(t.getx(),t.gety(),0,0,0,0)); return;}
}

#line 2142 "runtime.in"
// transform shiftless(transform t);
void gen201(stack *Stack)
{
  transform t = vm::pop<transform>(Stack);
#line 2143 "runtime.in"
  {Stack->push<transform>(transform(0,0,t.getxx(),t.getxy(),t.getyx(),t.getyy())); return;}
}

#line 2147 "runtime.in"
// transform identity();
void transformIdentity(stack *Stack)
{
#line 2148 "runtime.in"
  {Stack->push<transform>(identity()); return;}
}

#line 2152 "runtime.in"
// transform inverse(transform t);
void gen203(stack *Stack)
{
  transform t = vm::pop<transform>(Stack);
#line 2153 "runtime.in"
  {Stack->push<transform>(inverse(t)); return;}
}

#line 2157 "runtime.in"
// transform shift(pair z);
void gen204(stack *Stack)
{
  pair z = vm::pop<pair>(Stack);
#line 2158 "runtime.in"
  {Stack->push<transform>(shift(z)); return;}
}

#line 2162 "runtime.in"
// transform shift(real x, real y);
void gen205(stack *Stack)
{
  real y = vm::pop<real>(Stack);
  real x = vm::pop<real>(Stack);
#line 2163 "runtime.in"
  {Stack->push<transform>(shift(pair(x,y))); return;}
}

#line 2167 "runtime.in"
// transform xscale(real x);
void gen206(stack *Stack)
{
  real x = vm::pop<real>(Stack);
#line 2168 "runtime.in"
  {Stack->push<transform>(xscale(x)); return;}
}

#line 2172 "runtime.in"
// transform yscale(real y);
void gen207(stack *Stack)
{
  real y = vm::pop<real>(Stack);
#line 2173 "runtime.in"
  {Stack->push<transform>(yscale(y)); return;}
}

#line 2177 "runtime.in"
// transform scale(real x);
void gen208(stack *Stack)
{
  real x = vm::pop<real>(Stack);
#line 2178 "runtime.in"
  {Stack->push<transform>(scale(x)); return;}
}

#line 2182 "runtime.in"
// transform slant(real s);
void gen209(stack *Stack)
{
  real s = vm::pop<real>(Stack);
#line 2183 "runtime.in"
  {Stack->push<transform>(slant(s)); return;}
}

#line 2187 "runtime.in"
// transform rotate(real angle, pair z=0);
void gen210(stack *Stack)
{
  pair z = vm::pop<pair>(Stack,0);
  real angle = vm::pop<real>(Stack);
#line 2188 "runtime.in"
  {Stack->push<transform>(rotatearound(z,radians(angle))); return;}
}

#line 2192 "runtime.in"
// transform reflect(pair a, pair b);
void gen211(stack *Stack)
{
  pair b = vm::pop<pair>(Stack);
  pair a = vm::pop<pair>(Stack);
#line 2193 "runtime.in"
  {Stack->push<transform>(reflectabout(a,b)); return;}
}


// Pair operations
#line 2199 "runtime.in"
void pairZero(stack *Stack)
{
#line 2200 "runtime.in"
  static pair zero;
  {Stack->push<pair>(zero); return;}
}

#line 2206 "runtime.in"
void realRealToPair(stack *Stack)
{
  real y = vm::pop<real>(Stack);
  real x = vm::pop<real>(Stack);
#line 2207 "runtime.in"
  {Stack->push<pair>(pair(x,y)); return;}
}

#line 2211 "runtime.in"
void pairNegate(stack *Stack)
{
  pair z = vm::pop<pair>(Stack);
#line 2212 "runtime.in"
  {Stack->push<pair>(-z); return;}
}

#line 2216 "runtime.in"
// real xpart(pair z);
void pairXPart(stack *Stack)
{
  pair z = vm::pop<pair>(Stack);
#line 2217 "runtime.in"
  {Stack->push<real>(z.getx()); return;}
}

#line 2221 "runtime.in"
// real ypart(pair z);
void pairYPart(stack *Stack)
{
  pair z = vm::pop<pair>(Stack);
#line 2222 "runtime.in"
  {Stack->push<real>(z.gety()); return;}
}

#line 2226 "runtime.in"
// real length(pair z);
void gen217(stack *Stack)
{
  pair z = vm::pop<pair>(Stack);
#line 2227 "runtime.in"
  {Stack->push<real>(z.length()); return;}
}

#line 2231 "runtime.in"
// real abs(pair z);
void gen218(stack *Stack)
{
  pair z = vm::pop<pair>(Stack);
#line 2232 "runtime.in"
  {Stack->push<real>(z.length()); return;}
}

// Return the angle of z in radians.
#line 2237 "runtime.in"
// real angle(pair z, bool warn=true);
void gen219(stack *Stack)
{
  bool warn = vm::pop<bool>(Stack,true);
  pair z = vm::pop<pair>(Stack);
#line 2238 "runtime.in"
  if(!warn && z.getx() == 0.0 && z.gety() == 0.0) {Stack->push<real>(0.0); return;}
  {Stack->push<real>(z.angle()); return;}
}

// Return the angle of z in degrees in the interval [0,360).
#line 2244 "runtime.in"
// real degrees(pair z, bool warn=true);
void gen220(stack *Stack)
{
  bool warn = vm::pop<bool>(Stack,true);
  pair z = vm::pop<pair>(Stack);
#line 2245 "runtime.in"
  if(!warn && z.getx() == 0.0 && z.gety() == 0.0) {Stack->push<real>(0.0); return;}
  {Stack->push<real>(principalBranch(degrees(z.angle()))); return;}
}

// Convert degrees to radians.
#line 2251 "runtime.in"
// real radians(real degrees);
void gen221(stack *Stack)
{
  real degrees = vm::pop<real>(Stack);
#line 2252 "runtime.in"
  {Stack->push<real>(radians(degrees)); return;}
}

// Convert radians to degrees.
#line 2257 "runtime.in"
// real degrees(real radians);
void gen222(stack *Stack)
{
  real radians = vm::pop<real>(Stack);
#line 2258 "runtime.in"
  {Stack->push<real>(degrees(radians)); return;}
}

// Convert radians to degrees in [0,360).
#line 2263 "runtime.in"
// real Degrees(real radians);
void gen223(stack *Stack)
{
  real radians = vm::pop<real>(Stack);
#line 2264 "runtime.in"
  {Stack->push<real>(principalBranch(degrees(radians))); return;}
}

#line 2268 "runtime.in"
// real Sin(real deg);
void gen224(stack *Stack)
{
  real deg = vm::pop<real>(Stack);
#line 2269 "runtime.in"
  {Stack->push<real>(sin(radians(deg))); return;}
}

#line 2273 "runtime.in"
// real Cos(real deg);
void gen225(stack *Stack)
{
  real deg = vm::pop<real>(Stack);
#line 2274 "runtime.in"
  {Stack->push<real>(cos(radians(deg))); return;}
}

#line 2278 "runtime.in"
// real Tan(real deg);
void gen226(stack *Stack)
{
  real deg = vm::pop<real>(Stack);
#line 2279 "runtime.in"
  {Stack->push<real>(tan(radians(deg))); return;}
}

#line 2283 "runtime.in"
// real aSin(real x);
void gen227(stack *Stack)
{
  real x = vm::pop<real>(Stack);
#line 2284 "runtime.in"
  {Stack->push<real>(degrees(asin(x))); return;}
}

#line 2288 "runtime.in"
// real aCos(real x);
void gen228(stack *Stack)
{
  real x = vm::pop<real>(Stack);
#line 2289 "runtime.in"
  {Stack->push<real>(degrees(acos(x))); return;}
}

#line 2293 "runtime.in"
// real aTan(real x);
void gen229(stack *Stack)
{
  real x = vm::pop<real>(Stack);
#line 2294 "runtime.in"
  {Stack->push<real>(degrees(atan(x))); return;}
}

#line 2298 "runtime.in"
// pair unit(pair z);
void gen230(stack *Stack)
{
  pair z = vm::pop<pair>(Stack);
#line 2299 "runtime.in"
  {Stack->push<pair>(unit(z)); return;}
}

#line 2303 "runtime.in"
// pair dir(real theta);
void gen231(stack *Stack)
{
  real theta = vm::pop<real>(Stack);
#line 2304 "runtime.in"
  {Stack->push<pair>(expi(radians(theta))); return;}
}

#line 2308 "runtime.in"
// pair expi(real theta);
void gen232(stack *Stack)
{
  real theta = vm::pop<real>(Stack);
#line 2309 "runtime.in"
  {Stack->push<pair>(expi(theta)); return;}
}

#line 2313 "runtime.in"
// pair conj(pair z);
void gen233(stack *Stack)
{
  pair z = vm::pop<pair>(Stack);
#line 2314 "runtime.in"
  {Stack->push<pair>(conj(z)); return;}
}

#line 2318 "runtime.in"
// pair realmult(pair z, pair w);
void gen234(stack *Stack)
{
  pair w = vm::pop<pair>(Stack);
  pair z = vm::pop<pair>(Stack);
#line 2319 "runtime.in"
  {Stack->push<pair>(pair (z.getx()*w.getx(),z.gety()*w.gety())); return;}
}

// To avoid confusion, a dot product requires explicit pair arguments.
#line 2324 "runtime.in"
// real dot(explicit pair z, explicit pair w);
void gen235(stack *Stack)
{
  pair w = vm::pop<pair>(Stack);
  pair z = vm::pop<pair>(Stack);
#line 2325 "runtime.in"
  {Stack->push<real>(z.getx()*w.getx()+z.gety()*w.gety()); return;}
}


// Triple operations
#line 2331 "runtime.in"
void tripleZero(stack *Stack)
{
#line 2332 "runtime.in"
  static triple zero;
  {Stack->push<triple>(zero); return;}
}

#line 2338 "runtime.in"
void realRealRealToTriple(stack *Stack)
{
  real z = vm::pop<real>(Stack);
  real y = vm::pop<real>(Stack);
  real x = vm::pop<real>(Stack);
#line 2339 "runtime.in"
  {Stack->push<triple>(triple(x,y,z)); return;}
}

#line 2343 "runtime.in"
// real xpart(triple v);
void tripleXPart(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
#line 2344 "runtime.in"
  {Stack->push<real>(v.getx()); return;}
}

#line 2348 "runtime.in"
// real ypart(triple v);
void tripleYPart(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
#line 2349 "runtime.in"
  {Stack->push<real>(v.gety()); return;}
}

#line 2353 "runtime.in"
// real zpart(triple v);
void tripleZPart(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
#line 2354 "runtime.in"
  {Stack->push<real>(v.getz()); return;}
}

#line 2358 "runtime.in"
// triple *(real x, triple v);
void gen241(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
  real x = vm::pop<real>(Stack);
#line 2359 "runtime.in"
  {Stack->push<triple>(x*v); return;}
}

#line 2363 "runtime.in"
// triple *(triple v, real x);
void gen242(stack *Stack)
{
  real x = vm::pop<real>(Stack);
  triple v = vm::pop<triple>(Stack);
#line 2364 "runtime.in"
  {Stack->push<triple>(x*v); return;}
}

#line 2368 "runtime.in"
// triple /(triple v, real x);
void gen243(stack *Stack)
{
  real x = vm::pop<real>(Stack);
  triple v = vm::pop<triple>(Stack);
#line 2369 "runtime.in"
  {Stack->push<triple>(v/x); return;}
}

#line 2373 "runtime.in"
// real length(triple v);
void gen244(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
#line 2374 "runtime.in"
  {Stack->push<real>(v.length()); return;}
}

#line 2378 "runtime.in"
// real abs(triple v);
void gen245(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
#line 2379 "runtime.in"
  {Stack->push<real>(v.length()); return;}
}

#line 2383 "runtime.in"
// real polar(triple v);
void gen246(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
#line 2384 "runtime.in"
  {Stack->push<real>(v.polar()); return;}
}

#line 2388 "runtime.in"
// real azimuth(triple v);
void gen247(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
#line 2389 "runtime.in"
  {Stack->push<real>(v.azimuth()); return;}
}

#line 2393 "runtime.in"
// real colatitude(triple v);
void gen248(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
#line 2394 "runtime.in"
  {Stack->push<real>(degrees(v.polar())); return;}
}

#line 2398 "runtime.in"
// real latitude(triple v);
void gen249(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
#line 2399 "runtime.in"
  {Stack->push<real>(90.0-degrees(v.polar())); return;}
}

// Return the longitude of v in [0,360).
#line 2404 "runtime.in"
// real longitude(triple v, bool warn=true);
void gen250(stack *Stack)
{
  bool warn = vm::pop<bool>(Stack,true);
  triple v = vm::pop<triple>(Stack);
#line 2405 "runtime.in"
  if(!warn && v.getx() == 0.0 && v.gety() == 0.0) {Stack->push<real>(0.0); return;}
  {Stack->push<real>(principalBranch(degrees(v.azimuth()))); return;}
}

#line 2410 "runtime.in"
// triple unit(triple v);
void gen251(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
#line 2411 "runtime.in"
  {Stack->push<triple>(unit(v)); return;}
}

#line 2415 "runtime.in"
// real dot(triple u, triple v);
void gen252(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
  triple u = vm::pop<triple>(Stack);
#line 2416 "runtime.in"
  {Stack->push<real>(u.getx()*v.getx()+u.gety()*v.gety()+u.getz()*v.getz()); return;}
}

#line 2420 "runtime.in"
// triple cross(triple u, triple v);
void gen253(stack *Stack)
{
  triple v = vm::pop<triple>(Stack);
  triple u = vm::pop<triple>(Stack);
#line 2421 "runtime.in"
  {Stack->push<triple>(triple(u.gety()*v.getz()-u.getz()*v.gety(),
		u.getz()*v.getx()-u.getx()*v.getz(),
		u.getx()*v.gety()-v.getx()*u.gety())); return;}
}

#line 2427 "runtime.in"
// triple expi(real theta, real phi);
void gen254(stack *Stack)
{
  real phi = vm::pop<real>(Stack);
  real theta = vm::pop<real>(Stack);
#line 2428 "runtime.in"
  {Stack->push<triple>(expi(theta,phi)); return;}
  real sintheta=sin(theta);
  {Stack->push<triple>(triple(sintheta*cos(phi),sintheta*sin(phi),cos(theta))); return;}
}

#line 2434 "runtime.in"
// triple dir(real theta, real phi);
void gen255(stack *Stack)
{
  real phi = vm::pop<real>(Stack);
  real theta = vm::pop<real>(Stack);
#line 2435 "runtime.in"
  {Stack->push<triple>(expi(radians(theta),radians(phi))); return;}
}

#line 2439 "runtime.in"
// real cubiclength(triple z0, triple z0p, triple z1m, triple z1, real goal);
void gen256(stack *Stack)
{
  real goal = vm::pop<real>(Stack);
  triple z1 = vm::pop<triple>(Stack);
  triple z1m = vm::pop<triple>(Stack);
  triple z0p = vm::pop<triple>(Stack);
  triple z0 = vm::pop<triple>(Stack);
#line 2440 "runtime.in"
  {Stack->push<real>(cubiclength(z0,z0p,z1m,z1,goal)); return;}
}

#line 2444 "runtime.in"
// pair intersect(triplearray* pre1, triplearray* point1, triplearray* post1,               triplearray* pre2, triplearray* point2, triplearray* post2,	       real fuzz);
void gen257(stack *Stack)
{
  real fuzz = vm::pop<real>(Stack);
  triplearray* post2 = vm::pop<triplearray*>(Stack);
  triplearray* point2 = vm::pop<triplearray*>(Stack);
  triplearray* pre2 = vm::pop<triplearray*>(Stack);
  triplearray* post1 = vm::pop<triplearray*>(Stack);
  triplearray* point1 = vm::pop<triplearray*>(Stack);
  triplearray* pre1 = vm::pop<triplearray*>(Stack);
#line 2447 "runtime.in"
  size_t size1=checkArrays(pre1,point1);
  size_t size2=checkArrays(pre2,point2);
      
  if(checkArray(post1) != size1 || checkArray(post2) != size2)
    vm::error(arraymismatch);
  
  int single1=(size1 == 1);
  int single2=(size2 == 1);
  
  size_t Size1=size1+single1;
  size_t Size2=size2+single2;
  
  node *n1=new node[Size1];
  node *n2=new node[Size2];
      
  for(size_t i=0; i < size1; ++i)
    n1[i]=node(read<triple>(pre1,i),read<triple>(point1,i),
	       read<triple>(post1,i));

  for(size_t i=0; i < size2; ++i)
    n2[i]=node(read<triple>(pre2,i),read<triple>(point2,i),
	       read<triple>(post2,i));

  if(single1) n1[1]=n1[0];
  if(single2) n2[1]=n2[0];
  
  {Stack->push<pair>(intersect((int) Size1-1,(int) Size2-1,n1,n2,fuzz)); return;}
}


// System routines
#line 2479 "runtime.in"
// string VERSION();
void gen258(stack *Stack)
{
#line 2480 "runtime.in"
  {Stack->push<string>(VERSION); return;}
}

#line 2485 "runtime.in"
// void atexit(callable *f);
void gen259(stack *Stack)
{
  callable * f = vm::pop<callable *>(Stack);
#line 2486 "runtime.in"
  atExitFunction=f;
}

#line 2490 "runtime.in"
// callable* atexit();
void gen260(stack *Stack)
{
#line 2491 "runtime.in"
  {Stack->push<callable*>(atExitFunction); return;}
}

#line 2495 "runtime.in"
// void atbreakpoint(callableBp *f);
void gen261(stack *Stack)
{
  callableBp * f = vm::pop<callableBp *>(Stack);
#line 2496 "runtime.in"
  atBreakpointFunction=f;
}

#line 2500 "runtime.in"
// void breakpoint(runnable *s=NULL);
void gen262(stack *Stack)
{
  runnable * s = vm::pop<runnable *>(Stack,NULL);
#line 2501 "runtime.in"
  breakpoint(Stack,s);
}

#line 2505 "runtime.in"
// string locatefile(string file);
void gen263(stack *Stack)
{
  string file = vm::pop<string>(Stack);
#line 2506 "runtime.in"
  {Stack->push<string>(locateFile(file)); return;}
}

#line 2510 "runtime.in"
// void stop(string file, int line, runnable *s=NULL);
void gen264(stack *Stack)
{
  runnable * s = vm::pop<runnable *>(Stack,NULL);
  int line = vm::pop<int>(Stack);
  string file = vm::pop<string>(Stack);
#line 2511 "runtime.in"
  file=locateFile(file);
  clear(file,line);
  cout << "setting breakpoint at " << file << ": " << line << endl;
  bplist.push_back(bpinfo(file,line,s));
}

#line 2518 "runtime.in"
// void breakpoints();
void gen265(stack *)
{
#line 2519 "runtime.in"
  for(mem::list<bpinfo>::iterator p=bplist.begin(); p != bplist.end(); ++p)
    cout << p->f.name() << ": " << p->f.line() << endl;
}

#line 2524 "runtime.in"
// void clear(string file, int line);
void gen266(stack *Stack)
{
  int line = vm::pop<int>(Stack);
  string file = vm::pop<string>(Stack);
#line 2525 "runtime.in"
  file=locateFile(file);
  clear(file,line,true);
}

#line 2530 "runtime.in"
// void clear();
void gen267(stack *)
{
#line 2531 "runtime.in"
  bplist.clear();
}

// Merge output files  
#line 2536 "runtime.in"
// int merge(stringarray *files, string *args, string *format);
void gen268(stack *Stack)
{
  string * format = vm::pop<string *>(Stack);
  string * args = vm::pop<string *>(Stack);
  stringarray * files = vm::pop<stringarray *>(Stack);
#line 2537 "runtime.in"
  int ret;
  
  size_t size=checkArray(files);
  
  if(!checkFormatString(*format)) return;
  
  ostringstream cmd,remove;
  cmd << "'" << getSetting<string>("convert") << "' "+*args;
  
  for(size_t i=0; i < size; i++) 
    cmd << " " << read<string>(files,i);
  
  string name=buildname(outname(),format->c_str());
  cmd << " '" << name << "'";
  ret=System(cmd,2,true,"convert");
  
  if(ret == 0)
    if(verbose > 0) cout << "Wrote " << name << endl;
  
  if(!getSetting<bool>("keep"))
    for(size_t i=0; i < size; i++) 
      unlink(read<string>(files,i).c_str());
    
  if(ret == 0 && view()) {
    ostringstream cmd;
    cmd << "'" << getSetting<string>("animate") << "' '" << name << "'";
    System(cmd,0,false,"animate","your animated GIF viewer");
  }
  
  {Stack->push<int>(ret); return;}
}


// Array operations

// Create an empty array.
#line 2574 "runtime.in"
void emptyArray(stack *Stack)
{
#line 2575 "runtime.in"
  {Stack->push<array*>(new array(0)); return;}
}

// Create a new array (technically a vector).
// This array will be multidimensional.  First the number of dimensions
// is popped off the stack, followed by each dimension in reverse order.
// The array itself is technically a one dimensional array of one
// dimension arrays and so on.
#line 2584 "runtime.in"
void newDeepArray(stack *Stack)
{
  int depth = vm::pop<int>(Stack);
#line 2585 "runtime.in"
  assert(depth > 0);

  int *dims = new int[depth];

  for (int index = depth-1; index >= 0; index--)
    dims[index] = pop<int>(Stack);

  array *a=deepArray(depth, dims);
  delete[] dims;
  {Stack->push<array*>(a); return;}
}

// Creates an array with elements already specified.  First, the number
// of elements is popped off the stack, followed by each element in
// reverse order.
#line 2601 "runtime.in"
void newInitializedArray(stack *Stack)
{
  int n = vm::pop<int>(Stack);
#line 2602 "runtime.in"
  assert(n >= 0);

  array *a = new array(n);

  for (int index = n-1; index >= 0; index--)
    (*a)[index] = pop(Stack);

  {Stack->push<array*>(a); return;}
}

// Similar to newInitializedArray, but after the n elements, append another
// array to it.
#line 2615 "runtime.in"
void newAppendedArray(stack *Stack)
{
  int n = vm::pop<int>(Stack);
  array* tail = vm::pop<array*>(Stack);
#line 2616 "runtime.in"
  assert(n >= 0);

  array *a = new array(n);

  for (int index = n-1; index >= 0; index--)
    (*a)[index] = pop(Stack);
  
  copy(tail->begin(), tail->end(), back_inserter(*a));

  {Stack->push<array*>(a); return;}
}

// Read an element from an array. Checks for initialization & bounds.
#line 2630 "runtime.in"
void arrayRead(stack *Stack)
{
  int n = vm::pop<int>(Stack);
  array * a = vm::pop<array *>(Stack);
#line 2631 "runtime.in"
  item& i=arrayRead(a,n);
  if (i.empty()) {
    ostringstream buf;
    buf << "read uninitialized value from array at index " << n;
    error(buf);
  }
  {Stack->push(i); return;}
}

// Read an element from an array of arrays. Check bounds and initialize
// as necessary.
#line 2643 "runtime.in"
void arrayArrayRead(stack *Stack)
{
  int n = vm::pop<int>(Stack);
  array * a = vm::pop<array *>(Stack);
#line 2644 "runtime.in"
  item& i=arrayRead(a,n);
  if (i.empty()) i=new array(0);
  {Stack->push(i); return;}
}

// Write an element to an array.  Increase size if necessary.
#line 2651 "runtime.in"
void arrayWrite(stack *Stack)
{
  int n = vm::pop<int>(Stack);
  array * a = vm::pop<array *>(Stack);
  item value = vm::pop(Stack);
#line 2652 "runtime.in"
  size_t len=checkArray(a);
  bool cyclic=a->cyclic();
  if(cyclic && len > 0) n=imod(n,len);
  else {
    if(cyclic) outOfBounds("writing cyclic",len,n);
    if(n < 0) outOfBounds("writing",len,n);
    if(len <= (size_t) n)
      a->resize(n+1);
  }
  (*a)[n] = value;
  {Stack->push(value); return;}
}

// Returns the length of an array.
#line 2667 "runtime.in"
void arrayLength(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
#line 2668 "runtime.in"
  {Stack->push<int>((int) checkArray(a)); return;}
}

// Return the cyclic flag for an array.
#line 2673 "runtime.in"
void arrayCyclicFlag(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
#line 2674 "runtime.in"
  checkArray(a);
  {Stack->push<bool>(a->cyclic()); return;}
}

// The helper function for the cyclic method that sets the cyclic flag.
#line 2680 "runtime.in"
void arrayCyclicHelper(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
  bool b = vm::pop<bool>(Stack);
#line 2681 "runtime.in"
  checkArray(a);
  a->cyclic(b);
}

// Set the cyclic flag for an array.
#line 2687 "runtime.in"
void arrayCyclic(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
#line 2688 "runtime.in"
  {Stack->push<callable*>(new thunk(new bfunc(arrayCyclicHelper),a)); return;}
}

// The helper function for the push method that does the actual operation.
#line 2693 "runtime.in"
void arrayPushHelper(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
  item x = vm::pop(Stack);
#line 2694 "runtime.in"
  checkArray(a);
  a->push(x);
  {Stack->push(x); return;}
}

// Returns the push method for an array.
#line 2701 "runtime.in"
void arrayPush(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
#line 2702 "runtime.in"
  {Stack->push<callable*>(new thunk(new bfunc(arrayPushHelper),a)); return;}
}

// The helper function for the append method that appends b to a.
#line 2707 "runtime.in"
void arrayAppendHelper(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
  array * b = vm::pop<array *>(Stack);
#line 2708 "runtime.in"
  checkArray(a);
  size_t size=checkArray(b);
  for(size_t i=0; i < size; i++)
    a->push((*b)[i]);
}

// Returns the append method for an array.
#line 2716 "runtime.in"
void arrayAppend(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
#line 2717 "runtime.in"
  {Stack->push<callable*>(new thunk(new bfunc(arrayAppendHelper),a)); return;}
}

// The helper function for the pop method.
#line 2722 "runtime.in"
void arrayPopHelper(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
#line 2723 "runtime.in"
  size_t asize=checkArray(a);
  if(asize == 0) 
    error("cannot pop element from empty array");
  {Stack->push(a->pop()); return;}
}

// Returns the pop method for an array.
#line 2731 "runtime.in"
void arrayPop(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
#line 2732 "runtime.in"
  {Stack->push<callable*>(new thunk(new bfunc(arrayPopHelper),a)); return;}
}

// The helper function for the insert method.
#line 2737 "runtime.in"
void arrayInsertHelper(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
  item x = vm::pop(Stack);
  int i = vm::pop<int>(Stack);
#line 2738 "runtime.in"
  size_t asize=checkArray(a);
  if(a->cyclic() && asize > 0) i=imod(i,asize);
  if(i < 0 || i > (int) asize) 
    outOfBounds("inserting",asize,i);
  (*a).insert((*a).begin()+i,x);
  {Stack->push(x); return;}
}

// Returns the insert method for an array.
#line 2748 "runtime.in"
void arrayInsert(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
#line 2749 "runtime.in"
  {Stack->push<callable*>(new thunk(new bfunc(arrayInsertHelper),a)); return;}
}

// The helper function for the insert method.
#line 2754 "runtime.in"
void arrayDeleteHelper(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
  int i = vm::pop<int>(Stack);
#line 2755 "runtime.in"
  size_t asize=checkArray(a);
  if(a->cyclic() && asize > 0) i=imod(i,asize);
  if(i < 0 || i >= (int) asize) 
    outOfBounds("deleting",asize,i);
  item val=(*a)[i];
  (*a).erase((*a).begin()+i);
  {Stack->push(val); return;}
}

// Returns the delete method for an array.
#line 2766 "runtime.in"
void arrayDelete(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
#line 2767 "runtime.in"
  {Stack->push<callable*>(new thunk(new bfunc(arrayDeleteHelper),a)); return;}
}

#line 2771 "runtime.in"
void arrayAlias(stack *Stack)
{
  array * b = vm::pop<array *>(Stack);
  array * a = vm::pop<array *>(Stack);
#line 2772 "runtime.in"
  {Stack->push<bool>(a==b); return;}
}

// Return array formed by indexing array a with elements of integer array b
#line 2777 "runtime.in"
void arrayIntArray(stack *Stack)
{
  array * b = vm::pop<array *>(Stack);
  array * a = vm::pop<array *>(Stack);
#line 2778 "runtime.in"
  size_t asize=checkArray(a);
  size_t bsize=checkArray(b);
  array *r=new array(bsize);
  bool cyclic=a->cyclic();
  for(size_t i=0; i < bsize; i++) {
    int index=read<int>(b,i);
    if(cyclic && asize > 0) index=imod(index,asize);
    else
      if(index < 0 || index >= (int) asize)
	outOfBounds("reading",asize,index);
    (*r)[i]=(*a)[index];
  }
  {Stack->push<array*>(r); return;}
}

// returns the complement of the integer array a in {1,2,...,n},
// so that b[complement(a,b.length)] yields the complement of b[a].
#line 2796 "runtime.in"
// intarray* complement(intarray *a, int n);
void gen292(stack *Stack)
{
  int n = vm::pop<int>(Stack);
  intarray * a = vm::pop<intarray *>(Stack);
#line 2797 "runtime.in"
  size_t asize=checkArray(a);
  array *r=new array(0);
  bool *keep=new bool(n);
  for(int i=0; i < n; ++i) keep[i]=true;
  for(size_t i=0; i < asize; ++i) {
    int j=read<int>(a,i);
    if(j >= 0 && j < n) keep[j]=false;
  }
  for(int i=0; i < n; i++)
    if(keep[i]) r->push(i);
  
  delete[] keep;
  {Stack->push<intarray*>(r); return;}
}

// Generate the sequence {f_i : i=0,1,...n-1} given a function f and integer n
#line 2814 "runtime.in"
void arraySequence(stack *Stack)
{
  int n = vm::pop<int>(Stack);
  callable * f = vm::pop<callable *>(Stack);
#line 2815 "runtime.in"
  if(n < 0) n=0;
  array *a=new array(n);
  for(int i=0; i < n; ++i) {
    Stack->push(i);
    f->call(Stack);
    (*a)[i]=pop(Stack);
  }
  {Stack->push<intarray*>(a); return;}
}

// Return the array {0,1,...n-1}
#line 2827 "runtime.in"
// intarray* sequence(int n);
void gen294(stack *Stack)
{
  int n = vm::pop<int>(Stack);
#line 2828 "runtime.in"
  if(n < 0) n=0;
  array *a=new array(n);
  for(int i=0; i < n; ++i) {
    (*a)[i]=i;
  }
  {Stack->push<intarray*>(a); return;}
}

// Apply a function to each element of an array
#line 2838 "runtime.in"
void arrayFunction(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
  callable * f = vm::pop<callable *>(Stack);
#line 2839 "runtime.in"
  size_t size=checkArray(a);
  array *b=new array(size);
  for(size_t i=0; i < size; ++i) {
    Stack->push((*a)[i]);
    f->call(Stack);
    (*b)[i]=pop(Stack);
  }
  {Stack->push<array*>(b); return;}
}

#line 2850 "runtime.in"
// bool all(boolarray *a);
void gen296(stack *Stack)
{
  boolarray * a = vm::pop<boolarray *>(Stack);
#line 2851 "runtime.in"
  size_t size=checkArray(a);
  bool c=true;
  for(size_t i=0; i < size; i++)
    if(!get<bool>((*a)[i])) {c=false; break;}
  {Stack->push<bool>(c); return;}
}

#line 2859 "runtime.in"
// boolarray* !(boolarray* a);
void gen297(stack *Stack)
{
  boolarray* a = vm::pop<boolarray*>(Stack);
#line 2860 "runtime.in"
  size_t size=checkArray(a);
  array *c=new array(size);
  for(size_t i=0; i < size; i++)
    (*c)[i]=!read<bool>(a,i);
  {Stack->push<boolarray*>(c); return;}
}

#line 2868 "runtime.in"
// int sum(boolarray *a);
void gen298(stack *Stack)
{
  boolarray * a = vm::pop<boolarray *>(Stack);
#line 2869 "runtime.in"
  size_t size=checkArray(a);
  int sum=0;
  for(size_t i=0; i < size; i++)
    sum += read<bool>(a,i) ? 1 : 0;
  {Stack->push<int>(sum); return;}
}

#line 2877 "runtime.in"
void arrayCopy(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
#line 2878 "runtime.in"
  {Stack->push<array*>(copyArray(a)); return;}
}

#line 2882 "runtime.in"
void arrayConcat(stack *Stack)
{
  array * b = vm::pop<array *>(Stack);
  array * a = vm::pop<array *>(Stack);
#line 2883 "runtime.in"
  size_t asize=checkArray(a);
  size_t bsize=checkArray(b);
  array *c=new array(asize+bsize);
  for(size_t i=0; i < asize; i++) 
    (*c)[i]=(*a)[i];
  for(size_t i=0; i < bsize; i++, asize++) 
    (*c)[asize]=(*b)[i];
  {Stack->push<array*>(c); return;}
}

#line 2894 "runtime.in"
void array2Copy(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
#line 2895 "runtime.in"
  {Stack->push<array*>(copyArray2(a)); return;}
}

#line 2899 "runtime.in"
void array3Copy(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
#line 2900 "runtime.in"
  {Stack->push<array*>(copyArray3(a)); return;}
}

#line 2904 "runtime.in"
void array2Transpose(stack *Stack)
{
  array * a = vm::pop<array *>(Stack);
#line 2905 "runtime.in"
  size_t asize=checkArray(a);
  array *c=new array(0);
  for(size_t i=0; i < asize; i++) {
    size_t ip=i+1;
    array *ai=read<array*>(a,i);
    size_t aisize=checkArray(ai);
    size_t csize=c->size();
    if(csize < aisize) {
      c->resize(aisize);
      for(size_t j=csize; j < aisize; j++) {
	(*c)[j]=new array(ip);
      }
    }
    for(size_t j=0; j < aisize; j++) {
    array *cj=read<array*>(c,j);
    if(cj->size() < ip) cj->resize(ip);
    (*cj)[i]=(*ai)[j];
    }
  }
  {Stack->push<array*>(c); return;}
}

// a is a rectangular 3D array; perm is an int array indicating the type of
// permutation  (021 or 120, etc; original is 012).
// Transpose by sending respective members to the permutated locations:
// return the array obtained by putting a[i][j][k] into position perm{ijk}. 
#line 2932 "runtime.in"
void array3Transpose(stack *Stack)
{
  array * perm = vm::pop<array *>(Stack);
  array * a = vm::pop<array *>(Stack);
#line 2933 "runtime.in"
  const size_t DIM=3;

  size_t *Perm=new size_t[DIM];
  if(checkArray(perm) != DIM) {
    ostringstream buf;
    buf << "permutation array must have length " << DIM;
    error(buf);
  }
  
  for(size_t i=0; i < DIM; ++i) {
    int p=read<int>(perm,i);
    // check if input is bad
    if(p < 0 || (size_t) p >= DIM) {
      ostringstream buf;
      buf << "permutation index out of range: " << p;
      error(buf);
    }
    Perm[i]=(size_t) p;
  }
  
  size_t* size=new size_t[DIM];
  
  for(size_t i=0; i < DIM; ++i) size[i]=DIM;
  for(size_t i=0; i < DIM; ++i) size[Perm[i]]=Perm[i];
  for(size_t i=0; i < DIM; ++i)
    if(size[i] == DIM) error("permutation indices must be distinct");
  
  static const char *rectangular=
    "3D transpose implemented for rectangular matrices only";
  
  size_t isize=size[0]=checkArray(a);
  array *a0=read<array*>(a,0);
  size[1]=a0->size();
  array *a00=read<array*>(a0,0);
  size[2]=a00->size();
  for(size_t i=0; i < isize; i++) {
    array *ai=read<array*>(a,i);
    size_t jsize=checkArray(ai);
    if(jsize != size[1]) error(rectangular);
    for(size_t j=0; j < jsize; j++) {
      array *aij=read<array*>(ai,j);
      if(checkArray(aij) != size[2]) error(rectangular);
    }
  }
  
  size_t Perm0=Perm[0];
  size_t Perm1=Perm[1];
  size_t Perm2=Perm[2];
  
  size_t sizep0=size[Perm0];
  array *c=new array(sizep0);
  for(size_t i=0; i < sizep0; ++i) {
    size_t sizep1=size[Perm1];
    array *ci=new array(sizep1);
    (*c)[i]=ci;
    for(size_t j=0; j < sizep1; ++j) {
      size_t sizep2=size[Perm2];
      array *cij=new array(sizep2);
      (*ci)[j]=cij;
    }
  }
  
  size_t* i=new size_t[DIM];

  for(i[0]=0; i[0] < size[0]; ++i[0]) {
    array *a0=read<array*>(a,i[0]);
    for(i[1]=0; i[1] < size[1]; ++i[1]) {
      array *a1=read<array*>(a0,i[1]);
      for(i[2]=0; i[2] < size[2]; ++i[2]) {
	array *c0=read<array*>(c,i[Perm0]);
	array *c1=read<array*>(c0,i[Perm1]);
	(*c1)[i[Perm2]]=read<real>(a1,i[2]);
      }
    }
  }
  
  delete [] i;  
  delete [] size;  

  {Stack->push<array*>(c); return;}
}

// In a boolean array, find the index of the nth true value or -1 if not found
// If n is negative, search backwards.
#line 3018 "runtime.in"
// int find(boolarray *a, int n=1);
void gen305(stack *Stack)
{
  int n = vm::pop<int>(Stack,1);
  boolarray * a = vm::pop<boolarray *>(Stack);
#line 3019 "runtime.in"
  
  size_t size=checkArray(a);
  int j=-1;
  if(n > 0)
    for(size_t i=0; i < size; i++)
      if(read<bool>(a,i)) {
	n--; if(n == 0) {j=(int) i; break;}
      }
  if(n < 0)
    for(size_t i=size; i > 0;)
      if(read<bool>(a,--i)) {
	n++; if(n == 0) {j=(int) i; break;}
      }
  {Stack->push<int>(j); return;}
}

// construct vector obtained by replacing those elements of b for which the
// corresponding elements of a are false by the corresponding element of c.
#line 3038 "runtime.in"
void arrayConditional(stack *Stack)
{
  array * c = vm::pop<array *>(Stack);
  array * b = vm::pop<array *>(Stack);
  array * a = vm::pop<array *>(Stack);
#line 3039 "runtime.in"
  size_t size=checkArray(a);
  array *r=new array(size);
  if(b && c) {
    checkArrays(a,b);
    checkArrays(b,c);
    for(size_t i=0; i < size; i++)
      (*r)[i]=read<bool>(a,i) ? (*b)[i] : (*c)[i];
  } else {
    r->clear();
    if(b) {
      checkArrays(a,b);
      for(size_t i=0; i < size; i++)
        if(read<bool>(a,i)) r->push((*b)[i]);
    } else if(c) {
      checkArrays(a,c);
      for(size_t i=0; i < size; i++)
        if(!read<bool>(a,i)) r->push((*c)[i]);
    }
  }
  {Stack->push<array*>(r); return;}
}

// Return the inverse of an n x n matrix a using Gauss-Jordan elimination.
#line 3063 "runtime.in"
// realarray2* inverse(realarray2 *a);
void gen307(stack *Stack)
{
  realarray2 * a = vm::pop<realarray2 *>(Stack);
#line 3064 "runtime.in"
  a=copyArray2(a);
  size_t n=a->size();
  checkSquare(a);
  
  inverseAllocate(n);
  
  for(size_t i=0; i < n; i++)
    pivot[i]=0;
 
  size_t col=0, row=0;
  // This is the main loop over the columns to be reduced.
  for(size_t i=0; i < n; i++) {
    real big=0.0;
    // This is the outer loop of the search for a pivot element.
    for(size_t j=0; j < n; j++) {
      array *aj=read<array*>(a,j);
      if(pivot[j] != 1) {
	for(size_t k=0; k < n; k++) {
	  if(pivot[k] == 0) {
	    real temp=fabs(read<real>(aj,k));
	    if(temp >= big) {
	      big=temp;
	      row=j;
	      col=k;
	    }
	  } else if(pivot[k] > 1) {
	    inverseDeallocate();
	    error(singular);
	  }
	}
      }
    }
    ++(pivot[col]);
    
    // Interchange rows, if needed, to put the pivot element on the diagonal.
    array *acol=read<array*>(a,col);
    if(row != col) {
      array *arow=read<array*>(a,row);
      for(size_t l=0; l < n; l++) {
	real temp=read<real>(arow,l);
	(*arow)[l]=read<real>(acol,l);
	(*acol)[l]=temp;
      }
    }
    
    Row[i]=row; 
    Col[i]=col;

    // Divide the pivot row by the pivot element.
    real denom=read<real>(acol,col);
    if(denom == 0.0) {
      inverseDeallocate();
      error(singular);
    }
    real pivinv=1.0/denom;
    (*acol)[col]=1.0;
    for(size_t l=0; l < n; l++) 
      (*acol)[l]=read<real>(acol,l)*pivinv;
    
    // Reduce all rows except for the pivoted one.
    for(size_t k=0; k < n; k++) {
      if(k != col) { 
	array *ak=read<array*>(a,k);
	real akcol=read<real>(ak,col);
	(*ak)[col]=0.0;
	for(size_t l=0; l < n; l++)
	  (*ak)[l]=read<real>(ak,l)-read<real>(acol,l)*akcol;
      }
    }
  }
  
  // Unscramble the inverse matrix in view of the column interchanges.
  for(size_t l=n; l > 0;) {
    l--;
    size_t r=Row[l];
    size_t c=Col[l];
    if(r != c) {
      for(size_t k=0; k < n; k++) {
	array *ak=read<array*>(a,k);
	real temp=read<real>(ak,r);
	(*ak)[r]=read<real>(ak,c);
	(*ak)[c]=temp;
      }
    }
  }
  inverseDeallocate();
  {Stack->push<realarray2*>(a); return;}
}

// Solve the linear equation ax=b by LU decomposition, returning the
// solution x, where a is an n x n matrix and b is an array of length n.
#line 3156 "runtime.in"
// realarray* solve(realarray2 *a, realarray *b);
void gen308(stack *Stack)
{
  realarray * b = vm::pop<realarray *>(Stack);
  realarray2 * a = vm::pop<realarray2 *>(Stack);
#line 3157 "runtime.in"
  real **A=copyArray2C(a);
  size_t n=a->size();
  
  array *x=new array(n);
  if(n == 0) {Stack->push<realarray*>(x); return;}
  
  real *B=copyArrayC(b);
  size_t m=b->size();
  if(m != n) error(incommensurate);  
  
  size_t *index=new size_t[n];
  LUdecompose(A,n,index);

  for(size_t i=0; i < n; ++i) {
    size_t ip=index[i];
    real sum=B[ip];
    B[ip]=B[i];
    real *Ai=A[i];
    for(size_t j=0; j < i; ++j)
      sum -= Ai[j]*B[j];
    B[i]=sum;
  }
  
  for(size_t i=n; i > 0;) {
    --i;
    real sum=B[i];
    real *Ai=A[i];
    for(size_t j=i+1; j < n; ++j)
      sum -= Ai[j]*B[j];
    B[i]=sum/Ai[i];
  }
  
  for(size_t i=0; i < n; ++i)
    (*x)[i]=B[i];

  delete[] index;
  {Stack->push<realarray*>(x); return;}
}

// Solve the linear equation ax=b by LU decomposition, returning the
// solution x, where a is an n x n matrix and b is an n x m matrix.
#line 3199 "runtime.in"
// realarray2* solve(realarray2 *a, realarray2 *b);
void gen309(stack *Stack)
{
  realarray2 * b = vm::pop<realarray2 *>(Stack);
  realarray2 * a = vm::pop<realarray2 *>(Stack);
#line 3200 "runtime.in"
  real **A=copyArray2C(a);
  size_t n=a->size();
  
  array *x=new array(n);
  if(n == 0) {Stack->push<realarray2*>(x); return;}
  
  real **B=copyArray2C(b,false);
  if(b->size() != n) error(incommensurate);  
  size_t m=read<array*>(b,0)->size();
  
  size_t *index=new size_t[n];
  LUdecompose(A,n,index);

  for(size_t i=0; i < n; ++i) {
    real *Ai=A[i];
    real *Bi=B[i];
    real *Bip=B[index[i]];
    for(size_t k=0; k < m; ++k) {
      real sum=Bip[k];
      Bip[k]=Bi[k];
      for(size_t j=0; j < i; ++j)
	sum -= Ai[j]*B[j][k];
      Bi[k]=sum;
    }
  }
  
  for(size_t i=n; i > 0;) {
    --i;
    real *Ai=A[i];
    real *Bi=B[i];
    for(size_t k=0; k < m; ++k) {
      real sum=Bi[k];
      for(size_t j=i+1; j < n; ++j)
	sum -= Ai[j]*B[j][k];
      Bi[k]=sum/Ai[i];
    }
  }
  
  for(size_t i=0; i < n; ++i) {
    real *Bi=B[i];
    array *xi=new array(m);
    (*x)[i]=xi;
    for(size_t j=0; j < m; ++j)
      (*xi)[j]=Bi[j];
  }
    
  delete[] index;
  {Stack->push<realarray2*>(x); return;}
}

// Compute the determinant of an n x n matrix.
#line 3252 "runtime.in"
// real determinant(realarray2 *a);
void gen310(stack *Stack)
{
  realarray2 * a = vm::pop<realarray2 *>(Stack);
#line 3253 "runtime.in"
  real **A=copyArray2C(a);
  size_t n=a->size();
  
  size_t *index=new size_t[n];
  real det=LUdecompose(A,n,index,false);
  for(size_t i=0; i < n; ++i) det *= A[i][i];
  delete[] index;
  {Stack->push<real>(det); return;}
}

#line 3264 "runtime.in"
// realarray* *(realarray2 *a, realarray *b);
void gen311(stack *Stack)
{
  realarray * b = vm::pop<realarray *>(Stack);
  realarray2 * a = vm::pop<realarray2 *>(Stack);
#line 3265 "runtime.in"
  size_t n=checkArray(a);
  size_t bsize=checkArray(b);
  if(bsize != n) error(incommensurate);  
  array *c=new array(n);
  for(size_t i=0; i < n; ++i) {
    array *ai=read<array*>(a,i);
    real sum=0.0;
    for(size_t j=0; j < n; ++j) {
      sum += read<real>(ai,j)*read<real>(b,j);
    }
    (*c)[i]=sum;
  }
  {Stack->push<realarray*>(c); return;}
}

// Solve the problem L\inv f, where f is an n vector and L is the n x n matrix
//
// [ b[0] c[0]           a[0]   ]
// [ a[1] b[1] c[1]             ]
// [      a[2] b[2] c[2]        ]
// [                ...         ]
// [ c[n-1]       a[n-1] b[n-1] ]
#line 3288 "runtime.in"
// realarray* tridiagonal(realarray *a, realarray *b, realarray *c, realarray *f);
void gen312(stack *Stack)
{
  realarray * f = vm::pop<realarray *>(Stack);
  realarray * c = vm::pop<realarray *>(Stack);
  realarray * b = vm::pop<realarray *>(Stack);
  realarray * a = vm::pop<realarray *>(Stack);
#line 3289 "runtime.in"
  size_t n=checkArrays(a,b);
  if(n != checkArray(c) || n != checkArray(f))
    vm::error(arraymismatch);
  
  array *up=new array(n);
  array& u=*up;

  if(n == 0) {Stack->push<realarray*>(up); return;}
  
  // Special case: zero Dirichlet boundary conditions
  if(read<real>(a,0) == 0.0 && read<real>(c,n-1) == 0.0) {
    real temp=read<real>(b,0);
    if(temp == 0.0) dividebyzero();
    temp=1.0/temp;
    
    real *work=new real[n];
    u[0]=read<real>(f,0)*temp;
    work[0]=-read<real>(c,0)*temp;
	
    for(size_t i=1; i < n; i++) {
      real temp=(read<real>(b,i)+read<real>(a,i)*work[i-1]);
      if(temp == 0.0) {delete[] work; dividebyzero();}
      temp=1.0/temp;
      u[i]=(read<real>(f,i)-read<real>(a,i)*read<real>(u,i-1))*temp;
      work[i]=-read<real>(c,i)*temp;
    }

    for(size_t i=n-1; i >= 1; i--)
      u[i-1]=read<real>(u,i-1)+work[i-1]*read<real>(u,i);
    
    delete[] work;
    {Stack->push<realarray*>(up); return;}
  }
  
  real binv=read<real>(b,0);
  if(binv == 0.0) dividebyzero();
  binv=1.0/binv;
  
  if(n == 1) {u[0]=read<real>(f,0)*binv; {Stack->push<realarray*>(up); return;}}
  if(n == 2) {
    real factor=(read<real>(b,0)*read<real>(b,1)-
		   read<real>(a,0)*read<real>(c,1));
    if(factor== 0.0) dividebyzero();
    factor=1.0/factor;
    real temp=(read<real>(b,0)*read<real>(f,1)-
	  read<real>(c,1)*read<real>(f,0))*factor;
    u[0]=(read<real>(b,1)*read<real>(f,0)-
	  read<real>(a,0)*read<real>(f,1))*factor;
    u[1]=temp;
    {Stack->push<realarray*>(up); return;}
  }
	
  real *gamma=new real[n-2];
  real *delta=new real[n-2];
  
  gamma[0]=read<real>(c,0)*binv;
  delta[0]=read<real>(a,0)*binv;
  u[0]=read<real>(f,0)*binv;
  real beta=read<real>(c,n-1);
  real fn=read<real>(f,n-1)-beta*read<real>(u,0);
  real alpha=read<real>(b,n-1)-beta*delta[0];

  for(size_t i=1; i <= n-3; i++) {
    real alphainv=read<real>(b,i)-read<real>(a,i)*gamma[i-1];
    if(alphainv == 0.0) {delete[] gamma; delete[] delta; dividebyzero();}
    alphainv=1.0/alphainv;
    beta *= -gamma[i-1];
    gamma[i]=read<real>(c,i)*alphainv;
    u[i]=(read<real>(f,i)-read<real>(a,i)*read<real>(u,i-1))*alphainv;
    fn -= beta*read<real>(u,i);
    delta[i]=-read<real>(a,i)*delta[i-1]*alphainv;
    alpha -= beta*delta[i];
  }
	
  real alphainv=read<real>(b,n-2)-read<real>(a,n-2)*gamma[n-3];
  if(alphainv == 0.0) {delete[] gamma; delete[] delta; dividebyzero();}
  alphainv=1.0/alphainv;
  u[n-2]=(read<real>(f,n-2)-read<real>(a,n-2)*read<real>(u,n-3))
    *alphainv;
  beta=read<real>(a,n-1)-beta*gamma[n-3];
  real dnm1=(read<real>(c,n-2)-read<real>(a,n-2)*delta[n-3])*alphainv;
  real temp=alpha-beta*dnm1;
  if(temp == 0.0) {delete[] gamma; delete[] delta; dividebyzero();}
  u[n-1]=temp=(fn-beta*read<real>(u,n-2))/temp;
  u[n-2]=read<real>(u,n-2)-dnm1*temp;
	
  for(size_t i=n-2; i >= 1; i--)
    u[i-1]=read<real>(u,i-1)-gamma[i-1]*read<real>(u,i)-delta[i-1]*temp;
  
  delete[] gamma;
  delete[] delta;
  
  {Stack->push<realarray*>(up); return;}
}

// Compute the fast Fourier transform of a pair array
#line 3386 "runtime.in"
void pairArrayFFT(stack *Stack)
{
  int sign = vm::pop<int>(Stack,1);
  pairarray * a = vm::pop<pairarray *>(Stack);
#line 3387 "runtime.in"
  unsigned n=(unsigned) checkArray(a);
#ifdef HAVE_LIBFFTW3
  array *c=new array(n);
  if(n) {
    Complex *f=FFTWComplex(n);
    fft1d Forward(n,sign,f);
  
    for(size_t i=0; i < n; i++) {
      pair z=read<pair>(a,i);
      f[i]=Complex(z.getx(),z.gety());
    }
    Forward.fft(f);
  
    for(size_t i=0; i < n; i++) {
      Complex z=f[i];
      (*c)[i]=pair(z.real(),z.imag());
    }
    FFTWdelete(f);
  }
#else
  array *c=new array(0*n*sign); // Avoid unused variable warning messages
#endif //  HAVE_LIBFFTW3
  {Stack->push<pairarray*>(c); return;}
}

// Call Gilles Dumoulin's port of Paul Bourke's triangulation code.
#line 3414 "runtime.in"
// intarray2* triangulate(pairarray *z);
void gen314(stack *Stack)
{
  pairarray * z = vm::pop<pairarray *>(Stack);
#line 3415 "runtime.in"
  size_t nv=checkArray(z);

  XYZ *pxyz=new XYZ[nv+3];
  ITRIANGLE *V=new ITRIANGLE[3*nv];
  
  for(size_t i=0; i < nv; ++i) {
    pair w=read<pair>(z,i);
    pxyz[i].x=w.getx();
    pxyz[i].y=w.gety();
    pxyz[i].i=(int) i;
  }
  
  int ntri;
  Triangulate((int) nv,pxyz,V,ntri,true,false);

  size_t nt=(size_t) ntri;
  array *t=new array(nt);
  for(size_t i=0; i < nt; ++i) {
    array *ti=new array(3);
    (*t)[i]=ti;
    ITRIANGLE *Vi=V+i;
    (*ti)[0]=pxyz[Vi->p1].i;
    (*ti)[1]=pxyz[Vi->p2].i;
    (*ti)[2]=pxyz[Vi->p3].i;
  }
   
  delete[] V;
  delete[] pxyz;
  
  {Stack->push<intarray2*>(t); return;}      
}


// File operations
#line 3450 "runtime.in"
// bool ==(file *a, file *b);
void gen315(stack *Stack)
{
  file * b = vm::pop<file *>(Stack);
  file * a = vm::pop<file *>(Stack);
#line 3451 "runtime.in"
  {Stack->push<bool>(a == b); return;}
}

#line 3456 "runtime.in"
// bool !=(file *a, file *b);
void gen316(stack *Stack)
{
  file * b = vm::pop<file *>(Stack);
  file * a = vm::pop<file *>(Stack);
#line 3457 "runtime.in"
  {Stack->push<bool>(a != b); return;}
}

#line 3461 "runtime.in"
void standardOut(stack *Stack)
{
#line 3462 "runtime.in"
  {Stack->push<file*>(&camp::Stdout); return;}
}

#line 3466 "runtime.in"
void nullFile(stack *Stack)
{
#line 3467 "runtime.in"
  {Stack->push<file*>(&camp::nullfile); return;}
}

#line 3471 "runtime.in"
// file* input(string name, bool check=true, string comment=commentchar);
void gen319(stack *Stack)
{
  string comment = vm::pop<string>(Stack,commentchar);
  bool check = vm::pop<bool>(Stack,true);
  string name = vm::pop<string>(Stack);
#line 3472 "runtime.in"
  char c=comment == "" ? (char) 0 : comment[0];
  file *f=new ifile(name,check,c);
  f->open();
  {Stack->push<file*>(f); return;}
}

#line 3479 "runtime.in"
// file* output(string name, bool append=false);
void gen320(stack *Stack)
{
  bool append = vm::pop<bool>(Stack,false);
  string name = vm::pop<string>(Stack);
#line 3480 "runtime.in"
  file *f=new ofile(name,append);
  f->open();
  {Stack->push<file*>(f); return;}
}

#line 3486 "runtime.in"
// file* xinput(string name, bool check=true);
void gen321(stack *Stack)
{
  bool check = vm::pop<bool>(Stack,true);
  string name = vm::pop<string>(Stack);
#line 3487 "runtime.in"
#ifdef HAVE_RPC_RPC_H
  file *f=new ixfile(name,check);
  {Stack->push<file*>(f); return;}
#else  
  ostringstream buf;
  buf << name << ": XDR read support not enabled";
  error(buf);
  if(check) return; // Never reached; suppress unused variable warning
#endif
}

#line 3499 "runtime.in"
// file* xoutput(string name, bool append=false);
void gen322(stack *Stack)
{
  bool append = vm::pop<bool>(Stack,false);
  string name = vm::pop<string>(Stack);
#line 3500 "runtime.in"
#ifdef HAVE_RPC_RPC_H
  file *f=new oxfile(name,append);
  {Stack->push<file*>(f); return;}
#else  
  ostringstream buf;
  buf << name << ": XDR write support not enabled";
  error(buf);
  if(append) return; // Never reached; suppress unused variable warning
#endif
}

#line 3512 "runtime.in"
// bool eof(file *File);
void gen323(stack *Stack)
{
  file * File = vm::pop<file *>(Stack);
#line 3513 "runtime.in"
  {Stack->push<bool>(File->eof()); return;}
}

#line 3517 "runtime.in"
// bool eol(file *File);
void gen324(stack *Stack)
{
  file * File = vm::pop<file *>(Stack);
#line 3518 "runtime.in"
  {Stack->push<bool>(File->eol()); return;}
}

#line 3522 "runtime.in"
// bool error(file *File);
void gen325(stack *Stack)
{
  file * File = vm::pop<file *>(Stack);
#line 3523 "runtime.in"
  {Stack->push<bool>(File->error()); return;}
}

#line 3527 "runtime.in"
// void clear(file *File);
void gen326(stack *Stack)
{
  file * File = vm::pop<file *>(Stack);
#line 3528 "runtime.in"
  File->clear();
}

#line 3532 "runtime.in"
// void close(file *File);
void gen327(stack *Stack)
{
  file * File = vm::pop<file *>(Stack);
#line 3533 "runtime.in"
  File->close();
}

#line 3537 "runtime.in"
// void precision(file *File, int digits);
void gen328(stack *Stack)
{
  int digits = vm::pop<int>(Stack);
  file * File = vm::pop<file *>(Stack);
#line 3538 "runtime.in"
  File->precision(digits);
}

#line 3542 "runtime.in"
// void flush(file *File);
void gen329(stack *Stack)
{
  file * File = vm::pop<file *>(Stack);
#line 3543 "runtime.in"
   File->flush();
}

#line 3547 "runtime.in"
// string getc(file *File);
void gen330(stack *Stack)
{
  file * File = vm::pop<file *>(Stack);
#line 3548 "runtime.in"
  char c;
  if(File->isOpen()) File->read(c);
  static char str[1];
  str[0]=c;
  {Stack->push<string>(string(str)); return;}
}

#line 3556 "runtime.in"
// int tell(file *File);
void gen331(stack *Stack)
{
  file * File = vm::pop<file *>(Stack);
#line 3557 "runtime.in"
  {Stack->push<int>((int) File->tell()); return;}
}

#line 3561 "runtime.in"
// void seek(file *File, int pos);
void gen332(stack *Stack)
{
  int pos = vm::pop<int>(Stack);
  file * File = vm::pop<file *>(Stack);
#line 3562 "runtime.in"
  File->seek(pos);
}

// Set file dimensions
#line 3567 "runtime.in"
// file* dimension(file *File, int nx);
void gen333(stack *Stack)
{
  int nx = vm::pop<int>(Stack);
  file * File = vm::pop<file *>(Stack);
#line 3568 "runtime.in"
  File->dimension(nx);
  {Stack->push<file*>(File); return;}
}

#line 3573 "runtime.in"
// file* dimension(file *File, int nx, int ny);
void gen334(stack *Stack)
{
  int ny = vm::pop<int>(Stack);
  int nx = vm::pop<int>(Stack);
  file * File = vm::pop<file *>(Stack);
#line 3574 "runtime.in"
  File->dimension(nx,ny);
  {Stack->push<file*>(File); return;}
}

#line 3579 "runtime.in"
// file* dimension(file *File, int nx, int ny, int nz);
void gen335(stack *Stack)
{
  int nz = vm::pop<int>(Stack);
  int ny = vm::pop<int>(Stack);
  int nx = vm::pop<int>(Stack);
  file * File = vm::pop<file *>(Stack);
#line 3580 "runtime.in"
  File->dimension(nx,ny,nz);
  {Stack->push<file*>(File); return;}
}

// Set file to read comma-separated values
#line 3586 "runtime.in"
// file* csv(file *File, bool b=true);
void gen336(stack *Stack)
{
  bool b = vm::pop<bool>(Stack,true);
  file * File = vm::pop<file *>(Stack);
#line 3587 "runtime.in"
  File->CSVMode(b);
  {Stack->push<file*>(File); return;}
}

// Set file to read arrays in line-at-a-time mode
#line 3593 "runtime.in"
// file* line(file *File, bool b=true);
void gen337(stack *Stack)
{
  bool b = vm::pop<bool>(Stack,true);
  file * File = vm::pop<file *>(Stack);
#line 3594 "runtime.in"
  File->LineMode(b);
  {Stack->push<file*>(File); return;}
}

// Set file to read/write single-precision XDR values.
#line 3600 "runtime.in"
// file* single(file *File, bool b=true);
void gen338(stack *Stack)
{
  bool b = vm::pop<bool>(Stack,true);
  file * File = vm::pop<file *>(Stack);
#line 3601 "runtime.in"
  File->SingleMode(b);
  {Stack->push<file*>(File); return;}
}

// Set file to read an array1 (1 int size followed by a 1d array)
#line 3607 "runtime.in"
// file* read1(file *File);
void gen339(stack *Stack)
{
  file * File = vm::pop<file *>(Stack);
#line 3608 "runtime.in"
  File->dimension(-2);
  {Stack->push<file*>(File); return;}
}

// Set file to read an array2 (2 int sizes followed by a 2d array)
#line 3614 "runtime.in"
// file* read2(file *File);
void gen340(stack *Stack)
{
  file * File = vm::pop<file *>(Stack);
#line 3615 "runtime.in"
  File->dimension(-2,-2);
  {Stack->push<file*>(File); return;}
}

// Set file to read an array3 (3 int sizes followed by a 3d array)
#line 3621 "runtime.in"
// file* read3(file *File);
void gen341(stack *Stack)
{
  file * File = vm::pop<file *>(Stack);
#line 3622 "runtime.in"
  File->dimension(-2,-2,-2);
  {Stack->push<file*>(File); return;}
}

// Prompt for a string using the GNU readline library and a local history.
// On exit, save this local history under the name historyfilename(history),
// unless history begins with an underscore character.
#line 3630 "runtime.in"
// string readline(string prompt=emptystring, string history=emptystring,		string initial=emptystring, bool tabcompletion=false);
void gen342(stack *Stack)
{
  bool tabcompletion = vm::pop<bool>(Stack,false);
  string initial = vm::pop<string>(Stack,emptystring);
  string history = vm::pop<string>(Stack,emptystring);
  string prompt = vm::pop<string>(Stack,emptystring);
#line 3632 "runtime.in"
#if defined(HAVE_LIBREADLINE) && defined(HAVE_LIBCURSES)
  init_readline(tabcompletion);
  
  store_history(&history_save);
  bool newhistory=historyMap.find(history) == historyMap.end();
  HISTORY_STATE& History=historyMap[history];
  history_set_history_state(&History);
  if(history[0] != nosave && newhistory)
    read_history(historyfilename(history).c_str());
  
  static char *line_read=NULL;
  /* Return the memory to the free pool
     if the buffer has already been allocated. */
  if(line_read) {
    free(line_read);
    line_read=NULL;
  }
     
  HIST_ENTRY *last=history_get(history_length);
  const char *Default=last ? last->line : initial.c_str();
  int size=snprintf(NULL,0,prompt.c_str(),Default)+1;
  if(size < 1) size=255; // Workaround for non-C99 compliant systems.
  char *buf=new char[size];
  snprintf(buf,size,prompt.c_str(),Default);
  
  /* Get a line from the user. */
  line_read=readline(buf);
  delete[] buf;
     
  if(line_read) {
  /* If the line has any text in it, save it on the history. */
    if(*line_read) add_history(line_read);
  } else cout << endl;
  
  store_history(&History);
  history_set_history_state(&history_save);

  {Stack->push<string>(line_read ? string(*line_read ? line_read : Default) : emptystring); return;}
#else
  Stdout.write(prompt);
  static ifile Stdin("");
  string s;
  Stdin.read(s);
  if(tabcompletion) {Stack->push<string>(s); return;} // Avoid unused variable warning message.
  {Stack->push<string>(s); return;}
#endif
}

} // namespace run

namespace trans {

void gen_base_venv(venv &ve)
{
#line 729 "runtime.in"
  addFunc(ve, run::gen8, primBoolean(), "!", formal(primBoolean(), "b", false, false));
#line 783 "runtime.in"
  addFunc(ve, run::gen17, primBoolean(), "empty", formal(primPicture(), "f", false, false));
#line 788 "runtime.in"
  addFunc(ve, run::gen18, primPair(), "max", formal(primPicture(), "f", false, false));
#line 793 "runtime.in"
  addFunc(ve, run::gen19, primPair(), "min", formal(primPicture(), "f", false, false));
#line 798 "runtime.in"
  addFunc(ve, run::gen20, primVoid(), "label", formal(primPicture(), "f", false, false), formal(primString(), "s", false, false), formal(primString(), "size", false, false), formal(primTransform(), "t", false, false), formal(primPair(), "position", false, false), formal(primPair(), "align", false, false), formal(primPen(), "p", false, false));
#line 804 "runtime.in"
  addFunc(ve, run::gen21, primBoolean(), "labels", formal(primPicture(), "f", false, false));
#line 809 "runtime.in"
  addFunc(ve, run::gen22, primVoid(), "_draw", formal(primPicture(), "f", false, false), formal(primPath(), "g", false, false), formal(primPen(), "p", false, false));
#line 814 "runtime.in"
  addFunc(ve, run::gen23, primVoid(), "fill", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primPen(), "p", false, false));
#line 819 "runtime.in"
  addFunc(ve, run::gen24, primVoid(), "latticeshade", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primPen(), "fillrule", false, false), formal(penArray2()  , "p", false, false));
#line 824 "runtime.in"
  addFunc(ve, run::gen25, primVoid(), "axialshade", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primPen(), "pena", false, false), formal(primPair(), "a", false, false), formal(primPen(), "penb", false, false), formal(primPair(), "b", false, false));
#line 829 "runtime.in"
  addFunc(ve, run::gen26, primVoid(), "radialshade", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primPen(), "pena", false, false), formal(primPair(), "a", false, false), formal(primReal(), "ra", false, false), formal(primPen(), "penb", false, false), formal(primPair(), "b", false, false), formal(primReal(), "rb", false, false));
#line 835 "runtime.in"
  addFunc(ve, run::gen27, primVoid(), "gouraudshade", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primPen(), "fillrule", false, false), formal(penArray()  , "p", false, false), formal(pairArray(), "z", false, false), formal(intArray(), "edges", false, false));
#line 844 "runtime.in"
  addFunc(ve, run::gen28, primVoid(), "clip", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primPen(), "p", false, false));
#line 851 "runtime.in"
  addFunc(ve, run::gen29, primVoid(), "beginclip", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primPen(), "p", false, false));
#line 856 "runtime.in"
  addFunc(ve, run::gen30, primVoid(), "endclip", formal(primPicture(), "f", false, false));
#line 861 "runtime.in"
  addFunc(ve, run::gen31, primVoid(), "gsave", formal(primPicture(), "f", false, false));
#line 866 "runtime.in"
  addFunc(ve, run::gen32, primVoid(), "grestore", formal(primPicture(), "f", false, false));
#line 871 "runtime.in"
  addFunc(ve, run::gen33, primVoid(), "begingroup", formal(primPicture(), "f", false, false));
#line 876 "runtime.in"
  addFunc(ve, run::gen34, primVoid(), "endgroup", formal(primPicture(), "f", false, false));
#line 881 "runtime.in"
  addFunc(ve, run::gen35, primVoid(), "add", formal(primPicture(), "dest", false, false), formal(primPicture(), "src", false, false));
#line 886 "runtime.in"
  addFunc(ve, run::gen36, primVoid(), "prepend", formal(primPicture(), "dest", false, false), formal(primPicture(), "src", false, false));
#line 891 "runtime.in"
  addFunc(ve, run::gen37, primVoid(), "postscript", formal(primPicture(), "f", false, false), formal(primString() , "s", false, false));
#line 896 "runtime.in"
  addFunc(ve, run::gen38, primVoid(), "tex", formal(primPicture(), "f", false, false), formal(primString() , "s", false, false));
#line 901 "runtime.in"
  addFunc(ve, run::gen39, primVoid(), "texpreamble", formal(primString() , "s", false, false));
#line 908 "runtime.in"
  addFunc(ve, run::gen40, primVoid(), "texreset");
#line 913 "runtime.in"
  addFunc(ve, run::gen41, primVoid(), "layer", formal(primPicture(), "f", false, false));
#line 918 "runtime.in"
  addFunc(ve, run::gen42, primVoid(), "_image", formal(primPicture(), "f", false, false), formal(realArray2(), "data", false, false), formal(primPair(), "initial", false, false), formal(primPair(), "final", false, false), formal(penArray()  , "palette", true, false), formal(primTransform(), "t", true, false));
#line 925 "runtime.in"
  addFunc(ve, run::gen43, primVoid(), "_image", formal(primPicture(), "f", false, false), formal(penArray2()  , "data", false, false), formal(primPair(), "initial", false, false), formal(primPair(), "final", false, false), formal(primTransform(), "t", true, false));
#line 931 "runtime.in"
  addFunc(ve, run::gen44, primString() , "nativeformat");
#line 936 "runtime.in"
  addFunc(ve, run::gen45, primBoolean(), "latex");
#line 941 "runtime.in"
  addFunc(ve, run::gen46, primBoolean(), "pdf");
#line 946 "runtime.in"
  addFunc(ve, run::gen47, primVoid(), "shipout", formal(primString() , "prefix", true, false), formal(primPicture(), "f", false, false), formal(primPicture(), "preamble", true, false), formal(primString() , "format", true, false), formal(primBoolean(), "wait", true, false), formal(primBoolean(), "view", true, false), formal(transformArray(), "guitransform", false, false), formal(boolArray(), "guidelete", false, false));
#line 1016 "runtime.in"
  addFunc(ve, run::gen49, primBoolean(), "==", formal(primPen(), "a", false, false), formal(primPen(), "b", false, false));
#line 1021 "runtime.in"
  addFunc(ve, run::gen50, primBoolean(), "!=", formal(primPen(), "a", false, false), formal(primPen(), "b", false, false));
#line 1026 "runtime.in"
  addFunc(ve, run::gen51, primPen(), "+", formal(primPen(), "a", false, false), formal(primPen(), "b", false, false));
#line 1031 "runtime.in"
  addFunc(ve, run::gen52, primPen(), "*", formal(primReal(), "a", false, false), formal(primPen(), "b", false, false));
#line 1036 "runtime.in"
  addFunc(ve, run::gen53, primPen(), "*", formal(primPen(), "a", false, false), formal(primReal(), "b", false, false));
#line 1041 "runtime.in"
  addFunc(ve, run::gen54, primPair(), "max", formal(primPen(), "p", false, false));
#line 1046 "runtime.in"
  addFunc(ve, run::gen55, primPair(), "min", formal(primPen(), "p", false, false));
#line 1051 "runtime.in"
  addFunc(ve, run::gen56, primVoid(), "resetdefaultpen");
#line 1057 "runtime.in"
  addFunc(ve, run::gen57, primVoid(), "defaultpen", formal(primPen(), "p", false, false));
#line 1062 "runtime.in"
  addFunc(ve, run::gen58, primPen(), "defaultpen");
#line 1067 "runtime.in"
  addFunc(ve, run::gen59, primPen(), "invisible");
#line 1072 "runtime.in"
  addFunc(ve, run::gen60, primPen(), "gray", formal(primPen(), "p", false, false));
#line 1079 "runtime.in"
  addFunc(ve, run::gen61, primPen(), "rgb", formal(primPen(), "p", false, false));
#line 1086 "runtime.in"
  addFunc(ve, run::gen62, primPen(), "rgb", formal(primReal(), "r", false, false), formal(primReal(), "g", false, false), formal(primReal(), "b", false, false));
#line 1091 "runtime.in"
  addFunc(ve, run::gen63, primPen(), "cmyk", formal(primReal(), "c", false, false), formal(primReal(), "m", false, false), formal(primReal(), "y", false, false), formal(primReal(), "k", false, false));
#line 1096 "runtime.in"
  addFunc(ve, run::gen64, primPen(), "gray", formal(primReal(), "gray", false, false));
#line 1101 "runtime.in"
  addFunc(ve, run::gen65, realArray(), "colors", formal(primPen(), "p", false, false));
#line 1129 "runtime.in"
  addFunc(ve, run::gen66, primPen(), "pattern", formal(primString(), "s", false, false));
#line 1134 "runtime.in"
  addFunc(ve, run::gen67, primString() , "pattern", formal(primPen(), "p", false, false));
#line 1139 "runtime.in"
  addFunc(ve, run::gen68, primPen(), "fillrule", formal(primInt(), "n", false, false));
#line 1144 "runtime.in"
  addFunc(ve, run::gen69, primInt(), "fillrule", formal(primPen(), "p", false, false));
#line 1149 "runtime.in"
  addFunc(ve, run::gen70, primPen(), "opacity", formal(primReal(), "opacity", true, false), formal(primString(), "blend", true, false));
#line 1159 "runtime.in"
  addFunc(ve, run::gen71, primReal(), "opacity", formal(primPen(), "p", false, false));
#line 1164 "runtime.in"
  addFunc(ve, run::gen72, primString() , "blend", formal(primPen(), "p", false, false));
#line 1169 "runtime.in"
  addFunc(ve, run::gen73, primPen(), "linetype", formal(primString(), "s", false, false), formal(primReal(), "offset", true, false), formal(primBoolean(), "scale", true, false), formal(primBoolean(), "adjust", true, false));
#line 1174 "runtime.in"
  addFunc(ve, run::gen74, primString() , "linetype", formal(primPen(), "p", false, false));
#line 1179 "runtime.in"
  addFunc(ve, run::gen75, primReal(), "offset", formal(primPen(), "p", false, false));
#line 1184 "runtime.in"
  addFunc(ve, run::gen76, primBoolean(), "scale", formal(primPen(), "p", false, false));
#line 1189 "runtime.in"
  addFunc(ve, run::gen77, primBoolean(), "adjust", formal(primPen(), "p", false, false));
#line 1194 "runtime.in"
  addFunc(ve, run::gen78, primPen(), "linecap", formal(primInt(), "n", false, false));
#line 1199 "runtime.in"
  addFunc(ve, run::gen79, primInt(), "linecap", formal(primPen(), "p", false, false));
#line 1204 "runtime.in"
  addFunc(ve, run::gen80, primPen(), "linejoin", formal(primInt(), "n", false, false));
#line 1209 "runtime.in"
  addFunc(ve, run::gen81, primInt(), "linejoin", formal(primPen(), "p", false, false));
#line 1214 "runtime.in"
  addFunc(ve, run::gen82, primPen(), "linewidth", formal(primReal(), "x", false, false));
#line 1219 "runtime.in"
  addFunc(ve, run::gen83, primReal(), "linewidth", formal(primPen(), "p", false, false));
#line 1224 "runtime.in"
  addFunc(ve, run::gen84, primPen(), "fontcommand", formal(primString(), "s", false, false));
#line 1229 "runtime.in"
  addFunc(ve, run::gen85, primString() , "font", formal(primPen(), "p", false, false));
#line 1234 "runtime.in"
  addFunc(ve, run::gen86, primPen(), "fontsize", formal(primReal(), "size", false, false), formal(primReal(), "lineskip", false, false));
#line 1240 "runtime.in"
  addFunc(ve, run::gen87, primReal(), "fontsize", formal(primPen(), "p", false, false));
#line 1245 "runtime.in"
  addFunc(ve, run::gen88, primReal(), "lineskip", formal(primPen(), "p", false, false));
#line 1250 "runtime.in"
  addFunc(ve, run::gen89, primPen(), "overwrite", formal(primInt(), "n", false, false));
#line 1256 "runtime.in"
  addFunc(ve, run::gen90, primInt(), "overwrite", formal(primPen(), "p", false, false));
#line 1261 "runtime.in"
  addFunc(ve, run::gen91, primPen(), "basealign", formal(primInt(), "n", false, false));
#line 1266 "runtime.in"
  addFunc(ve, run::gen92, primInt(), "basealign", formal(primPen(), "p", false, false));
#line 1271 "runtime.in"
  addFunc(ve, run::gen93, primPath(), "nib", formal(primPen(), "p", false, false));
#line 1278 "runtime.in"
  addFunc(ve, run::gen94, primPen(), "makepen", formal(primPath(), "p", false, false));
#line 1283 "runtime.in"
  addFunc(ve, run::gen95, primPen(), "colorless", formal(primPen(), "p", false, false));
#line 1289 "runtime.in"
  addFunc(ve, run::gen96, primBoolean(), "interactive");
#line 1296 "runtime.in"
  addFunc(ve, run::gen97, primVoid(), "uptodate", formal(primBoolean(), "b", false, false));
#line 1301 "runtime.in"
  addFunc(ve, run::gen98, primBoolean(), "uptodate");
#line 1306 "runtime.in"
  addFunc(ve, run::gen99, primInt(), "system", formal(primString(), "s", false, false));
#line 1315 "runtime.in"
  addFunc(ve, run::gen100, primVoid(), "abort", formal(primString() , "s", true, false));
#line 1321 "runtime.in"
  addFunc(ve, run::gen101, primVoid(), "assert", formal(primBoolean(), "b", false, false), formal(primString() , "s", true, false));
#line 1332 "runtime.in"
  addFunc(ve, run::gen102, primVoid(), "_eval", formal(primString(), "s", false, false), formal(primBoolean(), "embedded", false, false));
#line 1347 "runtime.in"
  addFunc(ve, run::gen103, primVoid(), "_eval", formal(primCode(), "s", false, false), formal(primBoolean(), "embedded", false, false));
#line 1365 "runtime.in"
  addFunc(ve, run::gen104, primString() , "location");
#line 1371 "runtime.in"
  addFunc(ve, run::gen105, primVoid(), "gui", formal(primReal(), "x", true, false));
#line 1376 "runtime.in"
  addFunc(ve, run::gen106, primBoolean(), "deconstruct");
#line 1381 "runtime.in"
  addFunc(ve, run::gen107, primVoid() , "readGUI");
#line 1413 "runtime.in"
  addFunc(ve, run::gen109, primString() , "cd", formal(primString(), "d", false, false));
#line 1427 "runtime.in"
  addFunc(ve, run::gen110, primVoid(), "list", formal(primString(), "s", false, false), formal(primBoolean(), "imports", true, false));
#line 1445 "runtime.in"
  addFunc(ve, run::gen112, primPair(), "point", formal(primPath(), "p", false, false), formal(primInt(), "n", false, false));
#line 1450 "runtime.in"
  addFunc(ve, run::gen113, primPair(), "point", formal(primPath(), "p", false, false), formal(primReal(), "t", false, false));
#line 1455 "runtime.in"
  addFunc(ve, run::gen114, primPair(), "precontrol", formal(primPath(), "p", false, false), formal(primInt(), "n", false, false));
#line 1460 "runtime.in"
  addFunc(ve, run::gen115, primPair(), "precontrol", formal(primPath(), "p", false, false), formal(primReal(), "t", false, false));
#line 1465 "runtime.in"
  addFunc(ve, run::gen116, primPair(), "postcontrol", formal(primPath(), "p", false, false), formal(primInt(), "n", false, false));
#line 1470 "runtime.in"
  addFunc(ve, run::gen117, primPair(), "postcontrol", formal(primPath(), "p", false, false), formal(primReal(), "t", false, false));
#line 1475 "runtime.in"
  addFunc(ve, run::gen118, primPair(), "dir", formal(primPath(), "p", false, false), formal(primInt(), "n", false, false));
#line 1480 "runtime.in"
  addFunc(ve, run::gen119, primPair(), "dir", formal(primPath(), "p", false, false), formal(primReal(), "t", false, false));
#line 1485 "runtime.in"
  addFunc(ve, run::gen120, primPath(), "reverse", formal(primPath(), "p", false, false));
#line 1490 "runtime.in"
  addFunc(ve, run::gen121, primPath(), "subpath", formal(primPath(), "p", false, false), formal(primInt(), "b", false, false), formal(primInt(), "e", false, false));
#line 1495 "runtime.in"
  addFunc(ve, run::gen122, primPath(), "subpath", formal(primPath(), "p", false, false), formal(primReal(), "b", false, false), formal(primReal(), "e", false, false));
#line 1500 "runtime.in"
  addFunc(ve, run::gen123, primInt(), "length", formal(primPath(), "p", false, false));
#line 1505 "runtime.in"
  addFunc(ve, run::gen124, primBoolean(), "cyclic", formal(primPath(), "p", false, false));
#line 1510 "runtime.in"
  addFunc(ve, run::gen125, primBoolean(), "straight", formal(primPath(), "p", false, false), formal(primInt(), "i", false, false));
#line 1515 "runtime.in"
  addFunc(ve, run::gen126, primBoolean(), "piecewisestraight", formal(primPath(), "p", false, false));
#line 1523 "runtime.in"
  addFunc(ve, run::gen127, primReal(), "arclength", formal(primPath(), "p", false, false));
#line 1528 "runtime.in"
  addFunc(ve, run::gen128, primReal(), "arctime", formal(primPath(), "p", false, false), formal(primReal(), "dval", false, false));
#line 1533 "runtime.in"
  addFunc(ve, run::gen129, primReal(), "dirtime", formal(primPath(), "p", false, false), formal(primPair(), "z", false, false));
#line 1538 "runtime.in"
  addFunc(ve, run::gen130, primPair(), "intersect", formal(primPath(), "x", false, false), formal(primPath(), "y", false, false), formal(primReal(), "fuzz", true, false));
#line 1543 "runtime.in"
  addFunc(ve, run::gen131, primInt(), "size", formal(primPath(), "p", false, false));
#line 1548 "runtime.in"
  addFunc(ve, run::gen132, primPath(), "&", formal(primPath(), "p", false, false), formal(primPath(), "q", false, false));
#line 1553 "runtime.in"
  addFunc(ve, run::gen133, primPair(), "min", formal(primPath(), "p", false, false));
#line 1558 "runtime.in"
  addFunc(ve, run::gen134, primPair(), "max", formal(primPath(), "p", false, false));
#line 1563 "runtime.in"
  addFunc(ve, run::gen135, primReal(), "relativedistance", formal(primReal(), "theta", false, false), formal(primReal(), "phi", false, false), formal(primReal(), "t", false, false), formal(primBoolean(), "atleast", false, false));
#line 1568 "runtime.in"
  addFunc(ve, run::gen136, primBoolean(), "inside", formal(pathArray()  , "g", false, false), formal(primPair(), "z", false, false), formal(primPen(), "p", false, false));
#line 1622 "runtime.in"
  addFunc(ve, run::gen140, primGuide(), "operator cycle");
#line 1627 "runtime.in"
  addFunc(ve, run::gen141, primGuide(), "operator spec", formal(primPair(), "z", false, false), formal(primInt(), "p", false, false));
#line 1635 "runtime.in"
  addFunc(ve, run::gen142, primGuide(), "operator curl", formal(primReal(), "gamma", false, false), formal(primInt(), "p", false, false));
#line 1643 "runtime.in"
  addFunc(ve, run::gen143, primGuide(), "operator tension", formal(primReal(), "tout", false, false), formal(primReal(), "tin", false, false), formal(primBoolean(), "atleast", false, false));
#line 1648 "runtime.in"
  addFunc(ve, run::gen144, primGuide(), "operator controls", formal(primPair(), "zout", false, false), formal(primPair(), "zin", false, false));
#line 1661 "runtime.in"
  addFunc(ve, run::gen146, primInt(), "length", formal(primString(), "s", false, false));
#line 1666 "runtime.in"
  addFunc(ve, run::gen147, primInt(), "find", formal(primString(), "s", false, false), formal(primString() , "t", false, false), formal(primInt(), "pos", true, false));
#line 1671 "runtime.in"
  addFunc(ve, run::gen148, primInt(), "rfind", formal(primString(), "s", false, false), formal(primString() , "t", false, false), formal(primInt(), "pos", true, false));
#line 1676 "runtime.in"
  addFunc(ve, run::gen149, primString() , "reverse", formal(primString() , "s", false, false));
#line 1682 "runtime.in"
  addFunc(ve, run::gen150, primString() , "insert", formal(primString() , "s", false, false), formal(primInt(), "pos", false, false), formal(primString() , "t", false, false));
#line 1689 "runtime.in"
  addFunc(ve, run::gen151, primString() , "substr", formal(primString(), "s", false, false), formal(primInt(), "pos", false, false), formal(primInt(), "n", true, false));
#line 1696 "runtime.in"
  addFunc(ve, run::gen152, primString() , "erase", formal(primString() , "s", false, false), formal(primInt(), "pos", false, false), formal(primInt(), "n", false, false));
#line 1703 "runtime.in"
  addFunc(ve, run::gen153, primString() , "replace", formal(primString(), "s", false, false), formal(stringArray2(), "translate", false, false));
#line 1730 "runtime.in"
  addFunc(ve, run::gen154, primString() , "format", formal(primString(), "format", false, false), formal(primInt(), "x", false, false));
#line 1745 "runtime.in"
  addFunc(ve, run::gen155, primString() , "format", formal(primString(), "format", false, false), formal(primReal(), "x", false, false));
#line 1849 "runtime.in"
  addFunc(ve, run::gen156, primString() , "string", formal(primReal(), "x", false, false), formal(primInt(), "digits", false, false));
#line 1857 "runtime.in"
  addFunc(ve, run::gen157, primString() , "time", formal(primString(), "format", true, false));
#line 1868 "runtime.in"
  addFunc(ve, run::gen158, primString() , "time", formal(primInt(), "seconds", false, false), formal(primString(), "format", true, false));
#line 1880 "runtime.in"
  addFunc(ve, run::gen159, primInt(), "seconds", formal(primString() , "t", true, false), formal(primString() , "format", true, false));
#line 1893 "runtime.in"
  addFunc(ve, run::gen160, realArray(), "_cputime");
#line 1907 "runtime.in"
  addFunc(ve, run::gen161, primReal(), "^", formal(primReal(), "x", false, false), formal(primInt(), "y", false, false));
#line 1915 "runtime.in"
  addFunc(ve, run::gen162, primInt(), "quotient", formal(primInt(), "x", false, false), formal(primInt(), "y", false, false));
#line 1922 "runtime.in"
  addFunc(ve, run::gen163, primInt(), "abs", formal(primInt(), "x", false, false));
#line 1927 "runtime.in"
  addFunc(ve, run::gen164, primInt(), "sgn", formal(primReal(), "x", false, false));
#line 1932 "runtime.in"
  addFunc(ve, run::gen165, primInt(), "rand");
#line 1937 "runtime.in"
  addFunc(ve, run::gen166, primVoid(), "srand", formal(primInt(), "seed", false, false));
#line 1942 "runtime.in"
  addFunc(ve, run::gen167, primInt(), "ceil", formal(primReal(), "x", false, false));
#line 1949 "runtime.in"
  addFunc(ve, run::gen168, primInt(), "floor", formal(primReal(), "x", false, false));
#line 1956 "runtime.in"
  addFunc(ve, run::gen169, primInt(), "round", formal(primReal(), "x", false, false));
#line 1962 "runtime.in"
  addFunc(ve, run::gen170, primInt(), "Ceil", formal(primReal(), "x", false, false));
#line 1967 "runtime.in"
  addFunc(ve, run::gen171, primInt(), "Floor", formal(primReal(), "x", false, false));
#line 1972 "runtime.in"
  addFunc(ve, run::gen172, primInt(), "Round", formal(primReal(), "x", false, false));
#line 1977 "runtime.in"
  addFunc(ve, run::gen173, primReal(), "fmod", formal(primReal(), "x", false, false), formal(primReal(), "y", false, false));
#line 1983 "runtime.in"
  addFunc(ve, run::gen174, primReal(), "atan2", formal(primReal(), "y", false, false), formal(primReal(), "x", false, false));
#line 1988 "runtime.in"
  addFunc(ve, run::gen175, primReal(), "hypot", formal(primReal(), "x", false, false), formal(primReal(), "y", false, false));
#line 1993 "runtime.in"
  addFunc(ve, run::gen176, primReal(), "remainder", formal(primReal(), "x", false, false), formal(primReal(), "y", false, false));
#line 1998 "runtime.in"
  addFunc(ve, run::gen177, primReal(), "J", formal(primInt(), "n", false, false), formal(primReal(), "x", false, false));
#line 2003 "runtime.in"
  addFunc(ve, run::gen178, primReal(), "Y", formal(primInt(), "n", false, false), formal(primReal(), "x", false, false));
#line 2008 "runtime.in"
  addFunc(ve, run::gen179, primReal(), "erf", formal(primReal(), "x", false, false));
#line 2013 "runtime.in"
  addFunc(ve, run::gen180, primReal(), "erfc", formal(primReal(), "x", false, false));
#line 2018 "runtime.in"
  addFunc(ve, run::gen181, primReal(), "gamma", formal(primReal(), "x", false, false));
#line 2028 "runtime.in"
  addFunc(ve, run::gen182, realArray(), "quadraticroots", formal(primReal(), "a", false, false), formal(primReal(), "b", false, false), formal(primReal(), "c", false, false));
#line 2037 "runtime.in"
  addFunc(ve, run::gen183, realArray(), "cubicroots", formal(primReal(), "a", false, false), formal(primReal(), "b", false, false), formal(primReal(), "c", false, false), formal(primReal(), "d", false, false));
#line 2047 "runtime.in"
  addFunc(ve, run::gen184, primBoolean(), "==", formal(primTransform(), "a", false, false), formal(primTransform(), "b", false, false));
#line 2055 "runtime.in"
  addFunc(ve, run::gen185, primBoolean(), "!=", formal(primTransform(), "a", false, false), formal(primTransform(), "b", false, false));
#line 2060 "runtime.in"
  addFunc(ve, run::gen186, primTransform(), "+", formal(primTransform(), "a", false, false), formal(primTransform(), "b", false, false));
#line 2065 "runtime.in"
  addFunc(ve, run::gen187, primTransform(), "*", formal(primTransform(), "a", false, false), formal(primTransform(), "b", false, false));
#line 2070 "runtime.in"
  addFunc(ve, run::gen188, primPair(), "*", formal(primTransform(), "t", false, false), formal(primPair(), "z", false, false));
#line 2075 "runtime.in"
  addFunc(ve, run::gen189, primPath(), "*", formal(primTransform(), "t", false, false), formal(primPath(), "g", false, false));
#line 2080 "runtime.in"
  addFunc(ve, run::gen190, primPen(), "*", formal(primTransform(), "t", false, false), formal(primPen(), "p", false, false));
#line 2085 "runtime.in"
  addFunc(ve, run::gen191, primPicture(), "*", formal(primTransform(), "t", false, false), formal(primPicture(), "f", false, false));
#line 2090 "runtime.in"
  addFunc(ve, run::gen192, primTransform(), "^", formal(primTransform(), "t", false, false), formal(primInt(), "n", false, false));
#line 2137 "runtime.in"
  addFunc(ve, run::gen200, primTransform(), "shift", formal(primTransform(), "t", false, false));
#line 2142 "runtime.in"
  addFunc(ve, run::gen201, primTransform(), "shiftless", formal(primTransform(), "t", false, false));
#line 2147 "runtime.in"
  addFunc(ve, run::transformIdentity, primTransform(), "identity");
#line 2152 "runtime.in"
  addFunc(ve, run::gen203, primTransform(), "inverse", formal(primTransform(), "t", false, false));
#line 2157 "runtime.in"
  addFunc(ve, run::gen204, primTransform(), "shift", formal(primPair(), "z", false, false));
#line 2162 "runtime.in"
  addFunc(ve, run::gen205, primTransform(), "shift", formal(primReal(), "x", false, false), formal(primReal(), "y", false, false));
#line 2167 "runtime.in"
  addFunc(ve, run::gen206, primTransform(), "xscale", formal(primReal(), "x", false, false));
#line 2172 "runtime.in"
  addFunc(ve, run::gen207, primTransform(), "yscale", formal(primReal(), "y", false, false));
#line 2177 "runtime.in"
  addFunc(ve, run::gen208, primTransform(), "scale", formal(primReal(), "x", false, false));
#line 2182 "runtime.in"
  addFunc(ve, run::gen209, primTransform(), "slant", formal(primReal(), "s", false, false));
#line 2187 "runtime.in"
  addFunc(ve, run::gen210, primTransform(), "rotate", formal(primReal(), "angle", false, false), formal(primPair(), "z", true, false));
#line 2192 "runtime.in"
  addFunc(ve, run::gen211, primTransform(), "reflect", formal(primPair(), "a", false, false), formal(primPair(), "b", false, false));
#line 2216 "runtime.in"
  addFunc(ve, run::pairXPart, primReal(), "xpart", formal(primPair(), "z", false, false));
#line 2221 "runtime.in"
  addFunc(ve, run::pairYPart, primReal(), "ypart", formal(primPair(), "z", false, false));
#line 2226 "runtime.in"
  addFunc(ve, run::gen217, primReal(), "length", formal(primPair(), "z", false, false));
#line 2231 "runtime.in"
  addFunc(ve, run::gen218, primReal(), "abs", formal(primPair(), "z", false, false));
#line 2236 "runtime.in"
  addFunc(ve, run::gen219, primReal(), "angle", formal(primPair(), "z", false, false), formal(primBoolean(), "warn", true, false));
#line 2243 "runtime.in"
  addFunc(ve, run::gen220, primReal(), "degrees", formal(primPair(), "z", false, false), formal(primBoolean(), "warn", true, false));
#line 2250 "runtime.in"
  addFunc(ve, run::gen221, primReal(), "radians", formal(primReal(), "degrees", false, false));
#line 2256 "runtime.in"
  addFunc(ve, run::gen222, primReal(), "degrees", formal(primReal(), "radians", false, false));
#line 2262 "runtime.in"
  addFunc(ve, run::gen223, primReal(), "Degrees", formal(primReal(), "radians", false, false));
#line 2268 "runtime.in"
  addFunc(ve, run::gen224, primReal(), "Sin", formal(primReal(), "deg", false, false));
#line 2273 "runtime.in"
  addFunc(ve, run::gen225, primReal(), "Cos", formal(primReal(), "deg", false, false));
#line 2278 "runtime.in"
  addFunc(ve, run::gen226, primReal(), "Tan", formal(primReal(), "deg", false, false));
#line 2283 "runtime.in"
  addFunc(ve, run::gen227, primReal(), "aSin", formal(primReal(), "x", false, false));
#line 2288 "runtime.in"
  addFunc(ve, run::gen228, primReal(), "aCos", formal(primReal(), "x", false, false));
#line 2293 "runtime.in"
  addFunc(ve, run::gen229, primReal(), "aTan", formal(primReal(), "x", false, false));
#line 2298 "runtime.in"
  addFunc(ve, run::gen230, primPair(), "unit", formal(primPair(), "z", false, false));
#line 2303 "runtime.in"
  addFunc(ve, run::gen231, primPair(), "dir", formal(primReal(), "theta", false, false));
#line 2308 "runtime.in"
  addFunc(ve, run::gen232, primPair(), "expi", formal(primReal(), "theta", false, false));
#line 2313 "runtime.in"
  addFunc(ve, run::gen233, primPair(), "conj", formal(primPair(), "z", false, false));
#line 2318 "runtime.in"
  addFunc(ve, run::gen234, primPair(), "realmult", formal(primPair(), "z", false, false), formal(primPair(), "w", false, false));
#line 2323 "runtime.in"
  addFunc(ve, run::gen235, primReal(), "dot", formal(primPair(), "z", false, true), formal(primPair(), "w", false, true));
#line 2343 "runtime.in"
  addFunc(ve, run::tripleXPart, primReal(), "xpart", formal(primTriple(), "v", false, false));
#line 2348 "runtime.in"
  addFunc(ve, run::tripleYPart, primReal(), "ypart", formal(primTriple(), "v", false, false));
#line 2353 "runtime.in"
  addFunc(ve, run::tripleZPart, primReal(), "zpart", formal(primTriple(), "v", false, false));
#line 2358 "runtime.in"
  addFunc(ve, run::gen241, primTriple(), "*", formal(primReal(), "x", false, false), formal(primTriple(), "v", false, false));
#line 2363 "runtime.in"
  addFunc(ve, run::gen242, primTriple(), "*", formal(primTriple(), "v", false, false), formal(primReal(), "x", false, false));
#line 2368 "runtime.in"
  addFunc(ve, run::gen243, primTriple(), "/", formal(primTriple(), "v", false, false), formal(primReal(), "x", false, false));
#line 2373 "runtime.in"
  addFunc(ve, run::gen244, primReal(), "length", formal(primTriple(), "v", false, false));
#line 2378 "runtime.in"
  addFunc(ve, run::gen245, primReal(), "abs", formal(primTriple(), "v", false, false));
#line 2383 "runtime.in"
  addFunc(ve, run::gen246, primReal(), "polar", formal(primTriple(), "v", false, false));
#line 2388 "runtime.in"
  addFunc(ve, run::gen247, primReal(), "azimuth", formal(primTriple(), "v", false, false));
#line 2393 "runtime.in"
  addFunc(ve, run::gen248, primReal(), "colatitude", formal(primTriple(), "v", false, false));
#line 2398 "runtime.in"
  addFunc(ve, run::gen249, primReal(), "latitude", formal(primTriple(), "v", false, false));
#line 2403 "runtime.in"
  addFunc(ve, run::gen250, primReal(), "longitude", formal(primTriple(), "v", false, false), formal(primBoolean(), "warn", true, false));
#line 2410 "runtime.in"
  addFunc(ve, run::gen251, primTriple(), "unit", formal(primTriple(), "v", false, false));
#line 2415 "runtime.in"
  addFunc(ve, run::gen252, primReal(), "dot", formal(primTriple(), "u", false, false), formal(primTriple(), "v", false, false));
#line 2420 "runtime.in"
  addFunc(ve, run::gen253, primTriple(), "cross", formal(primTriple(), "u", false, false), formal(primTriple(), "v", false, false));
#line 2427 "runtime.in"
  addFunc(ve, run::gen254, primTriple(), "expi", formal(primReal(), "theta", false, false), formal(primReal(), "phi", false, false));
#line 2434 "runtime.in"
  addFunc(ve, run::gen255, primTriple(), "dir", formal(primReal(), "theta", false, false), formal(primReal(), "phi", false, false));
#line 2439 "runtime.in"
  addFunc(ve, run::gen256, primReal(), "cubiclength", formal(primTriple(), "z0", false, false), formal(primTriple(), "z0p", false, false), formal(primTriple(), "z1m", false, false), formal(primTriple(), "z1", false, false), formal(primReal(), "goal", false, false));
#line 2444 "runtime.in"
  addFunc(ve, run::gen257, primPair(), "intersect", formal(tripleArray(), "pre1", false, false), formal(tripleArray(), "point1", false, false), formal(tripleArray(), "post1", false, false), formal(tripleArray(), "pre2", false, false), formal(tripleArray(), "point2", false, false), formal(tripleArray(), "post2", false, false), formal(primReal(), "fuzz", false, false));
#line 2477 "runtime.in"
  addFunc(ve, run::gen258, primString() , "VERSION");
#line 2485 "runtime.in"
  addFunc(ve, run::gen259, primVoid(), "atexit", formal(voidFunction(), "f", false, false));
#line 2490 "runtime.in"
  addFunc(ve, run::gen260, voidFunction(), "atexit");
#line 2495 "runtime.in"
  addFunc(ve, run::gen261, primVoid(), "atbreakpoint", formal(breakpointFunction(), "f", false, false));
#line 2500 "runtime.in"
  addFunc(ve, run::gen262, primVoid(), "breakpoint", formal(primCode(), "s", true, false));
#line 2505 "runtime.in"
  addFunc(ve, run::gen263, primString() , "locatefile", formal(primString() , "file", false, false));
#line 2510 "runtime.in"
  addFunc(ve, run::gen264, primVoid(), "stop", formal(primString() , "file", false, false), formal(primInt(), "line", false, false), formal(primCode(), "s", true, false));
#line 2518 "runtime.in"
  addFunc(ve, run::gen265, primVoid(), "breakpoints");
#line 2524 "runtime.in"
  addFunc(ve, run::gen266, primVoid(), "clear", formal(primString() , "file", false, false), formal(primInt(), "line", false, false));
#line 2530 "runtime.in"
  addFunc(ve, run::gen267, primVoid(), "clear");
#line 2535 "runtime.in"
  addFunc(ve, run::gen268, primInt(), "merge", formal(stringArray(), "files", false, false), formal(primString(), "args", false, false), formal(primString(), "format", false, false));
#line 2794 "runtime.in"
  addFunc(ve, run::gen292, intArray(), "complement", formal(intArray(), "a", false, false), formal(primInt(), "n", false, false));
#line 2826 "runtime.in"
  addFunc(ve, run::gen294, intArray(), "sequence", formal(primInt(), "n", false, false));
#line 2850 "runtime.in"
  addFunc(ve, run::gen296, primBoolean(), "all", formal(boolArray(), "a", false, false));
#line 2859 "runtime.in"
  addFunc(ve, run::gen297, boolArray(), "!", formal(boolArray(), "a", false, false));
#line 2868 "runtime.in"
  addFunc(ve, run::gen298, primInt(), "sum", formal(boolArray(), "a", false, false));
#line 3016 "runtime.in"
  addFunc(ve, run::gen305, primInt(), "find", formal(boolArray(), "a", false, false), formal(primInt(), "n", true, false));
#line 3062 "runtime.in"
  addFunc(ve, run::gen307, realArray2(), "inverse", formal(realArray2(), "a", false, false));
#line 3154 "runtime.in"
  addFunc(ve, run::gen308, realArray(), "solve", formal(realArray2(), "a", false, false), formal(realArray(), "b", false, false));
#line 3197 "runtime.in"
  addFunc(ve, run::gen309, realArray2(), "solve", formal(realArray2(), "a", false, false), formal(realArray2(), "b", false, false));
#line 3251 "runtime.in"
  addFunc(ve, run::gen310, primReal(), "determinant", formal(realArray2(), "a", false, false));
#line 3264 "runtime.in"
  addFunc(ve, run::gen311, realArray(), "*", formal(realArray2(), "a", false, false), formal(realArray(), "b", false, false));
#line 3281 "runtime.in"
  addFunc(ve, run::gen312, realArray(), "tridiagonal", formal(realArray(), "a", false, false), formal(realArray(), "b", false, false), formal(realArray(), "c", false, false), formal(realArray(), "f", false, false));
#line 3413 "runtime.in"
  addFunc(ve, run::gen314, intArray2(), "triangulate", formal(pairArray(), "z", false, false));
#line 3448 "runtime.in"
  addFunc(ve, run::gen315, primBoolean(), "==", formal(primFile(), "a", false, false), formal(primFile(), "b", false, false));
#line 3456 "runtime.in"
  addFunc(ve, run::gen316, primBoolean(), "!=", formal(primFile(), "a", false, false), formal(primFile(), "b", false, false));
#line 3471 "runtime.in"
  addFunc(ve, run::gen319, primFile(), "input", formal(primString() , "name", false, false), formal(primBoolean(), "check", true, false), formal(primString() , "comment", true, false));
#line 3479 "runtime.in"
  addFunc(ve, run::gen320, primFile(), "output", formal(primString() , "name", false, false), formal(primBoolean(), "append", true, false));
#line 3486 "runtime.in"
  addFunc(ve, run::gen321, primFile(), "xinput", formal(primString() , "name", false, false), formal(primBoolean(), "check", true, false));
#line 3499 "runtime.in"
  addFunc(ve, run::gen322, primFile(), "xoutput", formal(primString() , "name", false, false), formal(primBoolean(), "append", true, false));
#line 3512 "runtime.in"
  addFunc(ve, run::gen323, primBoolean(), "eof", formal(primFile(), "file", false, false));
#line 3517 "runtime.in"
  addFunc(ve, run::gen324, primBoolean(), "eol", formal(primFile(), "file", false, false));
#line 3522 "runtime.in"
  addFunc(ve, run::gen325, primBoolean(), "error", formal(primFile(), "file", false, false));
#line 3527 "runtime.in"
  addFunc(ve, run::gen326, primVoid(), "clear", formal(primFile(), "file", false, false));
#line 3532 "runtime.in"
  addFunc(ve, run::gen327, primVoid(), "close", formal(primFile(), "file", false, false));
#line 3537 "runtime.in"
  addFunc(ve, run::gen328, primVoid(), "precision", formal(primFile(), "file", false, false), formal(primInt(), "digits", false, false));
#line 3542 "runtime.in"
  addFunc(ve, run::gen329, primVoid(), "flush", formal(primFile(), "file", false, false));
#line 3547 "runtime.in"
  addFunc(ve, run::gen330, primString() , "getc", formal(primFile(), "file", false, false));
#line 3556 "runtime.in"
  addFunc(ve, run::gen331, primInt(), "tell", formal(primFile(), "file", false, false));
#line 3561 "runtime.in"
  addFunc(ve, run::gen332, primVoid(), "seek", formal(primFile(), "file", false, false), formal(primInt(), "pos", false, false));
#line 3566 "runtime.in"
  addFunc(ve, run::gen333, primFile(), "dimension", formal(primFile(), "file", false, false), formal(primInt(), "nx", false, false));
#line 3573 "runtime.in"
  addFunc(ve, run::gen334, primFile(), "dimension", formal(primFile(), "file", false, false), formal(primInt(), "nx", false, false), formal(primInt(), "ny", false, false));
#line 3579 "runtime.in"
  addFunc(ve, run::gen335, primFile(), "dimension", formal(primFile(), "file", false, false), formal(primInt(), "nx", false, false), formal(primInt(), "ny", false, false), formal(primInt(), "nz", false, false));
#line 3585 "runtime.in"
  addFunc(ve, run::gen336, primFile(), "csv", formal(primFile(), "file", false, false), formal(primBoolean(), "b", true, false));
#line 3592 "runtime.in"
  addFunc(ve, run::gen337, primFile(), "line", formal(primFile(), "file", false, false), formal(primBoolean(), "b", true, false));
#line 3599 "runtime.in"
  addFunc(ve, run::gen338, primFile(), "single", formal(primFile(), "file", false, false), formal(primBoolean(), "b", true, false));
#line 3606 "runtime.in"
  addFunc(ve, run::gen339, primFile(), "read1", formal(primFile(), "file", false, false));
#line 3613 "runtime.in"
  addFunc(ve, run::gen340, primFile(), "read2", formal(primFile(), "file", false, false));
#line 3620 "runtime.in"
  addFunc(ve, run::gen341, primFile(), "read3", formal(primFile(), "file", false, false));
#line 3627 "runtime.in"
  addFunc(ve, run::gen342, primString() , "readline", formal(primString() , "prompt", true, false), formal(primString() , "history", true, false), formal(primString() , "initial", true, false), formal(primBoolean(), "tabcompletion", true, false));
}

} // namespace trans
