/****************************************************************
**
** Attal : Lords of Doom
**
** aiLord.h
** manages ai lord
**
** Version : $Id: aiLord.h,v 1.1 2006/06/02 19:41:17 lusum Exp $
**
** Author(s) : Sardi Carlo
**
** Date : 27/07/2005
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

 
#ifndef AILORD_H
#define AILORD_H
 
 
// generic include files
// include files for QT
// application specific include files
#include "libCommon/genericLord.h"

/*              ------------------------------
 *                         AiLord
 *              ------------------------------ */

class AiLord : public GenericLord
{

public:
	enum LordPriority {
		PR_ENEMY = 1,
		PR_BASE,
		PR_BASEOWNER,
		PR_BUILD,
		PR_ART,
		PR_BONUS,
		PR_CHEST,
		PR_CREAT,
		PR_EXPLORE,
		PR_LAST 
	};
	
	/** Constructor */
	AiLord();

	/** Destructor */
	virtual ~AiLord();

	void reinit();

	void setPriority( LordPriority num, int value ) { _priorities[ num ] = value; }
	
	/** Return the unit 'num' */
	int getPriority( LordPriority num ) { return _priorities[ num ]; }
	
	int getPower();


protected:

	int _priorities[ PR_LAST + 1 ];
};

#endif // AILORD_H
