/****************************************************************
**
** Attal : Lords of Doom
**
** insideBase.cpp
** display the base and its buildings
**
** Version : $Id: insideBase.cpp,v 1.10 2006/06/02 00:38:04 lusum Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 28/10/2001
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "insideBase.h"
 
// generic include files
// include files for QT
#include <QMouseEvent>

// application specific include files
#include "libClient/insideBuilding.h"
#include "libClient/imageTheme.h"
#include "libCommon/genericInsideBuilding.h"
#include "libCommon/genericBase.h"
#include "libCommon/log.h"


extern QString IMAGE_PATH;
extern ImageTheme ImageTheme;

//
// ----- InsideBase -----
//
InsideBase::InsideBase( QObject * parent, const char * name )
    : Q3Canvas( parent , name )
{
	resize( 960, 720 );
	_background = 0;
	_base = 0;
}

InsideBase::~InsideBase()
{	
	clear();
}

void InsideBase::clear()
{
	while( ! _list.isEmpty() ) {
		delete _list.takeFirst();
	}
	_base = 0;
	_newBase = true;
}

void InsideBase::reinit()
{
	if( _base ) {
		setBackgroundPixmap( * ImageTheme.getInsideBase( _base->getRace() ) );
		_background = ImageTheme.getInsideBase( _base->getRace() );

		for( uint i = 0; i < _base->getBuildingCount(); i++ ) {
			addBuilding( _base->getBuilding( i ) );
		}
	}
}

void InsideBase::setBase( GenericBase * base )
{
	if( _base != base ) {
		clear();
		_base = base;
		setBackgroundPixmap( * ImageTheme.getInsideBase( _base->getRace() ) );
		_background = ImageTheme.getInsideBase( _base->getRace() );

		for( uint i = 0; i < base->getBuildingCount(); i++ ) {
			addBuilding( base->getBuilding( i ) );
		}
	}
}

void InsideBase::addBuilding( GenericInsideBuilding * building )
{
	// check if building is already added (remove a bug )
	for( int i = 0; i < _list.count(); i++ ) {
		if( _list.at( i )->getBuilding()->getLevel() == building->getLevel() ) {
			return;
		}
	}

	InsideBuilding * inside = new InsideBuilding( _base->getRace(), building, this );
	inside->move( building->getX(), building->getY() );
	inside->show();
	_list.append( inside );
}

void InsideBase::delBuilding( uint level )
{
	InsideBuilding * inside = 0;

	for( int i = 0; i < _list.count(); i++ ) {
		if( _list.at( i )->getBuilding()->getLevel() == level ) {
			inside = _list.at( i );
			break;
		}
	}
	if( inside ) {
		_list.removeAll( inside );
		delete inside;
	}
}

void InsideBase::delBuilding( GenericInsideBuilding * building )
{
	InsideBuilding * inside = 0;

	for( int i = 0; i < _list.count(); i++ ) {
		if( _list.at( i )->getBuilding() == building ) {
			inside = _list.at( i );
			break;
		}
	}
	if( inside ) {
		_list.removeAll( inside );
		delete inside;
	}
}

void InsideBase::drawBackground( QPainter& painter, const QRect& clip )
{
	if( _background ) {
		painter.fillRect( clip, Qt::black );
        	painter.drawPixmap( clip.x(), clip.y(), * _background, clip.x(), clip.y(), clip.width(), clip.height() );
	} else {
		painter.fillRect( clip, Qt::black );
	}
}

//
// ----- InsideBaseView -----
//

InsideBaseView::InsideBaseView( InsideBase * base, QWidget * parent, const char * name, Qt::WFlags f )
	: Q3CanvasView( base , parent, name, f )
{
	viewport()->setMouseTracking( true ) ;
	_selected = 0;
	_base = base;
}

/** handles mouse move event */
void InsideBaseView::contentsMouseMoveEvent( QMouseEvent * e )
{
	Q3CanvasItemList list;
	Q3CanvasItemList list2 = canvas()->collisions( e->pos() );
	
	uint nbItems2 = (uint) list2.count();
	for( unsigned int i = 0; i < nbItems2; i++ ) {
		if( list2[ i ]->rtti() == InsideBuilding::RTTI ) {
			if( ( (InsideBuilding*)list2[ i ] )->hit( e->pos() ) ) {
				list.append( list2[ i ] );
			}
		}
	}
	
	if(_base->getNewBase()==true){
		_selected = 0;
		canvas()->update();
		_base->setNewBase(false);
	}

	uint nbItems = (uint) list.count();
	for( unsigned int i = 0; i < nbItems; i++ ) {	
		if( _selected ) {
			if( _selected != (InsideBuilding*)list[i] ) {
				_selected->deselect();
				_selected = (InsideBuilding*)list[i];
				_selected->select();
				canvas()->update();
			} 				
		} else {
			_selected = (InsideBuilding*)list[i];
			_selected->select();
			canvas()->update();
		} 
	}
	
	if( ( list.count() == 0 ) && _selected ) {
		_selected->deselect();
		_selected = 0;
		canvas()->update();
	}
}


/*
 * handles mouse press event
 */
void InsideBaseView::contentsMouseReleaseEvent( QMouseEvent * e )
{
	Q3CanvasItemList list;
	Q3CanvasItemList list2 = canvas()->collisions( e->pos() );
	
	uint nbItems2 = (uint) list2.count();
	for( unsigned int i = 0; i < nbItems2; i++ ) {
		if( list2[ i ]->rtti() == InsideBuilding::RTTI ) {
			if( ( (InsideBuilding*)list2[ i ] )->hit( e->pos() ) ) {
				list.append( list2[ i ] );
			}
		}
	}
	
	uint nbItems = (uint) list.count();
	for( unsigned int i = 0; i < nbItems; i++ ) {	
		if( e->button() == Qt::LeftButton ) {
			emit sig_building( ((InsideBuilding *)list[i])->getBuilding() );
		} else {
		}
	}
}

