/****************************************************************
**
** Attal : Lords of Doom
**
** miniMap.h
** draw and manage the mini-map
**
** Version : $Id: miniMap.h,v 1.7 2005/12/28 10:06:05 audoux Exp $
**
** Author(s) : Pascal Audoux - Sardi Carlo - Forest Darling
**
** Date : 05/12/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

 
#ifndef MINIMAP_H
#define MINIMAP_H
 
 
// generic include files
// include files for QT
#include <QMouseEvent>
#include <QPaintEvent>
#include <QPen>
#include <QPixmap>
#include <QResizeEvent>
#include <QWidget>

// application specific include files
#include "libCommon/genericMap.h"
#include "libClient/map.h"

class GenericCell;

/*              ------------------------------
 *                         MiniMap
 *              ------------------------------ */


class MiniMap : public QWidget
{

	Q_OBJECT
public:
	/** Constructor */
	MiniMap( Map * map, QWidget * parent = 0, const char * name = 0 );

	/** Redraw the mini map */
	void redrawMap( Map * map );

	/** Redraws the cell <i, j> */
	void redrawCell( GenericCell * cell );
	
	void redrawCellFast( GenericCell * cell );

	void resizeMap( uint width, uint height );

public slots:

	void slot_graphicalMapResized();

	void slot_mapviewScrolled( int x, int y );

	void slot_mapviewChanged( int x, int y, int w, int h);

signals:

	void sig_mouseReleasedMinimap( uint, uint );

protected:
	virtual void paintEvent( QPaintEvent * event );
	virtual void resizeEvent( QResizeEvent * event );
	virtual void mousePressEvent( QMouseEvent * event );
	virtual void mouseMoveEvent( QMouseEvent * event );

private:
	void translatePoint( int x, int y );
	void repaintViewRect();

	static QPen _dashPen;
	static int _defaultHeight;
	static int _defaultWidth;

	QPixmap * _qp;
	Map * _map;
	uint _height, _width;
	int _ntiles;
	uint _sizeH,_sizeV;
	QRect * _viewrect;
	int _gmapw, _gmaph;
	int _viewx, _viewy, _vieww, _viewh;
};

#endif // MINIMAP_H
