/****************************************************************
**
** Attal : Lords of Doom
**
** dataTheme.cpp
** class for gathering all informations about theme (data part)
**
** Version : $Id: dataTheme.cpp,v 1.10 2006/07/27 12:58:38 lusum Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 03/06/2001
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "dataTheme.h"
//Added by qt3to4:
#include <QTextStream>

// generic include files
// include files for QT
// application specific include files

DataTheme DataTheme;


void indentation( QTextStream * ts, int num )
{
	for( int i = 0; i < num; i++ ) {
		(*ts) << "\t";
	}
}

//
// ----- DataTheme -----
//

DataTheme::DataTheme()
{
	_isLoaded = false;
}

bool DataTheme::init()
{
	_isLoaded = general.init();
	_isLoaded = _isLoaded && artefacts.init();
	_isLoaded = _isLoaded && teams.init();
	_isLoaded = _isLoaded && resources.init();
	_isLoaded = _isLoaded && decorations.init();
	_isLoaded = _isLoaded && creatures.init();
	_isLoaded = _isLoaded && techList.init();
	_isLoaded = _isLoaded && lordCategories.init();
	_isLoaded = _isLoaded && lords.init();
	_isLoaded = _isLoaded && bases.init();
	_isLoaded = _isLoaded && buildings.init();
	_isLoaded = _isLoaded && tiles.init();
	_isLoaded = _isLoaded && machines.init();
	_isLoaded = _isLoaded && lordExperience.init();
	_isLoaded = _isLoaded && _category.init();

	return isLoaded();
}

void DataTheme::save()
{
	general.save();
	artefacts.save();
	teams.save();
	resources.save();
	decorations.save();
	creatures.save();
	techList.save();
	lordCategories.save();
	lords.save();
	bases.save();
	buildings.save();
	tiles.save();
	machines.save();
	lordExperience.save();
	_category.save();
}

void DataTheme::clear()
{
	general.clear();
	artefacts.clear();
	teams.clear();
	resources.clear();
	decorations.clear();
	creatures.clear();
	techList.clearing();
	lordCategories.clear();
	lords.clear();
	bases.clear();
	buildings.clear();
	tiles.clear();
	machines.clear();
	lordExperience.clear();
	_category.clear();
}

QString DataTheme::getCategoryName( uint categ )
{
	QString ret = _category.getCategoryName( categ );

	return ret;
}

uint DataTheme::computeCategory( int nb )
{
	uint ret = _category.computeCategory( nb );

	return ret;
}

QString DataTheme::computeCategoryName( int nb )
{
	QString ret = _category.getCategoryName( nb );

	return ret;
}

uint DataTheme::getRandomInCategory( uchar categ )
{
	uint ret = _category.getRandomInCategory(categ);

	return ret;
}

uint DataTheme::getLordCategory( LordCategoryModel * category )
{
	uint ret = 0;

	uint nbCat = lordCategories.count();
	for( uint i = 0; i < nbCat; i++ ) {
		if( category == lordCategories.at( i ) ) {
			ret = i;
			break;
		}
	}

	return ret;
}

