/****************************************************************
**
** Attal : Lords of Doom
**
** genericRessources.cpp
** Management of ressources infos
**
** Version : $Id: genericRessources.cpp,v 1.6 2006/02/28 14:20:00 lusum Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 03/01/2001
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "genericRessources.h"
 
// generic include files
// include files for QT
#include <QFile>
#include <QTextStream>

// application specific include files
#include "libCommon/log.h"

extern QString DATA_PATH;

GenericRessources::GenericRessources()
{
}

bool GenericRessources::init()
{
	clear();
	QString filename = DATA_PATH + "ressources.dat";
	QFile f( filename );

	if (! f.open( QIODevice::ReadOnly ) ) {
		logEE( "Could not open file %s for reading\n", filename.toLatin1().constData() );
		return false;
	}
	
	QTextStream ts( &f );
	
	int temp;
	ts >> temp;
	
	for( int i = 0; i < temp; i++ ) {
		QString es;
		ts >> es;
		append( es );
		//logDD( "%s", ress->toLatin1().constData() );
	}

	f.close();

	return true;
}

bool GenericRessources::save()
{
	QString filename = DATA_PATH + "ressources.dat";
	QFile f( filename );

	if (! f.open( QIODevice::WriteOnly ) ) {
		logEE( "Could not open file %s for writng\n", filename.toLatin1().constData() );
		return false;
	}
	
	QTextStream ts( &f );
		
	ts << count() << endl;
	
	for( int i = 0; i < count(); i++ ) {
		ts << at( i ) << endl;
	}
	
	f.close();

	return true;
}

void GenericRessources::update( int num, QString val )
{
	(*this)[ num ] = val;
}

GenericRessources::~GenericRessources()
{
	clear();
}

QString GenericRessources::getRessource( uint num )
{
	if( (int)num < count() ) {
		return at( num );
	} else {
		return QString("");
	}
}
