/****************************************************************
**
** Attal : Lords of Doom
**
** fightControl.cpp
** Widget for the control board in fight mode
**
** Version : $Id: fightControl.cpp,v 1.3 2006/02/08 21:26:24 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 05/01/2002
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "fightControl.h"
 
// generic include files
// include files for QT
#include <QLayout>
#include <QToolTip>

// application specific include files
#include "libCommon/attalSettings.h"
#include "libCommon/log.h"

#include "libClient/attalButton.h"
#include "libClient/chatWidget.h"
#include "libClient/imageTheme.h"

extern QString IMAGE_PATH;

//
// ----- FightControl -----
//

FightControl::FightControl( QWidget * parent, const char * name )
	: QWidget( parent, name )
{
	AttalButton * butControl = new AttalButton( this );
	butControl->setPixmap( QPixmap( IMAGE_PATH + "misc/btn_control.png" ) );
	butControl->setFixedSize( 52, 52 );
	QToolTip::add( butControl, tr( "Options" ) );
	
	AttalButton * butSurrender = new AttalButton( this );
	butSurrender->setPixmap( QPixmap( IMAGE_PATH + "misc/btn_surrender.png" ) );
	butSurrender->setFixedSize( 52, 52 );
	QToolTip::add( butSurrender, tr( "Surrender" ) );
	
	AttalButton * butFlee = new AttalButton( this );
	butFlee->setPixmap( QPixmap( IMAGE_PATH + "misc/btn_flee.png" ) );
	butFlee->setFixedSize( 52, 52 );
	QToolTip::add( butFlee, tr( "Flee" ) );
	
	AttalButton * butAuto = new AttalButton( this );
	butAuto->setPixmap( QPixmap( IMAGE_PATH + "misc/btn_auto.png" ) );
	butAuto->setFixedSize( 52, 52 );
	QToolTip::add( butAuto, tr( "Auto-fight" ) );
	
	AttalButton * butSpell = new AttalButton( this );
	butSpell->setPixmap( QPixmap( IMAGE_PATH + "misc/btn_spell.png" ) );
	butSpell->setFixedSize( 52, 52 );
	QToolTip::add( butSpell, tr( "Spells" ) );
	
	AttalButton * butWait = new AttalButton( this );
	butWait->setPixmap( QPixmap( IMAGE_PATH + "misc/btn_wait.png" ) );
	butWait->setFixedSize( 52, 52 );
	QToolTip::add( butWait, tr( "Wait" ) );
	
	AttalButton * butDefend = new AttalButton( this );
	butDefend->setPixmap( QPixmap( IMAGE_PATH + "misc/btn_defend.png" ) );
	butDefend->setFixedSize( 52, 52 );
	QToolTip::add( butDefend, tr( "Defend" ) );

	QHBoxLayout * layH1 = new QHBoxLayout();	
	layH1->addStretch( 1 );
	layH1->addWidget( butWait );
	layH1->addStretch( 1 );
	layH1->addWidget( butDefend );
	layH1->addStretch( 1 );
	layH1->addWidget( butSpell );
	layH1->addStretch( 1 );

	QHBoxLayout * layH2 = new QHBoxLayout();	
	layH2->addStretch( 1 );
	layH2->addWidget( butFlee );
	layH2->addStretch( 1 );
	layH2->addWidget( butSurrender );
	layH2->addStretch( 1 );
	layH2->addWidget( butAuto );
	layH2->addStretch( 1 );
	layH2->addWidget( butControl );
	layH2->addStretch( 1 );

	_layV1 = new QVBoxLayout();
	_layV1->setSpacing( 5 );
	_layV1->setMargin( 5 );
	_layV1->addStretch( 1 );
	_layV1->addLayout( layH1 );
	_layV1->addStretch( 1 );
	_layV1->addLayout( layH2 );
	_layV1->addStretch( 1 );

	_chat = new ChatWidget( this );

	_layout = new QHBoxLayout( this );	
	_layout->addLayout( _layV1 );
	_layout->addWidget( _chat, 1 );
	_layout->activate();

	connect( butWait, SIGNAL( pressed( ) ), SLOT( slot_waitPressed( ) ) );
	connect( butFlee, SIGNAL( pressed( ) ), SLOT( slot_fleePressed( ) ) );
	connect( butControl, SIGNAL( clicked( ) ), SLOT( slot_controlPressed( ) ) );
	connect( butDefend, SIGNAL( pressed() ), SIGNAL( sig_defend() ) );
	connect( _chat, SIGNAL( sig_message( QString ) ),this, SIGNAL( sig_message( QString ) ) );
}

void FightControl::updateResolutionMode()
{
	if( AttalSettings::getInstance()->getDispositionMode() == AttalSettings::DM_FULL ) {
		setMinimumHeight( 150 );
		setMaximumHeight( 500 );
		setSizePolicy( QSizePolicy( QSizePolicy::Preferred, QSizePolicy::Preferred ) );
	} else {
		setFixedHeight( 150 );
	}
	update();
}

void FightControl::clear()
{
	_chat->clear();
}

void FightControl::newMessage( const QString & msg )
{
	_chat->newMessage( msg );
}


