/****************************************************************
**
** Attal : Lords of Doom
**
** fightMapView.cpp
** subclass of QCanvasSprite that handles mouse event ...
**
** Version : $Id: fightMapView.cpp,v 1.6 2005/12/09 15:01:16 lusum Exp $
**
** Author(s) : Cyrille Verrier - Sardi Carlo
**
** Date : 07/12/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "fightMapView.h"

 
// generic include files
// include files for QT
// application specific includes
#include "libCommon/log.h"
#include "libClient/lord.h"
#include "libFight/fightUnit.h"
//Added by qt3to4:
#include <QMouseEvent>


/** subclass of QCanvasView that handles mouse event ... */
FightMapView::FightMapView( FightMap *map, QWidget * parent, const char * name, Qt::WFlags f )
	: Q3CanvasView( map, parent, name, f )
{
	viewport()->setMouseTracking( true ) ;
	_press = false;
}


/** handles mouse move event */
void FightMapView::contentsMouseMoveEvent( QMouseEvent *e)
{
	Q3CanvasItemList list = canvas()->collisions(e->pos());
	uint nbItems = (uint)list.count();
	
	for( unsigned int i = 0; i < nbItems; i++ ) {	
		if( list[i]->rtti() == FightCell::RTTI ) {
			emit sig_mouseMoved( (FightCell *) list[i] );
			break;
		} else if( list[i]->rtti() == FightUnit::RTTI ) {
			if(((FightUnit*)list[ i ] )->hit( e->pos() ) ){
				emit sig_mouseMoved( (FightCell *) ((FightUnit*)list[i])->getCell());
				break;
			}
		}
	}
}


/*
 * handles mouse press event
 * emit a signal to say which cell is selected
 */
void FightMapView::contentsMousePressEvent( QMouseEvent * e )
{
	Q3CanvasItemList list = canvas()->collisions( e->pos() );
	uint nbItems = (uint)list.count();
	
	for( unsigned int i=0; i< nbItems; i++ ) {	
		if( list[i]->rtti() == FightUnit::RTTI ) {
			if(((FightUnit*)list[ i ] )->hit( e->pos() ) ){
				if( e->button() == Qt::RightButton ) { 
					emit sig_mouseRightPressed( (FightCell *) ((FightUnit*)list[i])->getCell() );
				} else {
					emit sig_mouseLeftPressed( (FightCell *) ((FightUnit*)list[i])->getCell() , true);
				}
			}
		}
		if( list[i]->rtti() == FightCell::RTTI ) {
			if( e->button() != Qt::RightButton ) {
				emit sig_mouseLeftPressed( (FightCell *) list[i], false);
			}
		}
	}
	_press = true;
}

/** handles mouse press event */

void FightMapView::contentsMouseReleaseEvent( QMouseEvent *e )
{
	_press = false;
	if( e->button() == Qt::RightButton )
		emit sig_mouseReleased();
}
