/****************************************************************
**
** Attal : Lords of Doom
**
** attal.cpp
** main file
**
** Version : $Id: main.cpp,v 1.17 2006/03/09 21:10:10 lusum Exp $
**
** Author(s) : Pascal Audoux - Cyrille Verrier - Sardi Carlo
**
** Date : 02/08/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/


#include <stdio.h>
#include <iostream>
// include files for QT
#include <QApplication>
#include <QDir>
#include <QLocale>
#include <QTranslator>
#include <QWidget>

// application specific include
#include "conf.h"

#include "libCommon/attalCommon.h"

#include "server/serverInterface.h"

using namespace std;

extern QString DATA_PATH;
extern QString SCENARIO_PATH;
extern QString CAMPAIGN_PATH;
extern QString THEME;

QString PORT = "1717";
bool FAST = false;

int main( int argc, char **argv )
{
	QDir trfolder;
	trfolder = translationsDir(); 

	QApplication app( argc, argv );
	QTranslator translator( 0 );
	translator.load( QString("attal_server_") + QLocale::system().name(), trfolder.absolutePath() );

	
	app.installTranslator( &translator );

	for( int i = 1; i < argc; i++ ) {
		if( ( strcmp( argv[i], "-theme" ) == 0 ) || ( strcmp( argv[i], "--theme" ) == 0 ) ) {
			i++;
			if( i < argc )
				THEME = QString( argv[i] );
		} else if( ( strcmp( argv[i], "-port" ) == 0 ) || ( strcmp( argv[i], "--port" ) == 0 ) ) {
			i++;
			if( i < argc ){
				PORT = QString( argv[i] );
			}
		} else if( ( strcmp( argv[i], "-v" ) == 0 )  ) {	
			int level;
			level = atoi(argv[i+1]) ;
			setLogLevel((LogLevel) level ) ;
		} else if( ( strcmp( argv[i], "-fast" ) == 0 ) || ( strcmp( argv[i], "--fast" ) == 0 ) ) {		
			FAST = true;
		} else if( ( strcmp( argv[i], "-help" ) == 0 ) || ( strcmp( argv[i], "--help" ) == 0 ) ) {
			cout << "Usage: attal-server [OPTION]"  << endl;
			cout << "Start the server "  << endl;
			cout << endl;
			cout << "  -theme  --theme [NAME]      Load a particular theme (Medieval by default)"  << endl;
			cout << "  -port   --port [PORT]       Used to listen on a particular port (avoid first dialog)"  << endl;
			cout << "  -fast   --fast              Listen on localhost:1717"  << endl;
			cout << "  -v [LEVEL]                  Level of error messages (0-4) (default 4)"  << endl;
			cout << "  -help   --help              This screen"  << endl;
			return 1; 
		}
	}

	useTheme();

	ServerInterface game;
	//app.setMainWidget( &game );

	game.show();
	if(!game.initServer()) {
		exit(0);
	}


	return app.exec();	
}
