/****************************************************************
**
** Attal : Lords of Doom
**
** buildingAction.h
** Widget for editing actions of building
**
** Version : $Id: buildingAction.h,v 1.4 2005/11/06 11:36:23 audoux Exp $
**
** Author(s) : Sardi Carlo - Pascal Audoux
**
** Date : 29/04/2004
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/


#ifndef BUILDINGACTION_H
#define BUILDINGACTION_H


// generic include files
// include files for QT
#include <QDialog>
#include <QListWidget>
// application specific include files
#include "libCommon/genericBuilding.h"
#include "libCommon/action.h"

class QSpinBox;
class QComboBox;

/*              ------------------------------
 *                        buildingAction
 *              ------------------------------ */

class BuildingAction : public QWidget
{
	Q_OBJECT
public:
	BuildingAction( QWidget * parent = 0, const char * name = 0 );

	void init( GenericBuildingModel * building );

	void save();

public slots:
	void slot_add();

	void slot_edit();

	void slot_del();

protected:
	QListWidget * _listBox;
	QPushButton * _pbAdd, * _pbEdit, * _pbDel;
	GenericBuildingModel * _building;
};

/*              ------------------------------
 *                     buildingActionItem
 *              ------------------------------ */

class BuildingActionItem : public QListWidgetItem
{
public:
	/** Constructor */
	BuildingActionItem( Action::ActionType action,
			ElementaryAction::ElementaryType modif, uint param, int value );

	Action::ActionType getActionType() { return _action; }

	void setActionType( Action::ActionType action ) { _action = action; computeLabel(); }

	ElementaryAction::ElementaryType getModifType() { return _modif; }

	void setModifType( ElementaryAction::ElementaryType modif ) { _modif = modif; computeLabel(); }

	uint getParam() { return _param; }

	void setParam( uint param ) { _param = param; computeLabel(); }

	int getValue() { return _value; }

	void setValue( int value ) { _value = value; computeLabel(); }

	void computeLabel();

protected:
	Action::ActionType _action;
	ElementaryAction::ElementaryType _modif;
	uint _param;
	int _value;
};

/*              ------------------------------
 *                   DialogbuildingAction
 *              ------------------------------ */

class DialogBuildingAction : public QDialog
{
	Q_OBJECT
public:
	DialogBuildingAction( QWidget * parent = 0, const char * name = 0 );

	Action::ActionType getActionType() { return _action; }

	void setActionType( Action::ActionType action ) { _action = action; updateDialog(); }

	ElementaryAction::ElementaryType getModifType() { return _modif; }

	void setModifType( ElementaryAction::ElementaryType modif ) { _modif = modif; updateDialog(); }

	uint getParam() { return _param; }

	void setParam( uint param ) { _param = param; updateDialog(); }

	int getValue() { return _value; }

	void setValue( int value ) { _value = value; updateDialog(); }

	void updateDialog();

public slots:
	void accept();

protected:
	Action::ActionType _action;
	ElementaryAction::ElementaryType _modif;
	uint _param;
	int _value;

	QComboBox * _comboAction, * _comboModif;
	QSpinBox * _spinParam, * _spinValue;
};



#endif // BUILDINGACTION_H
