
using Gtk;
using GtkSharp;
using System;


public class TestRotation
{
	public static int Main (string[] args)
	{
		Application.Init ();

		Window win = new Window ("Image rotation test program");
		win.DefaultSize = new System.Drawing.Size (400, 300);
		win.DeleteEvent += new DeleteEventHandler (Window_Delete);

		RotateTest rt = new RotateTest ("test.jpg");
		rt.CreateDisplay ();
		win.Add (rt.Display);

		win.ShowAll ();
		Application.Run ();

		return (0);
	}

	static void Window_Delete (object obj, DeleteEventArgs args)
	{
		Application.Quit ();
		args.RetVal = true;
	}
}

public class RotateTest
{
	Gtk.VBox rotateDisplay;
	public Gtk.Widget Display {
		get {
			return ((Gtk.Widget) rotateDisplay);
		}
	}

	private RotateTest ()
	{
	}


	string filename;

	public RotateTest (string filename)
	{
		this.filename = filename;
	}

	public void CreateDisplay ()
	{
		rotateDisplay = new Gtk.VBox (false, 0);

		DisplayImage pic = new DisplayImage (filename);
		rotateDisplay.Add (new Image (pic.Pbuf));

		ImageMap picMap = pic.ConvertToImageMap (null);
		picMap.Normalize ();

		//ImageMap rMap = picMap.Carve (101, 111, 101 + 64, 111 + 64);
		ImageMap rMap = picMap.Carve (101 + 10, 111, 101 + 10 + 32, 111 + 32);

		ImageMap rotated = rMap.RotateCircleInQuadratic (-Math.PI / 2.0);
		rotateDisplay.Add (new Image
			((new DisplayImage (rotated, 1.0)).Pbuf));

		rotated = rMap;
		/*
		for (double ang = 0.1 ; ang < Math.PI ; ang += 0.01)
			rotated = rotated.RotateCircleInQuadratic (ang);
		*/

		double angle = - Math.PI;
		do {
			Console.WriteLine ("\nROTATION by {0}", angle);
			rotated = rotated.RotateCircleInQuadratic (0.1);

			//rotated = rotated.Carve (16, 16, 48, 48);
			rotateDisplay.Add (new Image
				((new DisplayImage (rotated, 1.0)).Pbuf));

			angle += 0.1;
		} while (angle < Math.PI); //while (Math.Abs (angle - 2.0 * Math.PI) > 0.001);
	}
}

