#!/bin/sh

TMP=/tmp
MONO=./monoopt.sh

if [ $# -lt 3 ]; then
	echo "usage: autopano-complete.sh output.pto image1 image2 [...]"
	exit 1
fi

rm -f /tmp/apc_*.xml.gz
PANOFILE=$1
shift 1
for image in $@ ; do
	$MONO generatekeys.exe $image \
		$TMP/apc_$(echo -n $image | sed -r 's@.+/([^/]+$)@\1@').xml.gz 700
done

$MONO autopano.exe $PANOFILE $TMP/apc_*.xml.gz

