/*--------------------------------------------------------------------------*
 * AUTOPROFILE                                                              *
 *                                                                          *
 * A Gaim away message and profile manager that supports dynamic text       *
 *                                                                          *
 * AutoProfile is the legal property of its developers.  Please refer to    *
 * the COPYRIGHT file distributed with this source distribution.            *
 *                                                                          *
 * This program is free software; you can redistribute it and/or modify     *
 * it under the terms of the GNU General Public License as published by     *
 * the Free Software Foundation; either version 2 of the License, or        *
 * (at your option) any later version.                                      *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA *
 *--------------------------------------------------------------------------*/

#include "component.h"

/*---------- EXECUTABLE: STDOUT from a program ----------*/
GtkWidget *file_entry;

/* Read file into string and return */
char *executable_generate ()
{
  char *text, *text_start;
  int max;
  gboolean exec;
  GError *return_error;
  char *cmd;
  
  cmd = strdup (gaim_prefs_get_string (
    "/plugins/gtk/autoprofile/components/executable"));
  max = gaim_prefs_get_int (
    "/plugins/gtk/autoprofile/components/executable_size");

  exec = g_spawn_command_line_sync (cmd,
    &text_start, NULL, NULL, &return_error);

  if (!exec) {
    /* Excution failed */
    free(cmd);
    return NULL;
  }

  if (strlen (text_start) < max)
    text = text_start + strlen(text_start);
  else
    text = text_start + max;

  /* Should back off only if the last item is newline */
  /* Gets rid of the extra <BR> in output */
  text--;
  if (*text != '\n')
    text++;

  *text = '\0';
  free(cmd);
  return text_start;
}

static gboolean executable_update (GtkWidget *widget, GdkEventFocus *evt, 
                                gpointer data)
{
  gaim_prefs_set_string (
    "/plugins/gtk/autoprofile/components/executable",
    gtk_entry_get_text (GTK_ENTRY (file_entry)));
  return FALSE;
}

static gboolean executable_update_size (GtkWidget *widget, GdkEventFocus *evt, 
                                      gpointer data)
{
  gaim_prefs_set_int ("/plugins/gtk/autoprofile/components/executable_size",
    gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget)));
  return FALSE;
}

void executable_filename (GtkWidget *widget, gpointer user_data) {
  GtkWidget *file_selector = (GtkWidget *)user_data;
  const gchar *selected_filename;

  selected_filename = gtk_file_selection_get_filename (
    GTK_FILE_SELECTION (file_selector));

  gaim_prefs_set_string ("/plugins/gtk/autoprofile/components/executable",
    selected_filename);
  gtk_entry_set_text (GTK_ENTRY (file_entry), gaim_prefs_get_string (
    "/plugins/gtk/autoprofile/components/executable"));
}

/* Creates and pops up file selection dialog for fortune file */
void executable_selection (GtkWidget *widget, gpointer user_data) {
  GtkWidget *file_selector;
  const char *cur_file;
  
  /* Create the selector */
  file_selector = gtk_file_selection_new (
    "Select the location of the program");

  cur_file = gaim_prefs_get_string (
    "/plugins/gtk/autoprofile/components/executable");
  if (strlen (cur_file) > 1) {
    gtk_file_selection_set_filename (
      GTK_FILE_SELECTION (file_selector), cur_file); 
  }
  
  g_signal_connect (GTK_OBJECT(
                      GTK_FILE_SELECTION(file_selector)->ok_button),
                    "clicked", G_CALLBACK (executable_filename),
                    (gpointer) file_selector);
   			   
  /* Destroy dialog box when the user clicks button. */
  g_signal_connect_swapped (GTK_OBJECT(
      GTK_FILE_SELECTION(file_selector)->ok_button), 
    "clicked", G_CALLBACK (gtk_widget_destroy), (gpointer) file_selector); 

  g_signal_connect_swapped (GTK_OBJECT (
      GTK_FILE_SELECTION (file_selector)->cancel_button), 
    "clicked", G_CALLBACK (gtk_widget_destroy), (gpointer) file_selector); 
   
  /* Display dialog */
  gtk_widget_show (file_selector);
}

/* Create the menu */
GtkWidget *executable_menu ()
{
  GtkWidget *ret = gtk_vbox_new (FALSE, 5);
  GtkWidget *hbox, *label, *button, *spinner;

  label = gtk_label_new (
    _("Specify the command line you wish to execute"));
  gtk_box_pack_start (GTK_BOX (ret), label, FALSE, FALSE, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0);

  hbox = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (ret), hbox, FALSE, FALSE, 0);
  /* Text entry to type in program name */
  file_entry = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX (hbox), file_entry, FALSE, FALSE, 0);
  gtk_entry_set_text (GTK_ENTRY (file_entry), gaim_prefs_get_string (
    "/plugins/gtk/autoprofile/components/executable"));
  g_signal_connect (G_OBJECT (file_entry), "focus-out-event",
                    G_CALLBACK (executable_update), NULL);
  /* Button to bring up file select dialog */
  button = gtk_button_new_with_label ("Browse for program");
  g_signal_connect (G_OBJECT (button), "clicked",
                    G_CALLBACK (executable_selection), NULL);

  gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);

  hbox = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (ret), hbox, FALSE, FALSE, 0);
  label = gtk_label_new (_("Max characters to read from output: "));
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  spinner = gtk_spin_button_new_with_range (1, 1000, 1);
  gtk_box_pack_start (GTK_BOX (hbox), spinner, FALSE, FALSE, 0);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (spinner), gaim_prefs_get_int (
    "/plugins/gtk/autoprofile/components/executable_size"));
  g_signal_connect (G_OBJECT (spinner), "value-changed",
                    G_CALLBACK (executable_update_size), NULL);

  return ret;
}

void executable_init () {
  gaim_prefs_add_string ("/plugins/gtk/autoprofile/components/executable","");
  gaim_prefs_add_int ("/plugins/gtk/autoprofile/components/executable_size", 
    1000);
}

struct component executable =
{
  N_("Executable"),
  N_("Reproduces standard output of running a program on the command line"),
  'e',
  &executable_generate,
  &executable_init,
  NULL,
  NULL,
  &executable_menu
};

