/*
	ATtiny10.inc
	ATtiny11.inc
	
	AVA, Uros Platise, Marek Michalkiewicz
	(c) 1. Jul 1999
*/	

/* ***** I/O Register Definitions */
#define	SREG	 0x3f
#define	GIMSK	 0x3b
#define	GIFR	 0x3a
#define	TIMSK	 0x39
#define	TIFR	 0x38
#define	MCUCR	 0x35
#define	MCUSR	 0x34
#define	TCCR0	 0x33
#define	TCNT0	 0x32
#define	WDTCR	 0x21
#define	PORTB	 0x18
#define	DDRB	 0x17
#define	PINB	 0x16
#define ACSR     0x08

/* ***** Bit Definitions */

#define	EXTRF	 1
#define	PORF	 0

#define	INT0	 6
#define PCIE     5

#define	INTF0	 6
#define PCIF     5

#define	TOIE0	 1
#define	TOV0	 1

#define	SE	 5
#define	SM	 4
#define	ISC01	 1
#define	ISC00	 0

#define	CS02	 2
#define	CS01	 1
#define	CS00	 0

#define	WDTOE	 4
#define	WDE	 3
#define	WDP2	 2
#define	WDP1	 1
#define	WDP0	 0

#define	PB4	 4
#define	PB3	 3
#define	PB2	 2
#define	PB1	 1
#define	PB0	 0

#define	DDB5	 5
#define	DDB4	 4
#define	DDB3	 3
#define	DDB2	 2
#define	DDB1	 1
#define	DDB0	 0

#define	PINB5	 5
#define	PINB4	 4
#define	PINB3	 3
#define	PINB2	 2
#define	PINB1	 1
#define	PINB0	 0

#define ACD	 7
#define ACO	 5
#define ACI	 4
#define ACIE	 3
#define ACIS1	 1
#define ACIS0	 0

#define	ZL	 r30
#define	ZH	 r31

#define RAMEND   0x0    /* Last On-Chip SRAM Location */
#define	XRAMEND  0x0
#define	E2END	 0x0

/* FLASH byte addresses */
#define	FLASHEND 0x3FF

#define	INT0addr 0x002	/* External Interrupt0 Vector Address */
#define PCIaddr  0x004	/* Pin Change Interrupt */
#define	OVF0addr 0x006	/* Overflow0 Interrupt Vector Address */
#define ACIaddr  0x008  /* Analog Comparator Interrupt Vector Address */

#define VECT_SIZE 0x0A	/* interrupt vector table size (5 vectors) */

/* eof */
