/*
	ledkey.s
	
	Simple example that changes the state of the LED
	diode on occurence of the external interrupt INT0.
	
	Code was written for AT90S1200 but will run on
	AT90S2313 without changes. For use with other models
	please change the port settings as declared by
	below macros.
	
	Uros Platise 23. Januar 1999
*/

#arch AT90S1200
#include "avr.inc"

#define LED1		PB0
#define KEY1		PD2

#define PORTB_DIR	BV(LED1)
#define Tmp		r16
#define inv(x)		(0xff-x)

	seg abs=0 flash.code
	rjmp __init_
	rjmp __key_pressed_
	reti
	reti
	
	/* Initialize Hardware */
__init_:	
	ldi Tmp, PORTB_DIR
	out DDRB, Tmp
	
	/* clear LED */
	ser Tmp
	out PORTB, Tmp
	
	/* Enable External Interrupt */
	ldi Tmp, BV(INT0)
	out GIMSK, Tmp
	
	/* Set Triggering on Falling Edge */
	/* Set Power Down Mode */
	ldi Tmp, BV(SE)+BV(ISC01)
	out MCUCR, Tmp
	
	/* Enable Global Interrupts and Prepeare value of the Tmp */
	ser Tmp	
	sei		
forever:
	sleep
	rjmp forever
	
	
	/* Key is Pressed */
__key_pressed_:
	com Tmp
	out PORTB, Tmp
	reti
	
