/*
				    Hex View
 */

#ifndef HVIEW_H
#define HVIEW_H

#include <gtk/gtk.h>


typedef struct _hview_struct		hview_struct;
#define HVIEW(p)			((hview_struct *)(p))


/*
 *	Widget Name:
 */
#define HVIEW_WIDGET_NAME		"hex-view"


/*
 *	Flags:
 */
typedef enum {
	HVIEW_FLAG_HAS_CHANGES		= (1 << 0),
	HVIEW_FLAG_READ_ONLY		= (1 << 1),
	HVIEW_FLAG_DRAGGING_SELECTION	= (1 << 2),
	HVIEW_FLAG_DRAGGING_SCROLL	= (1 << 3)
} hview_flags;


/*
 *	Edit Modes:
 */
typedef enum {
	HVIEW_EDIT_MODE_HEX,
	HVIEW_EDIT_MODE_ASCII
} hview_edit_mode;


/*
 *	Hex View:
 */
struct _hview_struct {

	GtkWidget 	*toplevel;
	gboolean	map_state;
	gint		freeze_count,
			busy_count;
	hview_flags	flags;
	GdkCursor	*busy_cur,
			*text_cur,
			*translate_cur;
	GdkFont 	*font;
	GdkColormap	*colormap;
	GdkGC		*gc;

	gint		last_motion_x,
			last_motion_y;

	gint		cell_width,
			cell_height,
			cells_per_row;

	/* Column positions */
	gint		address_x,
			hex_x,
			ascii_x;

	GtkAdjustment	*vadj;
	GtkWidget	*heading_toplevel,
			*heading_address_toplevel,
			*heading_hex_toplevel,
			*heading_ascii_toplevel,
			*view_da,
			*vscrollbar,
			*status_bar_toplevel,
			*status_bar_label;
	GdkPixmap	*view_pm;
	guint		scroll_toid;

	/* Right-click popup menu */
	GtkWidget	*menu,
			*cut_mi,
			*copy_mi,
			*paste_mi,
			*insert_msep,
			*insert_mi,
			*delete_mi,
			*select_all_mi,
			*unselect_all_mi,
			*edit_mode_msep,
			*edit_mode_hex_mi,
			*edit_mode_ascii_mi;

	/* Loaded data */
	guint8		*buf;		/* Buffer */
	gint		buf_len,
			buf_pos;
	gint		buf_sel_start,	/* Selection */
			buf_sel_end;

	/* Edit mode */
	hview_edit_mode	edit_mode;

	/* Edit buffer
	 *
	 * If edit_buf_i is not 0 then it indicates the value is being
	 * edited and what position in edit_buf should the next value
	 * be entered to
	 */
	gint		edit_buf_i;
	gchar		edit_buf[4];

	/* Changed callback */
	void		(*changed_cb)(
		hview_struct *,			/* Hex View */
		gpointer			/* Data */
	);
	gpointer	changed_data;

	/* Select callback */
	void		(*select_cb)(
		hview_struct *,			/* Hex View */
		int, int,			/* Start, End */
		gpointer			/* Data */
	);
	gpointer	select_data;

	/* Edit mode changed callback */
	void		(*edit_mode_changed_cb)(
		hview_struct *,			/* Hex View */
		hview_edit_mode,		/* Edit mode */
		gpointer			/* Data */
	);
	gpointer	edit_mode_changed_data;

};


#define HVIEW_HAS_CHANGES(_hv_)		\
 ((_hv_)->flags & HVIEW_FLAG_HAS_CHANGES)
#define HVIEW_READ_ONLY(_hv_)		\
 ((_hv_)->flags & HVIEW_FLAG_READ_ONLY)
#define HVIEW_DRAGGING_SELECTION(_hv_)	\
 ((_hv_)->flags & HVIEW_FLAG_DRAGGING_SELECTION)
#define HVIEW_DRAGGING_SCROLL(_hv_)	\
 ((_hv_)->flags & HVIEW_FLAG_DRAGGING_SCROLL)


/* Returns TRUE if the buffer is selected (not nessisarly has selection)
 * or FALSE if the buffer is not selected
 */
#define HVIEW_IS_BUF_SELECTED(_h_)	(			\
 ((_h_) != NULL) ?						\
  (((_h_)->buf_sel_start > -1) && ((_h_)->buf_sel_end > -1)) :	\
  FALSE								\
)

/* Returns TRUE if the position i is in bounds */
#define HVIEW_IS_BUF_POS_VALID(_h_,_i_)	(			\
 ((_h_) != NULL) ?						\
  (((_h_)->buf != NULL) && ((_i_) >= 0) && ((_i_) < (_h_)->buf_len)) : \
  FALSE								\
)


extern gint HViewPositionXYToBuffer(
	hview_struct *hv,
	const gint x, const gint y
);
extern void HViewScrollTo(
	hview_struct *hv,
	const gint pos, const gfloat ycoeff
);
extern GtkVisibility HViewIsBufferPositionVisible(
	hview_struct *hv, const gint i
);

extern gint HViewOpenFileProgress(
        hview_struct *hv, const gchar *path,
        gint (*progress_cb)(
            hview_struct *, gulong, gulong, gpointer
        ),
        gpointer progress_data
);
extern gint HViewOpenFile(hview_struct *hv, const gchar *path);
extern gint HViewSaveFileProgress(
        hview_struct *hv, const gchar *path,
        gint (*progress_cb)(
            hview_struct *, gulong, gulong, gpointer
        ),
        gpointer progress_data
);
extern gint HViewSaveFile(hview_struct *hv, const gchar *path);
extern gint HViewOpenData(hview_struct *hv, const guint8 *data, gint data_len);
extern void HViewClear(hview_struct *hv);

extern void HViewSetEditMode(hview_struct *hv, const hview_edit_mode edit_mode);
extern void HViewSetSelected(hview_struct *hv, const guint8 v);
extern void HViewSetPosition(hview_struct *hv, const gint position);
extern void HViewSelect(
	hview_struct *hv,
	const gint start_position, const gint end_position
);
extern void HViewSelectAll(hview_struct *hv);
extern void HViewUnselectAll(hview_struct *hv);
extern void HViewCut(hview_struct *hv);
extern void HViewCopy(hview_struct *hv);
extern void HViewPaste(hview_struct *hv);
extern void HViewInsert(hview_struct *hv);
extern void HViewDeleteSelected(hview_struct *hv);
extern gint HViewFind(
	hview_struct *hv, const guint8 *needle, const gint needle_len,
	const gint start_pos, const gboolean case_sensitive
);

extern gboolean HViewToplevelIsWindow(hview_struct *hv);
extern GtkWidget *HViewGetToplevelWidget(hview_struct *hv);
extern GtkDrawingArea *HViewGetViewWidget(hview_struct *hv);
extern GtkMenu *HViewGetMenuWidget(hview_struct *hv);

extern hview_struct *HViewNew(GtkWidget *parent);
extern hview_struct *HViewNewWithToplevel(
	const gint width, const gint height
);
extern void HViewShowHeading(hview_struct *hv, const gboolean show);
extern void HViewShowStatusBar(hview_struct *hv, const gboolean show);
extern void HViewSetViewFont(hview_struct *hv, const gchar *font_name);
extern void HViewSetReadOnly(hview_struct *hv, const gboolean read_only);
extern void HViewSetChangedCB(
	hview_struct *hv,
	void (*func_cb)(hview_struct *, gpointer),
	gpointer data
);
extern void HViewSetSelectCB(
	hview_struct *hv,
	void (*func_cb)(
		hview_struct *,
		int, int,
		gpointer
	),
	gpointer data
);
extern void HViewSetEditModeChangedCB(
	hview_struct *hv,
	void (*func_cb)(
		hview_struct *,
		hview_edit_mode,
		gpointer
	),
	gpointer data
);

extern void HViewUpdate(hview_struct *hv);
extern void HViewDraw(hview_struct *hv);
extern void HViewQueueDraw(hview_struct *hv);
extern void HViewSetStatusMessage(
	hview_struct *hv, const gchar *msg,
	const gboolean allow_gtk_iteration
);
extern void HViewSetBusy(hview_struct *hv, const gboolean busy);
extern void HViewMap(hview_struct *hv);
extern void HViewUnmap(hview_struct *hv);
extern void HViewDelete(hview_struct *hv);


#endif	/* HVIEW_H */
