# Arch Perl library, Copyright (C) 2005 Mikhael Goikhman
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.005;
use strict;

package AXP::Command::cset::show;
use base 'AXP::Command::cset';

use Arch::Session;
use Arch::Name;

sub infoline {
	"show changeset listing"
}

sub optusage {
	"[options] revision-or-dir-or-tarball"
}

sub options {
	(
		diffs => { sh => 'd', desc => "include file diff output" },
	)
}

sub helptext {
	q{
		Given the revision name or changeset directory or project tree
		directory or changeset/tree tarball (including http:// ones),
		show the changeset listing and optionally all file diffs.

		The added and deleted files, as well as arch specific files
		participate in this combined diff.

		Somewhat similar to "tla show-changeset", but works on more
		input types.
	}
}

sub execute {
	my $self = shift;
	my %opt = %{$self->{options}};

	my $cset = $self->changeset;
	my $output = "";

	$output .= $cset->get_changes->get_listing;
	$output .= $cset->join_all_diffs if $opt{diffs};

	print $output;
}

1;
