#!/bin/bash

# Build tarball of package..
PACKAGE=`head -n 1 debian/control | cut -f2 -d' '`
VERSION=`head -n 1 debian/changelog | cut -f2 -d\( | cut -f1 -d')' | cut -f1 -d-`
PKG_TGZ=${PACKAGE}_${VERSION}.tgz
echo "creating tarball ${PKG_TGZ}.."

THE_PWD=`pwd`
THE_DIR=`basename $THE_PWD`

cd ..
tar czhf $PKG_TGZ --exclude "*lucene*" --exclude "*debian*" --exclude "*build*" --exclude "*CVS*" --exclude "*stamp" --exclude "*webprj" --exclude "Makefile" --exclude "*bak" $THE_DIR/

cd $THE_PWD

# ENDS