#!/bin/sh

# Gotta have the power..
if [ $(id -u) != 0 ]
then
  echo "You must be root to run this script."
  exit 11
fi

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# AXYL CONFIGURATION

# See if the config file is present - if so it will define
# our directories, and Axyl admin user..

# Defaults..
AXUSER=
AXYL_HOME=
AXYL_DATA=
AXYL_LOGS=
LUCENE_PORT=
AXYL_VERSION="unknown"

CONFDIR=/etc/axyl
CONF=${CONFDIR}/axyl.conf
if [ -f $CONF ]
then
  . $CONF
  # But if they are invalid dirs, then nullify them again..
  [ ! -d $AXYL_HOME ] && AXYL_HOME=
  [ ! -d $AXYL_DATA ] && AXYL_DATA=
  [ ! -d $AXYL_LOGS ] && AXYL_LOGS=
fi

VERSIONFILE=${CONFDIR}/axyl.version
if [ -f $VERSIONFILE ]
then
  AXYL_VERSION=`cat $VERSIONFILE`
  if [ "$AXYL_VERSION" = "" ]
  then
    AXYL_VERSION="unknown"
  fi
fi

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# GET COMMON AXYL SHELL FUNCTIONS

if [ ! -z $AXYL_HOME ] ; then
  if [ -f ${AXYL_HOME}/install/axyl-common-funcs.sh ] ; then
  	. ${AXYL_HOME}/install/axyl-common-funcs.sh
  fi
fi

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# Find apache conf dir, trying the obvious first, then searching..

find_location_of file httpd.conf in /etc/apache /etc/apache-perl
APACHE_CONFDIR=${LOC:-/etc/apache}


# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# END