<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    antihack.php                                            */
/* Author:      Paul Waite                                              */
/* Description: Anti-hacking filter/checking done on each page.         */
/*                                                                      */
/* ******************************************************************** */
/** @package core */

// ......................................................................
/**
* Filters out potential hacking
* A utility function to determine whether the supplied
* string contains any of the more sensitive SQL
* keywords. Usually called to parse URL parameters to
* check for hacks etc..
*/
function hasSQL($str) {
  if (stristr($str, "SELECT * ")) return true;
  if (stristr($str, "DELETE FROM ")) return true;
  if (stristr($str, "ALTER TABLE ")) return true;
  if (stristr($str, "DROP TABLE ")) return true;
  if (stristr($str, "CREATE TABLE ")) return true;
  return false;
}
if (isset($HTTP_POST_VARS)) {
  while (list($key, $val) = each($HTTP_POST_VARS)) {
    if (hasSQL($val)) {
      die("500: Internal Server Error");
      exit;
    }
  }
}
else if (isset($HTTP_GET_VARS)) {
  while (list($key, $val) = each($HTTP_POST_VARS)) {
    if (hasSQL($val)) {
      die("500: Internal Server Error");
      exit;
    }
  }
}
if (isset($QUERY_STRING)) {
  if (hasSQL($QUERY_STRING)) {
    die("500: Internal Server Error");
    exit;
  }
}
?>