<?php 

/****
 * 
 * PageNav.php
 * A class for getting navigation information.
 * 
 ****/

require_once('Properties.php');

class PageNav {

var $urlRoot;
var $documentRoot;
var $prop;

function PageNav(&$prop) {
	$this->prop = &$prop;
	$this->urlRoot = preg_replace('#/$#','',$prop->getGlobal('siteroot')); 
	$this->documentRoot = preg_replace('#/$#','',$_SERVER['DOCUMENT_ROOT']);
}


/**
 * getPathTree: returns an array of the site structure, expanded
 *   following the path of the $page. levels above $startlevel
 *   are ignored. $showall=true will show hidden pages.
 **/
 
function getTree(&$page, $startlevel=0, $showall=false) {
	return $this->getPathTree($page, $startlevel, -1, $showall);
}


// this is the worker function for getTree, should not be called directly.

function getPathTree(&$page, $startlevel=0, $level=-1, $showall=false) {
	if ($startlevel < 0) {
		return array();
	}
	if ($level == -1) {
		$level = $startlevel;
	}

	#d::log("-------------------------");
	#d::log('$page->path ' . $page->path);
	#d::log('$level ' . $level );
	#d::log('$startlevel ' . $startlevel );
	
	$path = explode("/", $page->path); 
	array_shift($path); // skip over empty first element;
	
	$path_so_far    = '/' . join('/', array_slice($path,0,$level));
	$path_remaining = join('/', array_slice($path,$level));
	
	#d::logv($path_so_far, '$path_so_far');
	#d::logv($path_remaining, 'path_remaining');

	$page_so_far = $page->ps->getPage($path_so_far);
	$children = $page_so_far->children();
	
	$ret = array();
	foreach($children as $child) {
		$f = array();
		#d::logv($child->path, '$child.path');
		$f['path'] = $child->path;
		$f['absolutepath'] = $child->absolutepath;
		$f['title'] = $child->navtitle;
		$f['level'] = $level-$startlevel;
		$f['dir'] = $child->dir;
		$f['type'] = $child->type;
		
		if (preg_match("'^$page->path(\.\w{3,4})?/?$'", "$child->path/")) {
			$f['selected'] = true;
		}
		else {
			$f['selected'] = false;
		}

		# optionally hide invisible pages, if invisible page is not page or a parent of page.
		if (! ($f['selected'] || preg_match("'^$child->path/'", $page->path)) ) {
			if ( ! $showall && ! $child->get('visible') ) continue;
		}

		$ret[] = $f;
		$childbaseurl = basename($child->path);
		#d::logv($childbaseurl,'$childbaseurl');
		#d::logv($path_remaining,'$path_remaining');
		$next_array = null;
		$more_path_remaining = preg_match("'^$childbaseurl/'", "$path_remaining/"); 
		if ( $child->dir && $more_path_remaining ) {
			$next_array = $this->getPathTree($page,$startlevel,$level+1,$showall);
		}
		elseif ( $child->get('nav-expand') ) {
			$next_array = $this->getOpenTree($child, '', 2);
		}
		if ($next_array!=null) {
			$ret[] = array('level'=>'push');
			foreach($next_array as $elem) $ret[] = $elem;
			$ret[] = array('level'=>'pop');
		}
	}
	return $ret;
}

function getPathInfo(&$page) {
	$ret = array();
	$path = $page->path;
	$path = explode("/", $path);
	array_shift($path); 
	$pathsofar = "";
	for ($i=0; $i<count($path); $i++) {		
		if ($path[$i] == "") continue;

		$pathsofar .= '/' . $path[$i];
		$entry = array();
		$entry['title'] = $page->ps->getNavTitle($pathsofar);
		$entry['path'] = $pathsofar;
		$ret[] = $entry;
	}
	return $ret;
}


/*
 * returns a tree under $page which is open (all branches included)
 * for at most $max_depth
 */
 
function getOpenTree(&$page, $selectedpath='', $max_depth=4, $current_depth=1) {
	$ret = array();
	$children = $page->children();
	if (count($children) == 0) return $ret;
	
	for($i=0; $i<count($children); $i++) {
		$child = $children[$i];
		
		$f = array();
		$f['path'] = $child->path;
		$f['absolutepath'] = $child->absolutepath;
		$f['page'] = &$children[$i];
		$f['title'] = $child->title;
		$f['level'] = $current_depth;
		if ($selectedpath == $child->path)
			$f['selected'] = true;
		else 
			$f['selected'] = false;
		
		if ($current_depth >= $max_depth)
			continue;

		# optionally hide invisible pages, if invisible page is not page or a parent of page.
		if (! ($f['selected'] || preg_match("'^$child->path/'", $page->path)) ) {
			if ( ! $child->get('visible') ) continue;
		}

		$next_array = $this->getOpenTree($child,$selectedpath, $max_depth,$current_depth+1);
		
		if (count($next_array)==0) {
			if (!isset($children[$i+1])) {
				$f['nextlevel'] = $f['level']-1;
				$next_array = null;
			}
			else {
				$f['nextlevel'] = $f['level'];
				$next_array = null;
			}
		}
		else {
			$f['nextlevel'] = $f['level'] + 1;
		}
		
		$ret[] = $f;
		if ($next_array!=null) {
			$ret[] = array('level'=>'push');
			foreach($next_array as $elem) $ret[] = $elem;
			$ret[] = array('level'=>'pop');
		}
	} 
	return $ret;
}


// a single level list of all sub pages

function getChildren(&$page,$selectedpath='') {
	return $this->getOpenTree(&$page, $selectedpath, 1);
}

/*
 * returns an expanded tree starting from level $start
 * to level $max. 
 */
 
function getBaseTree(&$page, $start=0, $depth=2) {
	$path = split('/',$page->path);
	
	if (count($path) > $start) {
		$subpath = array_slice($path,1,$start);
		$subpath = '/' . join('/',$subpath);
		$root = $page->ps->getPage($subpath);
	}
	else {
		$root = $page->ps->getPage('/');
	}		
	return $this->getOpenTree($root, $page->path, $start+$depth);
}



#################################################
## Private Functions
#################################################

function getFilePath($url_path) {
	$file_path = $this->documentRoot . $this->urlRoot . $url_path;
	return $file_path;
}



} // end class

return;
?>
