# Copyright (C) 1999, 2000 Jay Beale
# Copyright (C) 2001, 2002 Hewlett Packard
# Licensed under the GNU General Public License

package Bastille::MiscellaneousDaemons;
use lib "/usr/lib";

use Bastille::API;
use Bastille::TestAPI;

@ENV="";
$ENV{PATH}="";
$ENV{CDPATH}=".";
$ENV{BASH_ENV}="";



#######################################################################
##                          Miscellaneous Daemons                    ##
#######################################################################

# Deactivate ?standard? services chosen at install, at admin's option.
# Explain why they might want to turn this stuff off.  Remember, most
# newbies will take the, "I don't want to break anything -- turn it all on!"
# approach.  Let's deactivate apmd, portmap, pcmcia, nfs, netfs, smb, 
# dhcpd, amd, gpm, innd, linuxconf, if possible.

&DeactivateAPMD;
&DeactivateRemoteFS;
#&DeactivateATD;
&DeactivatePCMCIA;
&DeactivateDHCP;
&DeactivateGPM;
&DeactivateINND;
&MinimizeChkconfig;
&DeactivatePTY;
&DeactivatePwgrd;
&DeactivateRbootd;
&RestrictXaccess;
&RestrictRendevous;
&RestrictAutoDiskMount;
&RestrictNTPD;

# If we are running SuSE7.x, we also write to rc.config so that changes are unaltered
# upon reboot of the system. Otherwise, rc.config would overwrite these changes.

#
# Disable non-standard services, which may have been badly chosen at install:
#
# Possibly disable arpwatch, autofs, bootparamd, gated, mars-nwe, mcserv,
# postgresql, routed, rstatd, rusersd, rwalld, rwhod, snmpd, squid, xntpd, 
# ypbind, yppasswdd, ypserv

#
#### WHICH ONES SHOULD WE DISABLE?
#

&DeactivateRoutingDaemons;
&DeactivateNIS;
&DeactivateSNMPD;


sub DeactivateAPMD {

    if (&getGlobalConfig("MiscellaneousDaemons","apmd") eq "Y") {
        &ActionLog("# sub DeactivateAPMD\n");
 
        &B_chkconfig_off ("apmd");
	if (&GetDistro =~ "^SE") {
        &B_replace_line(&getGlobal('FILE',"rc.config"),'^START_APMD=','START_APMD="no"\n');
	}
}
}

sub DeactivateRemoteFS {

    if (&getGlobalConfig("MiscellaneousDaemons","remotefs") eq "Y") {
	&ActionLog("# sub DeactivateRemoteFS\n");

        # For now, we break NFS/SAMBA.  Does someone want to make a "secure?" NFS
        # configuration?  Should we allow samba? Can we use samba without the 
        # automounter? Are they safe when we don't know if the admin has a firewall?
	# question: should we remove the symbolic links for netfs, which
	# mounts external net-based drives?
 
        &B_chkconfig_off ("portmap");
        &B_chkconfig_off ("nfs");
        &B_chkconfig_off ("smb");
        &B_chkconfig_off ("amd");
    
	if (&GetDistro =~ "^SE7") {
	    &B_replace_line(&getGlobal('FILE',"rc.config"),'^START_PORTMAP','START_PORTMAP="no"\n');
	    &B_replace_line(&getGlobal('FILE',"rc.config"),'^NFS_SERVER','NFS_SERVER="no"\n');
	    &B_replace_line(&getGlobal('FILE',"rc.config"),'^START_SMB','START_SMB="no"\n');
	}
	
	&B_hash_comment_line(&getGlobal('FILE', "inetd.conf"),"nfs");

    }

    if (&getGlobalConfig("MiscellaneousDaemons","nfs_server") eq "Y") {
	&ActionLog("# sub DeactivateRemoteFS\n");

	if (&GetDistro =~ "^HP-UX") {
            # Kill off process and change permanant start-up behavior
            &B_ch_rc ("NFS_SERVER", &getGlobal('FILE', 'chkconfig_nfs_server'));
	}
	elsif (&GetDistro =~ '^OSX') {
	    # NFS is deactivated on OSX simply by making sure there are no exported
	    # filesystems.
	    &B_hash_comment_line('/etc/exports','^\s*[^\#]+');
	}

    }


    if (&getGlobalConfig("MiscellaneousDaemons","nfs_client") eq "Y") {
	&ActionLog("# sub DeactivateRemoteFS\n");

	if ( &GetDistro =~ "^HP-UX") {
            # Kill off process and change permanent start-up behavior
            &B_ch_rc ('NFS_CLIENT',&getGlobal('FILE', 'chkconfig_nfs_client'));
	}
	elsif (&GetDistro =~ '^OSX') {
	    # You can't deactivate NFS client daemon (nfsiod) separately without 
	    # deactivating the network, unless you're willing to modify the NFS
	    # script.  Right!

	    &B_hash_comment_line(&getGlobal('FILE','NFS'),'^\s*nfsiod\b');

	    # We also deactivate the automounter here, which is done via /etc/hostconfig.
	    
	    # JJB: Replace the line below with an abstraction, after talking with
	    #      Keith Buck.
	    &B_replace_line(&getGlobal('FILE','hostconfig'),'^AUTOMOUNT\=\-YES\-',"AUTOMOUNT=-NO-\n");
	}
    }


}


# We disable atd.  All the functionality of at can be mimicked via cron and # there have been large security problems with cron.  
#   if (&getGlobalConfig("MiscellaneousDaemons","atd") eq "Y") {
#   &ActionLog("# sub DeactivateATD\n");
#      &B_chkconfig_off ("atd");
#   if (&GetDistro =~ "^SE") {
#   &B_replace_line(&getGlobal('FILE',"rc.config"),'^START_ATD','START_ATD="no"\n');
#   }
#   }

sub DeactivatePCMCIA {
 
    # If this isn't a notebook, strongly recommend disabling PCMCIA.
    if (&getGlobalConfig("MiscellaneousDaemons","pcmcia") eq "Y") {
    &ActionLog("# sub DeactivatePCMCI\n");
 
        &B_chkconfig_off ("pcmcia");
    if (&GetDistro =~ "^SE") { 
    &B_replace_line(&getGlobal('FILE',"rc.config"),'^START_PCMCIA','START_PCMCIA="no"\n');
   }
}
}

sub DeactivateDHCP {
 
    # If this is # If this is not a DHCP server, we deactivate dhcpd.
 
    if (&getGlobalConfig("MiscellaneousDaemons","dhcpd") eq "Y") {
        &ActionLog("# sub DeactivateDHCP\n");
 
        &B_chkconfig_off ("dhcpd");
    if (&GetDistro =~ "^SE") {
        &B_replace_line(&getGlobal('FILE',"rc.config"),'^IFCONFIG_0="dhcpclient"','IFCONFIG_0=""\n');
    }
}
}

sub DeactivateGPM {
 
    if (&getGlobalConfig("MiscellaneousDaemons","gpm") eq "Y") {
        &ActionLog("# sub DeactivateGPM\n");
 
        &B_chkconfig_off ("gpm");
    if (&GetDistro =~ "^SE") {
        &B_replace_line(&getGlobal('FILE',"rc.config"),'^START_GPM="yes"','START_GPM="no"\n');
	&ActionLog("# this is where GPM should be edited in rc.config\n");
    }
}
}

sub DeactivateINND {

    # Deactivate innd unless they really need a new server.
	
    if (&getGlobalConfig("MiscellaneousDaemons","innd") eq "Y" ) {
	&ActionLog("# sub DeactivateINND\n");
	
	&B_chkconfig_off ("innd");
   }
    
}


sub DeactivateRoutingDaemons {

    # Disable gated if they're not running a router...  Otherwise, disable 
    # either gated or routed.
    
    &ActionLog("# sub DeactivateRoutingDaemons\n");

    if (&getGlobalConfig("MiscellaneousDaemons","disable_routed") eq "Y") {
	&B_chkconfig_off ("routed");
    }
    if (&getGlobalConfig("MiscellaneousDaemons","disable_gated") eq "Y") {
	&B_chkconfig_off ("gated");
    }

}


sub DeactivateNIS {

    &ActionLog("# sub DeactivateNIS\n");

    # NIS Server section
    if (&getGlobalConfig("MiscellaneousDaemons","nis_server") eq "Y") {
	&ActionLog("# deactivating NIS server\n");
	if ( &GetDistro =~ "^HP-UX") {
	    &B_ch_rc ('NIS_MASTER_SERVER',&getGlobal('FILE', 'chkconfig_nis_server'));
	    &B_ch_rc ('NIS_SLAVE_SERVER',&getGlobal('FILE', 'chkconfig_nis_server'));
	}
	else {
	    &B_chkconfig_off ("ypserv");
	    &B_chkconfig_off ("yppasswdd");
	}

    }


    # NIS Client Section
    if (&getGlobalConfig("MiscellaneousDaemons","nis_client") eq "Y") {
	&ActionLog("# deactivating NIS client\n");
	if ( &GetDistro =~ "^HP-UX") {
            &B_set_rc('NIS_DOMAIN',"");
	    &B_ch_rc ('NIS_CLIENT',&getGlobal('FILE', 'chkconfig_nis_client'));

	    # nsswitch.conf is used by several programs to determine how to resolve
	    # system unknowns.  e.g. the hosts entry of this file is used by nslookup
	    # to resolve network host names.
	    my $nsswitch = &getGlobal('FILE',"nsswitch.conf");

	    # The system defaults may use nis, in this case Bastille will
	    # create a reasonable default that depends on the system files and dns
	    if( ! -f $nsswitch ) {
		&B_create_file($nsswitch);
	    }

	    &B_append_line($nsswitch,'\s*passwd:', "passwd:       files\n");
	    &B_append_line($nsswitch,'\s*group:', "group:        files\n");
	    &B_append_line($nsswitch,'\s*hosts:', "hosts:        files dns\n");
	    &B_append_line($nsswitch,'\s*networks:', "networks:     files\n");
	    &B_append_line($nsswitch,'\s*protocols:', "protocols:    files\n");
	    &B_append_line($nsswitch,'\s*rpc:', "rpc:          files\n");
	    &B_append_line($nsswitch,'\s*publickey:', "publickey:    files\n"); 
	    &B_append_line($nsswitch,'\s*netgroup:', "netgroup:     files\n");
	    &B_append_line($nsswitch,'\s*automount:', "automount:    files\n");
	    &B_append_line($nsswitch,'\s*aliases:', "aliases:      files\n");
	    &B_append_line($nsswitch,'\s*services:', "services:     files\n");
	    
	    # if an nsswitch.conf file was using nis to resolve unknowns then
	    # changes need to be made to this file in order to ensure that
	    # the new system configuration is acknowledged by the nsswitch.conf file.
	    if( &B_match_line($nsswitch,'.+:\s+.*nis|.+:\s+.*compat') ) {
		&B_TODO("\n" .
			"------------------------------------\n" .
			"Deactivating NIS client programs:\n" .
			"------------------------------------\n" .
			"Bastille has detected nis entries in the following file:\n" .
			"$nsswitch\n" . 
			"To remain internally consistent please remove all references\n" .
                        "to 'nis' or 'compat' from the file.\n");
	    }
	    
	    
	}
	else {
	    &B_chkconfig_off ("ypbind");
	}

	if (&GetDistro =~ "^SE") {
	    &B_replace_line(&getGlobal('FILE',"rc.config"),'^START_YPBIND=','START_YPBIND="no"\n');
	}
    }


}

sub DeactivateSNMPD {

    # SNMP is rather insecure.  If you need proof, go read the Phrack
    # article or read a bit about the protocol...
    
    if (&getGlobalConfig("MiscellaneousDaemons","snmpd") eq "Y") {
	&ActionLog("# sub DeactivateSNMPD\n");
	unless ( &GetDistro =~ "^HP-UX") {
	    &B_chkconfig_off ("snmpd");
	}
	else {
	    &B_ch_rc ('SNMP_HPUNIX_START',&getGlobal('FILE', 'chkconfig_snmpd_HP'));
	    &B_ch_rc ('SNMP_MIB2_START',&getGlobal('FILE', 'chkconfig_snmpd_Mib2'));
	    &B_ch_rc ('SNMP_TRAPDEST_START',&getGlobal('FILE', 'chkconfig_snmpd_Trp'));
	    &B_ch_rc ('SNMP_MASTER_START',&getGlobal('FILE', 'chkconfig_snmpd_Master'));
	} # end HP-UX section
    }
}

###
### Should we disable the rest?
###

sub MinimizeChkconfig {

    # This routine is a duplicate of msec's functionality -- it turns
    # off all chkconfig-based services with the exception of those in
    # /etc/security/msec/server.4.

    if (&getGlobalConfig("MiscellaneousDaemons","minimize_chkconfig") eq "Y") {
	&ActionLog("# sub MinimizeChkconfig\n");

	open CHKCONFIGS,"/sbin/chkconfig --list |";
	my $line;
	while ($line = <CHKCONFIGS>) {
	    if ($line =~ /^(.*?)\s+0:/) {
		my $service = $1;
		my $chkconfig_this_off = 1;
		my $allowed_service;
		foreach $allowed_service ( "crond","syslog","keytable","network","gpm","xfs","pcmcia","bastille-firewall") {
		    if ($service eq $allowed_service) {
			$chkconfig_this_off=0;
		    }
		}
		
		if ($chkconfig_this_off) {
		    &B_chkconfig_off($service);
		}
	    }
	}
	close CHKCONFIGS;
    }

}

sub DeactivatePTY {
    if (&getGlobalConfig("MiscellaneousDaemons","disable_ptydaemon") eq "Y") {
	&ActionLog("# sub DeactivatePTY\n");
	&B_ch_rc ('VTDAEMON_START',&getGlobal('FILE', 'chkconfig_vt'));
	&B_ch_rc ('PTYDAEMON_START',&getGlobal('FILE', 'chkconfig_pty'));
    }
}

sub DeactivatePwgrd {
   if (&getGlobalConfig("MiscellaneousDaemons","disable_pwgrd") eq "Y") {
	&ActionLog("# sub DeactivatePwgrd\n");
	&B_ch_rc ('PWGR',&getGlobal('FILE', 'chkconfig_pwgrd'));
    }
}

sub DeactivateRbootd {
   if (&getGlobalConfig("MiscellaneousDaemons","disable_rbootd") eq "Y") {
	&ActionLog("# sub DeactivatePwgrd\n");
	&B_ch_rc ('START_RBOOTD',&getGlobal('FILE', 'chkconfig_rbootd'));
    }
}

sub RestrictXaccess {
    if (&getGlobalConfig("MiscellaneousDaemons","xaccess") eq "Y") {

	&B_System(&getGlobal('BIN',"dtlogin.rc") . " reset",&getGlobal('BIN',"dtlogin.rc") . " reset");
	&B_create_file (&getGlobal('BFILE', 'Xaccess.bastille'));
	&B_blank_file  (&getGlobal('BFILE', 'Xaccess.bastille'), "Bastille");
	&B_append_line (&getGlobal('BFILE', 'Xaccess.bastille'), "Bastille" ,
			"# This is a blank Xaccess file created by Bastille to prevent \n" .
			"# XDMCP logins.  It is referenced from " . &getGlobal('BFILE', 'Xconfig') . ".\n \n");
	&B_cp(&getGlobal('FILE', 'Xconfig'),&getGlobal('BFILE', 'Xconfig'));
	&B_replace_line(&getGlobal('BFILE', 'Xconfig'), "Dtlogin\.accessFile",
			"Dtlogin\.accessFile:          " .  &getGlobal('BFILE', 'Xaccess.bastille'));
	&B_System(&getGlobal('BIN',"dtlogin.rc") . " reset",&getGlobal('BIN',"dtlogin.rc") . " reset");

    }
}

sub RestrictRendevous {
    if (&getGlobalConfig("MiscellaneousDaemons","rendezvous") eq "Y") {

	if (&GetDistro =~ /^OSX/) {
	    &B_hash_comment_line('/System/Library/StartupItems/mDNSResponder/mDNSResponder','^\s*\/usr\/sbin\/mDNSResponder\b');
	}

    }
}

sub RestrictAutoDiskMount {
    if (&getGlobalConfig("MiscellaneousDaemons","autodiskmount") eq "Y") {

	if (&GetDistro =~ /^OSX/) {
	    &B_replace_line('/System/Library/StartupItems/Disks/Disks','^\s*\/sbin\/autodiskmount\s+\-va',"    /sbin/autodiskmount -v\n");
	}

    }
}

sub RestrictNTPD {
    if (&getGlobalConfig("MiscellaneousDaemons","disable_ntpd") eq "Y") {

	if (&GetDistro =~ /^OSX/) {
	    &B_replace_line(&getGlobal('FILE','hostconfig'),'^TIMESYNC=-YES-',"TIMESYNC=-NO-\n");
	}

    }
}

1;
