# Copyright (C) 2002-2003 Hewlett Packard
# Licensed under the GNU General Public License

# This is to be pulled into the API to define tests
# currently these only work for HP-UX
# Needed for access to API routines getDistro;
use Bastille::API;

$GLOBAL_TEST{'MiscellaneousDaemons'}{'nfs_server'} = 
    sub { if (! -e &getGlobal('FILE',"chkconfig_nfs_server")) {
             return $SKIPQ;
          } else {
             return &B_is_service_off('nfs_server');
          }
        };

$GLOBAL_TEST{'MiscellaneousDaemons'}{'nfs_client'} = 
    sub { if (! -e &getGlobal('FILE',"chkconfig_nfs_client")) {
             return $SKIPQ;
          } else {
             return &B_is_service_off('nfs_client');
          }
        };

$GLOBAL_TEST{'MiscellaneousDaemons'}{'disable_ptydaemon'} = 
    sub { #if (! -e &getGlobal('FILE',"")) { return $SKIPQ;}
          &B_is_service_off('ptydaemon');
        };

$GLOBAL_TEST{'MiscellaneousDaemons'}{'disable_pwgrd'} = 
    sub { if (! -e &getGlobal('FILE',"chkconfig_pwgrd")) {
             return $SKIPQ;
          } else {
             return &B_is_service_off('pwgr');
          }
        };

$GLOBAL_TEST{'MiscellaneousDaemons'}{'disable_rbootd'} = 
    sub { if (! -e &getGlobal('FILE',"chkconfig_rbootd")) {
             return $SKIPQ;
          } else {
             return &B_is_service_off('rbootd'); 
          }
        };

$GLOBAL_TEST{'MiscellaneousDaemons'}{'nis_server'} = 
    sub { if (! -e &getGlobal('FILE',"ypserv")) {
             return $SKIPQ;
          } else {
             return &B_is_service_off('nis_server');
          }
        };

$GLOBAL_TEST{'MiscellaneousDaemons'}{'nis_client'} = 
    sub { if (! -e &getGlobal('FILE',"chkconfig_ypbind")) {
             return $SKIPQ;
          } else {
             $oldnisdomain=&B_get_rc("NIS_DOMAIN");
             if (($oldnisdomain eq "") or ($oldnisdomain eq "\"\"")) {
                return &B_is_service_off('nis_client');
             } else {
                return $ASKQ;
             }
          }
        };

$GLOBAL_TEST{'MiscellaneousDaemons'}{'snmpd'} = 
    sub { if (! -e &getGlobal('FILE',"chkconfig_snmpd")) {
             return $SKIPQ;
          } else {
             return &B_is_service_off('snmpd');
          }
        };

$GLOBAL_TEST{'MiscellaneousDaemons'}{'xaccess'} = 
    sub { 
	# location of the Xconfig file
	my $xconfig = &getGlobal('BFILE',"Xconfig");
	# location of Bastille's Xaccess file
	my $xaccess = &getGlobal('BFILE',"Xaccess.bastille");
	
	# if Bastille's Xaccess file is referenced in Dt's Xconfig and
	#    Bastille's Xaccess file exists then
	if( (-e $xconfig) && 
	    (-e $xaccess) && 
	    (&B_match_line($xconfig,"Dtlogin\.accessFile:\\s+$xaccess")) ){
	    # don't ask the question
	    return 1;
	}
	else {
	    # otherwise ask the question
	    return 0;
	}

    };


$GLOBAL_TEST{'MiscellaneousDaemons'}{'minimalism'} = 
    sub {
	if( &GetDistro =~ "^HP-UX") {
	    my $testResults=1;
	    foreach my $test (keys %{$GLOBAL_TEST{'MiscellaneousDaemons'} }) {
		if($test !~ /minimalism/ ) {
		    $testResults = $testResults & &{$GLOBAL_TEST{'MiscellaneousDaemons'}{$test}};
		}
	    }
	    
	    return $testResults;
	    
	}
	else {
	    return undef;
	}
    };

1;
