/* changeset-utils.h:
 *
 * vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBARCH__CHANGESET_UTILS_H
#define INCLUDE__LIBARCH__CHANGESET_UTILS_H


#include "hackerlab/os/sys/stat.h"
#include "libawk/relational.h"
#include "libarch/inv-ids.h"
#include "libarch/project-tree.h"


typedef struct 
{
  struct stat stat_buf;
} arch_changeset_inventory_entry_t;

extern arch_changeset_inventory_entry_t * arch_changeset_inventory_entry_new (struct stat const * const);

typedef struct cset_map_incomplete_type * cset_map;

extern void cset_map_insert (cset_map * vtable, t_uchar const * key, arch_changeset_inventory_entry_t * value);
extern arch_changeset_inventory_entry_t * cset_map_find (cset_map vtable, t_uchar const * key);
extern void cset_map_remove (cset_map vtable, t_uchar const * key);
extern void cset_map_free (cset_map table);

AR_TYPEDEF (arch_changeset_inventory_entry_t *, changeset_inventory_entry);

struct arch_changeset_inventory
{
  /* [0] == loc;  [1] == id   (sort by 1)
   */
  rel_table dirs;
  rel_table files;
 // ar_changeset_inventory_entry files;

  enum arch_id_tagging_method method;
  int escape_classes;

  cset_map entries;
};

struct running_inventory_assocs
{
  assoc_table dir_loc_of;
  assoc_table dir_id_of;
  assoc_table file_loc_of;
  assoc_table file_id_of;
};




/* automatically generated __STDC__ prototypes */
extern void arch_changeset_inventory (struct arch_changeset_inventory * inv_out,
                                      arch_project_tree_t *tree,
                                      enum arch_id_tagging_method method,
                                      enum arch_inventory_category untagged_source_category,
                                      int escape_classes);
extern void arch_free_changeset_inventory_data (struct arch_changeset_inventory * i);
extern rel_table arch_read_changeset_index (t_uchar * path);
extern rel_table arch_read_changeset_dir_metadata (t_uchar * path);
extern mode_t arch_read_permissions_patch (t_uchar * file);
extern char * no_dot (char *name);
extern void save_patch_for_missing_file (t_uchar * missing_patch_dir, t_uchar * patch_path, t_uchar * mod_loc);

#endif  /* INCLUDE__LIBARCH__CHANGESET_UTILS_H */


/* tag: Tom Lord Sat Jan  5 15:26:10 2002 (changeset-utils.h)
 */
