/* inventory-entry.h:
 *
 * vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
 ****************************************************************
 * Copyright (C) 2005 Canonical Limited
 *      Authors: Robert Collins <robert.collins@canonical.com>
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBARCH__INVENTORY_ENTRY_H
#define INCLUDE__LIBARCH__INVENTORY_ENTRY_H


#include "hackerlab/machine/types.h"
#include "hackerlab/arrays/ar.h"


typedef struct inventory_entry_ inventory_entry_t;

typedef struct inventory_entry_vtable_
{
  inventory_entry_t * (*add_child) (inventory_entry_t * entry, inventory_entry_t * child);
  inventory_entry_t * (*get_child) (inventory_entry_t * entry, t_uchar const * const name);
  int *** (*vtable_end) (char const * const * const *); /* never used, makes compile fail when new methods are added but not in 
                                                             a vtable. should always be last */
} inventory_entry_vtable_t;

/* FIXME make this a global facility */
extern int *** arch_project_tree_vtable_end (char const * const * const *); /* never used, makes compile fail when new methods are added but not in 
                                                             a vtable */

struct inventory_entry_
{
  inventory_entry_vtable_t *vtable; 
  t_uchar *name; /* i.e. foo.h */
  t_uchar *id;   /* opaque text */
  inventory_entry_t *parent; /* the parent of this file. the root of a tree has no parent */
};

AR_TYPEDEF(inventory_entry_t *, inventory_entry);

typedef inventory_entry_t inventory_file_t;

typedef struct inventory_dir_
{
  inventory_entry_t entry; /* this dirs information */
  ar_inventory_entry children; 
} inventory_dir_t;

extern inventory_entry_t * inventory_entry_get_child (inventory_entry_t * file, t_uchar const * const name);
extern inventory_entry_t * inventory_entry_add_child (inventory_entry_t * file, inventory_file_t * child);

extern inventory_file_t * inventory_file_new (inventory_file_t * parent, t_uchar const * const name, t_uchar const * const id);
extern void inventory_file_init (inventory_file_t * file, inventory_file_t * parent, t_uchar const * const name, t_uchar const * const id);
extern int inventory_file_finalise (void *data);

extern inventory_entry_t * inventory_dir_new (inventory_file_t * parent, t_uchar const * const name, t_uchar const * const id);
extern int inventory_dir_finalise (void *data);

typedef struct inventory_link_
{
  inventory_entry_t entry; /* parent class info */
} inventory_link_t;

extern inventory_entry_t * inventory_link_new (inventory_file_t * parent, t_uchar const * const name, t_uchar const * const id);
extern int inventory_link_finalise (void *data);

#endif  /* INCLUDE__LIBARCH__INVENTORY_ENTRY_H */
