/* patch-parser.h:
 *
 * vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
 ****************************************************************
 * Copyright (C) 2005 Canonical Limited
 * 	Authors: Robert Collins <robert.collins@canonical.com>
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBARCH__PATCH_PARSER_H
#define INCLUDE__LIBARCH__PATCH_PARSER_H

#include "hackerlab/arrays/ar.h"

enum PATCH_HUNK_OPERATIONS {
  PATCH_ADD_LINE,
  PATCH_DEL_LINE
};

typedef struct patch_line_change_
{
    int offset;
    enum PATCH_HUNK_OPERATIONS operation;
} patch_line_change_t;


AR_TYPEDEF(patch_line_change_t, patch_line_change);
typedef ar_patch_line_change patch_line_changes_list;

extern patch_line_changes_list patch_parser_parse(t_uchar const * patch_content);
extern void ar_print_patch_line_change (int fd, patch_line_changes_list);

#endif /* INCLUDE__LIBARCH__PATCH_PARSER_H */
