#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# Test library-find a little
# Copyright © 2003 Colin Walters <walters@verbum.org>
#             2005 Canonical Ltd
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

setup_revlib () {
  [ ! -d "$1" ] || test_fail "$dir already exists"
  REVLIBDIR="$1"
  export REVLIBDIR
  echo "$REVLIBDIR"
  mkdir "$REVLIBDIR" || true
  tla my-revision-library "$REVLIBDIR"
}

teardown_revlib () {
  tla my-revision-library -d "$1"
  rm -rf "$1"
  [ ! -d "$1" ] || test_fail "revlib still exists"
}

initial_setup
setup_with_trivial_archives

test_class "library-find"

begin_test "test library-find can find an added revision"
setup_revlib `pwd`/revlib
tla library-add jane@example.com--2003/hello-world--mainline--1.0--base-0
tla library-find jane@example.com--2003/hello-world--mainline--1.0--base-0 || test_fail "unable to find revision in revlib"
teardown_revlib `pwd`/revlib
end_test

begin_test "test library-find can find an added revision in a revlib containing a space"
setup_revlib `pwd`/'revlib foo'
tla library-add jane@example.com--2003/hello-world--mainline--1.0--base-0
tla library-find jane@example.com--2003/hello-world--mainline--1.0--base-0 || test_fail "unable to find revision in revlib"
teardown_revlib `pwd`/'revlib foo'
end_test

clean_workdir
