#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
# Test whereis-archive
# Copyright © 2005 Canonical Limited
#	Authors: Robert Collins <robert.collins@canonical.com>
#                Rob Weir <rob.weir@canonical.com>
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

setup_with_trivial_archives

test_class "whereis-archive"

begin_test "whereis-archive on a tree"
tla get jane@example.com--2003/hello-world--mainline--1.0 hello-1.0
cd hello-1.0
wanted="${CACHEDARCHIVEDIR}/jane-archive"
got="$(tla whereis-archive)"
[ $wanted == $got ] || test_fail "Couldn't find archive ($wanted != $got)"
end_test

begin_test "whereis-archive on an archive"
tla get jane@example.com--2003/hello-world--mainline--1.0 hello-1.0
cd hello-1.0
wanted="${CACHEDARCHIVEDIR}/jane-archive"
got="$(tla whereis-archive jane@example.com--2003)"
[ $wanted == $got ] || test_fail "Couldn't find archive ($wanted != $got)"
end_test

clean_workdir
